/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl.weaksecretrules;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.security.impl.SecretStrengthRule;
import com.hazelcast.security.impl.WeakSecretError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Properties;

public class DictionaryRule
implements SecretStrengthRule {
    private static final String DEFAULT_WORD_LIST_PATH = "/usr/share/dict/words";
    private final ILogger logger = Logger.getLogger(this.getClass());
    private final File wordList;

    public DictionaryRule(Properties configProperties) {
        this.wordList = new File(configProperties.getProperty("hazelcast.security.dictionary.policy.wordlist.path", DEFAULT_WORD_LIST_PATH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnumSet<WeakSecretError> check(CharSequence secret) {
        if (!this.wordList.exists()) {
            this.logger.warning("Dictionary secret policy disabled, word-list file <" + this.wordList.getPath() + "> not found.");
            return EnumSet.noneOf(WeakSecretError.class);
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(this.wordList, StandardCharsets.UTF_8));
            if (br.lines().anyMatch(line -> line.equals(secret))) {
                EnumSet<WeakSecretError> enumSet = EnumSet.of(WeakSecretError.DICT_WORD);
                IOUtil.closeResource(br);
                return enumSet;
            }
            IOUtil.closeResource(br);
        }
        catch (IOException e) {
            ExceptionUtil.sneakyThrow(e);
        }
        finally {
            IOUtil.closeResource(br);
        }
        return EnumSet.noneOf(WeakSecretError.class);
    }
}

