/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.config.ConfigXmlGenerator;
import com.hazelcast.config.LoginModuleConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.security.JaasAuthenticationConfig;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.internal.util.AddressUtil;
import com.hazelcast.internal.util.XmlUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.security.RealmConfigCallback;
import com.hazelcast.security.impl.LoginConfigurationDelegate;
import com.hazelcast.security.permission.AllPermissions;
import com.hazelcast.security.permission.AtomicLongPermission;
import com.hazelcast.security.permission.AtomicReferencePermission;
import com.hazelcast.security.permission.CPMapPermission;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.security.permission.CardinalityEstimatorPermission;
import com.hazelcast.security.permission.ClusterPermission;
import com.hazelcast.security.permission.ConfigPermission;
import com.hazelcast.security.permission.ConnectorPermission;
import com.hazelcast.security.permission.CountDownLatchPermission;
import com.hazelcast.security.permission.DurableExecutorServicePermission;
import com.hazelcast.security.permission.ExecutorServicePermission;
import com.hazelcast.security.permission.FlakeIdGeneratorPermission;
import com.hazelcast.security.permission.JobPermission;
import com.hazelcast.security.permission.ListPermission;
import com.hazelcast.security.permission.LockPermission;
import com.hazelcast.security.permission.ManagementPermission;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.security.permission.MultiMapPermission;
import com.hazelcast.security.permission.PNCounterPermission;
import com.hazelcast.security.permission.QueuePermission;
import com.hazelcast.security.permission.ReliableTopicPermission;
import com.hazelcast.security.permission.ReplicatedMapPermission;
import com.hazelcast.security.permission.RingBufferPermission;
import com.hazelcast.security.permission.ScheduledExecutorPermission;
import com.hazelcast.security.permission.SemaphorePermission;
import com.hazelcast.security.permission.SetPermission;
import com.hazelcast.security.permission.SqlPermission;
import com.hazelcast.security.permission.TopicPermission;
import com.hazelcast.security.permission.TransactionPermission;
import com.hazelcast.security.permission.UserCodeDeploymentPermission;
import com.hazelcast.security.permission.UserCodeNamespacePermission;
import com.hazelcast.security.permission.VectorCollectionPermission;
import java.io.File;
import java.io.IOException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class SecurityUtil {
    private static final String TEMP_LOGIN_CONTEXT_NAME = "realmConfigLogin";
    private static final String FQCN_KRB5LOGINMODULE_SUN = "com.sun.security.auth.module.Krb5LoginModule";
    private static final String FQCN_KRB5LOGINMODULE_IBM = "com.ibm.security.auth.module.Krb5LoginModule";
    private static final ILogger LOGGER = Logger.getLogger(SecurityUtil.class);
    private static final ThreadLocal<Boolean> SECURE_CALL = new ThreadLocal();

    private SecurityUtil() {
    }

    public static ClusterPermission createPermission(PermissionConfig permissionConfig) {
        String[] actions = permissionConfig.getActions().toArray(new String[0]);
        String name = permissionConfig.getName();
        PermissionConfig.PermissionType type = permissionConfig.getType();
        return SecurityUtil.createPermission(type, name, actions);
    }

    public static ClusterPermission createPermission(PermissionConfig.PermissionType type, String name, String ... actions) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PermissionConfig.PermissionType.ALL -> new AllPermissions();
            case PermissionConfig.PermissionType.MAP -> new MapPermission(name, actions);
            case PermissionConfig.PermissionType.QUEUE -> new QueuePermission(name, actions);
            case PermissionConfig.PermissionType.ATOMIC_LONG -> new AtomicLongPermission(name, actions);
            case PermissionConfig.PermissionType.ATOMIC_REFERENCE -> new AtomicReferencePermission(name, actions);
            case PermissionConfig.PermissionType.COUNTDOWN_LATCH -> new CountDownLatchPermission(name, actions);
            case PermissionConfig.PermissionType.EXECUTOR_SERVICE -> new ExecutorServicePermission(name, actions);
            case PermissionConfig.PermissionType.LIST -> new ListPermission(name, actions);
            case PermissionConfig.PermissionType.LOCK -> new LockPermission(name, actions);
            case PermissionConfig.PermissionType.MULTIMAP -> new MultiMapPermission(name, actions);
            case PermissionConfig.PermissionType.SEMAPHORE -> new SemaphorePermission(name, actions);
            case PermissionConfig.PermissionType.SET -> new SetPermission(name, actions);
            case PermissionConfig.PermissionType.TOPIC -> new TopicPermission(name, actions);
            case PermissionConfig.PermissionType.FLAKE_ID_GENERATOR -> new FlakeIdGeneratorPermission(name, actions);
            case PermissionConfig.PermissionType.TRANSACTION -> new TransactionPermission();
            case PermissionConfig.PermissionType.DURABLE_EXECUTOR_SERVICE -> new DurableExecutorServicePermission(name, actions);
            case PermissionConfig.PermissionType.CARDINALITY_ESTIMATOR -> new CardinalityEstimatorPermission(name, actions);
            case PermissionConfig.PermissionType.SCHEDULED_EXECUTOR -> new ScheduledExecutorPermission(name, actions);
            case PermissionConfig.PermissionType.PN_COUNTER -> new PNCounterPermission(name, actions);
            case PermissionConfig.PermissionType.CACHE -> new CachePermission(name, actions);
            case PermissionConfig.PermissionType.USER_CODE_DEPLOYMENT -> new UserCodeDeploymentPermission(actions);
            case PermissionConfig.PermissionType.CONFIG -> new ConfigPermission();
            case PermissionConfig.PermissionType.RING_BUFFER -> new RingBufferPermission(name, actions);
            case PermissionConfig.PermissionType.RELIABLE_TOPIC -> new ReliableTopicPermission(name, actions);
            case PermissionConfig.PermissionType.REPLICATEDMAP -> new ReplicatedMapPermission(name, actions);
            case PermissionConfig.PermissionType.MANAGEMENT -> new ManagementPermission(name);
            case PermissionConfig.PermissionType.JOB -> new JobPermission(actions);
            case PermissionConfig.PermissionType.CONNECTOR -> new ConnectorPermission(name, actions);
            case PermissionConfig.PermissionType.SQL -> new SqlPermission(name, actions);
            case PermissionConfig.PermissionType.CPMAP -> new CPMapPermission(name, actions);
            case PermissionConfig.PermissionType.USER_CODE_NAMESPACE -> new UserCodeNamespacePermission(name, actions);
            case PermissionConfig.PermissionType.VECTOR_COLLECTION -> new VectorCollectionPermission(name, actions);
        };
    }

    static void setSecureCall() {
        if (SecurityUtil.isSecureCall()) {
            throw new SecurityException("Not allowed! <SECURE_CALL> flag is already set!");
        }
        SECURE_CALL.set(Boolean.TRUE);
    }

    static void resetSecureCall() {
        if (!SecurityUtil.isSecureCall()) {
            throw new SecurityException("Not allowed! <SECURE_CALL> flag is not set!");
        }
        SECURE_CALL.remove();
    }

    private static boolean isSecureCall() {
        Boolean value = SECURE_CALL.get();
        return value != null && value != false;
    }

    public static boolean addressMatches(String address, String pattern) {
        return AddressUtil.matchInterface(address, pattern);
    }

    public static Subject getRunAsSubject(CallbackHandler callbackHandler, String securityRealm) {
        if (securityRealm == null) {
            if (LOGGER.isFineEnabled()) {
                LOGGER.fine("No RunAs Subject created for callbackHandler=%s, realm is not provided", callbackHandler);
            }
            return null;
        }
        RealmConfigCallback cb = new RealmConfigCallback(securityRealm);
        try {
            callbackHandler.handle(new Callback[]{cb});
        }
        catch (IOException | UnsupportedCallbackException e) {
            LOGGER.info("Unable to retrieve the RealmConfig", e);
            return null;
        }
        return SecurityUtil.getRunAsSubject(callbackHandler, cb.getRealmConfig());
    }

    public static Subject getRunAsSubject(CallbackHandler callbackHandler, RealmConfig realmConfig) {
        if (realmConfig == null) {
            if (LOGGER.isFineEnabled()) {
                LOGGER.fine("The realmConfig is not provided.");
            }
            return null;
        }
        LoginConfigurationDelegate loginConfiguration = new LoginConfigurationDelegate(realmConfig.asLoginModuleConfigs());
        try {
            LoginContext lc = new LoginContext(TEMP_LOGIN_CONTEXT_NAME, new Subject(), callbackHandler, loginConfiguration);
            lc.login();
            return lc.getSubject();
        }
        catch (LoginException e) {
            LOGGER.info("Authentication failed.", e);
            return null;
        }
    }

    public static RealmConfig createKerberosJaasRealmConfig(String principal, String keytabPath, boolean isInitiator) {
        LoginModuleConfig krb5LoginModuleConfig;
        if (keytabPath == null) {
            if (LOGGER.isFineEnabled()) {
                LOGGER.fine("The keytab path is not provided.");
            }
            return null;
        }
        if (SecurityUtil.hasLoginModuleClass(FQCN_KRB5LOGINMODULE_SUN)) {
            krb5LoginModuleConfig = new LoginModuleConfig(FQCN_KRB5LOGINMODULE_SUN, LoginModuleConfig.LoginModuleUsage.REQUIRED).setOrClear("keyTab", keytabPath).setProperty("doNotPrompt", "true").setProperty("useKeyTab", "true").setProperty("storeKey", "true").setProperty("isInitiator", Boolean.toString(isInitiator));
        } else if (SecurityUtil.hasLoginModuleClass(FQCN_KRB5LOGINMODULE_IBM)) {
            krb5LoginModuleConfig = new LoginModuleConfig(FQCN_KRB5LOGINMODULE_IBM, LoginModuleConfig.LoginModuleUsage.REQUIRED).setProperty("useKeytab", new File(keytabPath).toURI().toString()).setProperty("credsType", isInitiator ? "both" : "acceptor");
        } else {
            throw new UnsupportedOperationException("No supported Krb5LoginModule was found in the current Java runtime. The JAAS security realm configurations can't be created automatically. You have to explicitly configure the realms.");
        }
        krb5LoginModuleConfig.setOrClear("principal", principal).setProperty("refreshKrb5Config", "true");
        RealmConfig kerberosRealmConfig = new RealmConfig().setJaasAuthenticationConfig(new JaasAuthenticationConfig().addLoginModuleConfig(krb5LoginModuleConfig));
        if (LOGGER.isFineEnabled()) {
            LOGGER.fine("A helper security realm for Kerberos keytab-based authentication was generated: %s", kerberosRealmConfig);
        }
        return kerberosRealmConfig;
    }

    private static boolean hasLoginModuleClass(String fcqn) {
        try {
            Class.forName(fcqn);
            return true;
        }
        catch (Throwable t) {
            if (LOGGER.isFinestEnabled()) {
                LOGGER.finest("Login module class not found: " + fcqn, t);
            }
            return false;
        }
    }

    public static String generateRealmConfigXml(RealmConfig realmConfig, String realmName) {
        StringBuilder xmlBuilder = new StringBuilder();
        ConfigXmlGenerator.XmlGenerator gen = new ConfigXmlGenerator.XmlGenerator(xmlBuilder);
        SecurityXmlGenerator cfgGen = new SecurityXmlGenerator();
        cfgGen.securityRealmGenerator(gen, realmName, realmConfig);
        return XmlUtil.format(xmlBuilder.toString(), 2);
    }

    private static class SecurityXmlGenerator
    extends ConfigXmlGenerator {
        private SecurityXmlGenerator() {
        }

        @Override
        protected void securityRealmGenerator(ConfigXmlGenerator.XmlGenerator gen, String name, RealmConfig c) {
            super.securityRealmGenerator(gen, name, c);
        }
    }
}

