/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security.impl;

import com.hazelcast.config.LoginModuleConfig;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.BiConsumer;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public final class LoginConfigurationDelegate
extends Configuration {
    private final LoginModuleConfig[] loginModuleConfigs;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public LoginConfigurationDelegate(LoginModuleConfig[] loginModuleConfigs) {
        this.loginModuleConfigs = loginModuleConfigs;
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        AppConfigurationEntry[] entries = new AppConfigurationEntry[this.loginModuleConfigs.length];
        for (int i = 0; i < this.loginModuleConfigs.length; ++i) {
            LoginModuleConfig module = this.loginModuleConfigs[i];
            AppConfigurationEntry.LoginModuleControlFlag flag = this.getFlag(module);
            HashMap options = new HashMap();
            module.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> options.put((String)k, v)));
            entries[i] = new AppConfigurationEntry(module.getClassName(), flag, options);
        }
        return entries;
    }

    private AppConfigurationEntry.LoginModuleControlFlag getFlag(LoginModuleConfig module) {
        return switch (module.getUsage()) {
            default -> throw new IncompatibleClassChangeError();
            case LoginModuleConfig.LoginModuleUsage.REQUIRED -> AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
            case LoginModuleConfig.LoginModuleUsage.OPTIONAL -> AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
            case LoginModuleConfig.LoginModuleUsage.REQUISITE -> AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
            case LoginModuleConfig.LoginModuleUsage.SUFFICIENT -> AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        };
    }

    public String toString() {
        return "LoginConfigurationDelegate [loginModuleConfigs=" + Arrays.toString(this.loginModuleConfigs) + "]";
    }
}

