/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.operation;

import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.operation.AbstractNamedSerializableOperation;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import java.io.IOException;
import java.util.List;

public class MergeOperation
extends AbstractNamedSerializableOperation {
    private String name;
    private List<SplitBrainMergeTypes.ReplicatedMapMergeTypes<Object, Object>> mergingEntries;
    private SplitBrainMergePolicy<Object, SplitBrainMergeTypes.ReplicatedMapMergeTypes<Object, Object>, Object> mergePolicy;
    private transient boolean hasMergedValues;

    public MergeOperation() {
    }

    MergeOperation(String name, List<SplitBrainMergeTypes.ReplicatedMapMergeTypes<Object, Object>> mergingEntries, SplitBrainMergePolicy<Object, SplitBrainMergeTypes.ReplicatedMapMergeTypes<Object, Object>, Object> mergePolicy) {
        this.name = name;
        this.mergingEntries = mergingEntries;
        this.mergePolicy = mergePolicy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void run() {
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        ReplicatedRecordStore recordStore = service.getReplicatedRecordStore(this.name, true, this.getPartitionId());
        for (SplitBrainMergeTypes.ReplicatedMapMergeTypes<Object, Object> mergingEntry : this.mergingEntries) {
            if (!recordStore.merge(mergingEntry, this.mergePolicy)) continue;
            this.hasMergedValues = true;
        }
    }

    @Override
    public Object getResponse() {
        return this.hasMergedValues;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeString(this.name);
        SerializationUtil.writeList(this.mergingEntries, out);
        out.writeObject(this.mergePolicy);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.name = in.readString();
        this.mergingEntries = SerializationUtil.readList(in);
        this.mergePolicy = NamespaceUtil.callWithNamespace(in::readObject, this.name, ReplicatedMapService::lookupNamespace);
    }

    @Override
    public int getClassId() {
        return 26;
    }
}

