/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.monitor.impl.PerIndexStats;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.service.TieredStoreService;
import com.hazelcast.internal.tstore.service.TieredStoreUser;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.recordstore.CompactionAwareStorage;
import com.hazelcast.map.impl.recordstore.CustomStepAwareStorage;
import com.hazelcast.query.impl.GlobalIndexPartitionTracker;
import com.hazelcast.query.impl.TSAbstractIndexImpl;
import com.hazelcast.query.impl.getters.Extractors;

public class TSPartitionedIndexImpl
extends TSAbstractIndexImpl {
    private static final int UNINDEXED = -1;
    private int indexedPartition = -1;

    public TSPartitionedIndexImpl(Node node, IndexConfig config, InternalSerializationService ss, Extractors extractors, PerIndexStats stats, String mapName, int partitionId) {
        super(node, config, ss, extractors, stats, mapName, partitionId);
    }

    @Override
    HybridLog createIndexHybridLog(TieredStoreService tieredStoreService, TieredStoreUser user, MapContainer mapContainer, IndexConfig indexConfig, String tag, int partitionId) {
        return tieredStoreService.createPartitionedIndexHybridLog(TieredStoreUser.BTREE, mapContainer, indexConfig, partitionId, tag);
    }

    @Override
    public boolean hasPartitionIndexed(int partitionId) {
        return this.indexedPartition == partitionId;
    }

    @Override
    public boolean allPartitionsIndexed(int ownedPartitionCount) {
        return this.indexedPartition != -1;
    }

    @Override
    public void beginPartitionUpdate() {
    }

    @Override
    public void markPartitionAsIndexed(int partitionId) {
        assert (this.indexedPartition == -1);
        this.indexedPartition = partitionId;
    }

    @Override
    public void markPartitionAsUnindexed(int partitionId) {
        this.indexedPartition = -1;
    }

    @Override
    public void clear() {
        this.indexedPartition = -1;
        super.clear();
    }

    @Override
    public GlobalIndexPartitionTracker.PartitionStamp getPartitionStamp() {
        return null;
    }

    @Override
    public boolean validatePartitionStamp(long stamp) {
        return false;
    }

    public CompactionAwareStorage getCompactorAwareStorage() {
        return this.getIndexStore().getCompactorAwareStorage();
    }

    @Override
    public CustomStepAwareStorage getCustomStepAwareStorage() {
        return this.getIndexStore().getCustomStepAwareStorage();
    }

    public HybridLog getHybridLog() {
        return this.getIndexStore().getHybridLog();
    }

    @Override
    public String toString() {
        return "TSLocalIndexImpl{} " + super.toString();
    }
}

