/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.EntryView;
import com.hazelcast.internal.hotrestart.HotRestartKey;
import com.hazelcast.internal.hotrestart.HotRestartStore;
import com.hazelcast.internal.hotrestart.impl.KeyOnHeap;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.EnterpriseMapServiceContext;
import com.hazelcast.map.impl.EntryCostEstimator;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.iterator.MapKeysWithCursor;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;
import com.hazelcast.map.impl.recordstore.HotRestartStorage;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.recordstore.StorageImpl;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystem;
import java.util.Iterator;
import java.util.Map;

public class HotRestartStorageImpl<R extends Record>
implements Storage<Data, R>,
HotRestartStorage<R> {
    protected final EnterpriseMapServiceContext mapServiceContext;
    protected final HotRestartStore hotRestartStore;
    protected final Storage<Data, R> storage;
    protected final ExpirySystem expirySystem;
    protected final boolean fsync;
    protected final long prefix;

    HotRestartStorageImpl(EnterpriseMapServiceContext mapServiceContext, RecordFactory<R> recordFactory, InMemoryFormat inMemoryFormat, boolean statsEnabled, ExpirySystem expirySystem, boolean fsync, long prefix, int partitionId) {
        this.mapServiceContext = mapServiceContext;
        this.expirySystem = expirySystem;
        this.fsync = fsync;
        this.hotRestartStore = this.findPartitionsHotRestartStore(partitionId);
        this.storage = this.createStorage(recordFactory, inMemoryFormat, statsEnabled);
        this.prefix = prefix;
    }

    protected HotRestartStore findPartitionsHotRestartStore(int partitionId) {
        return this.mapServiceContext.getOnHeapHotRestartStoreForPartition(partitionId);
    }

    @Override
    public HotRestartStore getHotRestartStore() {
        return this.hotRestartStore;
    }

    @Override
    public boolean isFsync() {
        return this.fsync;
    }

    @Override
    public long getPrefix() {
        return this.prefix;
    }

    public Storage createStorage(RecordFactory recordFactory, InMemoryFormat inMemoryFormat, boolean statsEnabled) {
        SerializationService serializationService = this.mapServiceContext.getNodeEngine().getSerializationService();
        return new StorageImpl(inMemoryFormat, this.expirySystem, serializationService);
    }

    @Override
    public final void putTransient(Data key, R record) {
        this.storage.put(key, record);
    }

    @Override
    public final void updateTransient(Data key, R record, Object value) {
        this.storage.updateRecordValue(key, record, value);
    }

    @Override
    public final void removeTransient(Data key, R record) {
        this.storage.removeRecord(key, record);
    }

    @Override
    public void put(Data key, R record) {
        this.storage.put(key, record);
        this.putToHotRestart(key, record);
    }

    @Override
    public R updateRecordValue(Data key, R record, Object value) {
        this.storage.updateRecordValue(key, record, value);
        this.putToHotRestart(key, record);
        return record;
    }

    @Override
    public void removeRecord(Data key, R record) {
        this.hotRestartStore.remove(this.createHotRestartKey(key, (Record)record), this.fsync);
        this.storage.removeRecord(key, record);
    }

    @Override
    public void clear(boolean isDuringShutdown) {
        this.storage.clear(isDuringShutdown);
    }

    @Override
    public void destroy(boolean isDuringShutdown) {
        this.storage.destroy(isDuringShutdown);
    }

    @Override
    public final R get(Data key) {
        return (R)((Record)this.storage.get(key));
    }

    @Override
    public R getIfSameKey(Data key) {
        return (R)((Record)this.storage.getIfSameKey(key));
    }

    @Override
    public final boolean containsKey(Data key) {
        return this.storage.containsKey(key);
    }

    @Override
    public Iterator<Map.Entry<Data, R>> mutationTolerantIterator() {
        return this.storage.mutationTolerantIterator();
    }

    @Override
    public final int size() {
        return this.storage.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public final EntryCostEstimator getEntryCostEstimator() {
        return this.storage.getEntryCostEstimator();
    }

    @Override
    public final void setEntryCostEstimator(EntryCostEstimator entryCostEstimator) {
        this.storage.setEntryCostEstimator(entryCostEstimator);
    }

    @Override
    public void disposeDeferredBlocks() {
        this.storage.disposeDeferredBlocks();
    }

    @Override
    public Iterable<EntryView> getRandomSamples(int sampleCount) {
        return this.storage.getRandomSamples(sampleCount);
    }

    @Override
    public MapKeysWithCursor fetchKeys(IterationPointer[] pointers, int size) {
        return this.storage.fetchKeys(pointers, size);
    }

    @Override
    public MapEntriesWithCursor fetchEntries(IterationPointer[] pointers, int size) {
        return this.storage.fetchEntries(pointers, size);
    }

    @Override
    public Data extractDataKeyFromLazy(EntryView entryView) {
        return this.storage.extractDataKeyFromLazy(entryView);
    }

    @Override
    public Data toBackingDataKeyFormat(Data key) {
        return this.storage.toBackingDataKeyFormat(key);
    }

    protected final void putToHotRestart(Data key, R record) {
        HotRestartKey hotRestartKey = this.createHotRestartKey(key, (Record)record);
        Data value = this.mapServiceContext.toData(record.getValue());
        this.hotRestartStore.put(hotRestartKey, value.toByteArray(), this.fsync);
    }

    public HotRestartKey createHotRestartKey(Data key, Record record) {
        return new KeyOnHeap(this.prefix, key.toByteArray());
    }
}

