/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.internal.memory.HazelcastMemoryManager;
import com.hazelcast.internal.memory.PoolingMemoryManager;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapKeyLoader;
import com.hazelcast.map.impl.recordstore.DefaultRecordStore;
import com.hazelcast.map.impl.wan.MerkleTreeUpdaterMutationObserver;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.wan.impl.merkletree.MerkleTree;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class EnterpriseBaseRecordStore
extends DefaultRecordStore {
    protected final HazelcastMemoryManager memoryManager;
    protected final boolean statsEnabled;

    public EnterpriseBaseRecordStore(MapContainer mapContainer, int partitionId, MapKeyLoader keyLoader, ILogger logger) {
        super(mapContainer, partitionId, keyLoader, logger);
        this.statsEnabled = mapContainer.getMapConfig().isStatisticsEnabled();
        HazelcastMemoryManager memoryManager = ((EnterpriseSerializationService)this.serializationService).getMemoryManager();
        if (memoryManager instanceof PoolingMemoryManager) {
            PoolingMemoryManager manager = (PoolingMemoryManager)memoryManager;
            memoryManager = manager.getMemoryManager();
        }
        this.memoryManager = memoryManager;
    }

    @Override
    protected void initJsonMetadataStore() {
    }

    @Override
    protected void addMutationObservers() {
        super.addMutationObservers();
        EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)this.mapServiceContext.getPartitionContainer(this.partitionId);
        MerkleTree merkleTree = partitionContainer.getOrCreateMerkleTree(this.mapContainer);
        if (merkleTree != null) {
            this.mutationObserver.add(new MerkleTreeUpdaterMutationObserver(merkleTree, this.serializationService));
        }
    }

    @Override
    public Data readBackupData(Data key) {
        if (this.inMemoryFormat != InMemoryFormat.NATIVE) {
            return super.readBackupData(key);
        }
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        OperationService opService = nodeEngine.getOperationService();
        ReadBackupDataTask readBackupDataTask = new ReadBackupDataTask(key);
        opService.execute(readBackupDataTask);
        try {
            return (Data)readBackupDataTask.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private class ReadBackupDataTask
    extends FutureTask<Data>
    implements PartitionSpecificRunnable {
        ReadBackupDataTask(Data key) {
            super(new InnerCallable(key));
        }

        @Override
        public int getPartitionId() {
            return EnterpriseBaseRecordStore.this.partitionId;
        }
    }

    private class InnerCallable
    implements Callable {
        private final Data key;

        InnerCallable(Data key) {
            this.key = key;
        }

        public Object call() {
            int threadIndex = EnterpriseBaseRecordStore.this.storage.beforeOperation();
            try {
                Data data = EnterpriseBaseRecordStore.super.readBackupData(this.key);
                return data;
            }
            finally {
                EnterpriseBaseRecordStore.this.storage.afterOperation(threadIndex);
            }
        }
    }
}

