/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.serialization.impl.NativeMemoryDataUtil;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.HybridLogDirectAccessor;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.eviction.Evictor;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.TieredStoreChunkAccessor;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;
import com.hazelcast.map.impl.record.TieredStoreRecordWithStats;
import com.hazelcast.map.impl.record.TieredStoreRecordWithVersion;
import com.hazelcast.map.impl.record.TieredStoreSlotAccessor;
import java.util.Map;
import java.util.function.Supplier;

abstract class BaseTieredStoreRecordAccessor
implements TieredStoreRecordAccessor {
    protected static final int HEADER_OFFSET = 0;
    protected static final int RECORD_LENGTH_OFFSET = 8;
    protected static final int KEY_OFFSET = 12;
    protected static final long DUMMY_RECORD_MASK = Long.MIN_VALUE;
    protected static final long LOCK_RECORD_MASK = 0x4000000000000000L;
    protected static final long NEXT_ADDRESS_CLEAR_MASK = -4611686018427387904L;
    protected static final long NEXT_ADDRESS_MASK = 0x3FFFFFFFFFFFFFFFL;
    protected final int partitionId;
    protected final MapContainer mapContainer;
    protected final EnterpriseSerializationService ss;
    private final Supplier<HybridLog> hybridLogSupplier;
    private final TieredStoreSlotAccessor inMemorySlotAccessor;
    private final TieredStoreChunkAccessor inMemoryChunkAccessor;

    BaseTieredStoreRecordAccessor(EnterpriseSerializationService ss, MapContainer mapContainer, int partitionId) {
        this.ss = ss;
        this.mapContainer = mapContainer;
        MapServiceContext mapServiceContext = mapContainer.getMapServiceContext();
        this.partitionId = partitionId;
        EnterprisePartitionContainer partitionContainer = (EnterprisePartitionContainer)mapServiceContext.getPartitionContainer(this.partitionId);
        this.hybridLogSupplier = partitionContainer.createHybridLogSupplier(mapContainer);
        this.inMemorySlotAccessor = new TieredStoreSlotAccessor(this);
        this.inMemoryChunkAccessor = new TieredStoreChunkAccessor();
    }

    @Override
    public TieredStoreRecord newRecord() {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        boolean hasEviction = this.mapContainer.getEvictor() != Evictor.NULL_EVICTOR;
        boolean hasHotRestart = mapConfig.getHotRestartConfig().isEnabled();
        if (mapConfig.isPerEntryStatsEnabled()) {
            return new TieredStoreRecordWithStats(this);
        }
        if (!hasEviction && !hasHotRestart) {
            return new TieredStoreRecordWithVersion(this);
        }
        throw new IllegalStateException("No tiered-store record type found matching with the provided " + String.valueOf(mapConfig));
    }

    @Override
    public Record newRecord(byte[] recordBytes) {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        boolean hasEviction = this.mapContainer.getEvictor() != Evictor.NULL_EVICTOR;
        boolean hasHotRestart = mapConfig.getHotRestartConfig().isEnabled();
        if (mapConfig.isPerEntryStatsEnabled()) {
            Record record = TieredStoreRecordWithStats.makeRecordFrom(recordBytes);
            return record;
        }
        if (!hasEviction && !hasHotRestart) {
            Record record = TieredStoreRecordWithVersion.makeRecordFrom(recordBytes);
            return record;
        }
        throw new IllegalStateException("No tiered-store record type found matching with the provided " + String.valueOf(mapConfig));
    }

    @Override
    public Record newRecordFrom(TieredStoreRecord record) {
        MapConfig mapConfig = this.mapContainer.getMapConfig();
        boolean hasEviction = this.mapContainer.getEvictor() != Evictor.NULL_EVICTOR;
        boolean hasHotRestart = mapConfig.getHotRestartConfig().isEnabled();
        if (mapConfig.isPerEntryStatsEnabled()) {
            Record onHeapRecord = TieredStoreRecordWithStats.makeRecordFrom(record);
            return onHeapRecord;
        }
        if (!hasEviction && !hasHotRestart) {
            Record onHeapRecord = TieredStoreRecordWithVersion.makeRecordFrom(record);
            return onHeapRecord;
        }
        throw new IllegalStateException("No tiered-store record type found matching with the provided " + String.valueOf(mapConfig));
    }

    @Override
    public Map.Entry<Data, Record<Data>> newEntry(byte[] recordBytes) {
        Data key = TieredStoreRecord.getKeyFromRecord(recordBytes);
        Record record = this.newRecord(recordBytes);
        return new MapEntry(key, record);
    }

    @Override
    public Map.Entry<Data, Record<Data>> newEntry(TieredStoreRecord record) {
        Data key = record.getKey();
        return new MapEntry(key, record);
    }

    @Override
    public Data newKey(byte[] record) {
        return TieredStoreRecord.getKeyFromRecord(record);
    }

    @Override
    public int recordSize(Data key, Data value, int metadataSize) {
        int totalKeySize = 4 + key.totalSize();
        int totalValueSize = 4 + value.totalSize();
        return 12 + totalKeySize + totalValueSize + metadataSize;
    }

    @Override
    public NativeMemoryData readData(long valueAddress) {
        if (valueAddress == 0L) {
            throw new IllegalArgumentException("Illegal memory address: " + valueAddress);
        }
        return new NativeMemoryData().reset(valueAddress);
    }

    @Override
    public long disposeData(NativeMemoryData data) {
        throw new UnsupportedOperationException("Dispose is not supported for the hybrid log");
    }

    @Override
    public long disposeData(long address) {
        throw new UnsupportedOperationException("Dispose is not supported for the hybrid log");
    }

    @Override
    public Object readValue(TieredStoreRecord record) {
        NativeMemoryData nativeMemoryData = this.readData(record.getValueAddress());
        return this.ss.toObject((Object)nativeMemoryData, this.ss.getMemoryManager());
    }

    @Override
    public long readValueAddress(TieredStoreRecord record) {
        return this.readValueAddress(record.address());
    }

    @Override
    public void setValueAddress(TieredStoreRecord record, long address) {
        NativeMemoryData value = new NativeMemoryData().reset(address);
        this.setValue(record, (Data)value);
    }

    @Override
    public void setValue(TieredStoreRecord record, Data value) {
        assert (!BaseTieredStoreRecordAccessor.isKeyNull(record.address()));
        if (value == null) {
            BaseTieredStoreRecordAccessor.setValueNull(record);
            return;
        }
        HybridLogDirectAccessor directAccessor = this.directAccessor();
        int dataValueSize = value.totalSize();
        int valueOffset = BaseTieredStoreRecordAccessor.getValueOffset(record.address());
        int oldValueSize = directAccessor.getInt(record, record.address() + (long)valueOffset);
        long dstValueAddress = record.address() + (long)valueOffset;
        if (oldValueSize > 0 && dataValueSize != oldValueSize) {
            throw new HazelcastException("Cannot set value in TieredStoreRecord: value size mismatch");
        }
        if (value instanceof NativeMemoryData) {
            NativeMemoryData nativeValue = (NativeMemoryData)value;
            directAccessor.copyFromMemory(record, dstValueAddress, nativeValue.address(), nativeValue.size());
        } else {
            byte[] dataValue = value.toByteArray();
            directAccessor.putInt(record, dstValueAddress, dataValue.length);
            directAccessor.copyFromByteArray(record, dstValueAddress + 4L, dataValue, 0, dataValue.length);
        }
    }

    @Override
    public int readValueSize(TieredStoreRecord record) {
        int valueOffset = BaseTieredStoreRecordAccessor.getValueOffset(record.address());
        return this.directAccessor().getInt(record, record.address() + (long)valueOffset);
    }

    @Override
    public long disposeValue(TieredStoreRecord record) {
        record.setValueAddress(0L);
        return 0L;
    }

    @Override
    public int getMetadataOffset(TieredStoreRecord record) {
        int length = this.getTotalInlinedLength(record.getLogicalAddress(), record.address());
        return length - record.getMetadataSize();
    }

    @Override
    public long getSize(MemoryBlock memoryBlock) {
        if (memoryBlock == null || memoryBlock.address() == 0L) {
            return 0L;
        }
        return memoryBlock.size();
    }

    @Override
    public long getSize(long address, long expectedSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Data readKey(TieredStoreRecord record) {
        long keyAddress = this.readKeyAddress(record.getLogicalAddress(), record.address());
        if (keyAddress == 0L) {
            return null;
        }
        return new NativeMemoryData().reset(keyAddress);
    }

    @Override
    public void setKey(Data key, TieredStoreRecord record) {
        long oldKeyAddress;
        int oldKeySize;
        if (key == null) {
            this.setKeyNull(record);
            return;
        }
        int keySize = key.totalSize();
        HybridLogDirectAccessor directAccessor = this.directAccessor();
        if (!BaseTieredStoreRecordAccessor.isKeyNull(record.address()) && keySize != (oldKeySize = directAccessor.getInt(record, oldKeyAddress = record.address() + 12L))) {
            throw new HazelcastException("Cannot set key in TieredStoreRecord: key size mismatch");
        }
        long dstKeyAddress = record.address() + 12L;
        if (key instanceof NativeMemoryData) {
            NativeMemoryData nativeKey = (NativeMemoryData)key;
            directAccessor.copyFromMemory(record, dstKeyAddress, nativeKey.address(), nativeKey.size());
        } else {
            byte[] keyArray = key.toByteArray();
            directAccessor.putInt(record, dstKeyAddress, keyArray.length);
            directAccessor.copyFromByteArray(record, dstKeyAddress + 4L, keyArray, 0, keyArray.length);
        }
    }

    @Override
    public long readKeyAddress(long logicalAddress, long recordVAddress) {
        if (this.isKeyNull(logicalAddress, recordVAddress)) {
            return 0L;
        }
        long keyAddress = recordVAddress + 12L;
        assert (this.directAccessor().getInt(logicalAddress, keyAddress) > 0);
        return keyAddress;
    }

    @Override
    private long readValueAddress(long address) {
        if (this.isValueNull(address)) {
            return 0L;
        }
        int valueOffset = BaseTieredStoreRecordAccessor.getValueOffset(address);
        return address + (long)valueOffset;
    }

    @Override
    public boolean isDummy(TieredStoreRecord record) {
        long header = this.directAccessor().getLong(record, record.address() + 0L);
        return (header & Long.MIN_VALUE) != 0L;
    }

    @Override
    public void setDummy(TieredStoreRecord record, int threadIndex) {
        HybridLogDirectAccessor directAccessor = this.directAccessor();
        long header = directAccessor.getLong(record, record.address() + 0L);
        long newHeader = header | Long.MIN_VALUE;
        directAccessor.putLong(record, record.address() + 0L, newHeader);
    }

    @Override
    public void setDummy(long logicalRecord, int threadIndex) {
        assert (this.isInMemory(logicalRecord));
        HybridLogDirectAccessor directAccessor = this.directAccessor();
        long physicalAddress = this.asPhysicalAddress(logicalRecord, threadIndex);
        long header = directAccessor.getLong(logicalRecord, physicalAddress + 0L);
        long newHeader = header | Long.MIN_VALUE;
        directAccessor.putLong(logicalRecord, physicalAddress + 0L, newHeader);
    }

    @Override
    public void setNotDummy(long logicalRecord, int threadIndex) {
        assert (this.isInMemory(logicalRecord));
        HybridLogDirectAccessor directAccessor = this.directAccessor();
        long physicalAddress = this.asPhysicalAddress(logicalRecord, threadIndex);
        long header = directAccessor.getLong(logicalRecord, physicalAddress + 0L);
        long newHeader = header & Long.MAX_VALUE;
        directAccessor.putLong(logicalRecord, physicalAddress + 0L, newHeader);
    }

    @Override
    public long getNext(TieredStoreRecord record) {
        return BaseTieredStoreRecordAccessor.getNextRecordAddress(this.directAccessor(), record.getLogicalAddress(), record.address());
    }

    @Override
    public void setNext(TieredStoreRecord record, long logicalAddress) {
        this.setNextRecordAddress(record.getLogicalAddress(), record.address(), logicalAddress);
    }

    @Override
    public long getNextRecordAddress(long logicalAddress, long recordAddress) {
        long header = this.directAccessor().getLong(logicalAddress, recordAddress + 0L);
        return header & 0x3FFFFFFFFFFFFFFFL;
    }

    @Override
    public void setNextRecordAddress(long logicalAddress, long recordAddress, long nextRecordAddress) {
        HybridLogDirectAccessor directAccessor = this.directAccessor();
        long header = directAccessor.getLong(logicalAddress, recordAddress + 0L);
        long newHeader = header & 0xC000000000000000L | nextRecordAddress;
        directAccessor.putLong(logicalAddress, recordAddress + 0L, newHeader);
    }

    @Override
    public boolean keyEquals(long logicalAddress, long physicalRecord, Data key) {
        long recordKey = this.readKeyAddress(logicalAddress, physicalRecord);
        return NativeMemoryDataUtil.equals(recordKey, key);
    }

    @Override
    public void lockRecord(long recordLogicalAddress, long recordPhysicalAddress) {
        long lockedHeader;
        long oldHeader;
        long unlockedHeader;
        while (!this.casHeader(recordLogicalAddress, recordPhysicalAddress, unlockedHeader = BaseTieredStoreRecordAccessor.unlockedHeader(oldHeader = this.readHeader(recordLogicalAddress, recordPhysicalAddress)), lockedHeader = BaseTieredStoreRecordAccessor.lockedHeader(oldHeader))) {
        }
        assert (this.isLocked(recordLogicalAddress, recordPhysicalAddress));
    }

    @Override
    public void unlockRecord(long recordLogicalAddress, long recordPhysicalAddress) {
        assert (this.isLocked(recordLogicalAddress, recordPhysicalAddress));
        long oldHeader = this.readHeader(recordLogicalAddress, recordPhysicalAddress);
        long unlockedHeader = BaseTieredStoreRecordAccessor.unlockedHeader(oldHeader);
        this.writeHeader(recordLogicalAddress, recordPhysicalAddress, unlockedHeader);
    }

    private boolean casHeader(long recordLogicalAddress, long recordPhysicalAddress, long expectedHeader, long value) {
        return this.directAccessor().casLong(recordLogicalAddress, recordPhysicalAddress + 0L, expectedHeader, value);
    }

    private void writeHeader(long recordLogicalAddress, long recordPhysicalAddress, long value) {
        this.directAccessor().putLongVolatile(recordLogicalAddress, recordPhysicalAddress + 0L, value);
    }

    private long readHeader(long recordLogicalAddress, long recordPhysicalAddress) {
        return this.directAccessor().getLongVolatile(recordLogicalAddress, recordPhysicalAddress + 0L);
    }

    private boolean isLocked(long recordLogicalAddress, long recordPhysicalAddress) {
        long header = this.readHeader(recordLogicalAddress, recordPhysicalAddress);
        return (header & 0x4000000000000000L) != 0L;
    }

    private static long lockedHeader(long header) {
        return header | 0x4000000000000000L;
    }

    private static long unlockedHeader(long header) {
        return header & 0xBFFFFFFFFFFFFFFFL;
    }

    @Override
    public int getTotalInlinedLength(long logicalAddress, long physicalAddress) {
        return this.directAccessor().getInt(logicalAddress, physicalAddress + 8L);
    }

    @Override
    public void setTotalInlinedLength(long logicalAddress, long physicalAddress, int length) {
        this.directAccessor().putInt(logicalAddress, physicalAddress + 8L, length);
    }

    @Override
    public boolean isInMemory(TieredStoreRecord record) {
        return this.isInMemory(record.getLogicalAddress());
    }

    @Override
    public boolean isInMemory(TieredStoreRecord record, int threadIndex) {
        return this.isInMemory(record.getLogicalAddress(), threadIndex);
    }

    @Override
    public boolean isInMemory(long logicalRecord) {
        return this.getHybridLog().isInMemory(logicalRecord);
    }

    @Override
    public boolean isInMemory(long logicalRecord, int threadIndex) {
        return this.getHybridLog().isInMemory(logicalRecord, threadIndex);
    }

    @Override
    public long asPhysicalAddress(long logicalAddress, int threadIndex) {
        return this.getHybridLog().asPhysicalAddress(logicalAddress, threadIndex);
    }

    @Override
    public boolean isEqual(long address, TieredStoreRecord value) {
        this.directAccessor().verifyAccess(value.getLogicalAddress(), value.address());
        return this.isEqual(address, value.address());
    }

    @Override
    public boolean isEqual(long vAddress1, long vAddress2) {
        long keyAddress2;
        if (vAddress1 == vAddress2) {
            return true;
        }
        if (vAddress1 == 0L || vAddress2 == 0L) {
            return false;
        }
        long keyAddress1 = BaseTieredStoreRecordAccessor.readKeyAddress(vAddress1);
        if (NativeMemoryDataUtil.equals(keyAddress1, keyAddress2 = BaseTieredStoreRecordAccessor.readKeyAddress(vAddress2))) {
            long valueAddress1 = this.readValueAddress(vAddress1);
            long valueAddress2 = this.readValueAddress(vAddress2);
            return NativeMemoryDataUtil.equals(valueAddress1, valueAddress2);
        }
        return false;
    }

    @Override
    public TieredStoreRecord read(long address) {
        throw new UnsupportedOperationException("Tiered store has to provide logical address");
    }

    @Override
    public TieredStoreRecord read(long physicalAddress, long logicalAddress) {
        if (physicalAddress == 0L) {
            throw new IllegalArgumentException("Illegal memory address: " + physicalAddress);
        }
        TieredStoreRecord record = this.newRecord();
        record.reset(physicalAddress, logicalAddress, -1);
        return record;
    }

    @Override
    public long dispose(TieredStoreRecord record) {
        throw new UnsupportedOperationException("Hybrid log disposes records on compaction");
    }

    @Override
    public long dispose(long address) {
        throw new UnsupportedOperationException("Hybrid log disposes records on compaction");
    }

    private boolean isValueNull(long recordVAddress) {
        int valueOffset = BaseTieredStoreRecordAccessor.getValueOffset(recordVAddress);
        int valueSize = GlobalMemoryAccessorRegistry.AMEM.getInt(recordVAddress + (long)valueOffset);
        return valueSize == 0;
    }

    static long readKeyAddress(long recordVAddress) {
        if (BaseTieredStoreRecordAccessor.isKeyNull(recordVAddress)) {
            return 0L;
        }
        long keyAddress = recordVAddress + 12L;
        assert (GlobalMemoryAccessorRegistry.AMEM.getInt(keyAddress) > 0);
        return keyAddress;
    }

    static long getNextRecordAddress(HybridLogDirectAccessor directAccessor, long logicalAddress, long recordAddress) {
        long header = directAccessor.getLong(logicalAddress, recordAddress + 0L);
        return header & 0x3FFFFFFFFFFFFFFFL;
    }

    private static boolean isKeyNull(long recordVAddress) {
        int keySize = GlobalMemoryAccessorRegistry.AMEM.getInt(recordVAddress + 12L);
        return keySize == 0;
    }

    private boolean isKeyNull(long logicalAddress, long recordVAddress) {
        int keySize = this.directAccessor().getInt(logicalAddress, recordVAddress + 12L);
        return keySize == 0;
    }

    private void setKeyNull(TieredStoreRecord record) {
        this.directAccessor().putInt(record, record.address() + 12L, 0);
    }

    private static void setValueNull(TieredStoreRecord record) {
        int valueOffset = BaseTieredStoreRecordAccessor.getValueOffset(record.address());
        GlobalMemoryAccessorRegistry.AMEM.putInt(record.address() + (long)valueOffset, 0);
    }

    private static int getValueOffset(long recordVAddress) {
        int keySize = GlobalMemoryAccessorRegistry.AMEM.getInt(recordVAddress + 12L);
        assert (keySize > 0);
        return 16 + keySize;
    }

    @Override
    public Supplier<HybridLog> getHybridLogSupplier() {
        return this.hybridLogSupplier;
    }

    @Override
    public TieredStoreSlotAccessor getTieredStoreSlotAccessor() {
        return this.inMemorySlotAccessor;
    }

    @Override
    public TieredStoreChunkAccessor getTieredStoreChunkAccessor() {
        return this.inMemoryChunkAccessor;
    }

    protected abstract HybridLogDirectAccessor directAccessor();

    protected static class MapEntry
    implements Map.Entry<Data, Record<Data>> {
        private final Data key;
        private Record<Data> record;

        protected MapEntry(Data key, Record<Data> record) {
            this.key = key;
            this.record = record;
        }

        @Override
        public Data getKey() {
            return this.key;
        }

        @Override
        public Record getValue() {
            return this.record;
        }

        @Override
        public Record setValue(Record newValue) {
            Record<Data> oldValue = this.record;
            this.record = newValue;
            return oldValue;
        }
    }
}

