/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.internal.util.IterableUtil;
import com.hazelcast.internal.util.SetUtil;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.query.PartitionScanExecutor;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.QueryResultSizeLimiter;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.map.impl.query.ResultProcessor;
import com.hazelcast.map.impl.query.ResultProcessorRegistry;
import com.hazelcast.map.impl.query.ResultSegment;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.IndexRegistry;
import com.hazelcast.query.impl.QueryableEntriesSegment;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.predicates.QueryOptimizer;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.OperationService;
import java.util.Collection;

public class QueryRunner {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;
    protected final ILogger logger;
    protected final QueryResultSizeLimiter queryResultSizeLimiter;
    protected final InternalSerializationService serializationService;
    protected final QueryOptimizer queryOptimizer;
    protected final OperationService operationService;
    protected final ClusterService clusterService;
    protected final LocalMapStatsProvider localMapStatsProvider;
    protected final PartitionScanExecutor partitionScanExecutor;
    protected final ResultProcessorRegistry resultProcessorRegistry;
    private final int partitionCount;

    public QueryRunner(MapServiceContext mapServiceContext, QueryOptimizer optimizer, PartitionScanExecutor partitionScanExecutor, ResultProcessorRegistry resultProcessorRegistry) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.serializationService = (InternalSerializationService)this.nodeEngine.getSerializationService();
        this.logger = this.nodeEngine.getLogger(this.getClass());
        this.queryResultSizeLimiter = new QueryResultSizeLimiter(mapServiceContext, this.logger);
        this.queryOptimizer = optimizer;
        this.operationService = this.nodeEngine.getOperationService();
        this.clusterService = this.nodeEngine.getClusterService();
        this.localMapStatsProvider = mapServiceContext.getLocalMapStatsProvider();
        this.partitionScanExecutor = partitionScanExecutor;
        this.resultProcessorRegistry = resultProcessorRegistry;
        this.partitionCount = this.nodeEngine.getPartitionService().getPartitionCount();
    }

    public ResultSegment runPartitionScanQueryOnPartitionChunk(Query query, int partitionId, IterationPointer[] pointers, int fetchSize) {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(query.getMapName());
        Predicate predicate = this.queryOptimizer.optimize(query.getPredicate(), mapContainer.getOrCreateIndexRegistry(partitionId));
        QueryableEntriesSegment entries = this.partitionScanExecutor.execute(query.getMapName(), predicate, partitionId, pointers, fetchSize);
        ResultProcessor processor = this.resultProcessorRegistry.get(query.getResultType());
        Object result = processor.populateResult(query, Long.MAX_VALUE, entries.getEntries(), SetUtil.singletonPartitionIdSet(this.partitionCount, partitionId));
        return new ResultSegment((Result)result, entries.getPointers());
    }

    public Result runIndexOrPartitionScanQueryOnOwnedPartitions(Query query) {
        Result result = this.runIndexOrPartitionScanQueryOnOwnedPartitions(query, true);
        assert (result != null);
        return result;
    }

    public Result runIndexOrPartitionScanQueryOnOwnedPartitions(Query query, boolean doPartitionScan) {
        Result result;
        Predicate predicate;
        Iterable<QueryableEntry> entries;
        int migrationStamp = this.getMigrationStamp();
        PartitionIdSet ownedPartitions = this.mapServiceContext.getCachedOwnedPartitions();
        PartitionIdSet actualPartitions = query.getPartitionIdSet() != null ? ownedPartitions.intersectCopy(query.getPartitionIdSet()) : ownedPartitions;
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(query.getMapName());
        IndexRegistry indexRegistry = mapContainer.getGlobalIndexRegistry();
        if (indexRegistry == null) {
            indexRegistry = mapContainer.getOrCreateIndexRegistry(ownedPartitions.iterator().next());
        }
        if ((entries = this.runUsingGlobalIndexSafely(predicate = this.queryOptimizer.optimize(query.getPredicate(), indexRegistry), mapContainer, migrationStamp, ownedPartitions.size())) != null && !ownedPartitions.equals(actualPartitions)) {
            assert (indexRegistry.isGlobal());
            entries = IterableUtil.filter(entries, e -> {
                int partitionId = HashUtil.hashToIndex(e.getKeyData().getPartitionHash(), this.partitionCount);
                return actualPartitions.contains(partitionId);
            });
        }
        if (entries == null && !doPartitionScan) {
            return null;
        }
        if (entries == null) {
            result = this.runUsingPartitionScanSafely(query, predicate, actualPartitions, migrationStamp);
            if (result == null) {
                result = this.populateEmptyResult(query, actualPartitions);
            }
        } else {
            result = this.populateNonEmptyResult(query, entries, actualPartitions);
        }
        return result;
    }

    public Result runIndexQueryOnOwnedPartitions(Query query) {
        Predicate predicate;
        Iterable<QueryableEntry> entries;
        int migrationStamp = this.getMigrationStamp();
        PartitionIdSet ownedPartitions = this.mapServiceContext.getCachedOwnedPartitions();
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(query.getMapName());
        IndexRegistry indexRegistry = mapContainer.getGlobalIndexRegistry();
        if (indexRegistry == null) {
            indexRegistry = mapContainer.getOrCreateIndexRegistry(ownedPartitions.iterator().next());
        }
        Result result = (entries = this.runUsingGlobalIndexSafely(predicate = this.queryOptimizer.optimize(query.getPredicate(), indexRegistry), mapContainer, migrationStamp, ownedPartitions.size())) == null ? this.populateEmptyResult(query, ownedPartitions) : this.populateNonEmptyResult(query, entries, ownedPartitions);
        return result;
    }

    public Result runPartitionIndexOrPartitionScanQueryOnGivenOwnedPartition(Query query, int partitionId) {
        Result result;
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(query.getMapName());
        PartitionIdSet partitions = SetUtil.singletonPartitionIdSet(this.partitionCount, partitionId);
        Predicate predicate = this.queryOptimizer.optimize(query.getPredicate(), mapContainer.getOrCreateIndexRegistry(partitionId));
        Iterable<QueryableEntry> entries = null;
        IndexRegistry indexRegistry = mapContainer.getOrCreateIndexRegistry(partitionId);
        if (indexRegistry != null && !indexRegistry.isGlobal()) {
            entries = indexRegistry.query(predicate, partitions.size());
        }
        if (entries == null) {
            result = this.createResult(query, partitions);
            this.partitionScanExecutor.execute(query.getMapName(), predicate, partitions, result);
            result.completeConstruction(partitions);
        } else {
            result = this.populateNonEmptyResult(query, entries, partitions);
        }
        return result;
    }

    private Result createResult(Query query, Collection<Integer> partitions) {
        return query.createResult(this.serializationService, this.queryResultSizeLimiter, partitions.size());
    }

    protected Result populateEmptyResult(Query query, Collection<Integer> initialPartitions) {
        return this.resultProcessorRegistry.get(query.getResultType()).populateResult(query, this.queryResultSizeLimiter.getNodeResultLimit(initialPartitions.size()));
    }

    protected Result populateNonEmptyResult(Query query, Iterable<QueryableEntry> entries, PartitionIdSet initialPartitions) {
        ResultProcessor processor = this.resultProcessorRegistry.get(query.getResultType());
        return processor.populateResult(query, this.queryResultSizeLimiter.getNodeResultLimit(initialPartitions.size()), entries, initialPartitions);
    }

    protected Iterable<QueryableEntry> runUsingGlobalIndexSafely(Predicate predicate, MapContainer mapContainer, int migrationStamp, int ownedPartitionCount) {
        if (!this.validateMigrationStamp(migrationStamp)) {
            return null;
        }
        IndexRegistry indexRegistry = mapContainer.getGlobalIndexRegistry();
        if (indexRegistry == null) {
            return null;
        }
        if (!indexRegistry.isGlobal()) {
            return null;
        }
        Iterable<QueryableEntry> entries = indexRegistry.query(predicate, ownedPartitionCount);
        if (entries == null) {
            return null;
        }
        if (this.validateMigrationStamp(migrationStamp)) {
            return entries;
        }
        return null;
    }

    protected Result runUsingPartitionScanSafely(Query query, Predicate predicate, PartitionIdSet partitions, int migrationStamp) {
        if (!this.validateMigrationStamp(migrationStamp)) {
            return null;
        }
        Result result = this.createResult(query, partitions);
        this.partitionScanExecutor.execute(query.getMapName(), predicate, partitions, result);
        if (this.validateMigrationStamp(migrationStamp)) {
            result.completeConstruction(partitions);
            return result;
        }
        return null;
    }

    private int getMigrationStamp() {
        return this.mapServiceContext.getService().getMigrationStamp();
    }

    private boolean validateMigrationStamp(int migrationStamp) {
        return this.mapServiceContext.getService().validateMigrationStamp(migrationStamp);
    }

    int beforeOperation(int partitionId, String mapName) {
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        RecordStore recordStore = partitionContainer.getRecordStore(mapName);
        return recordStore.beforeOperation();
    }

    void afterOperation(int partitionId, String mapName, int threadIndex) {
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        RecordStore recordStore = partitionContainer.getRecordStore(mapName);
        recordStore.afterOperation(threadIndex);
    }
}

