/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.operation.LockAwareOperation;
import com.hazelcast.map.impl.operation.PutBackupOperation;
import com.hazelcast.map.impl.operation.steps.PutOpSteps;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.operation.steps.engine.Step;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.StaticParams;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryMetadata;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.Operation;

public abstract class BasePutOperation
extends LockAwareOperation
implements BackupAwareOperation {
    protected transient Object oldValue;
    protected transient EntryEventType eventType;
    protected transient Record recordToBackup;

    public BasePutOperation(String name, Data dataKey, Data value) {
        super(name, dataKey, value);
    }

    public BasePutOperation() {
    }

    @Override
    protected void innerBeforeRun() throws Exception {
        super.innerBeforeRun();
        if (this.getStaticParams().isCheckIfLoaded() && this.recordStore != null) {
            this.recordStore.checkIfLoaded();
        }
    }

    protected StaticParams getStaticParams() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Step getStartingStep() {
        return PutOpSteps.READ;
    }

    @Override
    public State createState() {
        return super.createState().setStaticPutParams(this.getStaticParams()).setTtl(this.getTtl()).setMaxIdle(this.getMaxIdle());
    }

    @Override
    public void applyState(State state) {
        this.oldValue = this.getOldValue(state);
        this.eventType = this.getEventType();
        this.recordToBackup = state.getRecord();
    }

    protected Data getOldValue(State state) {
        return this.mapServiceContext.toData(state.getOldValue());
    }

    @Override
    public void afterRunInternal() {
        Data value = this.isPostProcessingOrHasInterceptor(this.recordStore) ? this.recordStore.getRecord(this.dataKey).getValue() : this.dataValue;
        this.mapServiceContext.interceptAfterPut(this.mapContainer.getInterceptorRegistry(), value);
        this.mapEventPublisher.publishEvent(this.getCallerAddress(), this.name, this.oldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED, this.dataKey, this.oldValue, value);
        this.invalidateNearCache(this.dataKey);
        this.publishWanUpdate(this.dataKey, value);
        this.evict(this.dataKey);
        super.afterRunInternal();
    }

    protected long getTtl() {
        return -1L;
    }

    protected long getMaxIdle() {
        return -1L;
    }

    protected final EntryEventType getEventType() {
        if (this.eventType == null) {
            this.eventType = this.oldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
        }
        return this.eventType;
    }

    @Override
    public boolean shouldBackup() {
        this.recordToBackup = this.recordStore.getRecord(this.dataKey);
        return this.recordToBackup != null;
    }

    @Override
    public Operation getBackupOperation() {
        this.dataValue = this.getValueOrPostProcessedValue(this.recordToBackup, this.dataValue);
        return this.newBackupOperation(this.dataKey, this.recordToBackup, this.dataValue);
    }

    protected PutBackupOperation newBackupOperation(Data dataKey, Record record, Data dataValue) {
        ExpiryMetadata metadata = this.recordStore.getExpirySystem().getExpiryMetadata(dataKey);
        return new PutBackupOperation(this.name, dataKey, record, dataValue, metadata);
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public void onWaitExpire() {
        this.sendResponse(null);
    }
}

