/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.eviction;

import com.hazelcast.core.EntryView;
import com.hazelcast.internal.hidensity.HiDensityStorageInfo;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.eviction.EvictionChecker;
import com.hazelcast.map.impl.eviction.EvictorImpl;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.ForcedEvictable;
import com.hazelcast.map.impl.recordstore.HDStorageSCHM;
import com.hazelcast.map.impl.recordstore.HotRestartHDStorageImpl;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.recordstore.expiry.ExpiryReason;
import com.hazelcast.spi.eviction.EvictionPolicyComparator;
import java.util.Iterator;
import java.util.Map;

public class HDEvictorImpl
extends EvictorImpl {
    private static final int MAX_PER_PASS_REMOVAL_COUNT = 1024;
    private static final int MIN_FORCED_EVICTION_ENTRY_REMOVE_COUNT = 20;
    private final HiDensityStorageInfo storageInfo;
    private final ILogger logger;

    public HDEvictorImpl(EvictionPolicyComparator evictionPolicyComparator, EvictionChecker evictionChecker, int batchSize, IPartitionService partitionService, HiDensityStorageInfo storageInfo, ILogger logger) {
        super(evictionPolicyComparator, evictionChecker, batchSize, partitionService);
        this.storageInfo = storageInfo;
        this.logger = logger;
    }

    @Override
    protected Record getRecordFromEntryView(EntryView evictableEntryView) {
        return ((HDStorageSCHM.LazyEvictableEntryView)evictableEntryView).getRecord();
    }

    @Override
    protected Data getDataKeyFromEntryView(EntryView evictableEntryView) {
        return ((HDStorageSCHM.LazyEvictableEntryView)evictableEntryView).getDataKey();
    }

    @Override
    public void forceEvictByPercentage(RecordStore recordStore, double percentage) {
        assert (percentage > 0.0 && percentage <= 1.0) : "wrong percentage found " + percentage;
        if (recordStore.size() == 0) {
            return;
        }
        long now = HDEvictorImpl.getNow();
        boolean backup = this.isBackup(recordStore);
        int removeThisNumOfEntries = (int)Math.max((double)recordStore.size() * percentage, 20.0);
        int maxRemovePerPass = Math.min(removeThisNumOfEntries, 1024);
        Data[] keysToRemove = new Data[maxRemovePerPass];
        do {
            this.evictRecordStore(recordStore, maxRemovePerPass, keysToRemove, now, backup);
        } while (recordStore.size() > 0 && (removeThisNumOfEntries -= maxRemovePerPass) > 0);
    }

    private void evictRecordStore(RecordStore recordStore, int maxRemovePerPass, Data[] keysToRemove, long now, boolean backup) {
        int index = -1;
        Iterator<Map.Entry<Data, Record>> recordIterator = this.getEntryIterator(recordStore, maxRemovePerPass);
        while (recordIterator.hasNext()) {
            Map.Entry<Data, Record> entry = recordIterator.next();
            Data key = entry.getKey();
            if (!recordStore.isLocked(key)) {
                if (!backup) {
                    ExpiryReason expiryReason = recordStore.hasExpired(key, now, false);
                    recordStore.doPostEvictionOperations(key, entry.getValue().getValue(), expiryReason);
                }
                keysToRemove[++index] = key;
            }
            if (index + 1 != maxRemovePerPass) continue;
            break;
        }
        int removedKeyCount = HDEvictorImpl.removeKeys(keysToRemove, recordStore, backup);
        recordStore.disposeDeferredBlocks();
        if (this.storageInfo.increaseForceEvictionCount() == 1L) {
            this.logger.warning("Forced eviction invoked for the first time for IMap[name=" + recordStore.getName() + "]");
        }
        this.storageInfo.increaseForceEvictedEntryCount(removedKeyCount);
    }

    private Iterator<Map.Entry<Data, Record>> getEntryIterator(RecordStore recordStore, int maxRemovePerPass) {
        Storage storage = recordStore.getStorage();
        return maxRemovePerPass == recordStore.size() ? storage.mutationTolerantIterator() : ((ForcedEvictable)((Object)storage)).newRandomEvictionEntryIterator();
    }

    private static int removeKeys(Data[] keysToRemove, RecordStore recordStore, boolean backup) {
        int removedEntryCount = 0;
        for (int i = 0; i < keysToRemove.length; ++i) {
            Data key = keysToRemove[i];
            keysToRemove[i] = null;
            if (key == null) break;
            recordStore.evict(key, backup);
            ++removedEntryCount;
        }
        return removedEntryCount;
    }

    @Override
    protected Iterable<EntryView> getRandomSamples(RecordStore recordStore) {
        Storage storage = recordStore.getStorage();
        if (storage instanceof HotRestartHDStorageImpl) {
            HotRestartHDStorageImpl impl = (HotRestartHDStorageImpl)storage;
            return impl.getStorageImpl().getRandomSamples(SAMPLE_COUNT);
        }
        return storage.getRandomSamples(SAMPLE_COUNT);
    }
}

