/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.HotRestartConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MerkleTreeConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.instance.impl.EnterpriseNodeExtension;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.hotrestart.HotRestartIntegrationService;
import com.hazelcast.internal.hotrestart.HotRestartStore;
import com.hazelcast.internal.hotrestart.PersistentConfigDescriptors;
import com.hazelcast.internal.hotrestart.RamStore;
import com.hazelcast.internal.hotrestart.RamStoreRegistry;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.nio.Disposable;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.services.InternalMapOwner;
import com.hazelcast.internal.tstore.service.TieredStoreService;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.comparators.NativeValueComparator;
import com.hazelcast.internal.util.comparators.ValueComparator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.EnterpriseLocalMapStatsProvider;
import com.hazelcast.map.impl.EnterpriseMapContainer;
import com.hazelcast.map.impl.EnterpriseMapContainerImpl;
import com.hazelcast.map.impl.EnterpriseMapServiceContext;
import com.hazelcast.map.impl.EnterprisePartitionContainer;
import com.hazelcast.map.impl.EnterprisePartitionContainerImpl;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapKeyLoader;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContextImpl;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.event.EnterpriseMapEventPublisherImpl;
import com.hazelcast.map.impl.event.MapEventPublisherImpl;
import com.hazelcast.map.impl.nearcache.EnterpriseMapNearCacheManager;
import com.hazelcast.map.impl.nearcache.MapNearCacheManager;
import com.hazelcast.map.impl.operation.EnterpriseMapPartitionClearOperation;
import com.hazelcast.map.impl.query.HDPartitionScanExecutor;
import com.hazelcast.map.impl.query.HDPartitionScanRunner;
import com.hazelcast.map.impl.query.QueryRunner;
import com.hazelcast.map.impl.query.ResultProcessorRegistry;
import com.hazelcast.map.impl.recordstore.EnterpriseRecordStore;
import com.hazelcast.map.impl.recordstore.EnterpriseTieredRecordStore;
import com.hazelcast.map.impl.recordstore.HotRestartStorage;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.wan.MapFilterProvider;
import com.hazelcast.query.impl.HDGlobalIndexProvider;
import com.hazelcast.query.impl.HDPartitionedIndexProvider;
import com.hazelcast.query.impl.IndexProvider;
import com.hazelcast.query.impl.IndexUtils;
import com.hazelcast.query.impl.TSGlobalIndexProvider;
import com.hazelcast.query.impl.TSPartitionedIndexProvider;
import com.hazelcast.query.impl.predicates.QueryOptimizer;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.spi.impl.operationservice.OperationResponseHandlerFactory;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.spi.impl.proxyservice.impl.ProxyServiceImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EnterpriseMapServiceContextImpl
extends MapServiceContextImpl
implements EnterpriseMapServiceContext,
RamStoreRegistry {
    private static final int MAP_PARTITION_CLEAR_OPERATION_AWAIT_SECONDS = 10;
    private static final long MAP_HD_EXPIRY_STORAGE_DISPOSE_DELAY_SECONDS = 30L;
    private final QueryRunner hdMapQueryRunner;
    private final IndexProvider hdIndexProvider;
    private final MapFilterProvider mapFilterProvider;
    private HotRestartIntegrationService hotRestartService;
    private final boolean globalIndexEnabled;
    private final IndexProvider tstoreIndexProvider;
    private final boolean forciblyEnableGlobalIndex;
    private final TieredStoreService tieredStoreService;
    private final ConcurrentMap<String, Map<String, IndexConfig>> mapIndexConfigs = new ConcurrentHashMap<String, Map<String, IndexConfig>>();

    EnterpriseMapServiceContextImpl(NodeEngine nodeEngine) {
        super(nodeEngine);
        this.mapFilterProvider = new MapFilterProvider(nodeEngine);
        this.hdMapQueryRunner = this.createHDMapQueryRunner(new HDPartitionScanRunner(this), this.getQueryOptimizer(), this.getResultProcessorRegistry());
        this.globalIndexEnabled = this.getNodeEngine().getProperties().getBoolean(ClusterProperty.GLOBAL_HD_INDEX_ENABLED);
        this.forciblyEnableGlobalIndex = this.getNodeEngine().getProperties().getBoolean(new HazelcastProperty("hazelcast.tiered.store.global.index.enabled", false));
        this.hdIndexProvider = this.globalIndexEnabled() ? new HDGlobalIndexProvider() : new HDPartitionedIndexProvider();
        Node node = nodeEngine.getNode();
        EnterpriseNodeExtension nodeExtension = (EnterpriseNodeExtension)node.getNodeExtension();
        IndexProvider indexProvider = this.tstoreIndexProvider = this.forciblyEnableGlobalIndex ? new TSGlobalIndexProvider() : new TSPartitionedIndexProvider();
        if (nodeExtension.isHotRestartEnabled()) {
            this.hotRestartService = (HotRestartIntegrationService)nodeExtension.getInternalHotRestartService();
            this.hotRestartService.registerRamStoreRegistry("hz:impl:mapService", this);
            this.hotRestartService.registerLoadedConfigurationListener((serviceName, name, config) -> {
                if ("hz:impl:mapService".equals(serviceName) && config instanceof IndexConfig) {
                    IndexConfig indexConfig = (IndexConfig)config;
                    String[] parts = name.split("::", 2);
                    if (parts.length != 2 || !parts[1].equals(indexConfig.getName())) {
                        throw new HotRestartException("Inconsistent persisted index configuration: " + name);
                    }
                    this.addIndexConfig(parts[0], indexConfig);
                }
            });
        }
        nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(new MetricsProvider(this.getMapContainers()));
        this.tieredStoreService = (TieredStoreService)nodeEngine.getService("hz:ee:tieredStoreServiceImpl");
    }

    private QueryRunner createHDMapQueryRunner(HDPartitionScanRunner runner, QueryOptimizer queryOptimizer, ResultProcessorRegistry resultProcessorRegistry) {
        return new QueryRunner(this, queryOptimizer, new HDPartitionScanExecutor(runner), resultProcessorRegistry);
    }

    @Override
    protected PartitionContainer createPartitionContainer(MapService service, int partitionId) {
        return new EnterprisePartitionContainerImpl(service, this.tieredStoreService, partitionId);
    }

    @Override
    protected LocalMapStatsProvider createLocalMapStatsProvider() {
        return new EnterpriseLocalMapStatsProvider(this);
    }

    @Override
    MapContainer createMapContainer(String mapName) {
        return new EnterpriseMapContainerImpl(mapName, this.getNodeEngine().getConfig(), this);
    }

    @Override
    MapNearCacheManager createMapNearCacheManager() {
        return new EnterpriseMapNearCacheManager(this);
    }

    @Override
    MapEventPublisherImpl createMapEventPublisherSupport() {
        return new EnterpriseMapEventPublisherImpl(this);
    }

    @Override
    public ValueComparator getValueComparatorOf(InMemoryFormat inMemoryFormat) {
        if (inMemoryFormat == InMemoryFormat.NATIVE) {
            return NativeValueComparator.INSTANCE;
        }
        return super.getValueComparatorOf(inMemoryFormat);
    }

    @Override
    public HotRestartStore getOnHeapHotRestartStoreForPartition(int partitionId) {
        return this.hotRestartService.getOnHeapHotRestartStoreForPartition(partitionId);
    }

    @Override
    @Nullable
    public HotRestartStore getOffHeapHotRestartStoreForPartition(int partitionId) {
        return this.hotRestartService.getOffHeapHotRestartStoreForPartition(partitionId);
    }

    @Override
    public RamStore ramStoreForPrefix(long prefix) {
        String name;
        int partitionId = PersistentConfigDescriptors.toPartitionId(prefix);
        EnterpriseRecordStore recordStore = (EnterpriseRecordStore)this.getExistingRecordStore(partitionId, name = this.hotRestartService.getCacheName(prefix));
        return recordStore == null ? null : recordStore.getRamStore();
    }

    @Override
    public RamStore restartingRamStoreForPrefix(long prefix) {
        int partitionId = PersistentConfigDescriptors.toPartitionId(prefix);
        String name = this.hotRestartService.getCacheName(prefix);
        PartitionContainer partitionContainer = this.getPartitionContainer(partitionId);
        EnterpriseRecordStore recordStore = (EnterpriseRecordStore)partitionContainer.getRecordStoreForHotRestart(name);
        return recordStore.getRamStore();
    }

    @Override
    public int prefixToThreadId(long prefix) {
        throw new UnsupportedOperationException("prefixToThreadId() should not have been called on this class");
    }

    @Override
    public BiTuple<String, String> describe(long prefix) {
        HashMap<String, String> descriptorsMap = new HashMap<String, String>();
        for (InternalMapOwner service : this.getNodeEngine().getServices(InternalMapOwner.class)) {
            descriptorsMap.putAll(service.describeInternalMaps());
        }
        String mapName = this.hotRestartService.getCacheName(prefix);
        String instructions = "enable data persistence in MapConfig#dataPersistenceConfig";
        for (Map.Entry mapDescriptor : descriptorsMap.entrySet()) {
            if (!mapName.startsWith((String)mapDescriptor.getKey())) continue;
            instructions = (String)mapDescriptor.getValue();
            break;
        }
        return BiTuple.of(mapName, instructions);
    }

    @Override
    public MapFilterProvider getMapFilterProvider() {
        return this.mapFilterProvider;
    }

    @Override
    public QueryRunner getMapQueryRunner(String mapName) {
        if (this.getInMemoryFormat(mapName) == InMemoryFormat.NATIVE) {
            return this.hdMapQueryRunner;
        }
        return super.getMapQueryRunner(mapName);
    }

    private InMemoryFormat getInMemoryFormat(String mapName) {
        MapContainer container = this.getMapContainer(mapName);
        MapConfig mapConfig = container.getMapConfig();
        return mapConfig.getInMemoryFormat();
    }

    @Override
    public Data toData(Object object) {
        return ((EnterpriseSerializationService)this.getNodeEngine().getSerializationService()).toData(object, DataType.HEAP);
    }

    @Override
    protected void removeAllRecordStoresOfAllMaps(boolean onShutdown, boolean onRecordStoreDestroy) {
        NodeEngine nodeEngine = this.getNodeEngine();
        OperationService operationService = nodeEngine.getOperationService();
        ArrayList<EnterpriseMapPartitionClearOperation> operations = new ArrayList<EnterpriseMapPartitionClearOperation>();
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        for (int i = 0; i < partitionCount; ++i) {
            ConcurrentMap<String, RecordStore> maps;
            PartitionContainer partitionContainer = this.getPartitionContainer(i);
            if (partitionContainer == null || (maps = partitionContainer.getMaps()).isEmpty()) continue;
            EnterpriseMapPartitionClearOperation operation = new EnterpriseMapPartitionClearOperation(onShutdown);
            operation.setPartitionId(i).setOperationResponseHandler(OperationResponseHandlerFactory.createEmptyResponseHandler()).setNodeEngine(nodeEngine).setService(this.getService());
            if (operationService.isRunAllowed(operation)) {
                operationService.run(operation);
                continue;
            }
            operationService.execute(operation);
            operations.add(operation);
        }
        for (EnterpriseMapPartitionClearOperation operation : operations) {
            try {
                operation.awaitCompletion(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                nodeEngine.getLogger(this.getClass()).warning(e);
            }
        }
    }

    @Override
    public RecordStore createRecordStore(MapContainer mapContainer, int partitionId, MapKeyLoader keyLoader) {
        NodeEngine nodeEngine = this.getNodeEngine();
        if (mapContainer.getMapConfig().getTieredStoreConfig().isEnabled()) {
            ILogger logger = nodeEngine.getLogger(EnterpriseTieredRecordStore.class);
            return new EnterpriseTieredRecordStore(mapContainer, partitionId, keyLoader, logger);
        }
        long prefix = -1L;
        HotRestartConfig hotRestartConfig = this.getHotRestartConfig(mapContainer);
        if (hotRestartConfig.isEnabled()) {
            if (this.hotRestartService == null) {
                throw new HazelcastException("Hot Restart is enabled for map: " + mapContainer.getMapConfig().getName() + " but Hot Restart persistence is not enabled!");
            }
            String name = mapContainer.getName();
            this.hotRestartService.ensureHasConfiguration("hz:impl:mapService", name, null);
            prefix = this.hotRestartService.registerRamStore(this, "hz:impl:mapService", name, partitionId);
            if (!this.hotRestartService.isStartCompleted()) {
                ProxyServiceImpl proxyService = (ProxyServiceImpl)nodeEngine.getProxyService();
                UUID source = nodeEngine.getLocalMember().getUuid();
                proxyService.getOrCreateRegistry("hz:impl:mapService").getOrCreateProxyFuture(name, source, false, false);
            }
        }
        return new EnterpriseRecordStore(mapContainer, partitionId, keyLoader, this.logger, hotRestartConfig, prefix);
    }

    private HotRestartConfig getHotRestartConfig(MapContainer mapContainer) {
        return mapContainer.getMapConfig().getHotRestartConfig();
    }

    @Override
    public IndexProvider getIndexProvider(MapConfig mapConfig) {
        if (mapConfig.getInMemoryFormat() != InMemoryFormat.NATIVE) {
            return super.getIndexProvider(mapConfig);
        }
        if (mapConfig.getTieredStoreConfig().isEnabled()) {
            return this.tstoreIndexProvider;
        }
        return this.hdIndexProvider;
    }

    @Override
    public boolean globalIndexEnabled() {
        return this.globalIndexEnabled;
    }

    @Override
    public boolean isForciblyEnabledGlobalIndex() {
        return this.forciblyEnableGlobalIndex;
    }

    @Override
    public boolean shouldEnableMerkleTree(MapConfig mapConfig) {
        MerkleTreeConfig merkleTreeConfig = mapConfig.getMerkleTreeConfig();
        Boolean merkleTreeEnabled = merkleTreeConfig.getEnabled();
        boolean hotRestartEnabled = mapConfig.getHotRestartConfig().isEnabled();
        boolean implicitlyEnabled = hotRestartEnabled && merkleTreeEnabled == null;
        return implicitlyEnabled || Boolean.TRUE.equals(merkleTreeEnabled);
    }

    @Override
    public boolean shouldEnableMerkleTree(MapContainer mapContainer, boolean log) {
        MapConfig mapConfig = mapContainer.getMapConfig();
        boolean shouldEnableMerkleTree = this.shouldEnableMerkleTree(mapConfig);
        if (shouldEnableMerkleTree && log && (mapConfig.getMerkleTreeConfig().getEnabled() == null || !mapConfig.getMerkleTreeConfig().getEnabled().booleanValue())) {
            ((EnterpriseMapContainer)mapContainer).logMerkleTreeImplicitlyEnabled(this.logger);
        }
        return shouldEnableMerkleTree;
    }

    @Override
    public void shutdown() {
        try {
            super.shutdown();
        }
        finally {
            this.onNodeShutdownCloseHybridLogHandlePool();
        }
    }

    private void onNodeShutdownCloseHybridLogHandlePool() {
        PartitionContainer[] partitionContainers;
        for (PartitionContainer partitionContainer : partitionContainers = this.getPartitionContainers()) {
            if (partitionContainer == null) continue;
            ((EnterprisePartitionContainer)partitionContainer).onNodeShutdownCloseHybridLogHandlePool();
        }
    }

    @Override
    public void registerIndex(String mapName, IndexConfig config) {
        assert (config.getName() != null) : "Index config should be already normalized";
        MapConfig mapConfig = this.getMapContainer(mapName).getMapConfig();
        if (mapConfig.getIndexConfigs().stream().anyMatch(index -> config.getName().equals(index.getName()))) {
            return;
        }
        if (mapConfig.getIndexConfigs().stream().filter(index -> index.getName() == null).map(index -> IndexUtils.validateAndNormalize(mapName, index)).anyMatch(index -> config.getName().equals(index.getName()))) {
            return;
        }
        if (mapConfig.getDataPersistenceConfig().isEnabled()) {
            this.addIndexConfig(mapName, config);
            this.hotRestartService.ensureHasConfiguration("hz:impl:mapService", EnterpriseMapServiceContextImpl.getIndexHotRestartConfigName(mapName, config.getName()), config);
        }
    }

    @Override
    public Collection<IndexConfig> getMapIndexConfigs(String mapName) {
        return this.mapIndexConfigs.getOrDefault(mapName, Map.of()).values();
    }

    @Override
    protected void removeMapIndexConfigs(String mapName) {
        Map indexes = (Map)this.mapIndexConfigs.remove(mapName);
        if (indexes != null) {
            for (String indexName : indexes.keySet()) {
                this.hotRestartService.removeConfiguration("hz:impl:mapService", EnterpriseMapServiceContextImpl.getIndexHotRestartConfigName(mapName, indexName));
            }
        }
    }

    private void addIndexConfig(String mapName, IndexConfig indexConfig) {
        this.mapIndexConfigs.computeIfAbsent(mapName, k -> new ConcurrentHashMap()).putIfAbsent(indexConfig.getName(), indexConfig);
    }

    @Nonnull
    private static String getIndexHotRestartConfigName(String mapName, String indexName) {
        if (mapName.contains("::")) {
            throw new IllegalArgumentException("Cannot add index to IMap with HotRestart enabled whose name contains '::'. Use different IMap name");
        }
        return mapName + "::" + indexName;
    }

    @Override
    protected void postProcessNonEmptyRemovedRecordStores(List<RecordStore> removedRecordStores, int partitionId, boolean onShutdown) {
        super.postProcessNonEmptyRemovedRecordStores(removedRecordStores, partitionId, onShutdown);
        this.batchSubmitHotRestartClearTasks(removedRecordStores, partitionId, onShutdown);
    }

    private void batchSubmitHotRestartClearTasks(List<RecordStore> removedRecordStores, int partitionId, boolean onShutdown) {
        if (onShutdown) {
            return;
        }
        ArrayList<Long> onHeap = new ArrayList<Long>();
        ArrayList<Long> onHeapWithFsync = new ArrayList<Long>();
        ArrayList<Long> offHeap = new ArrayList<Long>();
        ArrayList<Long> offHeapWithFsync = new ArrayList<Long>();
        for (int i = 0; i < removedRecordStores.size(); ++i) {
            RecordStore recordStore = removedRecordStores.get(i);
            Storage storage = recordStore.getStorage();
            if (!(storage instanceof HotRestartStorage)) continue;
            HotRestartStorage store = (HotRestartStorage)storage;
            boolean fsync = store.isFsync();
            long prefix = store.getPrefix();
            if (recordStore.getInMemoryFormat() == InMemoryFormat.NATIVE) {
                (fsync ? offHeapWithFsync : offHeap).add(prefix);
                continue;
            }
            (fsync ? onHeapWithFsync : onHeap).add(prefix);
        }
        if (!onHeap.isEmpty()) {
            this.getOnHeapHotRestartStoreForPartition(partitionId).clear(false, EnterpriseMapServiceContextImpl.toPrimitiveLongArray(onHeap));
        }
        if (!onHeapWithFsync.isEmpty()) {
            this.getOnHeapHotRestartStoreForPartition(partitionId).clear(true, EnterpriseMapServiceContextImpl.toPrimitiveLongArray(onHeapWithFsync));
        }
        if (!offHeap.isEmpty()) {
            this.getOffHeapHotRestartStoreForPartition(partitionId).clear(false, EnterpriseMapServiceContextImpl.toPrimitiveLongArray(offHeap));
        }
        if (!offHeapWithFsync.isEmpty()) {
            this.getOffHeapHotRestartStoreForPartition(partitionId).clear(true, EnterpriseMapServiceContextImpl.toPrimitiveLongArray(offHeapWithFsync));
        }
    }

    private static long[] toPrimitiveLongArray(List<Long> list) {
        long[] result = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    @Override
    protected void processDisposalQueue(Queue<Disposable> disposalQueue, int partitionId, boolean onShutdown) {
        if (disposalQueue != null && !disposalQueue.isEmpty()) {
            Disposable disposable = () -> {
                Disposable e;
                while ((e = (Disposable)disposalQueue.poll()) != null) {
                    e.dispose();
                }
            };
            if (onShutdown) {
                ((EnterpriseSerializationService)this.getNodeEngine().getSerializationService()).disposeOnNodeClose(disposable);
            } else {
                NodeEngine nodeEngine = this.getNodeEngine();
                TaskScheduler globalTaskScheduler = nodeEngine.getExecutionService().getGlobalTaskScheduler();
                globalTaskScheduler.schedule(() -> this.disposeOnPartitionThread(partitionId, disposable), 30L, TimeUnit.SECONDS);
            }
        }
    }

    private void disposeOnPartitionThread(final int partitionId, final Disposable disposable) {
        this.getNodeEngine().getOperationService().getOperationExecutor().execute(new PartitionSpecificRunnable(){

            @Override
            public int getPartitionId() {
                return partitionId;
            }

            @Override
            public void run() {
                disposable.dispose();
            }
        });
    }

    private static final class MetricsProvider
    implements DynamicMetricsProvider {
        private final Map<String, MapContainer> mapContainers;

        private MetricsProvider(Map<String, MapContainer> mapContainers) {
            this.mapContainers = mapContainers;
        }

        @Override
        public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
            descriptor.withPrefix("map");
            for (MapContainer mapContainer : this.mapContainers.values()) {
                if (!(mapContainer instanceof EnterpriseMapContainer)) continue;
                EnterpriseMapContainer container = (EnterpriseMapContainer)mapContainer;
                context.collect(descriptor.copy().withDiscriminator("name", mapContainer.getName()), container.getHDStorageInfo());
            }
        }
    }
}

