/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.extractor;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.License;
import com.hazelcast.license.domain.LicenseVersion;
import com.hazelcast.license.exception.InvalidLicenseException;
import com.hazelcast.license.extractor.ExtractorUtils;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.EnumSet;

public final class LicenseExtractorV5 {
    public static final int RESERVED = 43;
    public static final char[] CHARS = "az{Vh}r4:t$e]>_3%?@o|^p=.x*~<R;&c[s!+L-F7\u00a3IvY6ulkJB9jfQSdTWqGbX58ECw21nNM0PHKZmyUiOAgD".toCharArray();
    public static final int LENGTH = CHARS.length;

    private LicenseExtractorV5() {
    }

    public static License extractLicense(String licenseKey) throws InvalidLicenseException {
        String string;
        if (licenseKey == null || licenseKey.isEmpty()) {
            throw new InvalidLicenseException("License key can not be empty.");
        }
        Object[] objectArray = licenseKey.split("#");
        if (LENGTH != (objectArray = (Object[])objectArray[objectArray.length - 1].toCharArray()).length) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        char[] cArray = new char[LENGTH];
        System.arraycopy(objectArray, 0, cArray, 0, LENGTH);
        char c = cArray[42];
        cArray[42] = '\u0000';
        char c2 = cArray[43];
        cArray[43] = '\u0000';
        char[] cArray2 = ExtractorUtils.hash(cArray);
        if (cArray2[0] != c || cArray2[cArray2.length - 1] != c2) {
            throw new InvalidLicenseException("Invalid License Key!");
        }
        c = cArray[0];
        char c3 = c;
        c = cArray[LicenseExtractorV5.a(CHARS, c3)] == '1' ? (char)'\u0001' : '\u0000';
        c3 = c2 = cArray[1];
        char cfr_ignored_0 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        c2 = cArray[2];
        char c4 = cArray[3];
        c3 = c2;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        int n = LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3) * 10;
        c3 = c4;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        c2 = n + LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3);
        c4 = cArray[4];
        char c5 = cArray[5];
        c3 = c4;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        int n2 = LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3) * 10;
        c3 = c5;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        c4 = n2 + LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3);
        c5 = cArray[6];
        char c6 = cArray[7];
        c3 = c5;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        int n3 = 2000 + LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3) * 10;
        c3 = c6;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        c5 = n3 + LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3);
        ZonedDateTime zonedDateTime = LocalDate.of((int)c5, c4, (int)c2).atTime(LocalTime.MAX).atZone(ZoneOffset.UTC);
        c4 = cArray[8];
        c5 = cArray[9];
        c6 = cArray[10];
        char c7 = cArray[11];
        c3 = c4;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        int n4 = LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3) * 1000;
        c3 = c5;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        int n5 = n4 + LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3) * 100;
        c3 = c6;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        int n6 = n5 + LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3) * 10;
        c3 = c7;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        c4 = n6 + LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3);
        c5 = cArray[12];
        c6 = cArray[13];
        c7 = cArray[14];
        char c8 = cArray[15];
        c3 = c5;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3) == 1) {
            c3 = c6;
            c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
            int n7 = LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3) * 100;
            c3 = c7;
            c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
            int n8 = n7 + LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3) * 10;
            c3 = c8;
            c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
            c5 = n8 + LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3);
        } else {
            c3 = c6;
            c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
            int n9 = LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3) * 10;
            c3 = c7;
            c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
            c5 = n9 + LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3);
        }
        c3 = c6 = cArray[16];
        c6 = cArray[LicenseExtractorV5.a(CHARS, c3)] == '1' ? (char)'\u0001' : '\u0000';
        c7 = cArray[17];
        c8 = cArray[18];
        c3 = c7;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        int n10 = LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3) * 10;
        c3 = c8;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        c7 = n10 + LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3);
        c8 = cArray[19];
        char c9 = cArray[20];
        c3 = c8;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        int n11 = LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3) * 10;
        c3 = c9;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        c8 = n11 + LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3);
        ZonedDateTime zonedDateTime2 = zonedDateTime.minusMonths(c8);
        char cfr_ignored_1 = cArray[21];
        char cfr_ignored_2 = cArray[22];
        char cfr_ignored_3 = cArray[23];
        char cfr_ignored_4 = cArray[24];
        char cfr_ignored_5 = cArray[25];
        c9 = cArray[26];
        char c10 = cArray[27];
        char c11 = cArray[28];
        char c12 = cArray[29];
        char c13 = cArray[30];
        char c14 = cArray[31];
        char c15 = cArray[32];
        char c16 = cArray[33];
        char c17 = cArray[34];
        char c18 = cArray[35];
        char c19 = cArray[36];
        char c20 = cArray[37];
        char c21 = cArray[38];
        char c22 = cArray[39];
        char c23 = cArray[40];
        char cfr_ignored_6 = cArray[41];
        EnumSet<Feature> enumSet = EnumSet.noneOf(Feature.class);
        c3 = c9;
        c3 = cArray[LicenseExtractorV5.a(CHARS, c3)];
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3) == 1) {
            enumSet.add(Feature.MAN_CENTER);
        }
        c3 = c10;
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3 = cArray[LicenseExtractorV5.a(CHARS, c3)]) == 1) {
            enumSet.add(Feature.CLUSTERED_JMX);
        }
        c3 = c11;
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3 = cArray[LicenseExtractorV5.a(CHARS, c3)]) == 1) {
            enumSet.add(Feature.CLUSTERED_REST);
        }
        c3 = c12;
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3 = cArray[LicenseExtractorV5.a(CHARS, c3)]) == 1) {
            enumSet.add(Feature.SECURITY);
        }
        c3 = c13;
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3 = cArray[LicenseExtractorV5.a(CHARS, c3)]) == 1) {
            enumSet.add(Feature.WAN);
        }
        c3 = c14;
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3 = cArray[LicenseExtractorV5.a(CHARS, c3)]) == 1) {
            enumSet.add(Feature.HD_MEMORY);
        }
        c3 = c15;
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3 = cArray[LicenseExtractorV5.a(CHARS, c3)]) == 1) {
            enumSet.add(Feature.PERSISTENCE);
        }
        c3 = c16;
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3 = cArray[LicenseExtractorV5.a(CHARS, c3)]) == 1) {
            enumSet.add(Feature.ROLLING_UPGRADE);
        }
        c3 = c17;
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3 = cArray[LicenseExtractorV5.a(CHARS, c3)]) == 1) {
            enumSet.add(Feature.STREAMING_MAN_CENTER);
        }
        c3 = c18;
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3 = cArray[LicenseExtractorV5.a(CHARS, c3)]) == 1) {
            enumSet.add(Feature.STREAMING_LOSSLESS_CLUSTER_RESTART);
        }
        c3 = c19;
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3 = cArray[LicenseExtractorV5.a(CHARS, c3)]) == 1) {
            enumSet.add(Feature.STREAMING_JOB_UPGRADES);
        }
        c3 = c20;
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3 = cArray[LicenseExtractorV5.a(CHARS, c3)]) == 1) {
            enumSet.add(Feature.STREAMING_ENTERPRISE);
        }
        c3 = c21;
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3 = cArray[LicenseExtractorV5.a(CHARS, c3)]) == 1) {
            enumSet.add(Feature.CLIENT_FILTERING);
        }
        c3 = c22;
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3 = cArray[LicenseExtractorV5.a(CHARS, c3)]) == 1) {
            enumSet.add(Feature.CP_PERSISTENCE);
        }
        c3 = c23;
        if (LicenseExtractorV5.a(ExtractorUtils.DIGITS, c3 = cArray[LicenseExtractorV5.a(CHARS, c3)]) == 1) {
            enumSet.add(Feature.DYNAMIC_CONFIGURATION);
        }
        return License.builder().version(LicenseVersion.V5).key(string).creationDate(zonedDateTime2).expiryDate(zonedDateTime).allowedNumberOfNodes(c4).allowedNativeMemorySize(100).hazelcastVersion(c5).oem(c6 != '\u0000').gracePeriod(c7).trial(c != '\u0000').features(enumSet).build();
    }

    private static int a(char[] cArray, char c) {
        for (int i = 0; i < cArray.length; ++i) {
            if (c != cArray[i]) continue;
            return i;
        }
        return -1;
    }
}

