/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.license.extractor;

import com.hazelcast.license.domain.Feature;
import com.hazelcast.license.domain.LicenseVersion;
import java.util.EnumSet;
import java.util.Set;

public final class ExtractorUtils {
    public static final char[] CHARS = "dsx4MZQvo2tqegGLpWhCDXnPYzciBR3murF5SA7KIObaw1Vf6JNyjEl0UTkH".toCharArray();
    public static final int LENGTH = CHARS.length;
    public static final char[] DIGITS = "0123456789".toCharArray();
    public static final int yearBase = 2000;

    private ExtractorUtils() {
    }

    public static char[] hash(char[] a2) {
        char[] cArray;
        if (a2 == null) {
            return new char[]{'0'};
        }
        int n = 1;
        for (char c : cArray) {
            n = n * 31 + c;
        }
        return Integer.toString(Math.abs(n)).toCharArray();
    }

    static Set<Feature> a(char c, LicenseVersion licenseVersion) {
        EnumSet<Feature> enumSet = EnumSet.noneOf(Feature.class);
        if (c == '0') {
            enumSet.add(Feature.MAN_CENTER);
        }
        if (c == '2') {
            enumSet.add(Feature.SECURITY);
        }
        if (c == '1') {
            ExtractorUtils.a(enumSet);
            if (licenseVersion == LicenseVersion.V2) {
                enumSet.add(Feature.HD_MEMORY);
            }
        }
        if (licenseVersion == LicenseVersion.V3 && c == '3') {
            ExtractorUtils.a(enumSet);
            enumSet.add(Feature.HD_MEMORY);
            enumSet.add(Feature.PERSISTENCE);
        }
        return enumSet;
    }

    private static void a(Set<Feature> set) {
        set.add(Feature.MAN_CENTER);
        set.add(Feature.WEB_SESSION);
        set.add(Feature.CLUSTERED_REST);
        set.add(Feature.CLUSTERED_JMX);
        set.add(Feature.SECURITY);
        set.add(Feature.WAN);
        set.add(Feature.ROLLING_UPGRADE);
    }
}

