/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline.test;

import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.AppendableTraverser;
import com.hazelcast.jet.core.EventTimeMapper;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.logging.ILogger;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class LongStreamSourceP
extends AbstractProcessor {
    private static final long SOURCE_THROUGHPUT_REPORTING_PERIOD_SECONDS = 5L;
    private static final long HICCUP_REPORT_THRESHOLD_NANOS = TimeUnit.MILLISECONDS.toNanos(10L);
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private final long nanoTimeMillisToCurrentTimeMillis = LongStreamSourceP.determineTimeOffset();
    private final long eventsPerSecond;
    private final EventTimeMapper<? super Long> eventTimeMapper;
    private long startNanoTime;
    private long globalProcessorIndex;
    private long totalParallelism;
    private long lastReportNanos;
    private long valueAtLastReport;
    private long lastCallNanos;
    private long valueToEmit;
    private long nowNanoTime;
    private ILogger logger;
    private Traverser<Object> traverser = new AppendableTraverser<Object>(2);

    LongStreamSourceP(long startTime, long eventsPerSecond, EventTimePolicy<? super Long> eventTimePolicy) {
        this.startNanoTime = startTime;
        this.eventsPerSecond = eventsPerSecond;
        this.eventTimeMapper = new EventTimeMapper<Long>(eventTimePolicy);
        this.eventTimeMapper.addPartitions(1);
    }

    @Override
    protected void init(@Nonnull Processor.Context context) {
        this.logger = context.logger();
        this.totalParallelism = context.totalParallelism();
        this.valueToEmit = this.globalProcessorIndex = (long)context.globalProcessorIndex();
        this.lastCallNanos = this.lastReportNanos = (this.startNanoTime = TimeUnit.MILLISECONDS.toNanos(this.startNanoTime + this.nanoTimeMillisToCurrentTimeMillis) + this.valueToEmit * NANOS_PER_SECOND / this.eventsPerSecond);
    }

    @Override
    public boolean complete() {
        this.nowNanoTime = System.nanoTime();
        this.emitEvents();
        this.detectAndReportHiccup();
        if (this.logger.isFineEnabled()) {
            this.reportThroughput();
        }
        return false;
    }

    private void emitEvents() {
        long emitValuesUpTo = (this.nowNanoTime - this.startNanoTime) * this.eventsPerSecond / NANOS_PER_SECOND;
        while (this.emitFromTraverser(this.traverser) && this.valueToEmit < emitValuesUpTo) {
            long timestampNanoTime = this.startNanoTime + this.valueToEmit * NANOS_PER_SECOND / this.eventsPerSecond;
            long timestamp = TimeUnit.NANOSECONDS.toMillis(timestampNanoTime) - this.nanoTimeMillisToCurrentTimeMillis;
            this.traverser = this.eventTimeMapper.flatMapEvent(this.nowNanoTime, (Long)this.valueToEmit, 0, timestamp);
            this.valueToEmit += this.totalParallelism;
        }
    }

    private void detectAndReportHiccup() {
        if (this.nowNanoTime - this.lastCallNanos > HICCUP_REPORT_THRESHOLD_NANOS) {
            this.logger.info(String.format("*** Source #%d hiccup: %,d ms%n", this.globalProcessorIndex, TimeUnit.NANOSECONDS.toMillis(this.nowNanoTime - this.lastCallNanos)));
        }
        this.lastCallNanos = this.nowNanoTime;
    }

    private void reportThroughput() {
        long nanosSinceLastReport = this.nowNanoTime - this.lastReportNanos;
        if (nanosSinceLastReport < TimeUnit.SECONDS.toNanos(5L)) {
            return;
        }
        this.lastReportNanos = this.nowNanoTime;
        long localItemCountSinceLastReport = (this.valueToEmit - this.valueAtLastReport) / this.totalParallelism;
        this.valueAtLastReport = this.valueToEmit;
        this.logger.fine("p%d: %,.0f items/second", this.globalProcessorIndex, (double)localItemCountSinceLastReport / ((double)nanosSinceLastReport / (double)NANOS_PER_SECOND));
    }

    private static long determineTimeOffset() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - System.currentTimeMillis();
    }
}

