/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.MasterContext;
import com.hazelcast.jet.impl.MasterSnapshotContext;
import com.hazelcast.jet.impl.SnapshotValidationRecord;
import com.hazelcast.jet.impl.TerminationMode;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.logging.ILogger;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class EnterpriseMasterSnapshotContext
extends MasterSnapshotContext {
    private static final int COPY_MAP_JOB_QUEUE_SIZE = 32;

    EnterpriseMasterSnapshotContext(MasterContext masterContext, ILogger logger) {
        super(masterContext, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Void> exportSnapshot(String name, boolean cancelJob) {
        JobStatus localStatus;
        CompletableFuture<Void> snapshotFuture = new CompletableFuture<Void>();
        this.mc.lock();
        boolean isJobSuspendable = Util.isJobSuspendable(this.mc.jobConfig());
        try {
            localStatus = this.mc.jobStatus();
            if (localStatus != JobStatus.RUNNING && localStatus != JobStatus.SUSPENDED) {
                throw new JetException("Cannot export snapshot, job is neither RUNNING nor SUSPENDED, but " + String.valueOf((Object)localStatus));
            }
            if (localStatus == JobStatus.SUSPENDED) {
                if (this.mc.jobExecutionRecord().snapshotId() < 0L) {
                    throw new JetException("Cannot export state snapshot: job is suspended and no successful snapshot was created while it was running");
                }
                this.mc.setJobStatus(JobStatus.SUSPENDED_EXPORTING_SNAPSHOT, "Export snapshot", true);
                localStatus = JobStatus.SUSPENDED_EXPORTING_SNAPSHOT;
            } else if (isJobSuspendable) {
                this.enqueueSnapshot(name, cancelJob, snapshotFuture);
            } else {
                snapshotFuture.complete(null);
            }
        }
        finally {
            this.mc.unlock();
        }
        if (localStatus == JobStatus.SUSPENDED_EXPORTING_SNAPSHOT) {
            String sourceMapName = this.mc.jobExecutionRecord().successfulSnapshotDataMapName();
            String targetMapName = "__jet.exportedSnapshot." + name;
            HazelcastInstance hazelcastInstance = this.mc.nodeEngine().getHazelcastInstance();
            CompletableFuture<Void> res = new CompletableFuture<Void>();
            Util.copyMapUsingJob(hazelcastInstance, 32, sourceMapName, targetMapName).whenComplete((BiConsumer)ExceptionUtil.withTryCatch(this.logger(), (r, t) -> {
                SnapshotValidationRecord validationRecord = (SnapshotValidationRecord)hazelcastInstance.getMap(targetMapName).get((Object)SnapshotValidationRecord.KEY);
                this.mc.jobRepository().cacheValidationRecord(name, validationRecord);
                if (cancelJob) {
                    this.mc.coordinationService().submitToCoordinatorThread(() -> {
                        String terminationFailure = this.mc.jobContext().requestTermination(TerminationMode.CANCEL_FORCEFUL, true, true).f1();
                        if (terminationFailure != null) {
                            throw new JetException("State for " + this.mc.jobIdString() + " exported to '" + name + "', but failed to cancel the job: " + terminationFailure);
                        }
                        this.completeNormallyOrExceptionally(res, (Object)r, (Throwable)t);
                    });
                } else {
                    this.mc.setJobStatus(JobStatus.SUSPENDED);
                    this.completeNormallyOrExceptionally(res, (Object)r, (Throwable)t);
                }
            }));
            return res;
        }
        if (cancelJob || !isJobSuspendable) {
            TerminationMode mode = isJobSuspendable ? TerminationMode.CANCEL_GRACEFUL : TerminationMode.CANCEL_FORCEFUL;
            String terminationFailure = this.mc.jobContext().requestTermination(mode, false, true).f1();
            if (terminationFailure != null) {
                throw new JetException("Cannot cancel " + this.mc.jobIdString() + " and export to '" + name + "': " + terminationFailure);
            }
        } else {
            this.tryBeginSnapshot();
        }
        return snapshotFuture;
    }

    private <T> void completeNormallyOrExceptionally(CompletableFuture<T> res, T r, Throwable t) {
        if (t != null) {
            res.completeExceptionally(t);
        } else {
            res.complete(r);
        }
    }
}

