/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import io.netty.handler.ssl.OpenSsl;
import io.netty.util.ReferenceCounted;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

public final class OpenSSLUtil {
    private OpenSSLUtil() {
    }

    public static boolean isOpenSSLAvailable() {
        try {
            return OpenSsl.isAvailable();
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    public static boolean releaseEngine(SSLEngine sslEngine) {
        if (OpenSSLUtil.isOpenSSLAvailable() && sslEngine instanceof ReferenceCounted) {
            ReferenceCounted refCounted = (ReferenceCounted)sslEngine;
            try {
                return refCounted.release();
            }
            catch (Throwable t) {
                Logger.getLogger(OpenSSLUtil.class.getName()).log(Level.FINE, "Failed to release an SSLEngine: " + String.valueOf(sslEngine), t);
            }
        }
        return false;
    }
}

