/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.config.AbstractSymmetricEncryptionConfig;
import com.hazelcast.internal.memory.impl.EndiannessUtil;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class BasicSymmetricCipherBuilder {
    protected static final int IV_LENGTH_CBC = 8;
    private static final int IV_LENGTH_AES = 16;
    protected final String algorithm;
    protected final byte[] salt;
    protected final byte[] saltDigest;

    public BasicSymmetricCipherBuilder(AbstractSymmetricEncryptionConfig<?> config) {
        this.algorithm = config.getAlgorithm();
        this.salt = BasicSymmetricCipherBuilder.createSalt(config.getSalt());
        this.saltDigest = BasicSymmetricCipherBuilder.createSaltDigest(this.salt);
    }

    public Cipher create(boolean encryptMode, byte[] keyBytes) {
        Objects.requireNonNull(keyBytes, "Key bytes cannot be null");
        try {
            Cipher cipher = Cipher.getInstance(this.algorithm);
            CipherParams params = this.createCipherParams(keyBytes);
            if (params == null) {
                throw new UnsupportedOperationException("Encryption algorithm not supported: " + this.algorithm);
            }
            AlgorithmParameterSpec paramSpec = this.buildFinalAlgorithmParameterSpec(params.ivLength, params.paramSpec);
            int mode = encryptMode ? 1 : 2;
            cipher.init(mode, (Key)params.key, paramSpec);
            return cipher;
        }
        catch (Throwable e) {
            throw new RuntimeException("Unable to create Cipher (encrypt mode: " + encryptMode + "): " + e.getMessage(), e);
        }
    }

    protected CipherParams createCipherParams(byte[] keyBytes) throws GeneralSecurityException {
        SecretKey key = null;
        int ivLength = this.getIvLength();
        if (this.algorithm.startsWith("AES")) {
            key = new SecretKeySpec(keyBytes, "AES");
        } else if (this.algorithm.startsWith("Blowfish")) {
            key = new SecretKeySpec(keyBytes, "Blowfish");
        } else if (this.algorithm.startsWith("DESede")) {
            DESedeKeySpec keySpec = new DESedeKeySpec(keyBytes);
            key = SecretKeyFactory.getInstance("DESede").generateSecret(keySpec);
        } else if (this.algorithm.startsWith("DES")) {
            DESKeySpec keySpec = new DESKeySpec(keyBytes);
            key = SecretKeyFactory.getInstance("DES").generateSecret(keySpec);
        }
        if (key == null) {
            return null;
        }
        return new CipherParams(ivLength, key);
    }

    protected AlgorithmParameterSpec buildFinalAlgorithmParameterSpec(int ivLength, AlgorithmParameterSpec paramSpec) {
        boolean isCBC = this.algorithm.contains("/CBC/");
        if (isCBC) {
            byte[] iv = ivLength == 8 ? this.salt : this.saltDigest;
            paramSpec = new IvParameterSpec(iv);
        }
        return paramSpec;
    }

    private static byte[] createSalt(String saltStr) {
        char[] chars;
        long hash = 0L;
        int prime = 31;
        for (char c : chars = saltStr.toCharArray()) {
            hash = 31L * hash + (long)c;
        }
        byte[] result = new byte[8];
        EndiannessUtil.writeLongB(EndiannessUtil.BYTE_ARRAY_ACCESS, result, 0L, hash);
        return result;
    }

    private static byte[] createSaltDigest(byte[] salt) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(salt);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String findKeyAlgorithm(String algorithm) {
        if (algorithm.indexOf(47) != -1) {
            return algorithm.substring(0, algorithm.indexOf(47));
        }
        return algorithm;
    }

    protected int getIvLength() {
        return this.algorithm.startsWith("AES") ? 16 : 8;
    }

    protected static class CipherParams {
        private int ivLength;
        private SecretKey key;
        private AlgorithmParameterSpec paramSpec;

        public CipherParams(int ivLength, SecretKey key) {
            this(ivLength, key, null);
        }

        public CipherParams(int ivLength, SecretKey key, AlgorithmParameterSpec paramSpec) {
            this.ivLength = ivLength;
            this.key = key;
            this.paramSpec = paramSpec;
        }

        public int getIvLength() {
            return this.ivLength;
        }

        public SecretKey getKey() {
            return this.key;
        }

        public AlgorithmParameterSpec getParamSpec() {
            return this.paramSpec;
        }
    }
}

