/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.service.impl;

import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.collection.IntHashSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

final class Escaping {
    private static final int[] BAD_CODE_POINTS = new int[]{47, 92, 60, 62, 58, 34, 124, 63, 42, 40};
    private static final String[] BAD_STRINGS = new String[]{"CON", "PRN", "AUX", "NUL", "COM0", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "COM\u00b9", "COM\u00b2", "COM\u00b3", "LPT0", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9", "LPT\u00b9", "LPT\u00b2", "LPT\u00b3"};
    private static final IntHashSet BAD_CODE_POINT_SET = new IntHashSet(BAD_CODE_POINTS.length, -1);
    private static final Set<String> BAD_STRING_SET;
    private static final int MIN_BAD_STRING_LENGTH;
    private static final int MAX_BAD_STRING_LENGTH;

    private Escaping() {
    }

    static String escape(String string) {
        int l = string.length();
        if (l == 0) {
            return "()";
        }
        boolean escapeFirst = false;
        for (int i = MIN_BAD_STRING_LENGTH; i <= Math.min(MAX_BAD_STRING_LENGTH, l); ++i) {
            if (i != l && string.charAt(i) != '.' || !BAD_STRING_SET.contains(Escaping.prefix(string, i).toUpperCase(Locale.ENGLISH))) continue;
            escapeFirst = true;
            break;
        }
        StringBuilder b = new StringBuilder(l);
        int i = 0;
        while (i < l) {
            int c = string.codePointAt(i);
            if (BAD_CODE_POINT_SET.contains(c) || Character.isISOControl(c) || c == 46 && (i += Character.charCount(c)) >= l || escapeFirst) {
                escapeFirst = false;
                b.append('(');
                b.append(Integer.toHexString(c));
                b.append(')');
                continue;
            }
            b.appendCodePoint(c);
        }
        return b.toString();
    }

    private static String prefix(String string, int length) {
        return string.length() == length ? string : string.substring(0, length);
    }

    static {
        for (int c : BAD_CODE_POINTS) {
            assert (c != -1);
            BAD_CODE_POINT_SET.add(c);
        }
        BAD_STRING_SET = new HashSet<String>(MapUtil.calculateInitialCapacity(BAD_STRINGS.length));
        int minLength = Integer.MAX_VALUE;
        int maxLength = Integer.MIN_VALUE;
        for (String s : BAD_STRINGS) {
            minLength = Math.min(minLength, s.length());
            maxLength = Math.max(maxLength, s.length());
            BAD_STRING_SET.add(s);
        }
        MIN_BAD_STRING_LENGTH = minLength;
        MAX_BAD_STRING_LENGTH = maxLength;
    }
}

