/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.index;

import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.Invariants;
import com.hazelcast.internal.tstore.State;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordReaderWriter;
import com.hazelcast.map.impl.record.TieredStoreRecord;
import com.hazelcast.map.impl.record.TieredStoreRecordAccessor;
import com.hazelcast.map.impl.record.UnguardedTieredStoreRecordAccessor;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;

public final class Index {
    public static final TieredStoreRecord NO_EXPECTATION = new StatusRecord("NO_EXPECTATION");
    public static final long NO_RAW_EXPECTATION = -1L;
    public static final TieredStoreRecord RETRY_RECORD = new StatusRecord("RETRY_RECORD");
    public static final long RETRY_RAW_RECORD = -1L;
    public static final TieredStoreRecord UNEXPECTED_RECORD = new StatusRecord("UNEXPECTED_RECORD");
    public static final long UNEXPECTED_RAW_RECORD = -2L;
    public static final long NULL = 0L;
    public static final long FORMAT_SIGNATURE = 8316306204480204662L;
    public static final long FORMAT_VERSION = 0L;
    private static final int BUCKET_SCALE = 7;
    public static final int BUCKET_SIZE = 128;
    private static final AtomicLongFieldUpdater<Index> SIZE = AtomicLongFieldUpdater.newUpdater(Index.class, "size");
    private static final VarHandle MAX_RECORD_CHAIN_LENGTH = ReflectionUtil.findVarHandle("maxRecordChainLength", Integer.TYPE);
    private static final VarHandle CLOSE_STATUS = ReflectionUtil.findVarHandle("closeStatus", Integer.TYPE);
    private static final int ENTRY_SIZE = 8;
    private static final int OVERFLOW_ENTRY_INDEX = 7;
    private static final int OVERFLOW_ENTRY_OFFSET = 56;
    private static final int ADDRESS_BITS = 48;
    private static final long ADDRESS_MASK = 0xFFFFFFFFFFFFL;
    private static final int TAG_BITS = 12;
    private static final int TAG_SHIFT = 52;
    private static final long TAG_MASK = -4503599627370496L;
    private static final int TENTATIVE_SHIFT = 51;
    private static final long TENTATIVE_MASK = 0x8000000000000L;
    private static final long TAG_AND_TENTATIVE_MASK = -2251799813685248L;
    private static final int LATCH_SHIFT = 50;
    private static final long LATCH_MASK = 0x4000000000000L;
    private static final int SINGLETON_SHIFT = 49;
    private static final long SINGLETON_MASK = 0x2000000000000L;
    private static final int LOCK_SHIFT = 48;
    private static final long LOCK_MASK = 0x1000000000000L;
    private static final int INDEX_ACTIVE = 0;
    private static final int INDEX_CLOSING = 1;
    private static final int INDEX_CLOSED = 2;
    private final Epoch epoch;
    private final State state;
    private final int segments;
    private final Dependencies dependencies;
    private final Table[] tables = new Table[]{new Table(), new Table()};
    private volatile int version;
    private volatile long size;
    private volatile int closeStatus;
    private volatile int maxRecordChainLength;

    public Index(Epoch epoch, State state, int segments, Dependencies dependencies) {
        this.epoch = epoch;
        this.state = state;
        this.segments = segments;
        this.dependencies = dependencies;
        this.tables[0].allocate(1, dependencies);
        this.version = 0;
    }

    public void save(int threadIndex, LongConsumer writer) {
        this.checkClosed();
        while (State.phase(this.state.threadState(threadIndex)) != 0) {
            this.epoch.refresh(threadIndex);
            this.state.refresh(threadIndex);
        }
        writer.accept(8316306204480204662L);
        writer.accept(0L);
        writer.accept(this.size);
        Table table = this.tables[this.version];
        writer.accept(table.bits);
        long capacity = 1L << table.bits;
        long bucket = table.buckets;
        for (long i = 0L; i < capacity; ++i) {
            long entry = bucket;
            do {
                for (int j = 0; j < 7; ++j) {
                    long record = Index.read(entry);
                    if (record != 0L) {
                        writer.accept(record);
                        writer.accept(Index.readKeyHash(entry));
                    }
                    entry += 8L;
                }
            } while ((entry = Index.read(entry)) != 0L);
            bucket += 128L;
        }
        writer.accept(0L);
    }

    public void load(int threadIndex, LongSupplier reader) {
        this.checkClosed();
        while (State.phase(this.state.threadState(threadIndex)) != 0) {
            this.epoch.refresh(threadIndex);
            this.state.refresh(threadIndex);
        }
        long signature = reader.getAsLong();
        if (signature != 8316306204480204662L) {
            throw new IllegalArgumentException("unexpected signature " + Long.toHexString(signature));
        }
        long version = reader.getAsLong();
        if (version != 0L) {
            throw new IllegalArgumentException("unexpected version " + version);
        }
        long size = reader.getAsLong();
        if (size < 0L) {
            throw new IllegalArgumentException("invalid size " + size);
        }
        long bits = reader.getAsLong();
        if (bits < 1L || bits > 64L) {
            throw new IllegalArgumentException("invalid bits " + bits);
        }
        int oldVersion = this.version;
        int newVersion = Index.other(oldVersion);
        Table table = this.tables[newVersion];
        if (size == 0L) {
            table.allocate(1, this.dependencies);
            this.size = 0L;
            this.version = newVersion;
            this.tables[oldVersion].free(this.dependencies);
            return;
        }
        table.allocate((int)bits, this.dependencies);
        try {
            long record;
            long buckets = table.buckets;
            long mask = table.mask;
            block3: while ((record = reader.getAsLong()) != 0L) {
                long bucket;
                long hash = reader.getAsLong();
                long index = hash & mask;
                long entry = bucket = buckets + (index << 7);
                do {
                    for (int i = 0; i < 7; ++i) {
                        long existing = Index.read(entry);
                        if (existing == 0L) {
                            Index.write(entry, record);
                            Index.writeKeyHash(entry, hash);
                            continue block3;
                        }
                        entry += 8L;
                    }
                } while ((entry = Index.read(entry)) != 0L);
                long newBucket = this.dependencies.allocateBuckets(1L);
                Index.write(newBucket + 56L, Index.read(bucket + 56L));
                Index.write(bucket + 56L, newBucket);
                Index.write(newBucket, record);
                Index.writeKeyHash(newBucket, hash);
            }
        }
        catch (Throwable t) {
            table.free(this.dependencies);
            throw t;
        }
        this.size = size;
        this.version = newVersion;
        this.tables[oldVersion].free(this.dependencies);
    }

    public long size() {
        return this.closeStatus == 0 ? SIZE.get(this) : 0L;
    }

    public TieredStoreRecord get(int threadIndex, Data key) {
        return this.translateResult(this.getRaw(threadIndex, key, -1L, true), threadIndex);
    }

    public long getRaw(int threadIndex, Data key, long expectedLogicalRecord, boolean pending) {
        this.checkClosed();
        int threadPhase = State.phase(this.state.threadState(threadIndex));
        if (threadPhase != 0) {
            return -1L;
        }
        Table table = this.tables[this.version];
        long keyHash = key.hash64();
        long index = keyHash & table.mask;
        long entry = table.buckets + (index << 7);
        long tag = Index.tag(keyHash);
        do {
            for (int i = 0; i < 7; ++i) {
                long lRecord = Index.read(entry);
                if (lRecord != 0L && Index.tagAndTentative(lRecord) == tag) {
                    if (expectedLogicalRecord != -1L && (lRecord & 0x2000000000000L) != 0L) {
                        long pRecord = this.asPhysicalAddress(lRecord = Index.asLogicalAddress(lRecord), threadIndex);
                        if (pRecord == -1L) {
                            return -1L;
                        }
                        return lRecord == expectedLogicalRecord ? (pending && pRecord == 0L ? Index.pending(lRecord) : lRecord) : 0L;
                    }
                    do {
                        long pRecord;
                        if ((pRecord = this.asPhysicalAddress(lRecord = Index.asLogicalAddress(lRecord), threadIndex)) == -1L) {
                            return -1L;
                        }
                        if (pRecord == 0L) {
                            if (pending) {
                                return Index.pending(lRecord);
                            }
                            if (lRecord == expectedLogicalRecord) {
                                return lRecord;
                            }
                            byte[] record = this.dependencies.readRecordFromDevice(lRecord);
                            if (Index.keyEquals(record, key)) {
                                return expectedLogicalRecord != -1L ? 0L : lRecord;
                            }
                            lRecord = Index.next(record);
                            continue;
                        }
                        if (lRecord == expectedLogicalRecord) {
                            return lRecord;
                        }
                        if (this.dependencies.recordAccessor().keyEquals(lRecord, pRecord, key)) {
                            return expectedLogicalRecord != -1L ? 0L : lRecord;
                        }
                        lRecord = this.next(lRecord, pRecord);
                    } while (lRecord != 0L);
                    return 0L;
                }
                entry += 8L;
            }
        } while ((entry = Index.read(entry)) != 0L);
        return 0L;
    }

    public TieredStoreRecord put(int threadIndex, Data key, TieredStoreRecord newRecord, TieredStoreRecord expectedRecord) {
        long newLogicalRecord = this.translateArgument(newRecord);
        long expectedLogicalRecord = this.translateArgument(expectedRecord);
        long logicalRecord = this.putRaw(threadIndex, key, newLogicalRecord, expectedLogicalRecord, false);
        return this.translateResult(logicalRecord, threadIndex);
    }

    public long putRaw(int threadIndex, Data key, long newLogicalRecord, long expectedLogicalRecord, boolean locked) {
        long lFirst;
        long entry;
        assert (newLogicalRecord != 0L);
        this.checkClosed();
        int threadPhase = State.phase(this.state.threadState(threadIndex));
        if (threadPhase != 0) {
            return -1L;
        }
        Table table = this.tables[this.version];
        if (this.size > table.limit && this.state.globalStart(threadIndex, () -> new GrowMachine(this))) {
            return -1L;
        }
        long newPhysicalRecord = this.physicalForUpdate(newLogicalRecord, threadIndex);
        assert (newPhysicalRecord != 0L);
        long keyHash = key.hash64();
        long index = keyHash & table.mask;
        long bucket = table.buckets + (index << 7);
        long tag = Index.tag(keyHash);
        block0: while (true) {
            int i;
            entry = bucket;
            long lRecord = 0L;
            block1: do {
                for (i = 0; i < 7; ++i) {
                    lRecord = Index.read(entry);
                    if (lRecord != 0L && Index.tag(lRecord) == tag && (!Index.isTentative(lRecord) || locked && Index.isLocked(lRecord))) break block1;
                    entry += 8L;
                }
            } while ((entry = Index.read(entry)) != 0L);
            if (entry == 0L) {
                entry = bucket;
                do {
                    for (i = 0; i < 7; ++i) {
                        lRecord = Index.read(entry);
                        if (lRecord != 0L) {
                            entry += 8L;
                            continue;
                        }
                        if (!Index.cas(entry, 0L, Index.tentativeRecord(tag, newLogicalRecord))) {
                            entry += 8L;
                            continue;
                        }
                        if (Index.anotherEntryExists(entry, bucket, tag)) {
                            Index.write(entry, 0L);
                            continue block0;
                        }
                        if (expectedLogicalRecord != -1L && expectedLogicalRecord != 0L) {
                            Index.write(entry, 0L);
                            return -2L;
                        }
                        this.dependencies.markAsReachable(newLogicalRecord, threadIndex);
                        Index.writeKeyHash(entry, keyHash);
                        Index.write(entry, Index.record(tag, newLogicalRecord) | 0x2000000000000L);
                        SIZE.incrementAndGet(this);
                        this.updateMaxRecordChainLength(1);
                        return 0L;
                    }
                } while ((entry = Index.read(entry)) != 0L);
                long newBucket = this.dependencies.allocateBuckets(1L);
                long overflowEntry = bucket + 56L;
                long nextBucket = Index.read(overflowEntry);
                Index.write(newBucket + 56L, nextBucket);
                if (Index.cas(overflowEntry, nextBucket, newBucket)) continue;
                this.dependencies.freeBuckets(newBucket, 1L);
                continue;
            }
            if (Index.isTentative(lRecord)) {
                assert (locked && Index.isLocked(lRecord) && Index.asLogicalAddress(lRecord) == 0L);
                if (expectedLogicalRecord != -1L && expectedLogicalRecord != 0L) {
                    return -2L;
                }
                if (!Index.cas(entry, lRecord, Index.record(tag, newLogicalRecord) | 0x1000000000000L)) continue;
                return 0L;
            }
            lFirst = Index.latchEntry(entry, lRecord, tag);
            if (lFirst != 0L) break;
        }
        long lPrevious = 0L;
        long pPrevious = 0L;
        long lCurrent = lFirst;
        int recordChainLength = 0;
        do {
            if ((lCurrent = Index.asLogicalAddress(lCurrent)) == expectedLogicalRecord && (lFirst & 0x2000000000000L) != 0L) {
                this.setNext(newLogicalRecord, newPhysicalRecord, 0L);
                Index.writeKeyHash(entry, keyHash);
                long lNewFirst = Index.record(tag, newLogicalRecord) | 0x2000000000000L | lFirst & 0x1000000000000L;
                Index.casEntry(entry, lFirst | 0x4000000000000L, lNewFirst);
                this.dependencies.markAsReachable(newLogicalRecord, threadIndex);
                this.dependencies.markAsNotReachable(lCurrent, threadIndex);
                return lCurrent;
            }
            long pCurrent = this.physicalForUpdate(lCurrent, threadIndex);
            if (pCurrent == 0L) {
                Index.casEntry(entry, lFirst | 0x4000000000000L, lFirst);
                return Index.pending(lCurrent);
            }
            if (lCurrent == expectedLogicalRecord || this.dependencies.recordAccessor().keyEquals(lCurrent, pCurrent, key)) {
                if (expectedLogicalRecord != -1L && lCurrent != expectedLogicalRecord) {
                    Index.casEntry(entry, lFirst | 0x4000000000000L, lFirst);
                    return -2L;
                }
                long lNext = Index.asLogicalAddress(this.next(lCurrent, pCurrent));
                this.setNext(newLogicalRecord, newPhysicalRecord, lNext);
                if (pPrevious == 0L) {
                    Index.writeKeyHash(entry, keyHash);
                    long lNewFirst = Index.record(tag, newLogicalRecord) | lFirst & 0x2000000000000L | lFirst & 0x1000000000000L;
                    Index.casEntry(entry, lFirst | 0x4000000000000L, lNewFirst);
                } else {
                    this.setNext(lPrevious, pPrevious, newLogicalRecord);
                    Index.casEntry(entry, lFirst | 0x4000000000000L, lFirst);
                }
                this.dependencies.markAsReachable(newLogicalRecord, threadIndex);
                this.dependencies.markAsNotReachable(lCurrent, threadIndex);
                return lCurrent;
            }
            lPrevious = lCurrent;
            pPrevious = pCurrent;
            lCurrent = this.next(lCurrent, pCurrent);
            ++recordChainLength;
        } while (lCurrent != 0L);
        if (expectedLogicalRecord != -1L && expectedLogicalRecord != 0L) {
            Index.casEntry(entry, lFirst | 0x4000000000000L, lFirst);
            return -2L;
        }
        this.dependencies.markAsReachable(newLogicalRecord, threadIndex);
        this.setNext(lPrevious, pPrevious, newLogicalRecord);
        Index.casEntry(entry, lFirst | 0x4000000000000L, lFirst & 0xFFFDFFFFFFFFFFFFL);
        SIZE.incrementAndGet(this);
        this.updateMaxRecordChainLength(++recordChainLength);
        return 0L;
    }

    public long remap(int threadIndex, Data key, long oldLogicalRecord, long newLogicalRecord) {
        assert (newLogicalRecord > oldLogicalRecord);
        return this.remap(threadIndex, key, oldLogicalRecord, () -> newLogicalRecord);
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    long remap(int threadIndex, Data key, long oldLogicalRecord, LongSupplier newLogicalRecordSupplier) {
        long lFirst;
        long entry;
        assert (oldLogicalRecord > 0L);
        this.checkClosed();
        int threadPhase = State.phase(this.state.threadState(threadIndex));
        if (threadPhase != 0) {
            return -1L;
        }
        Table table = this.tables[this.version];
        long keyHash = key.hash64();
        long index = keyHash & table.mask;
        long bucket = table.buckets + (index << 7);
        long tag = Index.tag(keyHash);
        long lUpdateFrom = 0L;
        long lUpdateTo = 0L;
        block0: while (true) {
            long pCurrent;
            block23: {
                entry = bucket;
                do {
                    for (int i = 0; i < 7; entry += 8L, ++i) {
                        long lRecord = Index.read(entry);
                        if (lRecord == 0L || Index.tagAndTentative(lRecord) != tag) continue;
                        lFirst = Index.latchEntry(entry, lRecord, tag);
                        if (lFirst == 0L) {
                            continue block0;
                        }
                        break block23;
                    }
                } while ((entry = Index.read(entry)) != 0L);
                return 0L;
            }
            long newLogicalRecord = newLogicalRecordSupplier.getAsLong();
            long lPrevious = 0L;
            long pPrevious = 0L;
            long lCurrent = lFirst;
            do {
                block24: {
                    boolean pinned;
                    if ((lCurrent = Index.asLogicalAddress(lCurrent)) == oldLogicalRecord) {
                        if (pPrevious == 0L) {
                            long lNewFirst = Index.record(tag, newLogicalRecord) | lFirst & 0x2000000000000L | lFirst & 0x1000000000000L;
                            Index.casEntry(entry, lFirst | 0x4000000000000L, lNewFirst);
                        } else {
                            this.setNext(lPrevious, pPrevious, newLogicalRecord);
                            Index.casEntry(entry, lFirst | 0x4000000000000L, lFirst);
                            this.dependencies.unpinRecord(lPrevious);
                        }
                        this.dependencies.markAsNotReachable(oldLogicalRecord, threadIndex);
                        this.dependencies.markAsReachable(newLogicalRecord, threadIndex);
                        return newLogicalRecord;
                    }
                    pCurrent = this.physicalForUpdate(lCurrent, threadIndex);
                    if (pCurrent == 0L) {
                        if (lCurrent == lUpdateFrom) {
                            pinned = this.dependencies.pinRecordForUpdate(lUpdateTo);
                            if (!pinned) {
                                Index.casEntry(entry, lFirst | 0x4000000000000L, lFirst);
                                if (lPrevious == 0L) return -1L;
                                this.dependencies.unpinRecord(lPrevious);
                                return -1L;
                            }
                            long newPCurrent = this.physicalForUpdate(lUpdateTo, threadIndex);
                            assert (newPCurrent != 0L);
                            if (pPrevious == 0L) {
                                long lNewFirst = Index.record(tag, lUpdateTo) | lFirst & 0x2000000000000L | lFirst & 0x1000000000000L;
                                lFirst = Index.casEntry(entry, lFirst | 0x4000000000000L, lNewFirst | 0x4000000000000L) & 0xFFFBFFFFFFFFFFFFL;
                            } else {
                                this.setNext(lPrevious, pPrevious, lUpdateTo);
                            }
                            this.dependencies.markAsNotReachable(lCurrent, threadIndex);
                            this.dependencies.markAsReachable(lUpdateTo, threadIndex);
                            lCurrent = lUpdateTo;
                            pCurrent = newPCurrent;
                            lUpdateFrom = 0L;
                            lUpdateTo = 0L;
                            break block24;
                        } else {
                            Index.casEntry(entry, lFirst | 0x4000000000000L, lFirst);
                            long epochBefore = this.epoch.getThreadEpoch(threadIndex);
                            if (lPrevious != 0L) {
                                this.dependencies.unpinRecord(lPrevious);
                            }
                            lUpdateFrom = lCurrent;
                            lUpdateTo = this.dependencies.readRecordForUpdate(lCurrent);
                            if (lUpdateTo == -1L) {
                                return -1L;
                            }
                            if (this.epoch.getThreadEpoch(threadIndex) != epochBefore) return -1L;
                            continue block0;
                        }
                    }
                    pinned = this.dependencies.pinRecordForUpdate(lCurrent);
                    if (!pinned) {
                        Index.casEntry(entry, lFirst | 0x4000000000000L, lFirst);
                        if (lPrevious == 0L) return -1L;
                        this.dependencies.unpinRecord(lPrevious);
                        return -1L;
                    }
                }
                assert (pPrevious == 0L || lPrevious != 0L);
                if (lPrevious != 0L) {
                    this.dependencies.unpinRecord(lPrevious);
                }
                if (this.dependencies.recordAccessor().keyEquals(lCurrent, pCurrent, key)) {
                    Index.casEntry(entry, lFirst | 0x4000000000000L, lFirst);
                    this.dependencies.unpinRecord(lCurrent);
                    return lCurrent;
                }
                lPrevious = lCurrent;
                pPrevious = pCurrent;
            } while ((lCurrent = this.next(lCurrent, pCurrent)) != 0L);
            break;
        }
        Index.casEntry(entry, lFirst | 0x4000000000000L, lFirst);
        return 0L;
    }

    public TieredStoreRecord remove(int threadIndex, Data key, TieredStoreRecord expectedRecord) {
        return this.translateResult(this.removeRaw(threadIndex, key, this.translateArgument(expectedRecord)), threadIndex);
    }

    public long removeRaw(int threadIndex, Data key, long expectedLogicalRecord) {
        long entry;
        long lFirst;
        this.checkClosed();
        int threadPhase = State.phase(this.state.threadState(threadIndex));
        if (threadPhase != 0) {
            return -1L;
        }
        Table table = this.tables[this.version];
        long keyHash = key.hash64();
        long index = keyHash & table.mask;
        long bucket = table.buckets + (index << 7);
        long tag = Index.tag(keyHash);
        do {
            long lRecord;
            block13: {
                entry = bucket;
                do {
                    for (int i = 0; i < 7; ++i) {
                        lRecord = Index.read(entry);
                        if (lRecord == 0L || Index.tagAndTentative(lRecord) != tag) {
                            entry += 8L;
                            continue;
                        }
                        break block13;
                    }
                } while ((entry = Index.read(entry)) != 0L);
                return expectedLogicalRecord == -1L || expectedLogicalRecord == 0L ? 0L : -2L;
            }
            lFirst = Index.latchEntry(entry, lRecord, tag);
        } while (lFirst == 0L);
        long pPrevious = 0L;
        long lPrevious = 0L;
        long lCurrent = lFirst;
        int seenRecords = 0;
        do {
            if ((lCurrent = Index.asLogicalAddress(lCurrent)) == expectedLogicalRecord && (lFirst & 0x2000000000000L) != 0L) {
                Index.writeKeyHash(entry, 0L);
                Index.write(entry, 0L);
                this.dependencies.markAsNotReachable(lCurrent, threadIndex);
                SIZE.decrementAndGet(this);
                return lCurrent;
            }
            long pCurrent = this.physicalForUpdate(lCurrent, threadIndex);
            if (pCurrent == 0L) {
                Index.write(entry, lFirst);
                return Index.pending(lCurrent);
            }
            if (lCurrent == expectedLogicalRecord || this.dependencies.recordAccessor().keyEquals(lCurrent, pCurrent, key)) {
                if (expectedLogicalRecord != -1L && lCurrent != expectedLogicalRecord) {
                    Index.write(entry, lFirst);
                    return -2L;
                }
                long lNext = Index.asLogicalAddress(this.next(lCurrent, pCurrent));
                if (pPrevious == 0L) {
                    Index.write(entry, lNext == 0L ? 0L : Index.record(tag, lNext) | lFirst & 0x1000000000000L);
                } else {
                    this.setNext(lPrevious, pPrevious, lNext);
                    if (lNext == 0L && seenRecords == 1) {
                        Index.writeKeyHash(entry, this.keyHash(lPrevious, pPrevious));
                        lFirst |= 0x2000000000000L;
                    }
                    Index.write(entry, lFirst);
                }
                this.dependencies.markAsNotReachable(lCurrent, threadIndex);
                SIZE.decrementAndGet(this);
                return lCurrent;
            }
            lPrevious = lCurrent;
            pPrevious = pCurrent;
            lCurrent = this.next(lCurrent, pCurrent);
            ++seenRecords;
        } while (lCurrent != 0L);
        Index.write(entry, lFirst);
        return expectedLogicalRecord == -1L || expectedLogicalRecord == 0L ? 0L : -2L;
    }

    public IterationPointer[] fetchEntries(int threadIndex, int size, IterationPointer[] pointers, Consumer<TieredStoreRecord> recordConsumer) {
        this.checkClosed();
        int threadPhase = State.phase(this.state.threadState(threadIndex));
        if (threadPhase != 0) {
            return pointers;
        }
        Table table = this.tables[this.version];
        if (!Index.isMoreToVisit(pointers = Index.refreshPointers(pointers, table.getSize()))) {
            return pointers;
        }
        long tableBeginAddr = table.buckets;
        long bucket = tableBeginAddr + ((long)Index.nextToVisit(pointers) << 7);
        ArrayList<Long> pendingLogicalRecords = new ArrayList<Long>();
        while (Index.isMoreToVisit(pointers) && size > 0) {
            if (Index.isVisited(this.bucketIndex(bucket, tableBeginAddr), pointers)) {
                Index.advancePointer(pointers);
            } else {
                long entry = bucket;
                boolean needIO = false;
                boolean secondIteration = false;
                do {
                    int i = 0;
                    while (i < 7) {
                        long logicalRecord = Index.read(entry);
                        if (logicalRecord != 0L && !Index.isTentative(logicalRecord)) {
                            long physicalRecord;
                            do {
                                if ((physicalRecord = this.asPhysicalAddress(logicalRecord = Index.asLogicalAddress(logicalRecord), threadIndex)) == 0L) {
                                    pendingLogicalRecords.add(logicalRecord);
                                    needIO = true;
                                    break;
                                }
                                if (!secondIteration) continue;
                                recordConsumer.accept(this.translateResult(logicalRecord, threadIndex));
                                --size;
                            } while ((logicalRecord = this.next(logicalRecord, physicalRecord)) != 0L);
                        }
                        ++i;
                        entry += 8L;
                    }
                    if ((entry = Index.read(entry)) != 0L || secondIteration || needIO) continue;
                    secondIteration = true;
                    entry = bucket;
                } while (entry != 0L);
                if (needIO) break;
                Index.advancePointer(pointers);
            }
            bucket -= 128L;
        }
        if (!pendingLogicalRecords.isEmpty()) {
            this.handlePendingRecords(threadIndex, pendingLogicalRecords);
        }
        return pointers;
    }

    public IterationPointer[] fetchMapKeys(int threadIndex, int size, IterationPointer[] pointers, Consumer<Data> recordConsumer) {
        this.checkClosed();
        int threadPhase = State.phase(this.state.threadState(threadIndex));
        if (threadPhase != 0) {
            return pointers;
        }
        Table table = this.tables[this.version];
        if (!Index.isMoreToVisit(pointers = Index.refreshPointers(pointers, table.getSize()))) {
            return pointers;
        }
        long tableBeginAddr = table.buckets;
        long bucket = tableBeginAddr + ((long)Index.nextToVisit(pointers) << 7);
        while (Index.isMoreToVisit(pointers) && size > 0) {
            if (Index.isVisited(this.bucketIndex(bucket, tableBeginAddr), pointers)) {
                Index.advancePointer(pointers);
            } else {
                long entry = bucket;
                do {
                    int i = 0;
                    while (i < 7) {
                        long logicalRecord = Index.read(entry);
                        if (logicalRecord != 0L && !Index.isTentative(logicalRecord)) {
                            do {
                                Data recordKey;
                                Object record;
                                long physicalRecord;
                                if ((physicalRecord = this.asPhysicalAddress(logicalRecord = Index.asLogicalAddress(logicalRecord), threadIndex)) == 0L) {
                                    record = this.dependencies.readRecordFromDevice(logicalRecord);
                                    recordKey = this.translateResultToKey((byte[])record);
                                    recordConsumer.accept(recordKey);
                                    --size;
                                    logicalRecord = Index.next((byte[])record);
                                    continue;
                                }
                                record = this.translateResult(logicalRecord, threadIndex);
                                recordKey = ((TieredStoreRecord)record).getKey();
                                recordConsumer.accept(recordKey);
                                --size;
                                logicalRecord = this.next(logicalRecord, physicalRecord);
                            } while (logicalRecord != 0L);
                        }
                        ++i;
                        entry += 8L;
                    }
                } while ((entry = Index.read(entry)) != 0L);
                Index.advancePointer(pointers);
            }
            bucket -= 128L;
        }
        return pointers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePendingRecords(int threadIndex, List<Long> pendingLogicalRecords) {
        Set<Integer> pinnedSegmentsNo = this.pinSegments(pendingLogicalRecords);
        try {
            for (long logicalRecord : pendingLogicalRecords) {
                this.dependencies.readRecordAndDoRemapping(logicalRecord);
                this.epoch.refresh(threadIndex);
                this.state.refresh(threadIndex);
            }
        }
        finally {
            this.unpinSegments(pinnedSegmentsNo);
        }
    }

    private Set<Integer> pinSegments(List<Long> logicalAddresses) {
        HashSet<Integer> pinnedSegmentNo = new HashSet<Integer>();
        for (long logicalAddress : logicalAddresses) {
            int segmentNo = this.dependencies.segmentNoOf(logicalAddress);
            if (pinnedSegmentNo.contains(segmentNo)) continue;
            this.dependencies.pinSegment(segmentNo);
            pinnedSegmentNo.add(segmentNo);
        }
        return pinnedSegmentNo;
    }

    private void unpinSegments(Set<Integer> segmentsNo) {
        for (int segmentNo : segmentsNo) {
            this.dependencies.unpinSegment(segmentNo);
        }
    }

    private long bucketIndex(long bucketAddr, long tableBeginAddr) {
        assert (bucketAddr >= tableBeginAddr);
        return bucketAddr - tableBeginAddr >> 7;
    }

    static boolean isVisited(long keyHash, IterationPointer[] pointers) {
        for (int i = pointers.length - 1; i >= 0; --i) {
            IterationPointer pointer = pointers[i];
            if ((keyHash & (long)(pointer.getSize() - 1)) <= (long)pointer.getIndex()) continue;
            return true;
        }
        return false;
    }

    public static boolean isMoreToVisit(IterationPointer[] pointers) {
        return pointers[pointers.length - 1].getIndex() >= 0;
    }

    static int nextToVisit(IterationPointer[] pointers) {
        return pointers[pointers.length - 1].getIndex();
    }

    static IterationPointer[] refreshPointers(IterationPointer[] pointers, int tableSize) {
        IterationPointer lastPointer = pointers[pointers.length - 1];
        if (tableSize < lastPointer.getSize()) {
            lastPointer.setIndex(-1);
            return pointers;
        }
        if (lastPointer.getSize() == tableSize) {
            return pointers;
        }
        if (lastPointer.getSize() == -1) {
            pointers[pointers.length - 1].setIndex(tableSize - 1);
            pointers[pointers.length - 1].setSize(tableSize);
            return pointers;
        }
        pointers = Arrays.copyOf(pointers, pointers.length + 1);
        pointers[pointers.length - 1] = new IterationPointer(tableSize - 1, tableSize);
        return pointers;
    }

    static void advancePointer(IterationPointer[] pointers) {
        IterationPointer lastPointer = pointers[pointers.length - 1];
        int idx = lastPointer.getIndex();
        assert (idx >= 0);
        lastPointer.setIndex(idx - 1);
    }

    public KeyLock lock(int threadIndex, Data key) {
        long lRecord;
        long entry;
        this.checkClosed();
        assert (State.phase(this.state.threadState(threadIndex)) == 0);
        Table table = this.tables[this.version];
        long keyHash = key.hash64();
        long index = keyHash & table.mask;
        long bucket = table.buckets + (index << 7);
        long tag = Index.tag(keyHash);
        block0: do {
            entry = bucket;
            do {
                for (int i = 0; i < 7; ++i) {
                    lRecord = Index.read(entry);
                    if (lRecord != 0L && Index.tag(lRecord) == tag) continue block0;
                    entry += 8L;
                }
            } while ((entry = Index.read(entry)) != 0L);
            return null;
        } while (Index.lockEntry(entry, lRecord, tag) == 0L);
        return new KeyLock(keyHash, entry, table.bits);
    }

    public void unlock(int threadIndex, KeyLock keyLock, boolean remove) {
        assert (keyLock != null);
        this.checkClosed();
        while (State.phase(this.state.threadState(threadIndex)) != 0) {
            this.epoch.refresh(threadIndex);
            this.state.refresh(threadIndex);
        }
        long keyHash = keyLock.hash;
        long tag = Index.tag(keyHash);
        Table table = this.tables[this.version];
        int lockBits = keyLock.bits;
        int resizesPerformed = table.bits - lockBits;
        if (resizesPerformed == 0) {
            long entry = keyLock.entry;
            long lRecord = Index.read(entry);
            if (!remove || lRecord != 0L && Index.tagAndTentative(lRecord) == tag) {
                this.unlockEntry(entry, lRecord, tag);
            }
            return;
        }
        int bucketsToInspect = 1 << resizesPerformed;
        long lockMask = (1L << lockBits) - 1L;
        long lockHash = keyHash & lockMask;
        int seenLocks = 0;
        for (long b = 0L; b < (long)bucketsToInspect; ++b) {
            long lRecord;
            long entry;
            block12: {
                long index = lockHash | b << lockBits;
                entry = table.buckets + (index << 7);
                do {
                    for (int i = 0; i < 7; ++i) {
                        lRecord = Index.read(entry);
                        if (lRecord == 0L || Index.tag(lRecord) != tag || !Index.isLocked(lRecord)) {
                            entry += 8L;
                            continue;
                        }
                        break block12;
                    }
                } while ((entry = Index.read(entry)) != 0L);
                continue;
            }
            if (Index.isTentative(lRecord)) {
                assert (Index.asLogicalAddress(lRecord) == 0L && (lRecord & 0x2000000000000L) != 0L);
                Index.write(entry, 0L);
            } else {
                this.unlockEntry(entry, lRecord, tag);
            }
            ++seenLocks;
        }
        assert (remove || seenLocks == bucketsToInspect);
    }

    public long tryLock(int threadIndex, long keyHash) {
        long lRecord;
        long entry;
        block4: {
            this.checkClosed();
            int threadPhase = State.phase(this.state.threadState(threadIndex));
            if (threadPhase != 0) {
                return -1L;
            }
            Table table = this.tables[this.version];
            long index = keyHash & table.mask;
            long bucket = table.buckets + (index << 7);
            long tag = Index.tag(keyHash);
            entry = bucket;
            do {
                for (int i = 0; i < 7; ++i) {
                    lRecord = Index.read(entry);
                    if (lRecord == 0L || Index.tag(lRecord) != tag) {
                        entry += 8L;
                        continue;
                    }
                    break block4;
                }
            } while ((entry = Index.read(entry)) != 0L);
            return 0L;
        }
        boolean locked = Index.cas(entry, Index.unlockedRecord(lRecord), Index.lockedRecord(lRecord));
        return locked ? entry : -entry;
    }

    public void waitUntilUnlocked(int threadIndex, long keyHash, long cookie) {
        assert (cookie < 0L);
        this.checkClosed();
        long entry = -cookie;
        long tag = Index.tag(keyHash);
        long lRecord;
        while ((lRecord = Index.read(entry)) != 0L && Index.tagAndTentative(lRecord) == tag) {
            if ((lRecord & 0x1000000000000L) == 0L) {
                return;
            }
            this.epoch.refresh(threadIndex);
            if (State.phase(this.state.refresh(threadIndex)) != 0) {
                return;
            }
            Thread.yield();
            this.checkClosed();
        }
        return;
    }

    public void unlock(long keyHash, long cookie) {
        long unlocked;
        long locked;
        assert (cookie > 0L);
        this.checkClosed();
        long entry = cookie;
        do {
            long lRecord = Index.read(entry);
            assert (lRecord != 0L && Index.tagAndTentative(lRecord) == Index.tag(keyHash));
            locked = lRecord;
            unlocked = Index.unlockedRecord(locked);
            assert (locked != unlocked) : locked;
        } while (!Index.cas(entry, locked, unlocked));
    }

    public Iterator iterator(int threadIndex) {
        this.checkClosed();
        while (0 != State.phase(this.state.threadState(threadIndex))) {
            Thread.yield();
            this.epoch.refresh(threadIndex);
            this.state.refresh(threadIndex);
        }
        return new Iterator(this);
    }

    public MapEntryNoCachingIterator mapEntryNoCachingIterator(int threadIndex) {
        this.checkClosed();
        while (0 != State.phase(this.state.threadState(threadIndex))) {
            Thread.yield();
            this.epoch.refresh(threadIndex);
            this.state.refresh(threadIndex);
        }
        return new MapEntryNoCachingIterator(this);
    }

    public void clear(int threadIndex) {
        this.checkClosed();
        this.clear(threadIndex, null);
    }

    void clear(int threadIndex, LongConsumer logicalRecordVisitor) {
        int threadPhase = State.phase(this.state.threadState(threadIndex));
        boolean machineWasStarted = false;
        while (true) {
            if (threadPhase != 0) {
                int newThreadPhase = State.phase(this.state.refresh(threadIndex));
                if (newThreadPhase == threadPhase) {
                    Thread.yield();
                    this.epoch.refresh(threadIndex);
                    newThreadPhase = State.phase(this.state.refresh(threadIndex));
                }
                threadPhase = newThreadPhase;
                continue;
            }
            if (machineWasStarted) {
                return;
            }
            machineWasStarted = this.state.globalStart(threadIndex, () -> new ClearMachine(this, logicalRecordVisitor));
            threadPhase = State.phase(this.state.refresh(threadIndex));
        }
    }

    public void close(int threadIndex) {
        this.checkClosed();
        if (!CLOSE_STATUS.compareAndSet(this, 0, 1)) {
            this.throwIndexClosedException();
        }
        while (!this.state.tryClose()) {
            Thread.yield();
            this.epoch.refresh(threadIndex);
            this.state.refresh(threadIndex);
        }
        this.epoch.bump(threadIndex, (threadIdx, actionEpoch) -> {
            this.tables[this.version].free(this.dependencies);
            this.dependencies.onDispose();
            assert (this.closeStatus == 1);
            CLOSE_STATUS.set(this, 2);
        });
    }

    public boolean isCloseCompleted() {
        return this.closeStatus == 2;
    }

    private void checkClosed() {
        if (this.closeStatus != 0) {
            this.throwIndexClosedException();
        }
    }

    private void throwIndexClosedException() {
        throw new IllegalStateException("Index has been closed and no more operations can be invoked on it");
    }

    void close(LongConsumer logicalRecordVisitor, int currentThreadIndex) {
        this.tables[this.version].free(this.dependencies, logicalRecordVisitor, currentThreadIndex);
    }

    long bucketOf(Data key) {
        Table table = this.tables[this.version];
        long keyHash = key.hash64();
        return keyHash & table.mask;
    }

    long tagOf(Data key) {
        long keyHash = key.hash64();
        return Index.tag(keyHash);
    }

    boolean isSingleton(Data key) {
        Table table = this.tables[this.version];
        long keyHash = key.hash64();
        long index = keyHash & table.mask;
        long entry = table.buckets + (index << 7);
        long tag = Index.tag(keyHash);
        do {
            for (int i = 0; i < 7; ++i) {
                long lRecord = Index.read(entry);
                if (lRecord != 0L && Index.tagAndTentative(lRecord) == tag) {
                    return (lRecord & 0x2000000000000L) != 0L;
                }
                entry += 8L;
            }
        } while ((entry = Index.read(entry)) != 0L);
        throw new IllegalArgumentException();
    }

    long remainingCapacity() {
        Table table = this.tables[this.version];
        return table.limit - this.size;
    }

    long getKeyHash(Data key) {
        Table table = this.tables[this.version];
        long keyHash = key.hash64();
        long index = keyHash & table.mask;
        long entry = table.buckets + (index << 7);
        long tag = Index.tag(keyHash);
        do {
            for (int i = 0; i < 7; ++i) {
                long lRecord = Index.read(entry);
                if (lRecord != 0L && Index.tagAndTentative(lRecord) == tag) {
                    return Index.readKeyHash(entry);
                }
                entry += 8L;
            }
        } while ((entry = Index.read(entry)) != 0L);
        throw new IllegalArgumentException();
    }

    public KeyLock keyLockFrom(long hash, long cookie) {
        assert (cookie > 0L);
        return new KeyLock(hash, cookie, this.tables[this.version].bits);
    }

    private static boolean anotherEntryExists(long excludedEntry, long bucket, long tag) {
        long entry = bucket;
        do {
            for (int i = 0; i < 7; ++i) {
                long lRecord = Index.read(entry);
                if (lRecord != 0L && Index.tag(lRecord) == tag && entry != excludedEntry) {
                    return true;
                }
                entry += 8L;
            }
        } while ((entry = Index.read(entry)) != 0L);
        return false;
    }

    private static long latchEntry(long entry, long logicalRecord, long tag) {
        assert ((logicalRecord & 0x8000000000000L) == 0L);
        long unlatchedLogicalRecord = Index.unlatchedRecord(logicalRecord);
        while (!Index.cas(entry, unlatchedLogicalRecord, Index.latchedRecord(logicalRecord))) {
            logicalRecord = Index.read(entry);
            if (logicalRecord == 0L || Index.tagAndTentative(logicalRecord) != tag) {
                return 0L;
            }
            unlatchedLogicalRecord = Index.unlatchedRecord(logicalRecord);
        }
        return unlatchedLogicalRecord;
    }

    private static long casEntry(long entry, long expectedLogicalRecord, long logicalRecord) {
        while (!Index.cas(entry, expectedLogicalRecord, logicalRecord)) {
            long freshLogicalRecord = Index.read(entry);
            assert ((freshLogicalRecord & 0xFFFEFFFFFFFFFFFFL) == (expectedLogicalRecord & 0xFFFEFFFFFFFFFFFFL));
            expectedLogicalRecord = freshLogicalRecord;
            logicalRecord = logicalRecord & 0xFFFEFFFFFFFFFFFFL | freshLogicalRecord & 0x1000000000000L;
        }
        return logicalRecord;
    }

    private static long lockEntry(long entry, long logicalRecord, long tag) {
        assert ((logicalRecord & 0x8000000000000L) == 0L || (logicalRecord & 0x1000000000000L) != 0L);
        long unlockedLogicalRecord = Index.unlockedRecord(logicalRecord);
        while (!Index.cas(entry, unlockedLogicalRecord, Index.lockedRecord(logicalRecord))) {
            logicalRecord = Index.read(entry);
            if (logicalRecord == 0L || Index.tag(logicalRecord) != tag) {
                return 0L;
            }
            unlockedLogicalRecord = Index.unlockedRecord(logicalRecord);
        }
        return unlockedLogicalRecord;
    }

    private void unlockEntry(long entry, long lRecord, long tag) {
        while (true) {
            long locked = lRecord;
            long unlocked = Index.unlockedRecord(locked);
            assert (locked != unlocked);
            if (Index.cas(entry, locked, unlocked)) {
                return;
            }
            lRecord = Index.read(entry);
            assert (lRecord != 0L && Index.tagAndTentative(lRecord) == tag);
        }
    }

    static long tag(long hashOrRecord) {
        return hashOrRecord & 0xFFF0000000000000L;
    }

    private static long tagAndTentative(long record) {
        return record & 0xFFF8000000000000L;
    }

    private static long asLogicalAddress(long record) {
        return record & 0xFFFFFFFFFFFFL;
    }

    private static long tentativeRecord(long tag, long address) {
        return tag | 0x8000000000000L | address;
    }

    private static boolean isTentative(long record) {
        return (record & 0x8000000000000L) != 0L;
    }

    private static boolean isLocked(long record) {
        return (record & 0x1000000000000L) != 0L;
    }

    static long record(long tag, long address) {
        return tag | address;
    }

    private static long latchedRecord(long logicalRecord) {
        return 0x4000000000000L | logicalRecord;
    }

    private static long unlatchedRecord(long logicalRecord) {
        return 0xFFFBFFFFFFFFFFFFL & logicalRecord;
    }

    private static long lockedRecord(long logicalRecord) {
        return 0x1000000000000L | logicalRecord;
    }

    private static long unlockedRecord(long logicalRecord) {
        return 0xFFF6FFFFFFFFFFFFL & logicalRecord;
    }

    private static long pending(long logicalRecord) {
        return -logicalRecord;
    }

    private static long read(long address) {
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(address);
    }

    private static void write(long address, long value) {
        GlobalMemoryAccessorRegistry.AMEM.putLongVolatile(address, value);
    }

    private static void writeKeyHash(long entryAddress, long keyHash) {
        long address = entryAddress + 64L;
        GlobalMemoryAccessorRegistry.AMEM.putLongVolatile(address, keyHash);
    }

    private static long readKeyHash(long entryAddress) {
        long address = entryAddress + 64L;
        return GlobalMemoryAccessorRegistry.AMEM.getLongVolatile(address);
    }

    private static boolean cas(long address, long expected, long value) {
        return GlobalMemoryAccessorRegistry.AMEM.compareAndSwapLong(address, expected, value);
    }

    private static long updateNext(Dependencies dependencies, long logicalRecord, long logicalNext, Epoch epoch, int threadIndex) {
        long physicalRecord = dependencies.physicalAddressForUpdate(logicalRecord, threadIndex);
        if (physicalRecord == 0L) {
            long loaded;
            while (true) {
                if ((loaded = dependencies.readRecordForUpdate(logicalRecord)) != -1L) break;
                epoch.refresh(threadIndex);
                Thread.yield();
            }
            logicalRecord = loaded;
            physicalRecord = dependencies.physicalAddressForUpdate(logicalRecord, threadIndex);
            assert (physicalRecord != 0L);
            dependencies.markAsReachable(logicalRecord, threadIndex);
        }
        Index.setNext(dependencies.recordAccessor(), logicalRecord, physicalRecord, logicalNext);
        return logicalRecord;
    }

    private static boolean keyEquals(byte[] record, Data key) {
        return UnguardedTieredStoreRecordAccessor.keyEquals(record, key);
    }

    private long next(long logicalRecord, long physicalRecord) {
        return Index.next(this.dependencies.recordAccessor(), logicalRecord, physicalRecord);
    }

    private static long next(TieredStoreRecordAccessor recordAccessor, long logicalRecord, long physicalRecord) {
        return recordAccessor.getNextRecordAddress(logicalRecord, physicalRecord);
    }

    private static long next(byte[] record) {
        return UnguardedTieredStoreRecordAccessor.getNextRecordAddress(record);
    }

    private void setNext(long logicalRecord, long physicalRecord, long logicalNext) {
        Index.setNext(this.dependencies.recordAccessor(), logicalRecord, physicalRecord, logicalNext);
    }

    private static void setNext(TieredStoreRecordAccessor recordAccessor, long logicalRecord, long physicalRecord, long logicalNext) {
        recordAccessor.setNextRecordAddress(logicalRecord, physicalRecord, logicalNext);
    }

    private long keyHash(long logicalAddress, long physicalRecord) {
        return this.dependencies.keyHash(logicalAddress, physicalRecord);
    }

    private long asPhysicalAddress(long logical, int threadIndex) {
        return this.dependencies.physicalAddress(logical, threadIndex);
    }

    private long physicalForUpdate(long logical, int threadIndex) {
        return this.dependencies.physicalAddressForUpdate(logical, threadIndex);
    }

    private TieredStoreRecord translateResult(long logicalRecord, int threadIndex) {
        if (logicalRecord == 0L) {
            return null;
        }
        if (logicalRecord == -2L) {
            return UNEXPECTED_RECORD;
        }
        if (logicalRecord == -1L) {
            return RETRY_RECORD;
        }
        if (logicalRecord < 0L) {
            return new StatusRecord(-logicalRecord);
        }
        long physicalRecord = this.asPhysicalAddress(logicalRecord, threadIndex);
        assert (physicalRecord != 0L);
        return this.dependencies.makeRecord(physicalRecord, logicalRecord, threadIndex);
    }

    private Map.Entry<Data, Record<Data>> translateResultToEntry(long logicalRecord, int threadIndex) {
        assert (logicalRecord > 0L);
        assert (this.asPhysicalAddress(logicalRecord, threadIndex) != 0L);
        TieredStoreRecord record = this.translateResult(logicalRecord, threadIndex);
        return this.dependencies.newEntry(record);
    }

    private Map.Entry<Data, Record<Data>> translateResultToEntry(byte[] record) {
        if (record == null) {
            return null;
        }
        return this.dependencies.newEntry(record);
    }

    private Data translateResultToKey(byte[] record) {
        if (record == null) {
            return null;
        }
        return this.dependencies.newKey(record);
    }

    private long translateArgument(TieredStoreRecord record) {
        if (record == null) {
            return 0L;
        }
        if (record == NO_EXPECTATION) {
            return -1L;
        }
        assert (record != UNEXPECTED_RECORD && record != RETRY_RECORD && !record.isPending());
        return record.getLogicalAddress();
    }

    private static int other(int version) {
        return 1 - version;
    }

    private void updateMaxRecordChainLength(int newValue) {
        int oldValue;
        do {
            if ((oldValue = MAX_RECORD_CHAIN_LENGTH.get(this)) < newValue) continue;
            return;
        } while (!MAX_RECORD_CHAIN_LENGTH.compareAndSet(this, oldValue, newValue));
    }

    public int getMaxRecordChainLength() {
        return MAX_RECORD_CHAIN_LENGTH.get(this);
    }

    private static final class Table {
        static final int DEFAULT_BITS = 1;
        static final int RECORDS_PER_TOP_LEVEL_BUCKET_LIMIT = 28;
        int bits;
        long mask;
        long buckets;
        long limit;

        private Table() {
        }

        Table copy() {
            Table table = new Table();
            table.bits = this.bits;
            table.mask = this.mask;
            table.buckets = this.buckets;
            table.limit = this.limit;
            return table;
        }

        void allocate(int bits, Dependencies dependencies) {
            assert (bits >= 0 && bits <= 64);
            this.bits = bits;
            long capacity = 1L << bits;
            this.mask = capacity - 1L;
            this.buckets = dependencies.allocateBuckets(capacity);
            this.limit = capacity * 28L;
        }

        void free(Dependencies dependencies) {
            long capacity = 1L << this.bits;
            long endBucket = this.buckets + (capacity << 7);
            for (long bucket = this.buckets; bucket < endBucket; bucket += 128L) {
                long current = Index.read(bucket + 56L);
                while (current != 0L) {
                    long next = Index.read(current + 56L);
                    dependencies.freeBuckets(current, 1L);
                    current = next;
                }
            }
            dependencies.freeBuckets(this.buckets, capacity);
        }

        void free(Dependencies dependencies, LongConsumer logicalRecordVisitor, int currentThreadIndex) {
            long capacity = 1L << this.bits;
            long endBucket = this.buckets + (capacity << 7);
            for (long bucket = this.buckets; bucket < endBucket; bucket += 128L) {
                long entry = bucket;
                long overflowBucket = 0L;
                do {
                    for (int i = 0; i < 7; ++i) {
                        long lRecord = Index.asLogicalAddress(Index.read(entry));
                        while (lRecord != 0L) {
                            long pRecord = dependencies.physicalAddress(lRecord, currentThreadIndex);
                            assert (pRecord != 0L);
                            long lNext = Index.next(dependencies.recordAccessor(), lRecord, pRecord);
                            logicalRecordVisitor.accept(lRecord);
                            lRecord = Index.asLogicalAddress(lNext);
                        }
                        entry += 8L;
                    }
                    entry = Index.read(entry);
                    if (overflowBucket != 0L) {
                        dependencies.freeBuckets(overflowBucket, 1L);
                    }
                    overflowBucket = entry;
                } while (entry != 0L);
            }
            dependencies.freeBuckets(this.buckets, capacity);
        }

        int getSize() {
            return (int)this.mask + 1;
        }
    }

    public static interface Dependencies {
        public long allocateBuckets(long var1);

        public void freeBuckets(long var1, long var3);

        public long physicalAddress(long var1, int var3);

        public long physicalAddressForUpdate(long var1, int var3);

        public long readRecordForUpdate(long var1);

        public long readRecordAndDoRemapping(long var1);

        public byte[] readRecordFromDevice(long var1);

        public boolean pinRecordForUpdate(long var1);

        public void unpinRecord(long var1);

        public TieredStoreRecord makeRecord(long var1, long var3, int var5);

        public Map.Entry<Data, Record<Data>> newEntry(byte[] var1);

        public Map.Entry<Data, Record<Data>> newEntry(TieredStoreRecord var1);

        public Data newKey(byte[] var1);

        public void keyHashAndNext(long var1, LongPair var3);

        public long keyHash(long var1, long var3);

        public void markAsReachable(long var1, int var3);

        public void markAsNotReachable(long var1, int var3);

        public EnterpriseSerializationService serializationService();

        public TieredStoreRecordAccessor recordAccessor();

        public Epoch getEpoch();

        default public void onDispose() {
        }

        public void pinSegment(int var1);

        public void unpinSegment(int var1);

        public int segmentNoOf(long var1);
    }

    public static final class KeyLock {
        private final long hash;
        private final long entry;
        private final int bits;

        KeyLock(long hash, long entry, int bits) {
            this.hash = hash;
            this.entry = entry;
            this.bits = bits;
        }
    }

    public static final class Iterator {
        private IterationPointer[] pointers;
        private final Queue<Data> keys;
        private final Index index;
        private long logicalRecord;

        private Iterator(Index index) {
            this.index = index;
            int size = index.tables[index.version].getSize();
            this.pointers = new IterationPointer[]{new IterationPointer(size - 1, size)};
            this.keys = new LinkedList<Data>();
        }

        public boolean hasNext(int threadIndex) {
            this.logicalRecord = this.tryNext(threadIndex);
            return this.logicalRecord != 0L;
        }

        private long tryNext(int threadIndex) {
            while (true) {
                if (!this.keys.isEmpty()) {
                    long r;
                    Data key = this.keys.peek();
                    while (0L != (r = this.index.getRaw(threadIndex, key, -1L, true))) {
                        if (r == -1L) {
                            this.yieldAndRefresh(threadIndex);
                            continue;
                        }
                        if (r > 0L) {
                            return r;
                        }
                        if (this.tryReadRecord(-r)) continue;
                        this.yieldAndRefresh(threadIndex);
                    }
                    Invariants.equals(r, 0L);
                    this.keys.poll();
                    continue;
                }
                if (!Index.isMoreToVisit(this.pointers)) break;
                if (!this.keys.isEmpty() || !Index.isMoreToVisit(this.pointers)) continue;
                this.fetchNext(threadIndex);
                this.yieldAndRefresh(threadIndex);
            }
            return 0L;
        }

        public TieredStoreRecord next(int threadIndex) {
            if (this.logicalRecord == 0L) {
                this.logicalRecord = this.tryNext(threadIndex);
            }
            if (this.logicalRecord == 0L) {
                throw new NoSuchElementException();
            }
            Invariants.notEquals(0, this.keys.size());
            this.keys.poll();
            TieredStoreRecord r = this.index.translateResult(this.logicalRecord, threadIndex);
            this.logicalRecord = 0L;
            return r;
        }

        private void fetchNext(int threadIndex) {
            this.pointers = Index.refreshPointers(this.pointers, this.index.tables[this.index.version].getSize());
            this.pointers = this.index.fetchEntries(threadIndex, 1, this.pointers, r -> {
                EnterpriseSerializationService ess = this.index.dependencies.serializationService();
                Object keyOnHeap = ess.toData((Object)r.getKey(), DataType.HEAP);
                this.keys.offer((Data)keyOnHeap);
            });
        }

        private boolean tryReadRecord(long logicalAddr) {
            long result = this.index.dependencies.readRecordAndDoRemapping(logicalAddr);
            return result != -1L;
        }

        private void yieldAndRefresh(int threadIndex) {
            Thread.yield();
            this.index.epoch.refresh(threadIndex);
            this.index.state.refresh(threadIndex);
        }
    }

    public static final class MapEntryNoCachingIterator {
        private IterationPointer[] pointers;
        private final Queue<Data> keys;
        private final Index index;
        private Map.Entry<Data, Record<Data>> mapEntry;

        private MapEntryNoCachingIterator(Index index) {
            this.index = index;
            int size = index.tables[index.version].getSize();
            this.pointers = new IterationPointer[]{new IterationPointer(size - 1, size)};
            this.keys = new LinkedList<Data>();
        }

        public boolean hasNext(int threadIndex) {
            this.mapEntry = this.tryNext(threadIndex);
            return this.mapEntry != null;
        }

        private Map.Entry<Data, Record<Data>> tryNext(int threadIndex) {
            while (true) {
                if (!this.keys.isEmpty()) {
                    long logicalRecord;
                    Data key = this.keys.peek();
                    while (0L != (logicalRecord = this.index.getRaw(threadIndex, key, -1L, false))) {
                        if (logicalRecord == -1L) {
                            this.yieldAndRefresh(threadIndex);
                            continue;
                        }
                        assert (logicalRecord > 0L);
                        long physicalRecord = this.index.asPhysicalAddress(logicalRecord, threadIndex);
                        if (physicalRecord != 0L) {
                            return this.index.translateResultToEntry(logicalRecord, threadIndex);
                        }
                        byte[] record = this.index.dependencies.readRecordFromDevice(logicalRecord);
                        return this.index.translateResultToEntry(record);
                    }
                    Invariants.equals(logicalRecord, 0L);
                    this.keys.poll();
                    continue;
                }
                if (!Index.isMoreToVisit(this.pointers)) break;
                if (!this.keys.isEmpty() || !Index.isMoreToVisit(this.pointers)) continue;
                this.fetchNext(threadIndex);
                this.yieldAndRefresh(threadIndex);
            }
            return null;
        }

        public Map.Entry<Data, Record<Data>> next(int threadIndex) {
            if (this.mapEntry == null) {
                this.mapEntry = this.tryNext(threadIndex);
            }
            if (this.mapEntry == null) {
                throw new NoSuchElementException();
            }
            Invariants.notEquals(0, this.keys.size());
            this.keys.poll();
            Map.Entry<Data, Record<Data>> result = this.mapEntry;
            this.mapEntry = null;
            return result;
        }

        private void fetchNext(int threadIndex) {
            this.pointers = Index.refreshPointers(this.pointers, this.index.tables[this.index.version].getSize());
            this.pointers = this.index.fetchMapKeys(threadIndex, 1, this.pointers, key -> {
                EnterpriseSerializationService ess = this.index.dependencies.serializationService();
                Object keyOnHeap = ess.toData(key, DataType.HEAP);
                this.keys.offer((Data)keyOnHeap);
            });
        }

        private void yieldAndRefresh(int threadIndex) {
            Thread.yield();
            this.index.epoch.refresh(threadIndex);
            this.index.state.refresh(threadIndex);
        }
    }

    private static final class StatusRecord
    extends TieredStoreRecord {
        private final String name;

        StatusRecord(String name) {
            super(null, null);
            this.logicalAddress = 0L;
            this.name = name;
        }

        StatusRecord(long logicalAddress) {
            super(null, null);
            this.logicalAddress = logicalAddress;
            this.name = "PENDING";
        }

        @Override
        public boolean isPending() {
            return this.logicalAddress != 0L;
        }

        @Override
        public int getVersion() {
            assert (false);
            return 0;
        }

        @Override
        public void setVersion(int version) {
            assert (false);
        }

        @Override
        public RecordReaderWriter getMatchingRecordReaderWriter() {
            assert (false);
            return null;
        }

        @Override
        public int getMetadataSize() {
            assert (false);
            return 0;
        }

        @Override
        public long getLogicalAddress() {
            assert (this.logicalAddress != 0L);
            return this.logicalAddress;
        }

        @Override
        protected int getSizeInternal() {
            assert (false);
            return 0;
        }

        @Override
        public String toString() {
            return this.logicalAddress == 0L ? this.name : this.name + " " + this.logicalAddress;
        }
    }

    private static final class ClearMachine
    extends State.Machine {
        private static final int PHASE_PREPARE_CLEAR = 4;
        private static final int PHASE_CLEARING = 5;
        private static final int PHASE_CLEARED = 6;
        private final Index index;
        private final LongConsumer logicalRecordVisitor;
        private final int version;
        private final Table table;

        ClearMachine(Index index, LongConsumer logicalRecordVisitor) {
            this.index = index;
            this.logicalRecordVisitor = logicalRecordVisitor;
            this.version = index.version;
            this.table = index.tables[this.version].copy();
        }

        @Override
        public void globalEntering(int threadIndex, long next, long current) {
            int phase = State.phase(next);
            switch (phase) {
                case 4: {
                    break;
                }
                case 5: {
                    int otherVersion = Index.other(this.version);
                    this.index.tables[otherVersion].allocate(1, this.index.dependencies);
                    this.index.size = 0L;
                    this.index.version = otherVersion;
                    break;
                }
                case 6: {
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected phase: " + phase);
                }
            }
        }

        @Override
        public void globalEntered(int threadIndex, long current, long previous) {
            int phase = State.phase(current);
            switch (phase) {
                case 4: {
                    this.index.epoch.bump(threadIndex, (actionThreadIndex, actionEpoch) -> this.index.state.globalStep(actionThreadIndex, current));
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    this.index.epoch.bump(threadIndex, (actionThreadIndex, actionEpoch) -> {
                        if (this.logicalRecordVisitor == null) {
                            this.table.free(this.index.dependencies);
                        } else {
                            this.table.free(this.index.dependencies, this.logicalRecordVisitor, threadIndex);
                        }
                        this.index.state.globalStep(actionThreadIndex, current);
                    });
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected phase: " + phase);
                }
            }
        }

        @Override
        public void threadEntered(int threadIndex, long current, long previous) {
            int phase = State.phase(current);
            switch (phase) {
                case 4: {
                    break;
                }
                case 5: {
                    this.index.state.globalStep(threadIndex, current);
                    break;
                }
                case 6: {
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected phase: " + phase);
                }
            }
        }

        @Override
        public long nextState(long current) {
            int phase = State.phase(current);
            long version = State.version(current);
            switch (phase) {
                case 0: {
                    return State.make(4L, version);
                }
                case 4: {
                    return State.make(5L, version);
                }
                case 5: {
                    return State.make(6L, version);
                }
                case 6: {
                    return State.make(0L, version);
                }
            }
            throw new IllegalArgumentException("unexpected phase: " + phase);
        }

        @Override
        public long startState(long current) {
            long version = State.version(current);
            return State.make(0L, version);
        }

        @Override
        public long endState(long current) {
            long version = State.version(current);
            return State.make(0L, version);
        }
    }

    private static final class GrowMachine
    extends State.Machine {
        private static final int PHASE_PREPARE_GROW = 1;
        private static final int PHASE_GROWING = 2;
        private static final int PHASE_GREW = 3;
        private static final int NOT_STARTED = 0;
        private static final int RESIZING = 1;
        private static final int RESIZED = 2;
        private final Index index;
        private final int version;
        private final Table table;
        private final AtomicIntegerArray segments;

        GrowMachine(Index index) {
            this.index = index;
            this.version = index.version;
            this.table = index.tables[this.version].copy();
            long capacity = 1L << this.table.bits;
            this.segments = new AtomicIntegerArray((int)Math.min((long)index.segments, capacity));
        }

        @Override
        public boolean validate() {
            return this.index.size > this.table.limit;
        }

        @Override
        public void globalEntering(int threadIndex, long next, long current) {
            int phase = State.phase(next);
            switch (phase) {
                case 1: {
                    break;
                }
                case 2: {
                    this.index.tables[Index.other(this.version)].allocate(this.table.bits + 1, this.index.dependencies);
                    break;
                }
                case 3: {
                    this.index.version = Index.other(this.version);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected phase: " + phase);
                }
            }
        }

        @Override
        public void globalEntered(int threadIndex, long current, long previous) {
            int phase = State.phase(current);
            switch (phase) {
                case 1: {
                    this.index.epoch.bump(threadIndex, (actionThreadIndex, actionEpoch) -> this.index.state.globalStep(actionThreadIndex, current));
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    this.index.epoch.bump(threadIndex, (actionThreadIndex, actionEpoch) -> {
                        this.table.free(this.index.dependencies);
                        this.index.state.globalStep(actionThreadIndex, current);
                    });
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected phase: " + phase);
                }
            }
        }

        @Override
        public void threadEntered(int threadIndex, long current, long previous) {
            int i;
            int phase = State.phase(current);
            switch (phase) {
                case 1: {
                    return;
                }
                case 2: {
                    break;
                }
                case 3: {
                    return;
                }
                case 0: {
                    return;
                }
                default: {
                    throw new IllegalArgumentException("unexpected phase: " + phase);
                }
            }
            long buckets = this.table.buckets;
            int segmentCount = this.segments.length();
            Table newTable = this.index.tables[Index.other(this.version)];
            long capacity = 1L << this.table.bits;
            long bucketsPerSegment = (capacity + (long)segmentCount - 1L) / (long)segmentCount;
            long endBucket = buckets + (capacity << 7);
            LongPair keyHashAndNext = new LongPair();
            for (i = 0; i < segmentCount; ++i) {
                int segment = (threadIndex + i) % segmentCount;
                if (!this.segments.compareAndSet(segment, 0, 1)) continue;
                long segmentStart = buckets + (long)segment * (bucketsPerSegment << 7);
                long segmentEnd = Math.min(segmentStart + (bucketsPerSegment << 7), endBucket);
                for (long bucket = segmentStart; bucket < segmentEnd; bucket += 128L) {
                    GrowMachine.transferBucket(bucket, newTable, this.index.dependencies, keyHashAndNext, this.index.epoch, threadIndex);
                }
                this.segments.set(segment, 2);
            }
            for (i = 0; i < segmentCount; ++i) {
                while (this.segments.get(i) != 2) {
                    Thread.yield();
                }
            }
            this.index.state.globalStep(threadIndex, current);
        }

        @Override
        public long nextState(long current) {
            int phase = State.phase(current);
            long version = State.version(current);
            switch (phase) {
                case 0: {
                    return State.make(1L, version);
                }
                case 1: {
                    return State.make(2L, version);
                }
                case 2: {
                    return State.make(3L, version);
                }
                case 3: {
                    return State.make(0L, version);
                }
            }
            throw new IllegalArgumentException("unexpected phase: " + phase);
        }

        @Override
        public long startState(long current) {
            long version = State.version(current);
            return State.make(0L, version);
        }

        @Override
        public long endState(long current) {
            long version = State.version(current);
            return State.make(0L, version);
        }

        private static void transferBucket(long bucket, Table table, Dependencies dependencies, LongPair keyHashAndNext, Epoch epoch, int threadIndex) {
            long entry = bucket;
            int bucketShift = table.bits - 1;
            do {
                for (int i = 0; i < 7; ++i) {
                    long lRecord = Index.read(entry);
                    assert ((lRecord & 0x8000000000000L) == 0L || (lRecord & 0x1000000000000L) != 0L && Index.asLogicalAddress(lRecord) == 0L);
                    assert ((lRecord & 0x4000000000000L) == 0L);
                    long locked = lRecord & 0x9000000000000L;
                    long seenBuckets = 0L;
                    long keyHash = 0L;
                    if ((lRecord & 0x2000000000000L) != 0L) {
                        lRecord = Index.asLogicalAddress(lRecord);
                        keyHash = Index.readKeyHash(entry);
                        GrowMachine.transferRecord(lRecord, keyHash, 0L, locked, table, dependencies, epoch, threadIndex);
                        seenBuckets |= 1L << (int)(keyHash >>> bucketShift & 1L);
                    } else {
                        while (lRecord != 0L) {
                            lRecord = Index.asLogicalAddress(lRecord);
                            dependencies.keyHashAndNext(lRecord, keyHashAndNext);
                            keyHash = keyHashAndNext.value1;
                            long lNext = keyHashAndNext.value2;
                            GrowMachine.transferRecord(lRecord, keyHash, lNext, locked, table, dependencies, epoch, threadIndex);
                            seenBuckets |= 1L << (int)(keyHash >>> bucketShift & 1L);
                            lRecord = lNext;
                        }
                    }
                    if (locked != 0L && seenBuckets != 3L) {
                        assert (seenBuckets == 1L || seenBuckets == 2L);
                        long lockMask = (1L << bucketShift) - 1L;
                        long lockIndex = keyHash & lockMask | 1L - (long)Long.numberOfTrailingZeros(seenBuckets) << bucketShift;
                        long lockBucket = table.buckets + (lockIndex << 7);
                        GrowMachine.insertTentativeLock(keyHash & (table.mask ^ 0xFFFFFFFFFFFFFFFFL) | lockIndex, lockBucket, dependencies);
                    }
                    entry += 8L;
                }
            } while ((entry = Index.read(entry)) != 0L);
        }

        private static void transferRecord(long lRecord, long keyHash, long lNext, long locked, Table table, Dependencies dependencies, Epoch epoch, int threadIndex) {
            long index = keyHash & table.mask;
            long bucket = table.buckets + (index << 7);
            long tag = Index.tag(keyHash);
            long freeEntry = 0L;
            long entry = bucket;
            do {
                for (int i = 0; i < 7; ++i) {
                    long lExistingRecord = Index.read(entry);
                    if (lExistingRecord == 0L) {
                        freeEntry = entry;
                    } else if (Index.tag(lExistingRecord) == tag) {
                        assert ((lExistingRecord & 0x9000000000000L) == locked) : keyHash + " " + Index.readKeyHash(entry);
                        lExistingRecord = Index.asLogicalAddress(lExistingRecord);
                        lRecord = Index.updateNext(dependencies, lRecord, lExistingRecord, epoch, threadIndex);
                        Index.writeKeyHash(entry, keyHash);
                        Index.write(entry, Index.record(tag, lRecord) & 0xFFFDFFFFFFFFFFFFL | locked);
                        return;
                    }
                    entry += 8L;
                }
            } while ((entry = Index.read(entry)) != 0L);
            if (lNext != 0L) {
                lRecord = Index.updateNext(dependencies, lRecord, 0L, epoch, threadIndex);
            }
            if (freeEntry != 0L) {
                Index.writeKeyHash(freeEntry, keyHash);
                Index.write(freeEntry, Index.record(tag, lRecord) | 0x2000000000000L | locked);
                return;
            }
            long newBucket = dependencies.allocateBuckets(1L);
            Index.writeKeyHash(newBucket, keyHash);
            Index.write(newBucket, Index.record(tag, lRecord) | 0x2000000000000L | locked);
            Index.write(newBucket + 56L, Index.read(bucket + 56L));
            Index.write(bucket + 56L, newBucket);
        }

        private static void insertTentativeLock(long keyHash, long bucket, Dependencies dependencies) {
            long tag = Index.tag(keyHash);
            long entry = bucket;
            do {
                for (int i = 0; i < 7; ++i) {
                    long lExistingRecord = Index.read(entry);
                    if (lExistingRecord == 0L) {
                        Index.writeKeyHash(entry, keyHash);
                        Index.write(entry, Index.record(tag, 0L) | 0x8000000000000L | 0x1000000000000L | 0x2000000000000L);
                        return;
                    }
                    assert (Index.tag(lExistingRecord) != tag) : lExistingRecord + " " + tag + " " + keyHash;
                    entry += 8L;
                }
            } while ((entry = Index.read(entry)) != 0L);
            long newBucket = dependencies.allocateBuckets(1L);
            Index.writeKeyHash(newBucket, keyHash);
            Index.write(newBucket, Index.record(tag, 0L) | 0x8000000000000L | 0x1000000000000L | 0x2000000000000L);
            Index.write(newBucket + 56L, Index.read(bucket + 56L));
            Index.write(bucket + 56L, newBucket);
        }
    }

    public static final class LongPair {
        public long value1;
        public long value2;
    }
}

