/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.hybridlog.impl;

import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import com.hazelcast.internal.tstore.Epoch;
import com.hazelcast.internal.tstore.TStoreException;
import com.hazelcast.internal.tstore.device.ChunkAccessor;
import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.device.DeviceOutOfCapacityException;
import com.hazelcast.internal.tstore.hybridlog.AddressRemapper;
import com.hazelcast.internal.tstore.hybridlog.EvictorDevice;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.internal.tstore.hybridlog.HybridLogConfiguration;
import com.hazelcast.internal.tstore.hybridlog.HybridLogDirectAccessor;
import com.hazelcast.internal.tstore.hybridlog.HybridLogIteratorConfigurator;
import com.hazelcast.internal.tstore.hybridlog.HybridLogRegion;
import com.hazelcast.internal.tstore.hybridlog.InMemorySlotAccessor;
import com.hazelcast.internal.tstore.hybridlog.PinType;
import com.hazelcast.internal.tstore.hybridlog.impl.FutureEpochBump;
import com.hazelcast.internal.tstore.hybridlog.impl.FutureSafeHeadAddressesList;
import com.hazelcast.internal.tstore.hybridlog.impl.GuardedHybridLogDirectAccessor;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogImplMetrics;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogIteratorConfiguratorImpl;
import com.hazelcast.internal.tstore.hybridlog.impl.HybridLogSlotAllocator;
import com.hazelcast.internal.tstore.hybridlog.impl.MultiStageEpochAction;
import com.hazelcast.internal.tstore.hybridlog.impl.PageMetadata;
import com.hazelcast.internal.tstore.hybridlog.impl.PagePool;
import com.hazelcast.internal.tstore.hybridlog.impl.PageState;
import com.hazelcast.internal.tstore.hybridlog.impl.Pager;
import com.hazelcast.internal.tstore.hybridlog.impl.TStoreUtil;
import com.hazelcast.internal.tstore.hybridlog.impl.TieredStoreWorkingSetImpl;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.internal.util.collection.Long2LongHashMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.LongConsumer;

public class HybridLogImpl
implements HybridLog {
    private static final boolean DEBUG = HybridLogImpl.class.desiredAssertionStatus();
    private static final ThreadLocal<Long2LongHashMap> MUTABLE_PINS = DEBUG ? ThreadLocal.withInitial(() -> new Long2LongHashMap(0L)) : null;
    private static final VarHandle HEAD_ADDRESS = ReflectionUtil.findVarHandle("headAddress", Long.TYPE);
    private static final VarHandle SAFE_HEAD_ADDRESS = ReflectionUtil.findVarHandle("safeHeadAddress", Long.TYPE);
    private static final VarHandle READONLY_ADDRESS = ReflectionUtil.findVarHandle("readOnlyAddress", Long.TYPE);
    private static final VarHandle SAFE_READONLY_ADDRESS = ReflectionUtil.findVarHandle("safeReadOnlyAddress", Long.TYPE);
    private static final VarHandle LAST_ALLOCATED_ADDRESS = ReflectionUtil.findVarHandle("lastAllocatedAddress", Long.TYPE);
    private static final VarHandle DISPOSED = ReflectionUtil.findVarHandle("disposed", Integer.TYPE);
    private static final AtomicIntegerFieldUpdater<HybridLogImpl> PENDING_FLUSHES = AtomicIntegerFieldUpdater.newUpdater(HybridLogImpl.class, "pendingFlushes");
    private static final long ALLOCATOR_STUCK_REPORT_THRESHOLD = 1048575L;
    private static final long BEYOND_READ_ONLY_ADDRESS = -1L;
    private static final long FLUSH_RETRY_DELAY = 1000L;
    final Pager pager;
    final Epoch epoch;
    final PagePool pagePool;
    final GuardedHybridLogDirectAccessor directAccessor;
    private final HybridLogSlotAllocator slotAllocator;
    private final ILogger logger = Logger.getLogger(HybridLogImpl.class);
    private final Device device;
    private final long firstValidLogicalAddress;
    private final String id;
    private final TieredStoreWorkingSetImpl defaultWorkingSet;
    private final FutureSafeHeadAddressesList futureSafeHeadAddresses;
    private final boolean fineEnabled;
    private final ConcurrentMap<Long, PendingWrite> pendingWrites = new ConcurrentHashMap<Long, PendingWrite>();
    private volatile long headAddress;
    private volatile long safeHeadAddress;
    private volatile long safeReadOnlyAddress;
    private volatile long readOnlyAddress;
    private volatile long lastAllocatedAddress;
    private volatile int disposed;
    private volatile int pendingFlushes;
    private final long headLagOffset;
    private final long readOnlyLagOffset;
    private final HybridLogImplMetrics metrics = new HybridLogImplMetrics();
    private final Queue<FutureEpochBump> scheduledEpochBumps = new ConcurrentLinkedQueue<FutureEpochBump>();

    HybridLogImpl(HybridLogConfiguration config, Epoch epoch, PagePool pagePool, Device device) {
        this(UuidUtil.newUnsecureUuidString(), config, epoch, pagePool, device);
    }

    public HybridLogImpl(String id, HybridLogConfiguration config, Epoch epoch, PagePool pagePool, Device device) {
        this.validateConfig(config);
        this.id = id;
        this.epoch = epoch;
        this.pagePool = pagePool;
        this.device = device;
        this.pager = new Pager(pagePool, config, this::scheduleEpochBump, this::debugPrologue);
        this.firstValidLogicalAddress = this.pager.pageSize;
        long nextLogicalAddress = this.getNextLogicalAddress();
        this.directAccessor = new GuardedHybridLogDirectAccessor(this);
        this.slotAllocator = new HybridLogSlotAllocator(this::debugPrologue, this.pager, this::prepareForAdvancingToNewPage, nextLogicalAddress, this.metrics);
        this.headAddress = nextLogicalAddress;
        this.safeHeadAddress = nextLogicalAddress;
        this.readOnlyAddress = nextLogicalAddress;
        this.safeReadOnlyAddress = nextLogicalAddress;
        this.headLagOffset = (long)this.pager.totalPages * (long)this.pager.pageSize;
        this.readOnlyLagOffset = (long)this.pager.mutablePages * (long)this.pager.pageSize;
        this.pager.flushedUntilPage = this.pager.pageOf(this.headAddress);
        this.pager.flushingUntilPage = this.pager.pageOf(this.headAddress) - 1;
        this.pager.closedUntilPage = this.pager.pageOf(this.headAddress);
        this.lastAllocatedAddress = nextLogicalAddress;
        this.defaultWorkingSet = new TieredStoreWorkingSetImpl(this);
        this.futureSafeHeadAddresses = new FutureSafeHeadAddressesList(this);
        this.fineEnabled = this.logger.isFineEnabled();
        this.logSetup();
    }

    @Override
    public int getMaxSupportedRecordSizeInBytes() {
        return this.slotAllocator.getMaxSupportedRecordSizeInBytes();
    }

    @Override
    public CompletableFuture<Void> flushMemoryRegionAndSyncFiles() {
        int newTailPage = this.slotAllocator.getBumpedTailPage();
        long newReadOnlyAddress = this.pager.asLogicalAddress(newTailPage, 0);
        MultiStageEpochAction epochAction = new MultiStageEpochAction();
        AddressUpdateResult readOnlyAddressUpdateResult = new AddressUpdateResult();
        CompletableFuture<Void> rootFuture = new CompletableFuture<Void>();
        CompletableFuture flushFuture = new CompletableFuture();
        boolean advanced = this.advanceReadOnlyAddress(newReadOnlyAddress, epochAction, readOnlyAddressUpdateResult, (oldFlushedUntilPage, newFlushedUntilPage) -> {
            if (newFlushedUntilPage >= newTailPage) {
                flushFuture.complete(null);
            }
        });
        assert (advanced);
        this.bumpEpoch(epochAction, futureSafeEpoch -> this.updateMutableEpoch(readOnlyAddressUpdateResult, futureSafeEpoch));
        flushFuture.whenCompleteAsync((unused, throwable) -> this.device.syncAllFilesAsync().whenCompleteAsync((unused2, throwable2) -> rootFuture.complete(null), ConcurrencyUtil.CALLER_RUNS), ConcurrencyUtil.CALLER_RUNS);
        return rootFuture;
    }

    private void logSetup() {
        if (this.fineEnabled) {
            long maxFootPrint = (long)this.pager.totalPages * (long)this.pager.pageSize;
            this.logger.fine("HybridLog created with parameters:\n - Hybrid log ID: " + this.id + "\n - Max in-memory footprint: " + maxFootPrint + " bytes\n - Page size: " + this.pager.pageSize + " bytes\n - Readonly pages: " + this.pager.readOnlyPages + "\n - Mutable pages: " + this.pager.mutablePages + "\n - First valid logical address: " + this.pager.prettyFormat(this.firstValidLogicalAddress) + "\n - Slot allocator: " + this.slotAllocator.debugInfo() + "\n - Device: " + this.device.debugInfo() + "\n");
        }
    }

    private void validateConfig(HybridLogConfiguration config) {
        Preconditions.checkTrue(QuickMath.isPowerOfTwo(config.getPageSize()), "Page size must be a power of two");
        if (config.getReadOnlyPages() <= 0) {
            throw new IllegalArgumentException("The number of read-only pages should be a positive integer");
        }
        if (config.getMutablePages() <= 0) {
            throw new IllegalArgumentException("The number of mutable pages should be a positive integer");
        }
    }

    public long headAddress() {
        return this.headAddress;
    }

    public long safeHeadAddress() {
        return this.safeHeadAddress;
    }

    long safeReadOnlyAddress() {
        return this.safeReadOnlyAddress;
    }

    public long lastAllocatedAddress() {
        return this.lastAllocatedAddress;
    }

    boolean advanceHeadAddress(long desiredHeadAddress) {
        long oldHeadAddress = this.headAddress;
        long newHeadAddressCandidate = Math.min(desiredHeadAddress, this.pager.pageStartLogicalAddress(this.pager.flushedUntilPage + 1));
        long newHeadAddress = Math.max(oldHeadAddress, newHeadAddressCandidate);
        if (newHeadAddress == oldHeadAddress) {
            return false;
        }
        return TStoreUtil.monotonicUpdate(this, HEAD_ADDRESS, newHeadAddress, (oldHeadAddressValue, newHeadAddressValue) -> {
            if (this.fineEnabled) {
                this.logger.fine(this.debugPrologue() + " - Advanced head address: " + this.pager.prettyFormat(oldHeadAddressValue) + " -> " + this.pager.prettyFormat(newHeadAddressValue));
            }
            MultiStageEpochAction epochAction = new MultiStageEpochAction(safeEpochIgnored -> this.onPagesClosed(newHeadAddressValue));
            AddressUpdateResult readOnlyAddressUpdateResult = new AddressUpdateResult();
            long desiredReadOnlyAddress = this.pager.asLogicalAddress(this.pager.pageOf(newHeadAddressValue) + this.pager.readOnlyPages, 0);
            this.advanceReadOnlyAddress(desiredReadOnlyAddress, epochAction, readOnlyAddressUpdateResult);
            epochAction.addStage(this.futureSafeHeadAddresses::cleanUpToEpoch);
            this.futureSafeHeadAddresses.prepare(newHeadAddressValue);
            this.bumpEpoch(epochAction, futureSafeEpoch -> {
                this.futureSafeHeadAddresses.finalizeWithEpoch(futureSafeEpoch, newHeadAddressValue);
                this.updateAccessibleEpoch(oldHeadAddressValue, newHeadAddressValue, futureSafeEpoch, epochAction);
                this.updateMutableEpoch(readOnlyAddressUpdateResult, futureSafeEpoch);
            });
        });
    }

    void bumpEpoch(Epoch.Action epochAction, LongConsumer epochConsumer) {
        int threadIndex = this.epoch.getCurrentThreadIndex();
        CompositeBumpAction actions = new CompositeBumpAction();
        FutureEpochBump futureEpochBump = this.scheduledEpochBumps.poll();
        while (futureEpochBump != null) {
            actions.includeBump(futureEpochBump);
            futureEpochBump = this.scheduledEpochBumps.poll();
        }
        if (actions.actions.isEmpty()) {
            this.epoch.bump(threadIndex, epochAction, epochConsumer);
            return;
        }
        actions.includeBump(new FutureEpochBump(epochAction, epochConsumer));
        this.epoch.bump(threadIndex, actions, actions);
    }

    void scheduleEpochBump(Epoch.Action epochAction, LongConsumer epochConsumer) {
        this.scheduledEpochBumps.offer(new FutureEpochBump(epochAction, epochConsumer));
    }

    private void updateAccessibleEpoch(long oldHeadAddressValue, long newHeadAddressValue, long futureSafeEpoch, MultiStageEpochAction epochAction) {
        int oldHeadPageValue = this.pager.pageOf(oldHeadAddressValue);
        int newHeadPageValue = this.pager.pageOf(newHeadAddressValue);
        for (int p = oldHeadPageValue; p < newHeadPageValue; ++p) {
            PageMetadata pageMetadata = this.pager.pageMetadata(p);
            assert (p == pageMetadata.page());
            this.pager.markPageReleasable(p, futureSafeEpoch, epochAction);
        }
    }

    private void updateMutableEpoch(AddressUpdateResult readOnlyAddressUpdateResult, long futureSafeEpoch) {
        int oldSafeReadOnlyPageValue = this.pager.pageOf(readOnlyAddressUpdateResult.oldAddress);
        int newSafeReadOnlyPageValue = this.pager.pageOf(readOnlyAddressUpdateResult.newAddress);
        for (int p = oldSafeReadOnlyPageValue; p < newSafeReadOnlyPageValue; ++p) {
            PageMetadata pageMetadata = this.pager.pageMetadata(p);
            assert (p == pageMetadata.page()) : TStoreUtil.loggingAssertMessage(this.logger, "Unexpected %s for page %d%n%s", pageMetadata, p, this.pager.debugInfo());
            pageMetadata.setMutableUntilEpoch(futureSafeEpoch);
        }
    }

    private boolean advanceReadOnlyAddress(long desiredReadOnlyAddress, MultiStageEpochAction epochAction, AddressUpdateResult result) {
        return this.advanceReadOnlyAddress(desiredReadOnlyAddress, epochAction, result, TStoreUtil.IntValueUpdateCallback.NOP_CALLBACK);
    }

    private boolean advanceReadOnlyAddress(long desiredReadOnlyAddress, MultiStageEpochAction epochAction, AddressUpdateResult result, TStoreUtil.IntValueUpdateCallback flushedPageCallback) {
        long newReadOnlyAddress = this.determineNewReadOnlyAddress(desiredReadOnlyAddress);
        if (newReadOnlyAddress == -1L) {
            return false;
        }
        return TStoreUtil.monotonicUpdate(this, READONLY_ADDRESS, newReadOnlyAddress, (oldReadOnlyAddressValue, newReadOnlyAddressValue) -> {
            result.oldAddress = oldReadOnlyAddressValue;
            result.newAddress = newReadOnlyAddressValue;
            epochAction.addStage(safeEpoch -> TStoreUtil.monotonicUpdate(this, SAFE_READONLY_ADDRESS, newReadOnlyAddressValue, (oldSafeReadOnlyAddressValue, newSafeReadOnlyAddressValue) -> {
                if (this.fineEnabled) {
                    this.logger.fine(this.debugPrologue() + " - Advanced safe read-only address: " + this.pager.prettyFormat(oldSafeReadOnlyAddressValue) + " -> " + this.pager.prettyFormat(newSafeReadOnlyAddressValue));
                }
                this.onPageMarkedReadOnly(newReadOnlyAddressValue, flushedPageCallback);
            }));
            if (this.fineEnabled) {
                this.logger.fine(this.debugPrologue() + " - Advanced read-only address: " + this.pager.prettyFormat(oldReadOnlyAddressValue) + " -> " + this.pager.prettyFormat(newReadOnlyAddressValue));
            }
        });
    }

    private long determineNewReadOnlyAddress(long desiredReadOnlyAddress) {
        int readOnlyPageHMW;
        long readOnlyAddressCopy;
        if (this.fineEnabled) {
            this.logger.fine(this.debugPrologue() + " - Attempting to set new read-only address: " + this.pager.prettyFormat(desiredReadOnlyAddress));
        }
        int newReadOnlyPage = this.pager.pageOf(desiredReadOnlyAddress);
        do {
            if ((readOnlyAddressCopy = this.readOnlyAddress) >= desiredReadOnlyAddress) {
                return -1L;
            }
            readOnlyPageHMW = this.pager.pageOf(readOnlyAddressCopy) - 1;
            int p = readOnlyPageHMW + 1;
            while (p < newReadOnlyPage && this.pager.markPageReadOnly(p)) {
                readOnlyPageHMW = p++;
            }
        } while (this.readOnlyAddress != readOnlyAddressCopy);
        long determinedReadOnlyAddress = this.pager.asLogicalAddress(readOnlyPageHMW + 1, 0);
        assert (determinedReadOnlyAddress <= desiredReadOnlyAddress) : "determinedReadOnlyAddress: " + this.pager.prettyFormat(determinedReadOnlyAddress) + ", desiredReadOnlyAddress: " + this.pager.prettyFormat(desiredReadOnlyAddress);
        return determinedReadOnlyAddress;
    }

    private void onPagesClosed(long newSafeHeadAddress) {
        assert (this.epoch.inEpochAction());
        TStoreUtil.monotonicUpdate(this, SAFE_HEAD_ADDRESS, newSafeHeadAddress, (oldSafeHeadAddressValue, newSafeHeadAddressValue) -> {
            if (this.fineEnabled) {
                this.logger.fine(this.debugPrologue() + " - Advanced safe head address: " + this.pager.prettyFormat(oldSafeHeadAddressValue) + " -> " + this.pager.prettyFormat(newSafeHeadAddressValue));
            }
            int firstPageRecycle = this.pager.pageOf(oldSafeHeadAddressValue);
            int lastPageRecycle = this.pager.pageOf(newSafeHeadAddressValue);
            for (int page = firstPageRecycle; page < lastPageRecycle; ++page) {
                this.recycleOrDetachPage(page);
            }
            this.pager.closedUntilPage = this.pager.pageOf(newSafeHeadAddressValue);
        });
    }

    private void onPageMarkedReadOnly(long newReadonlyAddress, TStoreUtil.IntValueUpdateCallback flushedPageCallback) {
        int flushedUntilPage = this.pager.flushedUntilPage;
        int newReadonlyPage = this.pager.pageOf(newReadonlyAddress);
        for (int page = flushedUntilPage; page < newReadonlyPage; ++page) {
            if (!Pager.FLUSHING_UNTIL_PAGE.compareAndSet(this.pager, page - 1, page)) continue;
            this.flushPage(page, System.nanoTime(), 0, flushedPageCallback);
        }
    }

    private void recycleOrDetachPage(int page) {
        PageMetadata pageMetadata = this.pager.pageMetadataNoDetached(page);
        if (pageMetadata.page() != page) {
            return;
        }
        if (this.fineEnabled) {
            this.logger.fine(this.debugPrologue() + " - Recycling or detaching page " + page + " with " + String.valueOf(pageMetadata));
        }
        this.pager.recycleOrDetachPage(pageMetadata);
    }

    @Override
    public boolean isInMemory(long logicalAddress, int threadIndex) {
        this.throwExceptionOnInvalidAddress(logicalAddress, threadIndex);
        if (logicalAddress >= this.headAddress) {
            return true;
        }
        return this.isInMemory0(logicalAddress, threadIndex);
    }

    @Override
    public boolean isInMemory(long logicalAddress) {
        this.throwExceptionOnInvalidAddress(logicalAddress, Integer.MIN_VALUE);
        if (logicalAddress >= this.headAddress) {
            return true;
        }
        return this.isInMemory0(logicalAddress, this.epoch.getCurrentThreadIndex());
    }

    private boolean isInMemory0(long logicalAddress, int threadIndex) {
        int page = this.pager.pageOf(logicalAddress);
        PageMetadata pageMetadata = this.pager.pageMetadata(page);
        long currentEpoch = this.currentThreadEpoch(threadIndex);
        long accessibleEpochBefore = pageMetadata.accessibleUntilEpoch();
        this.futureSafeHeadAddresses.waitUntilPreparationsDrainedFor(logicalAddress);
        long safeHeadAddressForCurrentEpoch = this.getSafeHeadAddressForEpoch(currentEpoch);
        if (safeHeadAddressForCurrentEpoch == -1L) {
            safeHeadAddressForCurrentEpoch = this.safeHeadAddress;
        }
        boolean accessibleInCurrentEpoch = HybridLogImpl.isAccessibleInCurrentEpoch(page, pageMetadata, currentEpoch);
        this.assertAddressVsEpochAccess(logicalAddress, currentEpoch, safeHeadAddressForCurrentEpoch, pageMetadata, accessibleInCurrentEpoch, accessibleEpochBefore);
        return accessibleInCurrentEpoch;
    }

    public boolean isRangeInMemoryOnAnyThread(long rangeBeginAddress, long rangeEndAddress) {
        return rangeEndAddress >= this.safeHeadAddress;
    }

    private void assertAddressVsEpochAccess(long logicalAddress, long currentEpoch, long safeHeadAddressForCurrentEpoch, PageMetadata pageMetadata, boolean accessibleInCurrentEpoch, long accessibleEpoch) {
        boolean accessibleByAddress;
        boolean bl = accessibleByAddress = logicalAddress >= safeHeadAddressForCurrentEpoch;
        assert (accessibleInCurrentEpoch == accessibleByAddress || pageMetadata.state().isDetachState()) : TStoreUtil.loggingAssertMessage(this.logger, "%s - logicalAddress: %s, accessibleInCurrentEpoch: %b, accessibleByAddress: %b, pageMetadata: %s, currentEpoch: %d, headAddress: %s, safeHeadAddress: %s, safeHeadAddressForCurrentEpoch: %s, accessibleUntilEpoch-before: %d", this.debugPrologue(), this.pager.prettyFormat(logicalAddress), accessibleInCurrentEpoch, accessibleByAddress, pageMetadata, currentEpoch, this.pager.prettyFormat(this.headAddress), this.pager.prettyFormat(this.safeHeadAddress), this.pager.prettyFormat(safeHeadAddressForCurrentEpoch), accessibleEpoch);
    }

    private static boolean isAccessibleInCurrentEpoch(int page, PageMetadata pageMetadata, long currentEpoch) {
        long accessibleUntilEpoch = pageMetadata.accessibleUntilEpoch();
        return page == pageMetadata.page() && (accessibleUntilEpoch == -1L || accessibleUntilEpoch >= currentEpoch);
    }

    long getSafeHeadAddressForEpoch(long currentEpoch) {
        return this.futureSafeHeadAddresses.getSafeHeadAddressForEpoch(currentEpoch);
    }

    @Override
    public boolean isMutable(long logicalAddress, int threadIndex) {
        this.throwExceptionOnInvalidAddress(logicalAddress, threadIndex);
        long currentEpoch = this.currentThreadEpoch(threadIndex);
        int page = this.pager.pageOf(logicalAddress);
        PageMetadata pageMetadata = this.pager.pageMetadata(page);
        boolean mutable = HybridLogImpl.isMutable(page, pageMetadata, currentEpoch);
        assert (!mutable || logicalAddress >= this.safeReadOnlyAddress) : String.format("%s - safeReadOnlyPage: %d, currentEpoch: %d, | %b | %s", this.debugPrologue(), this.pager.pageOf(this.safeReadOnlyAddress), currentEpoch, mutable, pageMetadata);
        return mutable;
    }

    @Override
    public boolean isMutable(long logicalAddress) {
        return this.isMutable(logicalAddress, this.epoch.getCurrentThreadIndex());
    }

    private static boolean isMutable(int page, PageMetadata pageMetadata, long currentEpoch) {
        long mutableUntilEpoch = pageMetadata.mutableUntilEpoch();
        return page == pageMetadata.page() && (mutableUntilEpoch == -1L || mutableUntilEpoch >= currentEpoch);
    }

    @Override
    public boolean isValidAddress(long logicalAddress, int threadIndex) {
        return this.isValidAddressInternal(logicalAddress, AddressValidationType.STRICT, threadIndex);
    }

    private boolean isValidAddressInternal(long logicalAddress, AddressValidationType validationType, int threadIndex) {
        boolean lazy = validationType == AddressValidationType.LAZY;
        int page = this.pager.pageOf(logicalAddress);
        return logicalAddress > 0L && logicalAddress <= this.lastAllocatedAddress() && this.pager.offsetOf(logicalAddress) >= 8 && (lazy || logicalAddress >= this.safeHeadAddress || HybridLogImpl.isAccessibleInCurrentEpoch(page, this.pager.pageMetadata(page), this.currentThreadEpoch(threadIndex)) || this.device.containsLogicalAddress(logicalAddress));
    }

    @Override
    public long asPhysicalAddress(long logicalAddress, int threadIndex) {
        if (!this.isValidAddressInternal(logicalAddress, AddressValidationType.STRICT, threadIndex)) {
            return -1L;
        }
        if (!this.isInMemory(logicalAddress, threadIndex)) {
            return 0L;
        }
        long physicalAddress = this.pager.asPhysicalAddress(logicalAddress);
        assert (physicalAddress != 0L && physicalAddress != 0L + (long)this.pager.offsetOf(logicalAddress)) : TStoreUtil.loggingAssertMessage(this.logger, String.format("%s - Resolved %s to invalid %s with %s", this.debugPrologue(), this.pager.prettyFormat(logicalAddress), TStoreUtil.prettyFormatPhysical(physicalAddress), this.pager.pageMetadata(logicalAddress)), new Object[0]);
        return physicalAddress;
    }

    private void throwExceptionOnInvalidAddress(long logicalAddress, int threadIndex) {
        if (!this.isValidAddressInternal(logicalAddress, AddressValidationType.LAZY, threadIndex)) {
            throw new TStoreException(String.format("%s - Invalid address: %s, headAddress=%s, lastAllocatedAddress=%s, segmentNo: %d, alive segments: %s", this.debugPrologue(), this.pager.prettyFormat(logicalAddress), this.pager.prettyFormat(this.headAddress), this.pager.prettyFormat(this.lastAllocatedAddress), this.device.segmentNoOf(logicalAddress), this.device.segmentsInfo()));
        }
    }

    @Override
    public long tryAllocate(long size) {
        for (int i = 0; i < 3; ++i) {
            long result = this.tryAllocateInternal(size);
            if (result != -1L) {
                if (result == -2L) {
                    return -3L;
                }
                assert (result > 0L);
                return result;
            }
            Thread.yield();
        }
        return -3L;
    }

    private long tryAllocateInternal(long size) {
        this.checkDisposed();
        long logicalAddress = this.slotAllocator.tryAllocate((int)size);
        boolean validLogicalAddress = this.isValidLogicalAddress(logicalAddress);
        if (this.logger.isFinestEnabled()) {
            if (validLogicalAddress) {
                long physicalAddress = this.pager.asPhysicalAddress(logicalAddress);
                this.logger.finest(this.debugPrologue() + " - Allocated slot at " + this.slotAllocator.pager.prettyFormat(logicalAddress) + " -> " + TStoreUtil.prettyFormatPhysical(physicalAddress));
            } else if (-2L == logicalAddress) {
                this.logger.finest(this.debugPrologue() + " - Unsuccessful allocation, waiting for page flush: the allocator should return later");
            } else if (-1L == logicalAddress) {
                this.logger.finest(this.debugPrologue() + " - Unsuccessful allocation, waiting for page close: the allocator should return immediately");
            }
        }
        if (validLogicalAddress) {
            TStoreUtil.monotonicUpdate(this, LAST_ALLOCATED_ADDRESS, logicalAddress);
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(this.debugRegions());
            }
        }
        this.advanceReadOnlyAddressIfNeeded();
        return logicalAddress;
    }

    @Override
    public long allocate(long size) {
        long logicalAddress = this.tryAllocate(size);
        long tryCount = 0L;
        long lastReportedAtTry = 0L;
        boolean logged = false;
        long stallStartedNs = 0L;
        int currentThreadIndex = Integer.MIN_VALUE;
        while (!this.isValidAddress(logicalAddress, currentThreadIndex) && !Thread.currentThread().isInterrupted()) {
            if (tryCount++ == 0L && logicalAddress == -1L) {
                logicalAddress = this.tryAllocate(size);
                continue;
            }
            if (currentThreadIndex == Integer.MIN_VALUE) {
                currentThreadIndex = this.epoch.getCurrentThreadIndex();
            }
            if (tryCount - lastReportedAtTry > 1048575L) {
                if (PENDING_FLUSHES.get(this) != 0) {
                    throw new DeviceOutOfCapacityException(String.format("No remaining capacity on disk [device='%s', hlog='%s']", this.device.deviceName(), this.id));
                }
                lastReportedAtTry = tryCount;
                this.warnAllocatorStuck(tryCount);
            }
            if (!logged) {
                logged = true;
                stallStartedNs = System.nanoTime();
            }
            Thread.yield();
            this.epoch.refresh(currentThreadIndex);
            logicalAddress = this.tryAllocate(size);
        }
        if (logged) {
            this.metrics.onAllocationStall(stallStartedNs);
        }
        if (Thread.currentThread().isInterrupted()) {
            throw ExceptionUtil.rethrow(new InterruptedException());
        }
        return logicalAddress;
    }

    private void advanceReadOnlyAddressIfNeeded() {
        AddressUpdateResult readOnlyAddressUpdateResult;
        MultiStageEpochAction epochAction;
        long desiredReadOnlyAddress = this.desiredReadOnlyAddress();
        if (desiredReadOnlyAddress > this.readOnlyAddress && this.advanceReadOnlyAddress(desiredReadOnlyAddress, epochAction = new MultiStageEpochAction(), readOnlyAddressUpdateResult = new AddressUpdateResult())) {
            this.bumpEpoch(epochAction, futureSafeEpoch -> this.updateMutableEpoch(readOnlyAddressUpdateResult, futureSafeEpoch));
        }
    }

    private boolean isValidLogicalAddress(long logicalAddress) {
        return logicalAddress >= this.firstValidLogicalAddress;
    }

    @Override
    public long reallocate(long address, long currentSize, long newSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void free(long address, long size) {
        throw new UnsupportedOperationException();
    }

    private void flushPage(int page, long startPageWriteNs, int attempt, TStoreUtil.IntValueUpdateCallback flushedPageCallback) {
        int oldFlushedUntilPage = this.pager.flushedUntilPage;
        long physicalPageStart = this.pagePhysicalAddressStart(page);
        long physicalPageEnd = this.pagePhysicalAddressEnd(page);
        long pageLogicalAddress = this.pager.pageStartLogicalAddress(page);
        int writeLength = this.pager.pageSize;
        if (this.fineEnabled) {
            String physicalStartStr = TStoreUtil.prettyFormatPhysical(physicalPageStart);
            String physicalEndStr = TStoreUtil.prettyFormatPhysical(physicalPageEnd);
            String sb = this.debugPrologue() + " - Trigger page flushing\n  - Hybrid log: " + this.id + "\n  - Device: " + this.device.debugInfo() + "\n  - Page: " + page + "\n  - Logical address range: " + this.pager.prettyFormat(pageLogicalAddress) + " - " + this.pager.prettyFormat(this.pager.pageEndLogicalAddress(page)) + "\n  - Physical address range: " + physicalStartStr + " - " + physicalEndStr;
            this.logger.fine(sb);
        }
        if (attempt == 0) {
            this.pager.markPageFlushing(page);
        }
        try {
            PendingWrite pendingWrite = new PendingWrite();
            this.pendingWrites.put(pageLogicalAddress, pendingWrite);
            pendingWrite.future = this.device.writeAsync(pageLogicalAddress, physicalPageStart, writeLength).whenCompleteAsync((unused, throwable) -> {
                this.pendingWrites.remove(pageLogicalAddress);
                this.finalizePageFlush(page, oldFlushedUntilPage, pageLogicalAddress, (Throwable)throwable, startPageWriteNs, attempt, flushedPageCallback);
            }, ConcurrencyUtil.CALLER_RUNS);
        }
        catch (Throwable throwable2) {
            this.finalizePageFlush(page, oldFlushedUntilPage, pageLogicalAddress, throwable2, startPageWriteNs, attempt, flushedPageCallback);
        }
    }

    private void finalizePageFlush(int page, int oldFlushedUntilPage, long pageLogicalAddress, Throwable throwable, long startPageWriteNs, int attempt, TStoreUtil.IntValueUpdateCallback flushedPageCallback) {
        if (throwable != null) {
            if (attempt == 0) {
                PENDING_FLUSHES.incrementAndGet(this);
                this.logger.severe(this.debugPrologue() + " - Flushing page " + page + " to the device '" + this.device.deviceName() + "' has failed. Retrying for (" + this.pager.prettyFormat(pageLogicalAddress) + " - " + this.pager.prettyFormat(this.pager.pageEndLogicalAddress(page)) + ") address range.", throwable);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            this.flushPage(page, startPageWriteNs, attempt + 1, flushedPageCallback);
            return;
        }
        if (attempt != 0) {
            PENDING_FLUSHES.decrementAndGet(this);
            this.logger.info(this.debugPrologue() + " - Flushing page " + page + " to the device '" + this.device.deviceName() + "' has succeeded after " + attempt + " attempt(s).");
        }
        this.metrics.onPageWritten(startPageWriteNs);
        this.pager.markPageFlushed(page);
        int newFlushedUntilPage = this.pager.flushedUntilPage;
        int p = this.pager.flushedUntilPage;
        while (PageState.FLUSHED == this.pager.pageState(p) || PageState.PINNED_FLUSHED == this.pager.pageState(p)) {
            newFlushedUntilPage = p + 1;
            ++p;
        }
        if (TStoreUtil.monotonicUpdate(this.pager, Pager.FLUSHED_UNTIL_PAGE, newFlushedUntilPage, flushedPageCallback) && this.fineEnabled) {
            this.logger.fine(this.debugPrologue() + " - Advanced flushed until page: " + oldFlushedUntilPage + " -> " + newFlushedUntilPage);
        }
    }

    @Override
    public <P, T> T readRecordForReadOnly(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper, byte[] buf) {
        return this.readRecord(logicalAddress, slotAccessor, addressRemapper, buf, false);
    }

    @Override
    public <P, T> T readRecordForUpdate(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper, byte[] buf) {
        return this.readRecord(logicalAddress, slotAccessor, addressRemapper, buf, true);
    }

    private <P, T> T readRecord(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper, byte[] buf, boolean readForUpdate) {
        this.checkAddress(logicalAddress);
        int currentThreadIndex = this.epoch.getCurrentThreadIndex();
        if (this.isInMemory(logicalAddress, currentThreadIndex)) {
            this.metrics.onReadRecordHit();
            if (!readForUpdate || this.isMutable(logicalAddress)) {
                return slotAccessor.asEntry(slotAccessor.prepare(logicalAddress, this, currentThreadIndex));
            }
            long newLogicalAddress = this.copyForUpdate(logicalAddress, slotAccessor, addressRemapper);
            if (newLogicalAddress == slotAccessor.retryRawStatus()) {
                return slotAccessor.retryStatus();
            }
            return slotAccessor.asEntry(slotAccessor.prepare(newLogicalAddress, this, currentThreadIndex));
        }
        this.metrics.onReadRecordMiss();
        long startNs = System.nanoTime();
        byte[] bytes = this.device.readRecord(logicalAddress, buf, slotAccessor);
        assert (bytes.length > 0) : TStoreUtil.loggingAssertMessage(this.logger, "%s - Read %d bytes for %s", this.debugPrologue(), bytes.length, this.pager.prettyFormat(logicalAddress));
        this.metrics.onRecordReadFromDeviceCompleted(startNs);
        long newLogicalAddressCandidate = this.addReadRecordToLog(bytes, slotAccessor);
        if (newLogicalAddressCandidate == slotAccessor.retryRawStatus()) {
            return slotAccessor.retryStatus();
        }
        T entry = slotAccessor.asEntry(slotAccessor.prepare(newLogicalAddressCandidate, this, currentThreadIndex));
        long status = addressRemapper.remap(entry, logicalAddress, newLogicalAddressCandidate, currentThreadIndex);
        if (status == slotAccessor.retryRawStatus()) {
            return slotAccessor.retryStatus();
        }
        this.device.onGarbage(logicalAddress, bytes.length);
        return entry;
    }

    @Override
    public <P, T> T readRecordForReadOnly(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper) {
        return this.readRecord(logicalAddress, slotAccessor, addressRemapper, false);
    }

    @Override
    public <P, T> T readRecordForUpdate(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper) {
        return this.readRecord(logicalAddress, slotAccessor, addressRemapper, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P, T> T readRecord(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper, boolean readForUpdate) {
        long remappedAddress;
        T entry;
        long newLogicalAddressCandidate;
        this.checkAddress(logicalAddress);
        int currentThreadIndex = this.epoch.getCurrentThreadIndex();
        if (this.isInMemory(logicalAddress, currentThreadIndex)) {
            this.metrics.onReadRecordHit();
            if (!readForUpdate || this.isMutable(logicalAddress)) {
                return slotAccessor.asEntry(slotAccessor.prepare(logicalAddress, this, currentThreadIndex));
            }
            long newLogicalAddress = this.copyForUpdate(logicalAddress, slotAccessor, addressRemapper);
            if (newLogicalAddress == slotAccessor.retryRawStatus()) {
                return slotAccessor.retryStatus();
            }
            return slotAccessor.asEntry(slotAccessor.prepare(newLogicalAddress, this, currentThreadIndex));
        }
        this.metrics.onReadRecordMiss();
        long startNs = System.nanoTime();
        byte[] bytes = this.device.readRecord(logicalAddress, slotAccessor);
        assert (bytes.length > 0) : TStoreUtil.loggingAssertMessage(this.logger, "%s - Read %d bytes for %s", this.debugPrologue(), bytes.length, this.pager.prettyFormat(logicalAddress));
        this.metrics.onRecordReadFromDeviceCompleted(startNs);
        do {
            if ((newLogicalAddressCandidate = this.addReadRecordToLog(bytes, slotAccessor)) != slotAccessor.retryRawStatus()) continue;
            return slotAccessor.retryStatus();
        } while (!this.pinAddress(newLogicalAddressCandidate, PinType.WRITE));
        try {
            entry = slotAccessor.asEntry(slotAccessor.prepare(newLogicalAddressCandidate, this, currentThreadIndex));
            remappedAddress = addressRemapper.remap(entry, logicalAddress, newLogicalAddressCandidate, currentThreadIndex);
            if (remappedAddress == slotAccessor.retryRawStatus()) {
                T t = slotAccessor.retryStatus();
                return t;
            }
        }
        finally {
            this.unpinAddress(newLogicalAddressCandidate, PinType.WRITE);
        }
        this.device.onGarbage(logicalAddress, bytes.length);
        if (remappedAddress != newLogicalAddressCandidate) {
            assert (remappedAddress > logicalAddress || remappedAddress == 0L);
            return slotAccessor.retryStatus();
        }
        return entry;
    }

    @Override
    public <P, T> T readRecordFromMemoryForReadOnly(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, int threadIndex) {
        if (!this.isInMemory(logicalAddress, threadIndex)) {
            throw new IllegalArgumentException(this.debugPrologue() + " - The requested logical address " + this.pager.prettyFormat(logicalAddress) + " is not in the memory");
        }
        this.metrics.onReadRecordHit();
        return slotAccessor.asEntry(slotAccessor.prepare(logicalAddress, this, threadIndex));
    }

    @Override
    public <P, T> byte[] readRecordFromDevice(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor) {
        this.checkAddress(logicalAddress);
        if (this.isInMemory(logicalAddress)) {
            throw new IllegalArgumentException(this.debugPrologue() + " - The requested logical address " + this.pager.prettyFormat(logicalAddress) + " is not on device");
        }
        this.metrics.onReadRecordMiss();
        return this.device.readRecord(logicalAddress, slotAccessor);
    }

    @Override
    public byte[] readChunk(long logicalAddress, byte[] buf, ChunkAccessor chunkAccessor) {
        this.checkAddress(logicalAddress);
        if (this.isInMemory(logicalAddress)) {
            throw new IllegalArgumentException(this.debugPrologue() + " - The requested logical address " + this.pager.prettyFormat(logicalAddress) + " is not on device");
        }
        return this.device.readChunk(logicalAddress, buf, chunkAccessor);
    }

    private void checkAddress(long logicalAddress) {
        if (!this.isValidAddressInternal(logicalAddress, AddressValidationType.STRICT, Integer.MIN_VALUE)) {
            throw new IllegalArgumentException(String.format("%s - Invalid logical address: %s. Valid addresses are within the range defined by and lastAllocatedAddress=%s, segmentNo: %d, alive segments %s", this.debugPrologue(), this.pager.prettyFormat(logicalAddress), this.pager.prettyFormat(this.lastAllocatedAddress), this.device.segmentNoOf(logicalAddress), this.device.segmentsInfo()));
        }
    }

    private <P, T> long copyForUpdate(long oldLogicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper) {
        int currentThreadIndex = this.epoch.getCurrentThreadIndex();
        long oldPhysicalAddress = this.asPhysicalAddress(oldLogicalAddress, currentThreadIndex);
        P preparedSlot = slotAccessor.prepare(oldLogicalAddress, this, currentThreadIndex);
        int size = slotAccessor.size(preparedSlot);
        byte[] tmp = new byte[size];
        assert (this.pager.verifyAccess(this.pager.pageOf(oldLogicalAddress), oldPhysicalAddress));
        GlobalMemoryAccessorRegistry.AMEM.copyToByteArray(oldPhysicalAddress, tmp, 0, size);
        long newLogicalAddressCandidate = this.tryAllocate(size);
        if (newLogicalAddressCandidate < 0L) {
            return slotAccessor.retryRawStatus();
        }
        long newLogicalAddress = newLogicalAddressCandidate;
        long newPhysicalAddress = this.asPhysicalAddress(newLogicalAddress, currentThreadIndex);
        assert (this.pager.verifyAccess(this.pager.pageOf(newLogicalAddress), newPhysicalAddress));
        GlobalMemoryAccessorRegistry.AMEM.copyFromByteArray(tmp, 0, newPhysicalAddress, size);
        P newPreparedSlot = slotAccessor.prepare(newLogicalAddress, this, currentThreadIndex);
        T newEntry = slotAccessor.asEntry(newPreparedSlot);
        return addressRemapper.remap(newEntry, oldLogicalAddress, newLogicalAddress, currentThreadIndex);
    }

    @Override
    public <P, T> CompletableFuture<T> readRecordAsync(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper) {
        return this.readRecordAsync(logicalAddress, slotAccessor, addressRemapper, false);
    }

    @Override
    public <P, T> CompletableFuture<T> readRecordAsyncForUpdate(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper) {
        return this.readRecordAsync(logicalAddress, slotAccessor, addressRemapper, true);
    }

    private <P, T> CompletableFuture<T> readRecordAsync(long logicalAddress, InMemorySlotAccessor<P, T> slotAccessor, AddressRemapper<T> addressRemapper, boolean readForUpdate) {
        this.checkAddress(logicalAddress);
        int currentThreadIndex = this.epoch.getCurrentThreadIndex();
        CompletableFuture future = new CompletableFuture();
        if (this.isInMemory(logicalAddress, currentThreadIndex)) {
            this.metrics.onReadRecordHit();
            if (!readForUpdate || this.isMutable(logicalAddress)) {
                T entry = slotAccessor.asEntry(slotAccessor.prepare(logicalAddress, this, currentThreadIndex));
                future.complete(entry);
                return future;
            }
            long newLogicalAddress = this.copyForUpdate(logicalAddress, slotAccessor, addressRemapper);
            if (newLogicalAddress == slotAccessor.retryRawStatus()) {
                future.complete(slotAccessor.retryStatus());
            }
            T entry = slotAccessor.asEntry(slotAccessor.prepare(newLogicalAddress, this, currentThreadIndex));
            future.complete(entry);
            return future;
        }
        this.metrics.onReadRecordMiss();
        long readStartNs = System.nanoTime();
        this.device.readRecordAsync(logicalAddress, slotAccessor).whenCompleteAsync((bytes, ex) -> {
            if (ex != null) {
                future.completeExceptionally((Throwable)ex);
                return;
            }
            try {
                long newLogicalAddressCandidate = this.tryAllocate(((byte[])bytes).length);
                if (newLogicalAddressCandidate < 0L) {
                    future.complete(slotAccessor.retryStatus());
                    return;
                }
                long physicalAddress = this.asPhysicalAddress(newLogicalAddressCandidate, currentThreadIndex);
                GlobalMemoryAccessorRegistry.AMEM.copyFromByteArray((byte[])bytes, 0, physicalAddress, ((byte[])bytes).length);
                Object entry = slotAccessor.asEntry(slotAccessor.prepare(newLogicalAddressCandidate, this, currentThreadIndex));
                long status = addressRemapper.remap(entry, logicalAddress, newLogicalAddressCandidate, currentThreadIndex);
                if (status == slotAccessor.retryRawStatus()) {
                    future.complete(slotAccessor.retryStatus());
                } else {
                    future.complete(entry);
                    this.metrics.onRecordReadFromDeviceCompleted(readStartNs);
                    this.device.onGarbage(logicalAddress, ((byte[])bytes).length);
                }
            }
            catch (Exception ex2) {
                future.completeExceptionally(ex2);
            }
        }, ConcurrencyUtil.CALLER_RUNS);
        return future;
    }

    void prepareForAdvancingToNewPage(int page) {
        long pageEndLogicalAddress = this.pager.pageEndLogicalAddress(page);
        long flushedUntilLogicalAddress = this.pager.pageStartLogicalAddress(this.pager.flushedUntilPage);
        long desiredHeadAddress = Math.min(pageEndLogicalAddress - this.headLagOffset + 1L, flushedUntilLogicalAddress);
        long desiredReadOnlyAddress = this.desiredReadOnlyAddress();
        if (this.logger.isFinestEnabled()) {
            this.logger.finest(this.debugPrologue() + " - Preparing for page " + page + " by advancing\n  - headAddress to " + this.pager.prettyFormat(desiredHeadAddress) + " \n  - readOnlyAddress to " + this.pager.prettyFormat(desiredReadOnlyAddress));
        }
        if (!this.advanceHeadAddress(desiredHeadAddress)) {
            this.advanceReadOnlyAddressIfNeeded();
        }
    }

    private long desiredReadOnlyAddress() {
        long nextPageAddress = this.pager.asLogicalAddress(this.pager.pageOf(this.lastAllocatedAddress) + 1, 0);
        return Math.max(nextPageAddress - this.readOnlyLagOffset & (long)this.pager.pageMask, this.firstValidLogicalAddress);
    }

    void fetchPage(int page, byte[] buffer) {
        if (buffer.length < this.pager.pageSize) {
            throw new IllegalArgumentException(this.debugPrologue() + " - The provided buffer is smaller than the size of a page");
        }
        long pageAddress = this.pager.asLogicalAddress(page, 0);
        this.device.read(pageAddress, buffer);
    }

    private <P, T> long addReadRecordToLog(byte[] bytes, InMemorySlotAccessor<P, T> slotAccessor) {
        assert (bytes.length > 0) : Arrays.toString(bytes);
        long newLogicalAddress = this.tryAllocate(bytes.length);
        if (newLogicalAddress < 0L) {
            return slotAccessor.retryRawStatus();
        }
        int currentThreadIndex = this.epoch.getCurrentThreadIndex();
        long physicalAddress = this.asPhysicalAddress(newLogicalAddress, currentThreadIndex);
        assert (physicalAddress != 0L) : "newLogicalAddress=" + newLogicalAddress;
        GlobalMemoryAccessorRegistry.AMEM.copyFromByteArray(bytes, 0, physicalAddress, bytes.length);
        return newLogicalAddress;
    }

    private long pagePhysicalAddressStart(int page) {
        long pageHeadLogicalAddress = this.pager.asLogicalAddress(page, 0);
        if (pageHeadLogicalAddress < this.headAddress) {
            throw new IllegalArgumentException(this.debugPrologue() + " - Page " + page + " is not in the memory");
        }
        return this.pager.asPhysicalAddress(pageHeadLogicalAddress);
    }

    private long pagePhysicalAddressEnd(int page) {
        long pageHeadLogicalAddress = this.pager.asLogicalAddress(page, 0);
        if (pageHeadLogicalAddress < this.headAddress) {
            throw new IllegalArgumentException(this.debugPrologue() + " - Page " + page + " is not in the memory");
        }
        return this.pager.asPhysicalAddress(pageHeadLogicalAddress) + (long)this.pager.pageSize - 1L;
    }

    @Override
    public void dispose() {
        if (!DISPOSED.compareAndSet(this, 0, 1)) {
            return;
        }
        this.waitForPendingWrites();
        this.pager.dispose();
        this.device.dispose();
    }

    private void waitForPendingWrites() {
        List<CompletableFuture> pendingWrites = this.pendingWrites.values().stream().map(pw -> pw.future).toList();
        FutureUtil.waitForever(pendingWrites);
    }

    private void checkDisposed() {
        if (DISPOSED.get(this) != 0) {
            throw new IllegalStateException(this.debugPrologue() + " has been disposed. It is no longer safe to issue invocations on it.");
        }
    }

    public String getId() {
        return this.id;
    }

    String debugPrologue() {
        return "{" + TStoreUtil.hybridLogStr(this.id) + "," + TStoreUtil.epochStr(this.epoch) + "}";
    }

    String debugAddresses() {
        int threadIndex = this.epoch.getCurrentThreadIndex();
        long currentEpoch = this.epoch.getThreadEpoch(threadIndex);
        long safeFutureHeadAddress = this.getSafeHeadAddressForEpoch(currentEpoch);
        return this.debugPrologue() + " addresses:\n  - safeHeadAddress:      " + this.pager.prettyFormat(this.safeHeadAddress) + " might update to (" + this.pager.prettyFormat(safeFutureHeadAddress) + ")\n  - headAddress:          " + this.pager.prettyFormat(this.headAddress) + "\n  - safeReadOnlyAddress:  " + this.pager.prettyFormat(this.safeReadOnlyAddress) + "\n  - readOnlyAddress:      " + this.pager.prettyFormat(this.readOnlyAddress) + "\n";
    }

    String debugRegions() {
        return this.debugPrologue() + " regions:     \n  - Read-only: " + this.debugRegion(this.headAddress, Math.min(this.readOnlyAddress, this.safeReadOnlyAddress) - 1L) + "\n  - Fuzzy:     " + this.debugRegion(Math.min(this.readOnlyAddress, this.safeReadOnlyAddress), this.readOnlyAddress - 1L) + "\n  - Mutable:   " + this.debugRegion(Math.max(this.readOnlyAddress, this.safeReadOnlyAddress), this.pager.pageEndLogicalAddress(this.pager.pageOf(this.lastAllocatedAddress))) + "\n";
    }

    private String debugRegion(long regionStartAddress, long regionEndAddress) {
        if (regionEndAddress > regionStartAddress) {
            return this.pager.prettyFormat(regionStartAddress) + " - " + this.pager.prettyFormat(regionEndAddress);
        }
        return "N/A";
    }

    String debugFutureSafeHeadAddresses() {
        return this.futureSafeHeadAddresses.debugInfo();
    }

    HybridLogRegion regionOf(long logicalAddress) {
        if (logicalAddress < this.headAddress) {
            return this.device instanceof EvictorDevice ? HybridLogRegion.NIRVANA : HybridLogRegion.STABLE;
        }
        if (logicalAddress < this.safeReadOnlyAddress) {
            return HybridLogRegion.READ_ONLY;
        }
        if (logicalAddress < this.readOnlyAddress) {
            return HybridLogRegion.FUZZY;
        }
        return HybridLogRegion.MUTABLE;
    }

    long align(long logicalAddress) {
        return TStoreUtil.align8Bytes(logicalAddress);
    }

    @Override
    public <P, T> HybridLogIteratorConfigurator<P, T> iterators() {
        return new HybridLogIteratorConfiguratorImpl(this);
    }

    @Override
    public boolean pinAddress(long logicalAddress, PinType pinType) {
        switch (pinType) {
            case READ: {
                return this.readPinAddress(logicalAddress);
            }
            case WRITE: {
                return this.writePinAddress(logicalAddress);
            }
        }
        throw new IllegalArgumentException(this.debugPrologue() + " - Invalid pin type: " + String.valueOf((Object)pinType));
    }

    private boolean readPinAddress(long logicalAddress) {
        this.validateAddressIsInMemory(logicalAddress);
        int page = this.pager.pageOf(logicalAddress);
        return this.defaultWorkingSet.pin(logicalAddress, PinType.READ, () -> this.pager.pinPage(page, (oldState, newState) -> {
            PageMetadata pageMetadata = this.pager.pageMetadata(page);
            if (newState == PageState.PINNED_DETACHABLE || newState == PageState.PINNED_DETACHED) {
                pageMetadata.clearAccessibleUntilEpoch();
            }
        }));
    }

    private boolean writePinAddress(long logicalAddress) {
        this.validateAddressIsInMemory(logicalAddress);
        int page = this.pager.pageOf(logicalAddress);
        boolean pinned = this.defaultWorkingSet.pin(logicalAddress, PinType.WRITE, () -> this.pager.pinPageForUpdate(page));
        if (DEBUG && pinned) {
            Long2LongHashMap mutablePins = MUTABLE_PINS.get();
            long count = mutablePins.get(logicalAddress);
            assert (count >= 0L);
            mutablePins.put(logicalAddress, count + 1L);
        }
        return pinned;
    }

    @Override
    public void unpinAddress(long logicalAddress, PinType pinType) {
        PageMetadata pageMetadata = this.pager.pageMetadata(logicalAddress);
        int page = this.pager.pageOf(logicalAddress);
        if (pageMetadata.page() != page) {
            throw new IllegalArgumentException(String.format("%s - Logical address %s could not be resolved to an in-memory page. Resolved metadata: %s", this.debugPrologue(), this.pager.prettyFormat(logicalAddress), pageMetadata));
        }
        try {
            this.defaultWorkingSet.unpin(logicalAddress, pinType, (oldPagePinType, newPagePinType) -> {
                if (oldPagePinType == PinType.WRITE && newPagePinType == PinType.READ) {
                    this.pager.demoteForUpdatePin(page);
                    return;
                }
                if (pageMetadata.state() == PageState.PINNED_DETACHED) {
                    assert (oldPagePinType == PinType.READ && newPagePinType == PinType.NONE) : TStoreUtil.loggingAssertMessage(this.logger, "Unexpected pin type transition: %s -> %s", oldPagePinType, newPagePinType);
                    MultiStageEpochAction epochAction = new MultiStageEpochAction();
                    this.scheduleEpochBump(epochAction, futureEpoch -> this.pager.markPageReleasable(page, futureEpoch, epochAction, true));
                }
                assert (newPagePinType == PinType.NONE) : TStoreUtil.loggingAssertMessage(this.logger, "Unexpected pin type transition: %s -> %s", oldPagePinType, newPagePinType);
                this.pager.unpinPage(pageMetadata);
            });
        }
        catch (Exception e) {
            this.logger.severe(String.format("Couldn't unpin page %s", pageMetadata), e);
            throw e;
        }
        if (DEBUG && pinType == PinType.WRITE) {
            Long2LongHashMap mutablePins = MUTABLE_PINS.get();
            long count = mutablePins.get(logicalAddress);
            assert (count >= 0L);
            if (count == 1L) {
                mutablePins.remove(logicalAddress);
            } else if (count != 0L) {
                mutablePins.put(logicalAddress, count - 1L);
            }
        }
    }

    @Override
    public boolean isAddressPinned(long logicalAddress) {
        return this.isAddressPinned(logicalAddress, true);
    }

    public static void assertCurrentThreadHasNoMutablePinsInstalled() {
        if (DEBUG) {
            Long2LongHashMap pins = MUTABLE_PINS.get();
            assert (pins.isEmpty()) : TStoreUtil.loggingAssertMessage(Logger.getLogger(HybridLogImpl.class), pins.toString(), new Object[0]);
        }
    }

    boolean isAddressPinned(long logicalAddress, boolean validate) {
        if (validate && this.pager.pageMetadata(logicalAddress).page() != this.pager.pageOf(logicalAddress)) {
            this.validateAddressIsInMemory(logicalAddress);
        }
        return this.defaultWorkingSet.isLogicalAddressPinned(logicalAddress);
    }

    private void validateAddressIsInMemory(long logicalAddress) {
        if (!this.isInMemory(logicalAddress)) {
            throw new IllegalArgumentException(String.format("%s - Logical address %s is not in the memory. Resolved metadata: %s", this.debugPrologue(), this.pager.prettyFormat(logicalAddress), this.pager.pageMetadata(logicalAddress)));
        }
    }

    private void warnAllocatorStuck(long tryCount) {
        String ln = System.lineSeparator();
        String s = "stuck in the allocate of HybridLog with id=" + this.getId() + ln + "tryCount=" + tryCount + ln + this.epoch.debugInfo() + ln + "headAddress page is " + this.pager.pageOf(this.headAddress) + ln + "headAddress page is pinned? - " + this.defaultWorkingSet.isPagePinned(this.pager.pageOf(this.headAddress)) + ln + this.debugAddresses() + ln + this.pager.debugInfo() + ln + this.pagePool.debugInfo() + ln + this.slotAllocator.debugInfo();
        this.logger.warning(s);
        if (Boolean.getBoolean("hazelcast.tstore.allocation.failOnStuck")) {
            throw new TStoreException("Stuck in the allocate of HybridLog with id=" + this.getId());
        }
    }

    public Device getDevice() {
        return this.device;
    }

    public HybridLogImplMetrics getMetrics() {
        return this.metrics;
    }

    public long getFirstValidLogicalAddress() {
        return this.firstValidLogicalAddress;
    }

    public long firstEntry(int segmentNo) {
        if (segmentNo == 0) {
            return this.firstValidLogicalAddress + 8L;
        }
        return this.device.segmentFirstLogicalAddress(segmentNo) + 8L;
    }

    @Override
    public HybridLogDirectAccessor accessor() {
        return this.directAccessor;
    }

    public int getReadonlyPageCount() {
        return this.pager.readOnlyPages;
    }

    public int getMutablePageCount() {
        return this.pager.mutablePages;
    }

    private long currentThreadEpoch(int threadIndex) {
        return threadIndex == Integer.MIN_VALUE ? (long)this.epoch.getCurrentThreadIndex() : this.epoch.getThreadEpoch(threadIndex);
    }

    public String prettyFormat(long logicalAddress) {
        return this.pager.prettyFormat(logicalAddress);
    }

    public Epoch getEpoch() {
        return this.epoch;
    }

    long getNextLogicalAddress() {
        int lastSegmentNo = this.device.restoreLastSegmentNo();
        if (lastSegmentNo >= 0) {
            int nextSegmentNo = lastSegmentNo + 1;
            return this.device.segmentFirstLogicalAddress(nextSegmentNo);
        }
        return this.pager.pageSize;
    }

    private static final class AddressUpdateResult {
        private long oldAddress = 0L;
        private long newAddress = 0L;

        private AddressUpdateResult() {
        }
    }

    private static class CompositeBumpAction
    implements Epoch.Action,
    LongConsumer {
        private final LinkedList<FutureEpochBump> actions = new LinkedList();

        private CompositeBumpAction() {
        }

        private void includeBump(FutureEpochBump bump) {
            this.actions.add(bump);
        }

        @Override
        public void run(int threadIndex, long actionEpoch) {
            for (FutureEpochBump bump : this.actions) {
                bump.action.run(threadIndex, actionEpoch);
            }
        }

        @Override
        public void accept(long futureEpoch) {
            for (FutureEpochBump bump : this.actions) {
                bump.epochConsumer.accept(futureEpoch);
            }
        }
    }

    protected static enum AddressValidationType {
        LAZY,
        STRICT;

    }

    private static final class PendingWrite {
        private volatile CompletableFuture<Void> future;

        private PendingWrite() {
        }
    }
}

