/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.device.local;

import com.hazelcast.internal.tstore.device.Device;
import com.hazelcast.internal.tstore.device.DeviceException;
import com.hazelcast.internal.tstore.device.HybridLogFileHandle;
import com.hazelcast.internal.tstore.device.HybridLogFileHandlePool;
import com.hazelcast.internal.tstore.device.HybridLogFileHandleProvider;
import com.hazelcast.internal.tstore.device.MutableOperation;
import com.hazelcast.internal.tstore.device.local.LocalStorageDevice;
import com.hazelcast.internal.tstore.device.local.LocalStorageDeviceMetrics;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashSet;
import java.util.Set;

final class SyncOperation
extends MutableOperation {
    private final Device device;
    private final Set<Integer> fileSet;

    SyncOperation(Device device, Set<Integer> fileSet) {
        super(device);
        this.device = device;
        this.fileSet = new HashSet<Integer>(fileSet);
    }

    @Override
    public Void run(byte[] context) {
        SyncOperation.run0(this.getDevice(), this.fileSet);
        return null;
    }

    public static void run0(LocalStorageDevice device, Set<Integer> fileSet) {
        HybridLogFileHandlePool handlePool = device.getHandlePool();
        int deviceId = device.getDeviceId();
        HybridLogFileHandleProvider handleProvider = device.getHandleProvider();
        for (int fileNo : fileSet) {
            HybridLogFileHandle handle = handlePool.getHandle(deviceId, fileNo, handleProvider);
            if (handle == null) {
                throw new DeviceException(String.format("Cannot get handle for fileNo: %s", fileNo));
            }
            try {
                RandomAccessFile raf = handle.getRaf();
                raf.getChannel().force(true);
                LocalStorageDeviceMetrics metrics = (LocalStorageDeviceMetrics)device.getMetrics();
                metrics.onFileSync();
            }
            catch (IOException ioe) {
                throw new DeviceException(ioe);
            }
            finally {
                handlePool.releaseHandle(handle);
            }
        }
    }

    private LocalStorageDevice getDevice() {
        return (LocalStorageDevice)this.device;
    }

    @Override
    public String toString() {
        return "SyncOperation(" + this.device.deviceName() + ", " + String.valueOf(this.fileSet) + ")";
    }
}

