/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tstore.compaction;

import com.hazelcast.internal.tstore.compaction.AbstractPartitionCompactorStep;
import com.hazelcast.internal.tstore.hybridlog.HybridLog;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.operation.steps.engine.State;
import com.hazelcast.map.impl.recordstore.CompactionAwareStorage;
import com.hazelcast.query.impl.IndexRegistry;
import com.hazelcast.query.impl.TSPartitionedIndexImpl;
import javax.annotation.Nullable;

public class IndexPartitionCompactorStep
extends AbstractPartitionCompactorStep {
    private final String indexName;

    public IndexPartitionCompactorStep(String indexName) {
        super(Logger.getLogger(IndexPartitionCompactorStep.class));
        this.indexName = indexName;
    }

    @Override
    CompactionAwareStorage getCompactionAwareStorage(State state) {
        int partitionId = state.getPartitionId();
        MapContainer mapContainer = state.getOperation().getMapContainer();
        IndexRegistry indexRegistry = mapContainer.getOrNullPartitionedIndexRegistry(partitionId);
        assert (indexRegistry != null);
        TSPartitionedIndexImpl index = (TSPartitionedIndexImpl)indexRegistry.getIndex(this.indexName);
        assert (index != null);
        return index.getCompactorAwareStorage();
    }

    @Override
    @Nullable
    HybridLog getHybridLogOrNull(State state) {
        int partitionId = state.getPartitionId();
        MapContainer mapContainer = state.getOperation().getMapContainer();
        IndexRegistry indexRegistry = mapContainer.getOrNullPartitionedIndexRegistry(partitionId);
        if (indexRegistry == null) {
            return null;
        }
        TSPartitionedIndexImpl index = (TSPartitionedIndexImpl)indexRegistry.getIndex(this.indexName);
        if (index == null) {
            return null;
        }
        return index.getHybridLog();
    }
}

