/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.nio;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.tpcengine.iobuffer.IOBuffer;
import com.hazelcast.internal.tpcengine.net.AsyncSocket;
import com.hazelcast.internal.tpcengine.net.AsyncSocketOptions;
import com.hazelcast.internal.tpcengine.net.AsyncSocketReader;
import com.hazelcast.internal.tpcengine.net.AsyncSocketWriter;
import com.hazelcast.internal.tpcengine.nio.IOVector;
import com.hazelcast.internal.tpcengine.nio.NioAsyncSocketBuilder;
import com.hazelcast.internal.tpcengine.nio.NioAsyncSocketOptions;
import com.hazelcast.internal.tpcengine.nio.NioHandler;
import com.hazelcast.internal.tpcengine.nio.NioReactor;
import com.hazelcast.internal.tpcengine.util.BufferUtil;
import com.hazelcast.internal.tpcengine.util.CircularQueue;
import com.hazelcast.internal.tpcengine.util.CloseUtil;
import com.hazelcast.internal.tpcengine.util.ExceptionUtil;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import com.hazelcast.internal.util.OpenSSLUtil;
import com.hazelcast.nio.ssl.SSLEngineFactory;
import com.hazelcast.shaded.org.jctools.queues.MpmcArrayQueue;
import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public final class TlsNioAsyncSocket
extends AsyncSocket {
    private static final Executor DEFAULT_TLS_EXECUTOR = Executors.newSingleThreadExecutor();
    private final NioAsyncSocketOptions options;
    private final AtomicReference<Thread> flushThread = new AtomicReference();
    private final MpmcArrayQueue writeQueue;
    final TlsHandler handler;
    private final SocketChannel socketChannel;
    private final NioReactor reactor;
    private final Thread eventloopThread;
    private final SelectionKey key;
    private final IOVector ioVector;
    private final AsyncSocketReader reader;
    private final CircularQueue localTaskQueue;
    private final AsyncSocketWriter writer;
    private boolean ioVectorWriteAllowed;
    private boolean started;
    private boolean connecting;
    private volatile CompletableFuture<Void> connectFuture;

    TlsNioAsyncSocket(NioAsyncSocketBuilder builder) {
        super(builder.clientSide);
        assert (Thread.currentThread() == builder.reactor.eventloopThread());
        try {
            this.reactor = builder.reactor;
            this.localTaskQueue = builder.reactor.eventloop().localTaskQueue;
            this.options = builder.options;
            this.eventloopThread = this.reactor.eventloopThread();
            this.socketChannel = builder.socketChannel;
            if (!this.clientSide) {
                this.localAddress = this.socketChannel.getLocalAddress();
                this.remoteAddress = this.socketChannel.getRemoteAddress();
            }
            this.writeQueue = new MpmcArrayQueue(builder.writeQueueCapacity);
            this.writer = builder.writer;
            if (this.writer != null) {
                this.writer.init(this, this.writeQueue);
                this.ioVector = null;
            } else {
                this.ioVector = new IOVector();
            }
            this.ioVectorWriteAllowed = this.ioVector != null;
            this.handler = new TlsHandler(builder);
            this.key = this.socketChannel.register(this.reactor.selector, 0, this.handler);
            this.reader = builder.reader;
            this.flushThread.set(this.eventloopThread);
            this.reader.init(this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public AsyncSocketOptions options() {
        return this.options;
    }

    @Override
    public NioReactor reactor() {
        return this.reactor;
    }

    @Override
    public void setReadable(boolean readable) {
        if (Thread.currentThread() == this.eventloopThread) {
            this.setReadable0(readable);
        } else {
            CompletableFuture future = new CompletableFuture();
            this.reactor.execute(() -> {
                try {
                    this.setReadable0(readable);
                    future.complete(null);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                    throw ExceptionUtil.sneakyThrow(t);
                }
            });
            future.join();
        }
    }

    private void setReadable0(boolean readable) {
        if (readable) {
            this.key.interestOps(this.key.interestOps() | 1);
        } else {
            this.key.interestOps(this.key.interestOps() & 0xFFFFFFFE);
        }
        this.reactor.wakeup();
    }

    @Override
    public boolean isReadable() {
        if (Thread.currentThread() == this.eventloopThread) {
            return this.isReadable0();
        }
        CompletableFuture future = new CompletableFuture();
        this.reactor.execute(() -> {
            try {
                future.complete(this.isReadable0());
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
                throw ExceptionUtil.sneakyThrow(t);
            }
        });
        return (Boolean)future.join();
    }

    private boolean isReadable0() {
        return (this.key.interestOps() & 1) != 0;
    }

    @Override
    public void start() {
        if (Thread.currentThread() == this.reactor.eventloopThread()) {
            this.start0();
        } else {
            CompletableFuture future = new CompletableFuture();
            this.reactor.execute(() -> {
                try {
                    this.start0();
                    future.complete(null);
                }
                catch (Throwable e) {
                    future.completeExceptionally(e);
                    throw ExceptionUtil.sneakyThrow(e);
                }
            });
            future.join();
        }
    }

    private void start0() {
        if (this.started) {
            throw new IllegalStateException(String.valueOf(this) + " is already started");
        }
        this.started = true;
        assert (this.flushThread.get() == this.reactor.eventloopThread());
        if (!this.clientSide) {
            this.key.interestOps(this.key.interestOps() | 1);
            this.handler.run();
        }
    }

    @Override
    public CompletableFuture<Void> connect(SocketAddress address) {
        Preconditions.checkNotNull(address, "address");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Connecting to address:" + String.valueOf(address));
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (Thread.currentThread() == this.eventloopThread) {
            this.connect0(address, future);
        } else {
            this.reactor.execute(() -> this.connect0(address, future));
        }
        return future;
    }

    private void connect0(SocketAddress address, CompletableFuture<Void> future) {
        try {
            if (!this.started) {
                throw new IllegalStateException(String.valueOf(this) + " can't connect when socket not yet started");
            }
            if (this.connecting) {
                throw new IllegalStateException(String.valueOf(this) + " is already trying to connect");
            }
            assert (this.flushThread.get() == this.reactor.eventloopThread());
            this.connecting = true;
            this.connectFuture = future;
            this.key.interestOps(this.key.interestOps() | 8);
            this.socketChannel.connect(address);
        }
        catch (Throwable e) {
            future.completeExceptionally(e);
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    @Override
    public void flush() {
        Thread currentThread = Thread.currentThread();
        if (this.flushThread.get() != null) {
            return;
        }
        if (!this.flushThread.compareAndSet(null, currentThread)) {
            return;
        }
        if (currentThread == this.eventloopThread) {
            this.localTaskQueue.add(this.handler);
        } else {
            this.reactor.execute(this.handler);
        }
    }

    private void resetFlushed() {
        this.flushThread.set(null);
        if (!this.writeQueue.isEmpty() && this.flushThread.compareAndSet(null, Thread.currentThread())) {
            this.localTaskQueue.add(this.handler);
        }
    }

    @Override
    public boolean write(Object msg) {
        Preconditions.checkNotNull(msg, "msg");
        if (this.writer == null && !(msg instanceof IOBuffer)) {
            throw new IllegalArgumentException("Message needs to be an IOBuffer is writer is not set.");
        }
        if (this.writeQueue.add(msg)) {
            return true;
        }
        this.flush();
        return false;
    }

    @Override
    public boolean writeAndFlush(Object msg) {
        boolean result = this.write(msg);
        this.flush();
        return result;
    }

    @Override
    public boolean unsafeWriteAndFlush(Object msg) {
        Preconditions.checkNotNull(msg, "msg");
        if (this.writer == null && !(msg instanceof IOBuffer)) {
            throw new IllegalArgumentException("Only accepting IOBuffers if writer isn't set.");
        }
        Thread currentThread = Thread.currentThread();
        if (currentThread != this.eventloopThread) {
            throw new IllegalStateException("insideWriteAndFlush can only be made from eventloop thread, found " + String.valueOf(currentThread));
        }
        Thread currentFlushThread = this.flushThread.get();
        boolean triggeredFlush = currentFlushThread == null ? this.flushThread.compareAndSet(null, currentThread) : false;
        boolean offered = this.unsafeWrite(msg);
        if (triggeredFlush && offered) {
            this.localTaskQueue.add(this.handler);
        }
        return offered;
    }

    private boolean unsafeWrite(Object msg) {
        if (this.ioVectorWriteAllowed) {
            if (this.ioVector.offer((IOBuffer)msg)) {
                return true;
            }
            this.ioVectorWriteAllowed = false;
            return this.writeQueue.offer(msg);
        }
        return this.writeQueue.offer(msg);
    }

    @Override
    protected void close0() throws IOException {
        CloseUtil.closeQuietly(this.socketChannel);
        this.key.cancel();
        super.close0();
    }

    final class TlsHandler
    implements NioHandler,
    Runnable {
        ByteBuffer receiveBuffer;
        ByteBuffer sendBuffer;
        ByteBuffer appBuffer;
        private final ByteBuffer writerBuffer;
        private final SSLEngineFactory sslEngineFactory;
        private SSLEngine sslEngine;
        private final boolean directBuffers;
        private SSLSession sslSession;
        private final ByteBuffer emptyBuffer = ByteBuffer.allocate(0);
        private boolean handshakeInProgress = true;
        private final Executor tlsExecutor;
        private volatile boolean handshakeTaskInProgress;
        private int targetInterestOps;

        private TlsHandler(NioAsyncSocketBuilder builder) throws SocketException {
            this.directBuffers = builder.directBuffers;
            this.receiveBuffer = BufferUtil.allocateBuffer(this.directBuffers, builder.options.get(AsyncSocketOptions.SO_RCVBUF));
            this.sendBuffer = BufferUtil.allocateBuffer(this.directBuffers, builder.options.get(AsyncSocketOptions.SO_SNDBUF));
            this.writerBuffer = TlsNioAsyncSocket.this.ioVector == null ? BufferUtil.allocateBuffer(builder.directBuffers, builder.options.get(AsyncSocketOptions.SO_SNDBUF)) : null;
            Executor providedTlsExecutor = builder.options.get(AsyncSocketOptions.TLS_EXECUTOR);
            this.tlsExecutor = providedTlsExecutor == null ? DEFAULT_TLS_EXECUTOR : providedTlsExecutor;
            this.sslEngineFactory = (SSLEngineFactory)builder.options.get(AsyncSocketOptions.SSL_ENGINE_FACTORY);
            if (!TlsNioAsyncSocket.this.clientSide) {
                this.initializeSslEngine();
            }
        }

        @Override
        public void run() {
            try {
                this.handleWrite();
            }
            catch (Throwable e) {
                this.close(null, e);
                throw ExceptionUtil.sneakyThrow(e);
            }
        }

        @Override
        public void close(String reason, Throwable cause) {
            if (cause instanceof EOFException) {
                TlsNioAsyncSocket.this.close(reason != null ? reason : cause.getMessage(), null);
            } else {
                TlsNioAsyncSocket.this.close(reason, cause);
            }
            OpenSSLUtil.releaseEngine(this.sslEngine);
        }

        @Override
        public void handle() throws IOException {
            if (!TlsNioAsyncSocket.this.key.isValid()) {
                throw new CancelledKeyException();
            }
            int readyOps = TlsNioAsyncSocket.this.key.readyOps();
            if ((readyOps & 1) != 0) {
                this.handleRead();
            }
            if ((readyOps & 4) != 0) {
                this.handleWrite();
            }
            if ((readyOps & 8) != 0) {
                this.handleConnect();
            }
        }

        private void handleRead() throws IOException {
            int read;
            TlsNioAsyncSocket.this.metrics.incReadEvents();
            if (this.handshakeInProgress) {
                if (!this.completeHandshake()) {
                    return;
                }
                TlsNioAsyncSocket.this.resetFlushed();
            }
            if ((read = TlsNioAsyncSocket.this.socketChannel.read(this.receiveBuffer)) == -1) {
                throw new EOFException("Socket closed by peer");
            }
            TlsNioAsyncSocket.this.metrics.incBytesRead(read);
            this.receiveBuffer.flip();
            boolean unwrapMore = true;
            block6: do {
                SSLEngineResult unwrapResult = this.sslEngine.unwrap(this.receiveBuffer, this.appBuffer);
                switch (unwrapResult.getStatus()) {
                    case OK: {
                        if (this.receiveBuffer.hasRemaining()) continue block6;
                        unwrapMore = false;
                        break;
                    }
                    case CLOSED: {
                        throw new EOFException("Socket closed!");
                    }
                    case BUFFER_OVERFLOW: {
                        this.readHandlerOnRead();
                        int requiredAppBufferSize = this.sslSession.getApplicationBufferSize() + this.appBuffer.position();
                        if (this.appBuffer.capacity() >= requiredAppBufferSize) continue block6;
                        this.appBuffer.flip();
                        this.appBuffer = this.allocateNewBufferAndPut(requiredAppBufferSize, this.appBuffer);
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        int requiredReceiveBufferSize = this.sslSession.getPacketBufferSize();
                        if (this.receiveBuffer.capacity() < requiredReceiveBufferSize) {
                            this.receiveBuffer = this.allocateNewBufferAndPut(requiredReceiveBufferSize, this.receiveBuffer);
                            return;
                        }
                        unwrapMore = false;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unknown unwrapResult:" + String.valueOf(unwrapResult));
                    }
                }
            } while (unwrapMore);
            this.readHandlerOnRead();
            BufferUtil.compactOrClear(this.receiveBuffer);
        }

        private void readHandlerOnRead() {
            this.appBuffer.flip();
            TlsNioAsyncSocket.this.reader.onRead(this.appBuffer);
            BufferUtil.compactOrClear(this.appBuffer);
        }

        private void handleWrite() throws IOException {
            boolean noMoreData;
            TlsNioAsyncSocket.this.metrics.incWriteEvents();
            if (this.handshakeInProgress) {
                if (this.sendBuffer.position() > 0) {
                    this.writeHandshakeDataToSocket();
                }
                if (!this.completeHandshake()) {
                    return;
                }
            }
            boolean writerClean = false;
            if (TlsNioAsyncSocket.this.writer == null) {
                TlsNioAsyncSocket.this.ioVector.populate(TlsNioAsyncSocket.this.writeQueue);
                if (TlsNioAsyncSocket.this.writeQueue.isEmpty()) {
                    TlsNioAsyncSocket.this.ioVectorWriteAllowed = true;
                }
            } else {
                writerClean = TlsNioAsyncSocket.this.writer.onWrite(this.writerBuffer);
                this.writerBuffer.flip();
            }
            boolean wrapMore = true;
            do {
                SSLEngineResult wrapResult;
                if (TlsNioAsyncSocket.this.writer == null) {
                    wrapResult = this.sslEngine.wrap(TlsNioAsyncSocket.this.ioVector.array(), 0, TlsNioAsyncSocket.this.ioVector.length(), this.sendBuffer);
                    TlsNioAsyncSocket.this.ioVector.compact(wrapResult.bytesConsumed());
                } else {
                    wrapResult = this.sslEngine.wrap(this.writerBuffer, this.sendBuffer);
                }
                switch (wrapResult.getStatus()) {
                    case OK: {
                        wrapMore = TlsNioAsyncSocket.this.ioVector != null ? TlsNioAsyncSocket.this.ioVector.hasRemaining() : this.writerBuffer.hasRemaining();
                        break;
                    }
                    case CLOSED: {
                        throw new EOFException("Remote socket closed!");
                    }
                    case BUFFER_OVERFLOW: {
                        int requiredBufferSize = this.sslSession.getPacketBufferSize();
                        if (this.sendBuffer.capacity() < requiredBufferSize) {
                            this.sendBuffer.flip();
                            this.sendBuffer = this.allocateNewBufferAndPut(requiredBufferSize, this.sendBuffer);
                            break;
                        }
                        wrapMore = false;
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        throw new IllegalStateException("Wrap operation should not result in a BUFFER_UNDERFLOW:" + String.valueOf(wrapResult));
                    }
                    default: {
                        throw new IllegalStateException("Unknown wrapResult:" + String.valueOf(wrapResult));
                    }
                }
            } while (wrapMore);
            if (this.writerBuffer == null) {
                noMoreData = TlsNioAsyncSocket.this.ioVector.isEmpty();
            } else {
                noMoreData = writerClean && !this.writerBuffer.hasRemaining();
                BufferUtil.compactOrClear(this.writerBuffer);
            }
            this.sendBuffer.flip();
            long written = TlsNioAsyncSocket.this.socketChannel.write(this.sendBuffer);
            TlsNioAsyncSocket.this.metrics.incBytesWritten(written);
            boolean sendBufferDrained = !this.sendBuffer.hasRemaining();
            BufferUtil.compactOrClear(this.sendBuffer);
            if (sendBufferDrained) {
                if (noMoreData) {
                    int interestOps = TlsNioAsyncSocket.this.key.interestOps();
                    if ((interestOps & 4) != 0) {
                        TlsNioAsyncSocket.this.key.interestOps(interestOps & 0xFFFFFFFB);
                    }
                    TlsNioAsyncSocket.this.resetFlushed();
                } else {
                    TlsNioAsyncSocket.this.localTaskQueue.add(this);
                }
            } else {
                TlsNioAsyncSocket.this.key.interestOps(TlsNioAsyncSocket.this.key.interestOps() | 4);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean completeHandshake() throws IOException {
            SSLEngineResult.HandshakeStatus handshakeStatus;
            if (this.handshakeTaskInProgress) {
                return false;
            }
            int requiredBufferSize = this.sslEngine.getSession().getPacketBufferSize();
            block18: while (true) {
                handshakeStatus = this.sslEngine.getHandshakeStatus();
                switch (handshakeStatus) {
                    case NEED_TASK: {
                        this.targetInterestOps = TlsNioAsyncSocket.this.key.interestOps();
                        if ((this.targetInterestOps & 5) != 0) {
                            TlsNioAsyncSocket.this.key.interestOps(this.targetInterestOps & 0xFFFFFFFB & 0xFFFFFFFE);
                        }
                        this.handshakeTaskInProgress = true;
                        this.tlsExecutor.execute(new RunHandshakeTasks());
                        return false;
                    }
                    case NEED_WRAP: {
                        SSLEngineResult wrapResult = this.sslEngine.wrap(this.emptyBuffer, this.sendBuffer);
                        switch (wrapResult.getStatus()) {
                            case BUFFER_OVERFLOW: {
                                if (this.sendBuffer.capacity() >= this.sslEngine.getSession().getPacketBufferSize()) {
                                    requiredBufferSize *= 2;
                                }
                                this.sendBuffer.flip();
                                this.sendBuffer = this.allocateNewBufferAndPut(requiredBufferSize, this.sendBuffer);
                                continue block18;
                            }
                            case OK: {
                                this.writeHandshakeDataToSocket();
                                if (wrapResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) continue block18;
                                return this.markHandshakeAsFinished();
                            }
                            case CLOSED: {
                                throw new EOFException("Socket closed!");
                            }
                            case BUFFER_UNDERFLOW: {
                                throw new IllegalStateException("Wrap operation should not result in a BUFFER_UNDERFLOW: " + String.valueOf(wrapResult));
                            }
                        }
                        throw new IllegalStateException("Unknown wrapResult: " + String.valueOf(wrapResult));
                    }
                    case NEED_UNWRAP: {
                        int read = TlsNioAsyncSocket.this.socketChannel.read(this.receiveBuffer);
                        if (read == -1) {
                            throw new EOFException("Remote socket closed!");
                        }
                        this.receiveBuffer.flip();
                        SSLEngineResult unwrapResult = this.sslEngine.unwrap(this.receiveBuffer, this.appBuffer);
                        BufferUtil.compactOrClear(this.receiveBuffer);
                        switch (unwrapResult.getStatus()) {
                            case BUFFER_UNDERFLOW: {
                                int requiredReceiveBufferSize = this.sslEngine.getSession().getPacketBufferSize();
                                if (this.receiveBuffer.capacity() < requiredReceiveBufferSize) {
                                    this.receiveBuffer.flip();
                                    this.receiveBuffer = this.allocateNewBufferAndPut(requiredReceiveBufferSize, this.receiveBuffer);
                                    continue block18;
                                }
                                if (unwrapResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) return false;
                                return this.markHandshakeAsFinished();
                            }
                            case BUFFER_OVERFLOW: {
                                int requiredAppBufferSize = this.sslEngine.getSession().getApplicationBufferSize();
                                if (this.appBuffer.capacity() >= requiredAppBufferSize) continue block18;
                                this.appBuffer.flip();
                                this.appBuffer = this.allocateNewBufferAndPut(requiredAppBufferSize, this.appBuffer);
                                continue block18;
                            }
                            case OK: {
                                if (unwrapResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) return this.markHandshakeAsFinished();
                                continue block18;
                            }
                            case CLOSED: {
                                throw new EOFException("Socket closed");
                            }
                        }
                        throw new RuntimeException("Unknown unwrapResult:" + String.valueOf(unwrapResult));
                    }
                    case NOT_HANDSHAKING: {
                        if (!this.handshakeInProgress) throw new IOException("Failed to complete the SSL/TLS handshake");
                        return this.markHandshakeAsFinished();
                    }
                }
                break;
            }
            throw new IllegalStateException("Illegal handshakeStatus:" + String.valueOf((Object)handshakeStatus));
        }

        private void writeHandshakeDataToSocket() throws IOException {
            this.sendBuffer.flip();
            long written = TlsNioAsyncSocket.this.socketChannel.write(this.sendBuffer);
            TlsNioAsyncSocket.this.metrics.incBytesWritten(written);
            boolean sendBufferDrained = !this.sendBuffer.hasRemaining();
            BufferUtil.compactOrClear(this.sendBuffer);
            if (sendBufferDrained) {
                int interestOps = TlsNioAsyncSocket.this.key.interestOps();
                if ((interestOps & 4) != 0) {
                    TlsNioAsyncSocket.this.key.interestOps(interestOps & 0xFFFFFFFB);
                }
            } else {
                TlsNioAsyncSocket.this.key.interestOps(TlsNioAsyncSocket.this.key.interestOps() | 4);
            }
        }

        private ByteBuffer allocateNewBufferAndPut(int newBufferSize, ByteBuffer sourceBuffer) {
            ByteBuffer tempBuffer = BufferUtil.allocateBuffer(this.directBuffers, newBufferSize);
            BufferUtil.put(tempBuffer, sourceBuffer);
            return tempBuffer;
        }

        private boolean markHandshakeAsFinished() {
            if (this.sendBuffer.position() != 0) {
                return false;
            }
            this.handshakeInProgress = false;
            this.sslSession = this.sslEngine.getSession();
            return true;
        }

        private void handleConnect() {
            try {
                if (!TlsNioAsyncSocket.this.socketChannel.finishConnect()) {
                    throw new IllegalStateException();
                }
                this.onConnectFinished();
            }
            catch (Throwable e) {
                if (TlsNioAsyncSocket.this.connectFuture != null) {
                    TlsNioAsyncSocket.this.connectFuture.completeExceptionally(e);
                }
                throw ExceptionUtil.sneakyThrow(e);
            }
            finally {
                TlsNioAsyncSocket.this.connectFuture = null;
            }
        }

        private void onConnectFinished() throws IOException {
            assert (TlsNioAsyncSocket.this.connecting);
            assert (TlsNioAsyncSocket.this.flushThread.get() == TlsNioAsyncSocket.this.reactor.eventloopThread());
            TlsNioAsyncSocket.this.remoteAddress = TlsNioAsyncSocket.this.socketChannel.getRemoteAddress();
            TlsNioAsyncSocket.this.localAddress = TlsNioAsyncSocket.this.socketChannel.getLocalAddress();
            if (TlsNioAsyncSocket.this.logger.isInfoEnabled()) {
                TlsNioAsyncSocket.this.logger.info("Connection established " + String.valueOf(TlsNioAsyncSocket.this));
            }
            TlsNioAsyncSocket.this.key.interestOps(TlsNioAsyncSocket.this.key.interestOps() | 1);
            TlsNioAsyncSocket.this.connectFuture.complete(null);
            TlsNioAsyncSocket.this.connectFuture = null;
            this.initializeSslEngine();
            TlsNioAsyncSocket.this.localTaskQueue.add(this);
        }

        private void initializeSslEngine() {
            if (!(TlsNioAsyncSocket.this.remoteAddress instanceof InetSocketAddress)) {
                throw new IllegalStateException(String.valueOf(TlsNioAsyncSocket.this.remoteAddress) + " is not an instance of InetSocketAddress");
            }
            Address peerAddress = new Address((InetSocketAddress)TlsNioAsyncSocket.this.remoteAddress);
            this.sslEngine = this.sslEngineFactory.create(TlsNioAsyncSocket.this.clientSide, peerAddress);
            this.appBuffer = BufferUtil.allocateBuffer(this.directBuffers, this.sslEngine.getSession().getApplicationBufferSize());
            try {
                this.sslEngine.beginHandshake();
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class RunHandshakeTasks
    implements Runnable {
        private RunHandshakeTasks() {
        }

        @Override
        public void run() {
            try {
                Runnable runnable = TlsNioAsyncSocket.this.handler.sslEngine.getDelegatedTask();
                while (runnable != null) {
                    runnable.run();
                    runnable = TlsNioAsyncSocket.this.handler.sslEngine.getDelegatedTask();
                }
                TlsNioAsyncSocket.this.handler.handshakeTaskInProgress = false;
                int currentInterestOps = TlsNioAsyncSocket.this.key.interestOps();
                if ((currentInterestOps | TlsNioAsyncSocket.this.handler.targetInterestOps) != currentInterestOps) {
                    TlsNioAsyncSocket.this.key.interestOps(currentInterestOps | TlsNioAsyncSocket.this.handler.targetInterestOps);
                }
                TlsNioAsyncSocket.this.handler.targetInterestOps = 0;
            }
            catch (Throwable e) {
                TlsNioAsyncSocket.this.close("Failed to execute SSL/TLS handshake task.", e);
                throw ExceptionUtil.sneakyThrow(e);
            }
            finally {
                if (!TlsNioAsyncSocket.this.reactor.offer(TlsNioAsyncSocket.this.handler)) {
                    TlsNioAsyncSocket.this.close("Failed to reschedule the TlsHandler after running the SSL/TLS handshake tasks.", null);
                }
            }
        }
    }
}

