/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.memory.HeapMemoryAccessor;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.nio.EnterpriseBufferObjectDataOutput;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.serialization.impl.UnsafeObjectDataOutput;
import java.io.IOException;

final class EnterpriseUnsafeObjectDataOutput
extends UnsafeObjectDataOutput
implements EnterpriseBufferObjectDataOutput {
    EnterpriseUnsafeObjectDataOutput(int size, EnterpriseSerializationService service) {
        super(size, service);
    }

    EnterpriseUnsafeObjectDataOutput(int initialSize, int firstGrowthSize, EnterpriseSerializationService service) {
        super(initialSize, firstGrowthSize, service);
    }

    @Override
    public EnterpriseSerializationService getSerializationService() {
        return (EnterpriseSerializationService)this.service;
    }

    @Override
    public void copyFromMemoryBlock(MemoryBlock memory, int offset, int length) throws IOException {
        this.ensureAvailable(length);
        if (memory.size() < offset + length) {
            throw new IOException("Cannot read " + length + " bytes from " + String.valueOf(memory));
        }
        memory.copyTo(offset, this.buffer, HeapMemoryAccessor.ARRAY_BYTE_BASE_OFFSET + this.pos, length);
        this.pos += length;
    }

    @Override
    public void copyToMemoryBlock(MemoryBlock memory, int offset, int length) throws IOException {
        if (this.pos < length) {
            throw new IOException("Not enough data available!");
        }
        if (memory.size() < offset + length) {
            throw new IOException("Cannot write " + length + " bytes to " + String.valueOf(memory));
        }
        memory.copyFrom(offset, this.buffer, HeapMemoryAccessor.ARRAY_BYTE_BASE_OFFSET, length);
    }

    @Override
    public void writeData(Data data) throws IOException {
        if (data instanceof NativeMemoryData) {
            NativeMemoryData nativeMemoryData = (NativeMemoryData)data;
            int size = nativeMemoryData.totalSize();
            this.writeInt(size);
            if (size > 0) {
                this.copyFromMemoryBlock(nativeMemoryData, 4, data.totalSize());
            }
        } else {
            super.writeData(data);
        }
    }
}

