/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.memory.HeapMemoryAccessor;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.nio.EnterpriseBufferObjectDataInput;
import com.hazelcast.internal.nio.EnterpriseObjectDataInput;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;

public final class EnterpriseSerializationUtil {
    private EnterpriseSerializationUtil() {
    }

    public static Data readDataInternal(EnterpriseObjectDataInput in, DataType type, MemoryAllocator malloc, boolean readToHeapOnOOME) throws IOException {
        if (type == DataType.HEAP) {
            return IOUtil.readData(in);
        }
        if (malloc == null) {
            throw new HazelcastSerializationException("MemoryManager is required!");
        }
        try {
            int size = in.readInt();
            if (size == -1) {
                return null;
            }
            if (size == 0) {
                return new HeapData(null);
            }
            return EnterpriseSerializationUtil.readNativeData(in, malloc, size, readToHeapOnOOME);
        }
        catch (Throwable e) {
            throw SerializationUtil.handleException(e);
        }
    }

    public static Data readNativeData(EnterpriseObjectDataInput in, MemoryAllocator malloc, int size, boolean readToHeapOnOOME) throws IOException {
        try {
            int memSize = size + 4;
            NativeMemoryData data = EnterpriseSerializationUtil.allocateNativeData(in, malloc, memSize, size, !readToHeapOnOOME);
            data.writeInt(0L, size);
            if (in instanceof EnterpriseBufferObjectDataInput) {
                EnterpriseBufferObjectDataInput bufferIn = (EnterpriseBufferObjectDataInput)in;
                bufferIn.copyToMemoryBlock(data, 4, size);
            } else {
                byte[] bytes = new byte[size];
                in.readFully(bytes);
                data.copyFrom(4L, bytes, HeapMemoryAccessor.ARRAY_BYTE_BASE_OFFSET, size);
            }
            return data;
        }
        catch (NativeOutOfMemoryError e) {
            if (readToHeapOnOOME) {
                byte[] bytes = new byte[size];
                in.readFully(bytes);
                return new HeapData(bytes);
            }
            throw e;
        }
    }

    @SuppressFBWarnings(value={"SR_NOT_CHECKED"})
    public static NativeMemoryData allocateNativeData(EnterpriseObjectDataInput in, MemoryAllocator malloc, int memSize, int size, boolean skipBytesOnOome) throws IOException {
        if (malloc == null) {
            throw new HazelcastSerializationException("MemoryManager is required!");
        }
        try {
            long address = malloc.allocate(memSize);
            return new NativeMemoryData(address, memSize);
        }
        catch (NativeOutOfMemoryError e) {
            if (skipBytesOnOome) {
                in.skipBytes(size);
            }
            throw e;
        }
    }
}

