/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nio.ssl;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.nio.ssl.SSLEngineFactorySupport;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ssl.SSLContextFactory;
import com.hazelcast.nio.ssl.SSLEngineFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class SSLEngineFactoryAdaptor
implements SSLEngineFactory {
    private final ILogger logger = Logger.getLogger(SSLEngineFactoryAdaptor.class);
    private final SSLContextFactory sslContextFactory;
    private volatile String[] cipherSuites;
    private volatile String protocol;

    public SSLEngineFactoryAdaptor(SSLContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    @Override
    public SSLEngine create(boolean clientMode, Address peerAddress) {
        SSLContext sslContext = this.sslContextFactory.getSSLContext();
        SSLEngine sslEngine = peerAddress == null ? sslContext.createSSLEngine() : sslContext.createSSLEngine(peerAddress.getHost(), peerAddress.getPort());
        sslEngine.setUseClientMode(clientMode);
        sslEngine.setEnableSessionCreation(true);
        if (this.cipherSuites != null) {
            sslEngine.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.protocol != null) {
            String[] enabledProtocols = this.findEnabledProtocols(this.protocol, sslEngine.getSupportedProtocols());
            if (enabledProtocols.length > 0) {
                sslEngine.setEnabledProtocols(enabledProtocols);
            } else {
                this.logger.warning("Enabling SSL protocol failed. Check if configured value contains a supported value" + Arrays.toString(sslEngine.getSupportedProtocols()));
            }
        }
        return sslEngine;
    }

    @Override
    public void init(Properties properties, boolean forClient) throws Exception {
        this.sslContextFactory.init(properties);
        Object[] configuredCipherSuites = StringUtil.splitByComma(SSLEngineFactorySupport.getProperty(properties, "ciphersuites"), false);
        if (configuredCipherSuites != null) {
            SSLEngine sslEngine = this.sslContextFactory.getSSLContext().createSSLEngine();
            Object[] supportedCipherSuites = sslEngine.getSupportedCipherSuites();
            this.cipherSuites = StringUtil.intersection((String[])configuredCipherSuites, (String[])supportedCipherSuites);
            if (this.cipherSuites.length < 1) {
                throw new InvalidConfigurationException("No configured SSL cipher suite name is valid. Check if configured values " + Arrays.toString(configuredCipherSuites) + " contain supported values: " + Arrays.toString(supportedCipherSuites));
            }
        }
        this.protocol = SSLEngineFactorySupport.getProperty(properties, "protocol");
    }

    private String[] findEnabledProtocols(String configuredName, String[] supportedProtocols) {
        ArrayList<String> enabled = new ArrayList<String>();
        for (String protocol : supportedProtocols) {
            if (!configuredName.equals(protocol) && (!"TLS".equals(configuredName) || !protocol.matches("TLSv1(\\.\\d+)?")) && (!"SSL".equals(configuredName) || !protocol.equals("SSLv3"))) continue;
            enabled.add(protocol);
        }
        return enabled.toArray(new String[enabled.size()]);
    }
}

