/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.nativememory;

import com.hazelcast.internal.hidensity.HiDensityRecord;
import com.hazelcast.internal.hidensity.HiDensityRecordAccessor;
import com.hazelcast.internal.memory.GlobalMemoryAccessorRegistry;
import com.hazelcast.internal.nearcache.NearCacheRecord;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.util.TimeStripUtil;
import java.util.UUID;

public class HDNearCacheRecord
extends HiDensityRecord
implements NearCacheRecord<NativeMemoryData> {
    public static final int SIZE = 61;
    public static final int VALUE_OFFSET = 0;
    static final int UUID_MOST_SIG_BITS_OFFSET = 8;
    static final int UUID_LEAST_SIG_BITS_OFFSET = 16;
    static final int INVALIDATION_SEQUENCE_OFFSET = 24;
    static final int RESERVATION_ID_OFFSET = 32;
    static final int CREATION_TIME_OFFSET = 40;
    static final int LAST_ACCESS_TIME_OFFSET = 44;
    static final int EXPIRATION_TIME_OFFSET = 48;
    static final int HITS_OFFSET = 52;
    static final int PARTITION_ID_OFFSET = 56;
    static final int CACHED_AS_NULL_OFFSET = 60;
    private HiDensityRecordAccessor<HDNearCacheRecord> nearCacheRecordAccessor;

    public HDNearCacheRecord(HiDensityRecordAccessor<HDNearCacheRecord> accessor) {
        super(GlobalMemoryAccessorRegistry.AMEM);
        this.nearCacheRecordAccessor = accessor;
        this.setSize(SIZE);
    }

    @Override
    public long getCreationTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(40L));
    }

    @Override
    public void setCreationTime(long creationTime) {
        this.writeInt(40L, TimeStripUtil.stripBaseTime(creationTime));
    }

    @Override
    public long getLastAccessTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(44L));
    }

    @Override
    public void setLastAccessTime(long lastAccessTime) {
        this.writeInt(44L, TimeStripUtil.stripBaseTime(lastAccessTime));
    }

    @Override
    public long getExpirationTime() {
        return TimeStripUtil.recomputeWithBaseTime(this.readInt(48L));
    }

    @Override
    public void setExpirationTime(long expirationTime) {
        this.writeInt(48L, TimeStripUtil.stripBaseTime(expirationTime));
    }

    @Override
    public long getHits() {
        return this.readInt(52L);
    }

    @Override
    public void setHits(int hit) {
        this.writeInt(52L, hit);
    }

    @Override
    public void incrementHits() {
        long hits = this.getHits() + 1L;
        this.writeInt(52L, hits > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)hits);
    }

    @Override
    public long getValueAddress() {
        return this.readLong(0L);
    }

    @Override
    public void setValueAddress(long valueAddress) {
        this.writeLong(0L, valueAddress);
    }

    @Override
    public HDNearCacheRecord reset(long address) {
        this.setAddress(address);
        this.setSize(SIZE);
        return this;
    }

    @Override
    public void clear() {
        this.zero();
    }

    @Override
    public NativeMemoryData getValue() {
        long valueAddress = this.getValueAddress();
        return valueAddress == 0L ? null : this.nearCacheRecordAccessor.readData(valueAddress);
    }

    @Override
    public void setValue(NativeMemoryData value) {
        if (value != null) {
            this.setValueAddress(value.address());
        } else {
            this.setValueAddress(0L);
        }
    }

    @Override
    public long getSequence() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getReservationId() {
        return this.readLong(32L);
    }

    @Override
    public void setReservationId(long reservationId) {
        this.writeLong(32L, reservationId);
    }

    @Override
    public int getPartitionId() {
        return this.readInt(56L);
    }

    @Override
    public void setPartitionId(int partitionId) {
        this.writeInt(56L, partitionId);
    }

    @Override
    public long getInvalidationSequence() {
        return this.readLong(24L);
    }

    @Override
    public void setInvalidationSequence(long sequence) {
        this.writeLong(24L, sequence);
    }

    @Override
    public void setUuid(UUID uuid) {
        this.writeLong(8L, uuid == null ? 0L : uuid.getMostSignificantBits());
        this.writeLong(16L, uuid == null ? 0L : uuid.getLeastSignificantBits());
    }

    @Override
    public boolean hasSameUuid(UUID uuid) {
        return uuid != null && this.readLong(8L) == uuid.getMostSignificantBits() && this.readLong(16L) == uuid.getLeastSignificantBits();
    }

    @Override
    public boolean isCachedAsNull() {
        return this.readByte(60L) == 1;
    }

    @Override
    public void setCachedAsNull(boolean valueCachedAsNull) {
        this.writeByte(60L, (byte)(valueCachedAsNull ? 1 : 0));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HDNearCacheRecord record = (HDNearCacheRecord)o;
        return this.address == record.address && this.size == record.size;
    }

    @Override
    public int hashCode() {
        int result = (int)(this.address ^ this.address >>> 32);
        result = 31 * result + this.size;
        return result;
    }

    @Override
    public String toString() {
        return this.address() == 0L ? "HDNearCacheRecord{NULL}" : "HDNearCacheRecord{creationTime=" + this.getCreationTime() + ", invalidationSequence=" + this.getInvalidationSequence() + ", expirationTime=" + this.getExpirationTime() + ", lastAccessTime=" + this.getLastAccessTime() + ", hits=" + this.getHits() + ", reservationId=" + this.getReservationId() + ", partitionId=" + this.getPartitionId() + ", valueAddress=" + this.getValueAddress();
    }
}

