/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.monitor.impl.IndexOperationStats;
import com.hazelcast.internal.monitor.impl.PartitionIndexChangeEvent;
import com.hazelcast.internal.monitor.impl.PartitionIndexOperationStats;
import com.hazelcast.internal.monitor.impl.PerIndexStats;
import com.hazelcast.internal.tpcengine.util.ReflectionUtil;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.Timer;
import com.hazelcast.query.impl.Index;
import java.lang.invoke.VarHandle;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class PartitionPerIndexStats
implements PerIndexStats {
    private static final VarHandle ENTRY_COUNT = ReflectionUtil.findVarHandle("entryCount", Long.TYPE);
    private static final VarHandle QUERY_COUNT = ReflectionUtil.findVarHandle("queryCount", Long.TYPE);
    private static final VarHandle HIT_COUNT = ReflectionUtil.findVarHandle("hitCount", Long.TYPE);
    private static final VarHandle TOTAL_HIT_LATENCY = ReflectionUtil.findVarHandle("totalHitLatency", Long.TYPE);
    private static final VarHandle TOTAL_NORMALIZED_HIT_CARDINALITY = ReflectionUtil.findVarHandle("totalNormalizedHitCardinality", Long.TYPE);
    private static final VarHandle INSERT_COUNT = ReflectionUtil.findVarHandle("insertCount", Long.TYPE);
    private static final VarHandle TOTAL_INSERT_LATENCY = ReflectionUtil.findVarHandle("totalInsertLatency", Long.TYPE);
    private static final VarHandle UPDATE_COUNT = ReflectionUtil.findVarHandle("updateCount", Long.TYPE);
    private static final VarHandle TOTAL_UPDATE_LATENCY = ReflectionUtil.findVarHandle("totalUpdateLatency", Long.TYPE);
    private static final VarHandle REMOVE_COUNT = ReflectionUtil.findVarHandle("removeCount", Long.TYPE);
    private static final VarHandle TOTAL_REMOVE_LATENCY = ReflectionUtil.findVarHandle("totalRemoveLatency", Long.TYPE);
    private static final VarHandle MEMORY_COST = ReflectionUtil.findVarHandle("memoryCost", Long.TYPE);
    private static final AtomicLongFieldUpdater<PartitionPerIndexStats> INDEX_NOT_READY_QUERY_COUNT = AtomicLongFieldUpdater.newUpdater(PartitionPerIndexStats.class, "indexNotReadyQueryCount");
    private final PartitionIndexOperationStats operationStats = new PartitionIndexOperationStats();
    private final long creationTime;
    private volatile long entryCount;
    private volatile long queryCount;
    private volatile long hitCount;
    private volatile long totalHitLatency;
    private volatile long totalNormalizedHitCardinality = Double.doubleToRawLongBits(0.0);
    private volatile long insertCount;
    private volatile long totalInsertLatency;
    private volatile long updateCount;
    private volatile long totalUpdateLatency;
    private volatile long removeCount;
    private volatile long totalRemoveLatency;
    private volatile long memoryCost;
    private volatile long partitionsIndexed;
    private volatile long indexNotReadyQueryCount;
    private boolean hasQueries;

    public PartitionPerIndexStats() {
        this.creationTime = Clock.currentTimeMillis();
    }

    @Override
    public void updateMemoryCost(long delta) {
        MEMORY_COST.setOpaque(this, this.memoryCost + delta);
    }

    @Override
    public void onDispose() {
        MEMORY_COST.setOpaque(this, 0);
    }

    @Override
    public long makeTimestamp() {
        return Timer.nanos();
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getQueryCount() {
        return this.queryCount;
    }

    @Override
    public void incrementQueryCount() {
        if (this.hasQueries) {
            QUERY_COUNT.setOpaque(this, this.queryCount + 1L);
        }
    }

    @Override
    public long getHitCount() {
        return this.hitCount;
    }

    @Override
    public long getTotalHitLatency() {
        return this.totalHitLatency;
    }

    @Override
    public double getTotalNormalizedHitCardinality() {
        return Double.longBitsToDouble(this.totalNormalizedHitCardinality);
    }

    @Override
    public long getInsertCount() {
        return this.insertCount;
    }

    @Override
    public long getTotalInsertLatency() {
        return this.totalInsertLatency;
    }

    @Override
    public long getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public long getTotalUpdateLatency() {
        return this.totalUpdateLatency;
    }

    @Override
    public long getRemoveCount() {
        return this.removeCount;
    }

    @Override
    public long getTotalRemoveLatency() {
        return this.totalRemoveLatency;
    }

    @Override
    public long getMemoryCost() {
        return this.memoryCost;
    }

    @Override
    public void onInsert(long startNanos, IndexOperationStats operationStats, Index.OperationSource operationSource) {
        if (operationStats.getEntryCountDelta() == 0L) {
            return;
        }
        if (operationSource == Index.OperationSource.USER) {
            TOTAL_INSERT_LATENCY.setOpaque(this, this.totalInsertLatency + Timer.nanosElapsed(startNanos));
            INSERT_COUNT.setOpaque(this, this.insertCount + 1L);
        }
        ENTRY_COUNT.setOpaque(this, this.entryCount + 1L);
    }

    @Override
    public void onUpdate(long startNanos, IndexOperationStats operationStats, Index.OperationSource operationSource) {
        if (operationSource == Index.OperationSource.USER) {
            TOTAL_UPDATE_LATENCY.setOpaque(this, this.totalUpdateLatency + Timer.nanosElapsed(startNanos));
            UPDATE_COUNT.setOpaque(this, this.updateCount + 1L);
        }
        ENTRY_COUNT.setOpaque(this, this.entryCount + operationStats.getEntryCountDelta());
    }

    @Override
    public void onRemove(long startNanos, IndexOperationStats operationStats, Index.OperationSource operationSource) {
        if (operationStats.getEntryCountDelta() == 0L) {
            return;
        }
        if (operationSource == Index.OperationSource.USER) {
            TOTAL_REMOVE_LATENCY.setOpaque(this, this.totalRemoveLatency + Timer.nanosElapsed(startNanos));
            REMOVE_COUNT.setOpaque(this, this.removeCount + 1L);
        }
        ENTRY_COUNT.setOpaque(this, this.entryCount - 1L);
    }

    @Override
    public void onClear() {
        ENTRY_COUNT.setOpaque(this, 0);
        this.partitionsIndexed = 0L;
    }

    @Override
    public void onIndexHit(long startNanos, long hitCardinality) {
        this.hasQueries = true;
        long localEntryCount = this.entryCount;
        if (localEntryCount == 0L) {
            return;
        }
        TOTAL_HIT_LATENCY.setOpaque(this, this.totalHitLatency + Timer.nanosElapsed(startNanos));
        HIT_COUNT.setOpaque(this, this.hitCount + 1L);
        long adjustedHitCardinality = Math.min(hitCardinality, localEntryCount);
        double normalizedHitCardinality = (double)adjustedHitCardinality / (double)localEntryCount;
        double decodedTotalNormalizedHitCardinality = Double.longBitsToDouble(this.totalNormalizedHitCardinality);
        double newTotalNormalizedHitCardinality = decodedTotalNormalizedHitCardinality + normalizedHitCardinality;
        long newEncodedTotalNormalizedHitCardinality = Double.doubleToRawLongBits(newTotalNormalizedHitCardinality);
        TOTAL_NORMALIZED_HIT_CARDINALITY.setOpaque(this, newEncodedTotalNormalizedHitCardinality);
    }

    @Override
    public void resetPerQueryStats() {
        this.hasQueries = false;
    }

    @Override
    public MemoryAllocator wrapMemoryAllocator(MemoryAllocator memoryAllocator) {
        return new MemoryAllocatorWithStats(memoryAllocator);
    }

    @Override
    public IndexOperationStats createOperationStats() {
        this.operationStats.reset();
        return this.operationStats;
    }

    @Override
    public long getPartitionsIndexed() {
        return this.partitionsIndexed;
    }

    @Override
    public long getPartitionUpdatesStarted() {
        return 0L;
    }

    @Override
    public long getPartitionUpdatesFinished() {
        return 0L;
    }

    @Override
    public void onPartitionChange(PartitionIndexChangeEvent changeEvent) {
        long indexed = switch (changeEvent) {
            default -> throw new IncompatibleClassChangeError();
            case PartitionIndexChangeEvent.INDEXED -> this.partitionsIndexed = 1L;
            case PartitionIndexChangeEvent.UNINDEXED -> this.partitionsIndexed = 0L;
            case PartitionIndexChangeEvent.CHANGE_STARTED, PartitionIndexChangeEvent.CHANGE_FINISHED -> this.partitionsIndexed;
        };
    }

    @Override
    public long getIndexNotReadyQueryCount() {
        return this.indexNotReadyQueryCount;
    }

    @Override
    public void incrementIndexNotReadyQueryCount() {
        INDEX_NOT_READY_QUERY_COUNT.incrementAndGet(this);
    }

    private class MemoryAllocatorWithStats
    implements MemoryAllocator {
        private final MemoryAllocator delegate;

        MemoryAllocatorWithStats(MemoryAllocator delegate) {
            this.delegate = delegate;
        }

        @Override
        public long allocate(long size) {
            long result = this.delegate.allocate(size);
            PartitionPerIndexStats.this.updateMemoryCost(size);
            return result;
        }

        @Override
        public long reallocate(long address, long currentSize, long newSize) {
            long result = this.delegate.reallocate(address, currentSize, newSize);
            PartitionPerIndexStats.this.updateMemoryCost(newSize - currentSize);
            return result;
        }

        @Override
        public void free(long address, long size) {
            this.delegate.free(address, size);
            PartitionPerIndexStats.this.updateMemoryCost(-size);
        }

        @Override
        public void dispose() {
            this.delegate.dispose();
            PartitionPerIndexStats.this.onDispose();
        }
    }
}

