/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.internal.monitor.impl.GlobalPerIndexStats;
import com.hazelcast.internal.monitor.impl.IndexesStats;
import com.hazelcast.internal.monitor.impl.PerIndexStats;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class GlobalIndexesStats
implements IndexesStats {
    private static final AtomicLongFieldUpdater<GlobalIndexesStats> QUERY_COUNT = AtomicLongFieldUpdater.newUpdater(GlobalIndexesStats.class, "queryCount");
    private static final AtomicLongFieldUpdater<GlobalIndexesStats> INDEXED_QUERY_COUNT = AtomicLongFieldUpdater.newUpdater(GlobalIndexesStats.class, "indexedQueryCount");
    private static final AtomicLongFieldUpdater<GlobalIndexesStats> INDEXES_SKIPPED_QUERY_COUNT = AtomicLongFieldUpdater.newUpdater(GlobalIndexesStats.class, "indexesSkippedQueryCount");
    private static final AtomicLongFieldUpdater<GlobalIndexesStats> NO_MATCHING_INDEX_QUERY_COUNT = AtomicLongFieldUpdater.newUpdater(GlobalIndexesStats.class, "noMatchingIndexQueryCount");
    private volatile long queryCount;
    private volatile long indexedQueryCount;
    private volatile long indexesSkippedQueryCount;
    private volatile long noMatchingIndexQueryCount;

    @Override
    public long getQueryCount() {
        return this.queryCount;
    }

    @Override
    public void incrementQueryCount() {
        QUERY_COUNT.incrementAndGet(this);
    }

    @Override
    public long getIndexedQueryCount() {
        return this.indexedQueryCount;
    }

    @Override
    public void incrementIndexedQueryCount() {
        INDEXED_QUERY_COUNT.incrementAndGet(this);
    }

    @Override
    public long getIndexesSkippedQueryCount() {
        return this.indexesSkippedQueryCount;
    }

    @Override
    public void incrementIndexesSkippedQueryCount() {
        INDEXES_SKIPPED_QUERY_COUNT.incrementAndGet(this);
    }

    @Override
    public long getNoMatchingIndexQueryCount() {
        return this.noMatchingIndexQueryCount;
    }

    @Override
    public void incrementNoMatchingIndexQueryCount() {
        NO_MATCHING_INDEX_QUERY_COUNT.incrementAndGet(this);
    }

    @Override
    public PerIndexStats createPerIndexStats(boolean ordered, boolean usesCachedQueryableEntries) {
        return new GlobalPerIndexStats(ordered, usesCachedQueryableEntries);
    }
}

