/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.memory.impl;

import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.PersistentMemoryConfig;
import com.hazelcast.config.PersistentMemoryMode;
import com.hazelcast.internal.memory.impl.AbstractMemkindMalloc;
import com.hazelcast.internal.memory.impl.MemkindHeap;
import com.hazelcast.internal.memory.impl.MemkindKind;
import com.hazelcast.internal.memory.impl.MemkindUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;

public final class MemkindMalloc
extends AbstractMemkindMalloc {
    private static final ILogger LOGGER = Logger.getLogger(MemkindMalloc.class);

    private MemkindMalloc(MemkindHeap memkindHeap) {
        super(memkindHeap);
    }

    static MemkindMalloc create(NativeMemoryConfig config, long size) {
        boolean systemMemMode;
        PersistentMemoryConfig pmemConfig = config.getPersistentMemoryConfig();
        boolean bl = systemMemMode = pmemConfig.getMode() == PersistentMemoryMode.SYSTEM_MEMORY;
        assert (systemMemMode && pmemConfig.isEnabled() || MemkindUtil.useMemkind());
        MemkindKind kind = MemkindUtil.configuredKindForMemkindMalloc(pmemConfig);
        LOGGER.info("Using Memkind memory allocator with " + kind.name() + " kind");
        MemkindHeap heap = MemkindHeap.createHeap(kind, size);
        return new MemkindMalloc(heap);
    }
}

