/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc.chunk;

import com.hazelcast.internal.hotrestart.impl.gc.chunk.Chunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.GrowingChunk;
import com.hazelcast.internal.hotrestart.impl.gc.record.RecordMap;
import java.util.Comparator;

public abstract class StableChunk
extends Chunk {
    public static final Comparator<StableChunk> BY_BENEFIT_COST_DESC = (left, right) -> {
        double leftCb = left.cachedBenefitToCost();
        double rightCb = right.cachedBenefitToCost();
        return Double.compare(rightCb, leftCb);
    };
    double benefitToCost;
    private final long size;

    StableChunk(GrowingChunk from) {
        super(from);
        this.size = from.size();
        this.needsDismissing(from.needsDismissing());
    }

    StableChunk(long seq, RecordMap records, int liveRecordCount, long size, long garbage, boolean needsDismissing) {
        super(seq, records, liveRecordCount, garbage);
        this.size = size;
        this.needsDismissing(needsDismissing);
    }

    @Override
    public final long size() {
        return this.size;
    }

    public final double cachedBenefitToCost() {
        return this.benefitToCost;
    }
}

