/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.impl.gc;

import com.hazelcast.internal.hotrestart.impl.gc.MutatorCatchup;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.Chunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableChunk;
import com.hazelcast.internal.hotrestart.impl.gc.chunk.StableTombChunk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

final class TombChunkSelector {
    private final MutatorCatchup mc;

    private TombChunkSelector(MutatorCatchup mc) {
        this.mc = mc;
    }

    static Collection<StableTombChunk> selectTombChunksToCollect(Collection<? extends StableChunk> allChunks, MutatorCatchup mc) {
        return new TombChunkSelector(mc).select(allChunks);
    }

    private Collection<StableTombChunk> select(Collection<? extends StableChunk> allChunks) {
        List<StableTombChunk> candidates = this.candidateChunks(allChunks);
        this.sortCandidates(candidates);
        return this.selectChunksForCollection(candidates);
    }

    private List<StableTombChunk> candidateChunks(Collection<? extends StableChunk> allChunks) {
        ArrayList<StableTombChunk> candidates = new ArrayList<StableTombChunk>();
        for (StableChunk stableChunk : allChunks) {
            StableTombChunk stableTombChunk;
            if (!(stableChunk instanceof StableTombChunk) || (stableTombChunk = (StableTombChunk)stableChunk).size() != 0L && stableTombChunk.garbage <= 0L) continue;
            stableTombChunk.updateBenefitToCost();
            candidates.add(stableTombChunk);
        }
        this.mc.catchupNow();
        return candidates;
    }

    private void sortCandidates(List<StableTombChunk> candidates) {
        Collections.sort(candidates, StableChunk.BY_BENEFIT_COST_DESC);
        this.mc.catchupNow();
    }

    private Collection<StableTombChunk> selectChunksForCollection(List<StableTombChunk> candidates) {
        StableTombChunk c;
        double b2c;
        ArrayList<StableTombChunk> selected = new ArrayList<StableTombChunk>();
        long minSize = Chunk.tombChunkSizeLimit() / 2;
        long size = 0L;
        long garbage = 0L;
        Iterator<StableTombChunk> iterator = candidates.iterator();
        while (iterator.hasNext() && (!((b2c = StableTombChunk.benefitToCost(garbage + c.garbage, size + (c = iterator.next()).size())) < 2.0) || size <= minSize)) {
            if (b2c < 1.0) {
                selected.clear();
                break;
            }
            selected.add(c);
            size += c.size();
            garbage += c.garbage;
        }
        return selected;
    }
}

