/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.hotrestart.cluster;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.HotRestartClusterDataRecoveryPolicy;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.hotrestart.HotRestartException;
import com.hazelcast.instance.impl.ClusterTopologyIntent;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.ClusterStateManagerAccessor;
import com.hazelcast.internal.hotrestart.ForceStartException;
import com.hazelcast.internal.hotrestart.cluster.AskForClusterStartResultOperation;
import com.hazelcast.internal.hotrestart.cluster.AskForExpectedMembersOperation;
import com.hazelcast.internal.hotrestart.cluster.ClusterHotRestartEventListener;
import com.hazelcast.internal.hotrestart.cluster.ClusterMetadataWriterLoop;
import com.hazelcast.internal.hotrestart.cluster.ClusterStateReader;
import com.hazelcast.internal.hotrestart.cluster.ClusterVersionReader;
import com.hazelcast.internal.hotrestart.cluster.CompactSchemaPersistenceManager;
import com.hazelcast.internal.hotrestart.cluster.CompactSchemaReader;
import com.hazelcast.internal.hotrestart.cluster.GetClusterStateOperation;
import com.hazelcast.internal.hotrestart.cluster.HotRestartClusterStartStatus;
import com.hazelcast.internal.hotrestart.cluster.LocalMemberReader;
import com.hazelcast.internal.hotrestart.cluster.MemberClusterStartInfo;
import com.hazelcast.internal.hotrestart.cluster.MemberListReader;
import com.hazelcast.internal.hotrestart.cluster.PartitionTableReader;
import com.hazelcast.internal.hotrestart.cluster.SendClusterStartResultOperation;
import com.hazelcast.internal.hotrestart.cluster.SendExpectedMembersOperation;
import com.hazelcast.internal.hotrestart.cluster.SendMemberClusterStartInfoOperation;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.partition.PartitionReplica;
import com.hazelcast.internal.partition.PartitionRuntimeState;
import com.hazelcast.internal.partition.PartitionTableView;
import com.hazelcast.internal.partition.ReadonlyInternalPartition;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.collection.Long2ObjectHashMap;
import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.executionservice.ExecutionService;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.version.Version;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

public class ClusterMetadataManager {
    private static final String DIR_NAME = "cluster";
    private static final long EXCLUDED_MEMBERS_LEAVE_WAIT_IN_MILLIS = TimeUnit.MINUTES.toMillis(2L);
    private static final long MEMBERS_STATE_WAIT_IN_NANOS = TimeUnit.MINUTES.toNanos(1L);
    private static final long MEMBERS_STATE_BACKOFF_MIN_PARK = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final long MEMBERS_STATE_BACKOFF_MAX_PARK = TimeUnit.MILLISECONDS.toNanos(1000L);
    final Node node;
    private final File homeDir;
    private final ILogger logger;
    private final long validationTimeout;
    private final long dataLoadTimeout;
    private final AtomicReference<PartitionTableView> partitionTableRef = new AtomicReference();
    private final HotRestartClusterDataRecoveryPolicy clusterDataRecoveryPolicy;
    private final ReentrantLock hotRestartStatusLock = new ReentrantLock();
    private final ConcurrentMap<UUID, MemberClusterStartInfo> memberClusterStartInfos = new ConcurrentHashMap<UUID, MemberClusterStartInfo>();
    private final AtomicReference<Collection<MemberImpl>> restoredMembersRef = new AtomicReference();
    private final AtomicReference<Map<UUID, Address>> expectedMembersRef = new AtomicReference();
    private final List<ClusterHotRestartEventListener> hotRestartEventListeners = new CopyOnWriteArrayList<ClusterHotRestartEventListener>();
    private final CompactSchemaPersistenceManager compactSchemaPersistenceManager;
    private final Set<UUID> crashedMemberUuids = ConcurrentHashMap.newKeySet();
    private final Set<UUID> unsafeMemberUuids = ConcurrentHashMap.newKeySet();
    private Thread pingThread;
    private volatile ClusterMetadataWriterLoop metadataWriterLoop;
    private volatile boolean startWithHotRestart = true;
    private volatile HotRestartClusterStartStatus hotRestartStatus = HotRestartClusterStartStatus.CLUSTER_START_IN_PROGRESS;
    private volatile boolean startCompleted;
    private volatile Set<UUID> excludedMemberUuids = Collections.emptySet();
    private volatile ClusterState clusterState = ClusterState.ACTIVE;
    private volatile long validationStartTime;
    private volatile long dataLoadStartTime;
    private volatile boolean rejoiningClusterInActiveState;
    private volatile ClusterTopologyIntent clusterTopologyIntentOnMaster;
    private volatile boolean memberListDirty;

    public ClusterMetadataManager(Node node, File hotRestartHome, HotRestartPersistenceConfig config) {
        this.node = node;
        this.logger = node.getLogger(this.getClass());
        this.homeDir = new File(hotRestartHome, DIR_NAME);
        this.validationTimeout = TimeUnit.SECONDS.toMillis(config.getValidationTimeoutSeconds());
        this.dataLoadTimeout = TimeUnit.SECONDS.toMillis(config.getDataLoadTimeoutSeconds());
        this.clusterDataRecoveryPolicy = config.getClusterDataRecoveryPolicy();
        this.metadataWriterLoop = new ClusterMetadataWriterLoop(this.homeDir, node::getLocalMember, node.hazelcastInstance.getName(), node::getLogger);
        this.compactSchemaPersistenceManager = new CompactSchemaPersistenceManager(node, this);
    }

    public void prepare() {
        try {
            this.clusterState = ClusterStateReader.readClusterState(this.homeDir);
            Version clusterVersion = ClusterVersionReader.readClusterVersion(this.homeDir);
            if (!clusterVersion.isUnknown()) {
                this.logger.info("Restored cluster version: " + String.valueOf(clusterVersion) + ", cluster state: " + String.valueOf((Object)this.clusterState));
                if (!this.node.getNodeExtension().isNodeVersionCompatibleWith(clusterVersion)) {
                    throw new HotRestartException("Member cannot start: codebase version " + String.valueOf(this.node.getVersion()) + " is not compatible with persisted cluster version " + String.valueOf(clusterVersion));
                }
                ClusterStateManagerAccessor.setClusterVersion(this.node.getClusterService(), clusterVersion);
            }
            this.restoreCompactSchemas();
            Collection<MemberImpl> members = this.restoreMemberList();
            PartitionTableView table = this.restorePartitionTable();
            if (this.startWithHotRestart) {
                this.node.getLocalMember().setAttribute("hazelcast.persistence.enabled", "true");
                ClusterServiceImpl clusterService = this.node.getClusterService();
                ClusterTopologyIntent clusterTopologyIntent = this.node.getClusterTopologyIntent();
                if (clusterTopologyIntent == ClusterTopologyIntent.CLUSTER_START || clusterTopologyIntent == ClusterTopologyIntent.NOT_IN_MANAGED_CONTEXT) {
                    this.logger.info("Cluster-wide start will be performed in transient PASSIVE cluster state.");
                    ClusterStateManagerAccessor.setClusterState(clusterService, ClusterState.PASSIVE, true);
                } else {
                    this.logger.info("Member start will be performed in PASSIVE node state.");
                    this.node.forceNodeStateToPassive();
                }
                ArrayList<MemberImpl> membersRemovedInNotActiveState = new ArrayList<MemberImpl>(members);
                membersRemovedInNotActiveState.remove(clusterService.getLocalMember());
                ClusterStateManagerAccessor.setMissingMembers(clusterService, membersRemovedInNotActiveState);
            }
            for (ClusterHotRestartEventListener listener : this.hotRestartEventListeners) {
                listener.onPrepareComplete(members, table, this.startWithHotRestart);
            }
            this.metadataWriterLoop.start();
        }
        catch (IOException e) {
            throw new HotRestartException(e);
        }
    }

    public boolean isStartWithHotRestart() {
        return this.startWithHotRestart;
    }

    public void addClusterHotRestartEventListener(ClusterHotRestartEventListener listener) {
        this.hotRestartEventListeners.add(listener);
    }

    public Set<UUID> getExcludedMemberUuids() {
        return this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED ? this.excludedMemberUuids : Collections.emptySet();
    }

    public CompactSchemaPersistenceManager getCompactSchemaPersistenceManager() {
        return this.compactSchemaPersistenceManager;
    }

    public void start() {
        if (this.clusterTopologyIntentOnMaster == ClusterTopologyIntent.CLUSTER_START && this.node.getClusterService().getClusterState() != ClusterState.PASSIVE) {
            ClusterStateManagerAccessor.setClusterState(this.node.getClusterService(), ClusterState.PASSIVE, true);
        }
        try {
            this.validate();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HotRestartException("Cluster metadata manager interrupted during startup");
        }
        this.setInitialPartitionTable();
        this.logger.info("Starting hot restart local data load.");
        for (ClusterHotRestartEventListener listener : this.hotRestartEventListeners) {
            listener.onDataLoadStart(this.node.getLocalMember());
        }
        this.dataLoadStartTime = Clock.currentTimeMillis();
        this.pingThread = new Thread(ThreadUtil.createThreadName(this.node.hazelcastInstance.getName(), "cluster-start-ping-thread")){

            @Override
            public void run() {
                while (ClusterMetadataManager.this.ping()) {
                    try {
                        ClusterMetadataManager.this.logger.fine("Cluster start ping...");
                        1.sleep(TimeUnit.SECONDS.toMillis(1L));
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        };
        this.pingThread.start();
    }

    private void validate() throws InterruptedException {
        this.validationStartTime = Clock.currentTimeMillis();
        if (this.completeValidationIfNoHotRestartData()) {
            return;
        }
        this.logger.info("Starting cluster member-list & partition table validation.");
        if (this.startWithHotRestart) {
            this.awaitUntilExpectedMembersJoin();
            this.logger.info("Expected members set after members join: " + String.valueOf(this.expectedMembersRef.get()));
            Map<Address, Address> addressMapping = this.getMemberAddressChangesMapping();
            this.logAddressChanges(addressMapping);
            this.repairRestoredMembers(addressMapping);
            this.repairPartitionTable();
        }
        this.callAfterExpectedMembersJoinListener();
        MemberClusterStartInfo clusterStartInfo = new MemberClusterStartInfo(this.partitionTableRef.get(), MemberClusterStartInfo.DataLoadStatus.LOAD_IN_PROGRESS);
        this.validateLocalClusterStartInfo(clusterStartInfo);
        if (this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_FAILED) {
            throw new HotRestartException("Cluster-wide start failed!");
        }
    }

    private void callAfterExpectedMembersJoinListener() {
        if (this.hotRestartEventListeners.isEmpty()) {
            return;
        }
        Collection<MemberImpl> members = new ArrayList();
        Map<UUID, Address> expectedMembers = this.expectedMembersRef.get();
        if (expectedMembers != null) {
            for (MemberImpl member : this.restoredMembersRef.get()) {
                if (!expectedMembers.containsKey(member.getUuid())) continue;
                members.add(member);
            }
        }
        members = Collections.unmodifiableCollection(members);
        for (ClusterHotRestartEventListener listener : this.hotRestartEventListeners) {
            listener.afterExpectedMembersJoin(members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ping() {
        this.hotRestartStatusLock.lock();
        try {
            long deadline = this.dataLoadStartTime + this.dataLoadTimeout;
            if (this.hotRestartStatus != HotRestartClusterStartStatus.CLUSTER_START_IN_PROGRESS || deadline <= Clock.currentTimeMillis()) {
                this.logger.fine("Completing cluster start ping...");
                boolean bl = false;
                return bl;
            }
            if (this.node.isMaster()) {
                this.askForClusterStartResult();
            } else {
                this.sendLocalMemberClusterStartInfoToMaster();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.hotRestartStatusLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCompletedLocal(@Nullable PartitionRuntimeState deferredPartitionRuntimeState, @Nullable Throwable failure) throws InterruptedException {
        boolean success;
        boolean bl = success = failure == null;
        if (success) {
            this.logger.info("Local Hot Restart procedure completed with success.");
        } else {
            this.logger.warning("Local Hot Restart procedure completed with failure.", failure);
        }
        this.hotRestartStatusLock.lock();
        try {
            if (this.startWithHotRestart) {
                if (this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_IN_PROGRESS) {
                    MemberClusterStartInfo current = (MemberClusterStartInfo)this.memberClusterStartInfos.get(this.node.getThisUuid());
                    MemberClusterStartInfo.DataLoadStatus dataLoadStatus = success ? MemberClusterStartInfo.DataLoadStatus.LOAD_SUCCESSFUL : MemberClusterStartInfo.DataLoadStatus.LOAD_FAILED;
                    PartitionTableView partitionTable = current.getPartitionTable();
                    MemberClusterStartInfo newMemberClusterStartInfo = new MemberClusterStartInfo(partitionTable, dataLoadStatus);
                    this.validateLocalClusterStartInfo(newMemberClusterStartInfo);
                }
            } else {
                this.logger.info("Shortcutting cluster start to success as there is no hot restart data on disk.");
                this.hotRestartStatus = HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED;
            }
        }
        finally {
            this.hotRestartStatusLock.unlock();
        }
        try {
            this.waitForDataLoadTimeoutOrFinalClusterStartStatus();
            if (this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED) {
                this.persistPartitions();
                if (deferredPartitionRuntimeState != null) {
                    this.logger.info("Applying deferred partition runtime state");
                    this.node.partitionService.applyPartitionRuntimeState(deferredPartitionRuntimeState);
                }
            }
            this.processFinalClusterStartStatus(failure);
            this.persistMembers();
            this.waitUntilAllMembersReachFinalState();
            this.startCompleted = true;
            this.restoredMembersRef.set(null);
            this.expectedMembersRef.set(null);
            this.partitionTableRef.set(null);
            this.memberClusterStartInfos.clear();
        }
        finally {
            try {
                this.pingThread.join();
            }
            catch (InterruptedException e) {
                this.logger.severe("Interrupted while joining to ping thread");
                Thread.currentThread().interrupt();
            }
        }
    }

    private void processFinalClusterStartStatus(Throwable failure) throws InterruptedException {
        if (this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED) {
            if (this.excludedMemberUuids.contains(this.node.getThisUuid())) {
                this.invokeListenersOnCompletion();
                throw new ForceStartException();
            }
        } else {
            this.invokeListenersOnCompletion();
            throw new HotRestartException("Cluster-wide start failed!", failure);
        }
        this.awaitUntilExcludedMembersLeave();
        this.invokeListenersOnCompletion();
    }

    private void invokeListenersOnCompletion() {
        for (ClusterHotRestartEventListener listener : this.hotRestartEventListeners) {
            listener.onHotRestartDataLoadComplete(this.hotRestartStatus, this.excludedMemberUuids);
        }
    }

    public void forceStartCompleted() {
        if (this.hotRestartStatus != HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED || this.excludedMemberUuids.contains(this.node.getThisUuid())) {
            throw new IllegalStateException("Cannot complete force start with " + String.valueOf((Object)this.hotRestartStatus) + " and excluded member UUIDs: " + String.valueOf(this.excludedMemberUuids));
        }
        this.logger.info("Force start completed.");
        this.startCompleted = true;
        if (this.memberListDirty) {
            this.logger.fine("Members list marked dirty, persisting members list...");
            this.persistMembers();
            this.memberListDirty = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitUntilExcludedMembersLeave() throws InterruptedException {
        HotRestartClusterStartStatus hotRestartStatus = this.hotRestartStatus;
        if (hotRestartStatus != HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED) {
            throw new IllegalStateException("Cannot wait for excluded UUIDs to leave because in " + String.valueOf((Object)hotRestartStatus) + " status");
        }
        long deadline = Clock.currentTimeMillis() + EXCLUDED_MEMBERS_LEAVE_WAIT_IN_MILLIS;
        while (this.isExcludedMemberPresentInCluster()) {
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            if (this.logger.isFineEnabled()) {
                long remaining = this.getRemainingDataLoadTimeMillis();
                this.logger.fine("Waiting for result... Remaining time: %s ms.", remaining);
            }
            if (Clock.currentTimeMillis() <= deadline) continue;
            throw new HotRestartException("Excluded members have not left the cluster before timeout!");
        }
        this.hotRestartStatusLock.lock();
        try {
            this.setFinalClusterState(this.clusterState);
        }
        finally {
            this.hotRestartStatusLock.unlock();
        }
        this.notifyClusterServiceForExcludedMembers();
        this.logger.info("Completed hot restart with final cluster state: " + String.valueOf((Object)this.clusterState));
    }

    private boolean isExcludedMemberPresentInCluster() {
        for (UUID uuid : this.excludedMemberUuids) {
            if (this.node.getClusterService().getMember(uuid) == null) continue;
            return true;
        }
        return false;
    }

    private void notifyClusterServiceForExcludedMembers() {
        for (MemberImpl member : this.restoredMembersRef.get()) {
            if (!this.excludedMemberUuids.contains(member.getUuid())) continue;
            this.node.getClusterService().notifyForRemovedMember(member);
        }
    }

    public boolean isStartCompleted() {
        return this.startCompleted;
    }

    public void onMembershipChange() {
        ClusterServiceImpl clusterService = this.node.getClusterService();
        boolean bl = this.memberListDirty = !this.startCompleted || !clusterService.isJoined();
        if (this.memberListDirty) {
            this.logger.fine("Members list is dirty, not persisting. [startCompleted: %s, isJoined: %s]", this.startCompleted, clusterService.isJoined());
            if (this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_IN_PROGRESS) {
                ExecutionService executionService = this.node.getNodeEngine().getExecutionService();
                executionService.execute("hz:system", new ClearMemberClusterStartInfoTask());
            }
        } else {
            this.persistMembers();
        }
    }

    public void onPartitionStateChange() {
        if (!this.node.getClusterService().isJoined()) {
            this.logger.finest("Skipping partition table change event, %s", "because node is shutting down and latest state will be persisted during shutdown.");
            return;
        }
        this.persistPartitions();
    }

    public void onClusterStateChange(ClusterState newState) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Will persist cluster state: %s", (Object)newState);
        }
        this.metadataWriterLoop.writeClusterState(newState);
    }

    public HotRestartClusterStartStatus getHotRestartStatus() {
        return this.hotRestartStatus;
    }

    public void onClusterVersionChange(Version newClusterVersion) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Will persist cluster version: %s", newClusterVersion);
        }
        this.metadataWriterLoop.writeClusterVersion(newClusterVersion);
        this.persistPartitions();
    }

    public void writeCompactSchemas(Collection<Schema> schemas, InternalCompletableFuture<Void> future) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Will persist schemas: %s", schemas);
        }
        this.metadataWriterLoop.writeCompactSchemas(schemas, future);
    }

    File getHomeDir() {
        return this.homeDir;
    }

    public boolean handleForceStartRequest() {
        if (!this.node.isMaster()) {
            this.logger.warning("Force start attempt received but this node is not master!");
            return false;
        }
        this.hotRestartStatusLock.lock();
        try {
            if (this.hotRestartStatus != HotRestartClusterStartStatus.CLUSTER_START_IN_PROGRESS) {
                this.logger.warning("Cannot trigger force start since cluster start status is " + String.valueOf((Object)this.hotRestartStatus));
                boolean bl = false;
                return bl;
            }
            this.excludedMemberUuids = this.getRestoredMemberUuids();
            this.unsafeMemberUuids.clear();
            this.crashedMemberUuids.clear();
            this.node.getClusterService().shrinkMissingMembers(this.excludedMemberUuids);
            this.clusterState = ClusterState.ACTIVE;
            this.hotRestartStatus = HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED;
            this.logger.warning("Force start is set.");
            this.broadcast(new SendClusterStartResultOperation(this.hotRestartStatus, this.excludedMemberUuids, this.clusterState));
            boolean bl = true;
            return bl;
        }
        finally {
            this.hotRestartStatusLock.unlock();
        }
    }

    public boolean handlePartialStartRequest() {
        if (!this.node.isMaster()) {
            this.logger.warning("Partial data recovery request received but this node is not master!");
            return false;
        }
        if (!this.isPartialStartPolicy()) {
            this.logger.warning("Cannot trigger partial data recovery because cluster start policy is " + String.valueOf((Object)this.clusterDataRecoveryPolicy));
            return false;
        }
        this.hotRestartStatusLock.lock();
        try {
            if (this.hotRestartStatus != HotRestartClusterStartStatus.CLUSTER_START_IN_PROGRESS) {
                this.logger.warning("Cannot trigger partial data recovery since cluster start status is " + String.valueOf((Object)this.hotRestartStatus));
                boolean bl = false;
                return bl;
            }
            if (this.restoredMembersRef.get() == null) {
                this.logger.warning("Cannot trigger partial data recovery since restored member list is not present");
                boolean bl = false;
                return bl;
            }
            if (!this.trySetCurrentMemberListToExpectedMembers()) {
                this.tryPartialStart();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.hotRestartStatusLock.unlock();
        }
    }

    private boolean trySetCurrentMemberListToExpectedMembers() {
        if (this.expectedMembersRef.get() != null) {
            return false;
        }
        ClusterServiceImpl clusterService = this.node.getClusterService();
        HashMap<UUID, Address> expectedMembers = new HashMap<UUID, Address>();
        for (MemberImpl restoredMember : this.restoredMembersRef.get()) {
            MemberImpl currentMember = clusterService.getMember(restoredMember.getUuid());
            if (currentMember == null) continue;
            expectedMembers.put(currentMember.getUuid(), currentMember.getAddress());
        }
        if (this.expectedMembersRef.compareAndSet(null, Collections.unmodifiableMap(expectedMembers))) {
            this.logger.info("Expected members are explicitly set to current members: " + String.valueOf(expectedMembers));
            return true;
        }
        return false;
    }

    public void stopPersistence() {
        ClusterMetadataWriterLoop writerLoop = this.metadataWriterLoop;
        this.metadataWriterLoop = null;
        writerLoop.stop(false);
    }

    public void reset(boolean isAfterJoin) {
        this.metadataWriterLoop = new ClusterMetadataWriterLoop(this.homeDir, this.node::getLocalMember, this.node.hazelcastInstance.getName(), this.node::getLogger);
        if (isAfterJoin) {
            this.metadataWriterLoop.start();
        }
        this.hotRestartStatusLock.lock();
        try {
            this.restoredMembersRef.set(null);
            this.expectedMembersRef.set(null);
            this.partitionTableRef.set(null);
            this.memberClusterStartInfos.clear();
            this.startWithHotRestart = false;
        }
        finally {
            this.hotRestartStatusLock.unlock();
        }
    }

    public void shutdown() {
        if (this.startCompleted) {
            this.persistMembers();
            this.logger.fine("Persisting partition table during shutdown");
            this.persistPartitions();
        }
        this.metadataWriterLoop.stop(true);
    }

    void receiveClusterStartInfoFromMember(Member sender, MemberClusterStartInfo senderClusterStartInfo) {
        assert (!sender.localMember());
        if (!this.node.isMaster()) {
            this.logger.warning("Ignoring partition table received from non-master " + String.valueOf(sender) + " since this node is not master!");
            return;
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Received partition table from %s", sender);
        }
        this.hotRestartStatusLock.lock();
        try {
            if (this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_FAILED) {
                this.logger.info("Cluster start already failed. Sending failure to: " + String.valueOf(sender));
                this.sendIfNotThisMember(SendClusterStartResultOperation.newFailureResultOperation(), sender.getAddress());
            } else if (this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED) {
                this.validateSenderClusterStartInfoWhenSuccess(sender, senderClusterStartInfo);
            } else {
                this.validateSenderClusterStartInfoWhenInProgress(sender, senderClusterStartInfo);
            }
        }
        finally {
            this.hotRestartStatusLock.unlock();
        }
    }

    void validateLocalClusterStartInfo(MemberClusterStartInfo senderClusterStartInfo) {
        this.hotRestartStatusLock.lock();
        try {
            if (this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED) {
                this.validateSenderClusterStartInfoWhenSuccess(this.node.getLocalMember(), senderClusterStartInfo);
            } else {
                this.validateSenderClusterStartInfoWhenInProgress(this.node.getLocalMember(), senderClusterStartInfo);
            }
        }
        finally {
            this.hotRestartStatusLock.unlock();
        }
    }

    private void validateSenderClusterStartInfoWhenSuccess(Member sender, MemberClusterStartInfo senderClusterStartInfo) {
        if (this.unsafeMemberUuids.contains(sender.getUuid())) {
            this.unsafeMemberUuids.remove(sender.getUuid());
            this.crashedMemberUuids.remove(sender.getUuid());
            this.logger.info(String.valueOf(sender) + " is marked as unsafe due to crashing when 1 or more other nodes had crashed.");
            this.sendIfNotThisMember(SendClusterStartResultOperation.newFailureResultOperation(), sender.getAddress());
            return;
        }
        if (this.excludedMemberUuids.contains(sender.getUuid())) {
            this.logger.info(String.valueOf(sender) + " is excluded in start.");
            SendClusterStartResultOperation op = new SendClusterStartResultOperation(this.hotRestartStatus, this.excludedMemberUuids, null);
            this.sendIfNotThisMember(op, sender.getAddress());
            return;
        }
        if (this.excludedMemberUuids.contains(this.node.getThisUuid())) {
            this.logger.info("Will not answer " + String.valueOf(sender) + "'s cluster start info since this member is excluded in start.");
            return;
        }
        PartitionTableView senderPartitionTable = senderClusterStartInfo.getPartitionTable();
        MemberClusterStartInfo.DataLoadStatus senderDataLoadStatus = senderClusterStartInfo.getDataLoadStatus();
        PartitionTableView localPartitionTable = this.getLocalPartitionTableToCompareAgainst(sender);
        boolean partitionTableValidated = this.validatePartitionTable(localPartitionTable, senderPartitionTable);
        this.notifyListeners(sender, partitionTableValidated, senderDataLoadStatus);
        if (partitionTableValidated) {
            this.crashedMemberUuids.remove(sender.getUuid());
        }
        if (partitionTableValidated && senderDataLoadStatus == MemberClusterStartInfo.DataLoadStatus.LOAD_SUCCESSFUL) {
            this.logger.info("Sender: " + String.valueOf(sender) + " succeeded after cluster is started");
            SendClusterStartResultOperation op = new SendClusterStartResultOperation(HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED, this.excludedMemberUuids, this.getCurrentClusterState());
            this.sendIfNotThisMember(op, sender.getAddress());
        } else if (!partitionTableValidated || senderDataLoadStatus == MemberClusterStartInfo.DataLoadStatus.LOAD_FAILED) {
            this.logger.warning("Sender: " + String.valueOf(sender) + " failed after cluster is started. Partition table validated: " + partitionTableValidated + ", sender data load result: " + String.valueOf((Object)senderDataLoadStatus));
            this.sendIfNotThisMember(SendClusterStartResultOperation.newFailureResultOperation(), sender.getAddress());
        } else {
            this.logger.fine("Sender: %s validated its partition table but we are still waiting for data load result...", sender);
        }
    }

    private PartitionTableView getLocalPartitionTableToCompareAgainst(Member sender) {
        MemberClusterStartInfo thisMemberClusterStartInfo = (MemberClusterStartInfo)this.memberClusterStartInfos.get(this.node.getThisUuid());
        PartitionTableView localPartitionTable = thisMemberClusterStartInfo != null ? thisMemberClusterStartInfo.getPartitionTable() : this.node.getPartitionService().createPartitionTableView();
        if (this.node.getClusterService().getClusterJoinManager().hasMemberLeft(sender.getUuid())) {
            PartitionTableView temp = this.node.getPartitionService().getLeftMemberSnapshot(sender.getUuid());
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Partition table view for crashed member %s was %s", sender.getUuid(), temp);
            }
            localPartitionTable = temp == null ? localPartitionTable : temp;
        }
        return localPartitionTable;
    }

    private boolean validatePartitionTable(PartitionTableView localPartitionTable, PartitionTableView senderPartitionTable) {
        if (localPartitionTable.length() != senderPartitionTable.length()) {
            return false;
        }
        for (int partitionId = 0; partitionId < localPartitionTable.length(); ++partitionId) {
            for (int replicaIndex = 0; replicaIndex < 7; ++replicaIndex) {
                PartitionReplica localReplica = localPartitionTable.getReplica(partitionId, replicaIndex);
                PartitionReplica remoteReplica = senderPartitionTable.getReplica(partitionId, replicaIndex);
                if (localReplica == null) {
                    if (remoteReplica == null) continue;
                    this.logger.fine("Partition table validation failed! Local replica is null but sender's replica is " + String.valueOf(remoteReplica) + ". partitionId=" + partitionId + ", replicaIndex=" + replicaIndex);
                    return false;
                }
                if (remoteReplica == null) {
                    this.logger.fine("Partition table validation failed! Local replica is " + String.valueOf(localReplica) + " but sender's replica is null. partitionId=" + partitionId + ", replicaIndex=" + replicaIndex);
                    return false;
                }
                if (localReplica.uuid().equals(remoteReplica.uuid())) continue;
                this.logger.fine("Partition table validation failed! Local replica is " + String.valueOf(localReplica) + " but sender's replica is " + String.valueOf(remoteReplica) + ". partitionId=" + partitionId + ", replicaIndex=" + replicaIndex);
                return false;
            }
        }
        return true;
    }

    private void sendIfNotThisMember(Operation operation, Address target) {
        if (!this.node.getThisAddress().equals(target)) {
            OperationServiceImpl operationService = this.node.getNodeEngine().getOperationService();
            operationService.send(operation, target);
        }
    }

    private void validateSenderClusterStartInfoWhenInProgress(Member sender, MemberClusterStartInfo senderClusterStartInfo) {
        this.memberClusterStartInfos.put(sender.getUuid(), senderClusterStartInfo);
        this.logger.fine("Received cluster info from member %s load-status %s", sender, (Object)senderClusterStartInfo.getDataLoadStatus());
        if (!this.memberClusterStartInfos.containsKey(this.node.getThisUuid())) {
            this.logger.fine("Not validating member cluster start info of %s as this member's cluster start info is not known yet", sender);
            return;
        }
        if (!this.validateMemberClusterStartInfosForFullStart(sender)) {
            this.autoTryPartialStart();
        }
        if (this.hotRestartStatus != HotRestartClusterStartStatus.CLUSTER_START_IN_PROGRESS) {
            ClusterState clusterState = this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED ? this.clusterState : null;
            SendClusterStartResultOperation op = new SendClusterStartResultOperation(this.hotRestartStatus, this.excludedMemberUuids, clusterState);
            this.sendIfNotThisMember(op, sender.getAddress());
        }
    }

    private boolean validateMemberClusterStartInfosForFullStart(Member sender) {
        MemberClusterStartInfo thisMemberClusterStartInfo = (MemberClusterStartInfo)this.memberClusterStartInfos.get(this.node.getThisUuid());
        boolean fullStartSuccessful = true;
        for (Member member : this.restoredMembersRef.get()) {
            boolean memberFailed;
            MemberClusterStartInfo memberClusterStartInfo = (MemberClusterStartInfo)this.memberClusterStartInfos.get(member.getUuid());
            if (memberClusterStartInfo == null) {
                fullStartSuccessful = false;
                continue;
            }
            boolean partitionTableValidated = this.validatePartitionTable(thisMemberClusterStartInfo.getPartitionTable(), memberClusterStartInfo.getPartitionTable());
            MemberClusterStartInfo.DataLoadStatus memberDataLoadStatus = memberClusterStartInfo.getDataLoadStatus();
            if (member.equals(sender)) {
                this.notifyListeners(member, partitionTableValidated, memberDataLoadStatus);
            }
            boolean bl = memberFailed = !partitionTableValidated || memberDataLoadStatus == MemberClusterStartInfo.DataLoadStatus.LOAD_FAILED;
            if (memberFailed) {
                fullStartSuccessful = false;
                if (this.clusterDataRecoveryPolicy != HotRestartClusterDataRecoveryPolicy.FULL_RECOVERY_ONLY) continue;
                this.logger.warning("Failing cluster start since full cluster data recovery is expected and we have a failure! Failed member: " + String.valueOf(member) + ", reference partition table stamp: " + thisMemberClusterStartInfo.getPartitionTable().stamp() + ", member partition table stamp: " + memberClusterStartInfo.getPartitionTable().stamp() + ", member load status: " + String.valueOf((Object)memberDataLoadStatus));
                this.hotRestartStatus = HotRestartClusterStartStatus.CLUSTER_START_FAILED;
                break;
            }
            if (memberDataLoadStatus != MemberClusterStartInfo.DataLoadStatus.LOAD_IN_PROGRESS) continue;
            fullStartSuccessful = false;
        }
        if (fullStartSuccessful) {
            this.logger.info("All members completed! Setting final result to success!");
            this.hotRestartStatus = HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED;
        }
        return fullStartSuccessful;
    }

    private void notifyListeners(Member sender, boolean isSenderPartitionTableValidated, MemberClusterStartInfo.DataLoadStatus memberDataLoadStatus) {
        for (ClusterHotRestartEventListener listener : this.hotRestartEventListeners) {
            listener.onPartitionTableValidationResult(sender, isSenderPartitionTableValidated);
        }
        if (memberDataLoadStatus != MemberClusterStartInfo.DataLoadStatus.LOAD_IN_PROGRESS) {
            for (ClusterHotRestartEventListener listener : this.hotRestartEventListeners) {
                listener.onHotRestartDataLoadResult(sender, memberDataLoadStatus == MemberClusterStartInfo.DataLoadStatus.LOAD_SUCCESSFUL);
            }
        }
    }

    private void autoTryPartialStart() {
        if (this.hotRestartStatus != HotRestartClusterStartStatus.CLUSTER_START_IN_PROGRESS) {
            this.logger.fine("No partial data recovery attempt since %s", (Object)this.hotRestartStatus);
            return;
        }
        if (!this.isPartialStartPolicy()) {
            this.logger.fine("No partial data recovery attempt cluster start policy: %s", (Object)this.clusterDataRecoveryPolicy);
            return;
        }
        if (this.checkPartialStart()) {
            return;
        }
        this.logger.fine("Auto partial data recovery attempt...");
        this.tryPartialStart();
    }

    private boolean checkPartialStart() {
        Map<UUID, Address> expectedMembers = this.expectedMembersRef.get();
        if (expectedMembers == null) {
            return true;
        }
        for (MemberImpl expectedMember : this.restoredMembersRef.get()) {
            if (!expectedMembers.containsKey(expectedMember.getUuid())) continue;
            MemberClusterStartInfo memberClusterStartInfo = (MemberClusterStartInfo)this.memberClusterStartInfos.get(expectedMember.getUuid());
            if (memberClusterStartInfo == null) {
                return true;
            }
            if (memberClusterStartInfo.getDataLoadStatus() != MemberClusterStartInfo.DataLoadStatus.LOAD_IN_PROGRESS) continue;
            this.logger.fine("No partial data recovery attempt since member load is in progress...");
            return true;
        }
        return false;
    }

    private boolean isPartialStartPolicy() {
        return this.clusterDataRecoveryPolicy == HotRestartClusterDataRecoveryPolicy.PARTIAL_RECOVERY_MOST_COMPLETE || this.clusterDataRecoveryPolicy == HotRestartClusterDataRecoveryPolicy.PARTIAL_RECOVERY_MOST_RECENT;
    }

    public void receiveHotRestartStatus(Address sender, HotRestartClusterStartStatus result, Set<UUID> excludedMemberUuids, ClusterState clusterState) {
        if (this.node.getClusterService().isJoined()) {
            Address master = this.node.getMasterAddress();
            if (master.equals(sender) || this.node.isMaster()) {
                this.handleHotRestartStatus(sender, result, excludedMemberUuids, clusterState);
            } else {
                this.logger.warning(String.format("Received cluster start status from a non-master member %s. Current master is %s", sender, master));
            }
        } else {
            this.handleHotRestartStatus(sender, result, excludedMemberUuids, clusterState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHotRestartStatus(Address sender, HotRestartClusterStartStatus result, Set<UUID> excludedMemberUuids, ClusterState clusterState) {
        if (result != HotRestartClusterStartStatus.CLUSTER_START_FAILED && result != HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED) {
            throw new IllegalArgumentException("Cannot set hot restart status to " + String.valueOf((Object)result));
        }
        this.hotRestartStatusLock.lock();
        try {
            if (this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_IN_PROGRESS) {
                this.logger.info("Setting cluster-wide start status to " + String.valueOf((Object)result) + " with cluster state " + String.valueOf((Object)clusterState) + " received from: " + String.valueOf(sender));
                this.excludedMemberUuids = Set.copyOf(excludedMemberUuids);
                this.node.getClusterService().shrinkMissingMembers(this.excludedMemberUuids);
                if (result == HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED && !excludedMemberUuids.contains(this.node.getThisUuid())) {
                    this.clusterState = clusterState;
                }
                this.hotRestartStatus = result;
            } else if (this.hotRestartStatus != result) {
                this.logger.severe("Current cluster status: " + String.valueOf((Object)this.hotRestartStatus) + " received cluster status: " + String.valueOf((Object)result) + " from: " + String.valueOf(sender));
            }
        }
        finally {
            this.hotRestartStatusLock.unlock();
        }
    }

    private void setFinalClusterState(ClusterState newState) {
        this.logger.info("Setting final cluster state to: " + String.valueOf((Object)newState));
        ClusterStateManagerAccessor.setClusterState(this.node.getClusterService(), newState, false);
    }

    private void setInitialPartitionTable() {
        PartitionTableView partitionTable = this.partitionTableRef.get();
        this.node.partitionService.setInitialState(partitionTable);
    }

    private PartitionTableView restorePartitionTable() throws IOException {
        int partitionCount = this.node.getProperties().getInteger(ClusterProperty.PARTITION_COUNT);
        PartitionTableReader reader = new PartitionTableReader(this.homeDir, partitionCount);
        reader.read();
        PartitionTableView partitionTable = reader.getPartitionTable();
        this.partitionTableRef.set(partitionTable);
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Restored partition table with stamp: %s", partitionTable.stamp());
        }
        return partitionTable;
    }

    private Collection<MemberImpl> restoreMemberList() throws IOException {
        MemberListReader reader = new MemberListReader(this.homeDir);
        reader.read();
        MemberImpl thisMember = reader.getLocalMember();
        Collection<MemberImpl> members = reader.getMembers();
        if (thisMember != null && !this.node.getThisAddress().equals(thisMember.getAddress())) {
            this.logger.info("Local address change detected. Previous: " + String.valueOf(thisMember.getAddress()) + ", Current: " + String.valueOf(this.node.getThisAddress()));
        }
        if (thisMember == null) {
            this.logger.info("Cluster metadata could not be found on disk. Will not load Hot Restart data.");
            this.startWithHotRestart = false;
            members = List.of(this.node.getLocalMember());
        } else if (this.logger.isFineEnabled()) {
            this.logger.fine("Restored %s members -> %s", members.size(), members);
        }
        this.restoredMembersRef.set(members);
        return members;
    }

    private void restoreCompactSchemas() throws IOException {
        CompactSchemaReader reader = new CompactSchemaReader(this.homeDir);
        reader.read();
        Collection<Schema> schemas = reader.getSchemas();
        this.compactSchemaPersistenceManager.markPersistedSchemas(schemas);
        this.node.getSchemaService().onHotRestartRestore(schemas);
    }

    private boolean completeValidationIfNoHotRestartData() {
        if (this.startWithHotRestart) {
            return false;
        }
        int memberListSize = this.restoredMembersRef.get().size();
        this.logger.info("No need to start validation since expected member count is: " + memberListSize);
        for (ClusterHotRestartEventListener listener : this.hotRestartEventListeners) {
            listener.onSingleMemberCluster();
        }
        return true;
    }

    private void logAddressChanges(Map<Address, Address> addressMapping) {
        if (!addressMapping.isEmpty()) {
            StringBuilder s = new StringBuilder("Address changes detected in the member list:");
            for (Map.Entry<Address, Address> entry : addressMapping.entrySet()) {
                s.append("\n\t").append(entry.getKey()).append(" -> ").append(entry.getValue());
            }
            this.logger.info(s.toString());
        }
    }

    private void repairRestoredMembers(Map<Address, Address> addressMapping) {
        if (addressMapping.isEmpty()) {
            return;
        }
        HashSet<MemberImpl> updatedMembers = new HashSet<MemberImpl>();
        for (MemberImpl member : this.restoredMembersRef.get()) {
            Address newAddress = addressMapping.get(member.getAddress());
            if (newAddress == null) {
                updatedMembers.add(member);
                continue;
            }
            updatedMembers.add(new MemberImpl.Builder(newAddress).version(member.getVersion()).localMember(member.localMember()).uuid(member.getUuid()).build());
        }
        this.restoredMembersRef.set(updatedMembers);
    }

    private void repairPartitionTable() {
        Map<UUID, Address> uuidAddressMap = this.expectedMembersRef.get();
        if (this.logger.isFineEnabled()) {
            StringBuilder s = new StringBuilder("Replacing old addresses with the new ones in restored partition table:");
            for (Map.Entry<UUID, Address> entry : uuidAddressMap.entrySet()) {
                s.append("\n\t").append("Replicas belonging to member uuid: ").append(entry.getKey()).append(" will be mapped to the new address: ").append(entry.getValue());
            }
            this.logger.fine(s.toString());
        }
        PartitionTableView table = this.partitionTableRef.get();
        InternalPartition[] newPartitions = new InternalPartition[table.length()];
        for (int p = 0; p < newPartitions.length; ++p) {
            int versionInc = 0;
            PartitionReplica[] replicas = table.getReplicas(p);
            newPartitions[p] = table.getPartition(p);
            for (int i = 0; i < 7; ++i) {
                Address newAddress;
                PartitionReplica current = replicas[i];
                if (current == null || (newAddress = uuidAddressMap.get(current.uuid())) == null || newAddress.equals(current.address())) continue;
                replicas[i] = new PartitionReplica(newAddress, current.uuid());
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Owner address of PartitionReplica[partitionId=" + p + ", replicaIdx=" + i + "] is changed. New replica owner: " + String.valueOf(replicas[i]));
                }
                ++versionInc;
            }
            if (versionInc <= 0) continue;
            InternalPartition partition = newPartitions[p];
            int version = this.rejoiningClusterInActiveState ? partition.version() : partition.version() + versionInc;
            newPartitions[p] = new ReadonlyInternalPartition(replicas, p, version);
        }
        PartitionTableView newTable = new PartitionTableView(newPartitions);
        this.partitionTableRef.set(newTable);
        this.logger.fine("Partition table repair has been completed. New partition table stamp: %s", newTable.stamp());
    }

    public void setRejoiningClusterInActiveState(boolean rejoiningClusterInActiveState) {
        this.rejoiningClusterInActiveState = rejoiningClusterInActiveState;
    }

    private void awaitUntilExpectedMembersJoin() throws InterruptedException {
        Set<UUID> restoredMemberUuids = this.getRestoredMemberUuids();
        ClusterServiceImpl clusterService = this.node.getClusterService();
        HashMap<UUID, Address> expectedMembers = new HashMap<UUID, Address>();
        while (this.expectedMembersRef.get() == null) {
            if (this.node.isMaster()) {
                expectedMembers.clear();
                if (this.isExpectedMembersJoined(expectedMembers)) {
                    this.trySetExpectedMembers(expectedMembers);
                    break;
                }
            } else {
                this.logger.info("Waiting for cluster formation... Expected-Size: " + restoredMemberUuids.size() + ", Actual-Size: " + clusterService.getSize() + ". Start-time: " + String.valueOf(new Date(this.validationStartTime)) + ", Timeout: " + TimeUnit.MILLISECONDS.toSeconds(this.validationTimeout) + " sec.");
                this.sendIfNotThisMember(new AskForExpectedMembersOperation(), this.node.getMasterAddress());
            }
            Set<Member> members = clusterService.getMembers();
            this.failOrSetExpectedMembersIfValidationTimedOut(members);
            this.failIfUnexpectedMemberJoins(restoredMemberUuids, members);
            for (ClusterHotRestartEventListener listener : this.hotRestartEventListeners) {
                listener.beforeAllMembersJoin(members);
            }
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
        }
    }

    private void failIfUnexpectedMemberJoins(Set<UUID> restoredMemberUuids, Collection<Member> members) {
        for (Member member : members) {
            if (restoredMemberUuids.contains(member.getUuid())) continue;
            throw new HotRestartException("Unexpected member is joined: " + String.valueOf(member) + ". Restored members: " + String.valueOf(this.restoredMembersRef.get()));
        }
    }

    private Set<UUID> getRestoredMemberUuids() {
        return this.restoredMembersRef.get().stream().map(Member::getUuid).collect(Collectors.toUnmodifiableSet());
    }

    private void trySetExpectedMembers(Map<UUID, Address> expectedMembers) {
        if (!this.node.isMaster()) {
            return;
        }
        if (this.expectedMembersRef.compareAndSet(null, Collections.unmodifiableMap(expectedMembers))) {
            this.logger.info("Expected members are set to: " + String.valueOf(expectedMembers));
            this.broadcast(new SendExpectedMembersOperation(expectedMembers));
        }
    }

    private void failOrSetExpectedMembersIfValidationTimedOut(Collection<Member> members) {
        if (this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED && this.excludedMemberUuids.contains(this.node.getThisUuid())) {
            throw new ForceStartException();
        }
        if (this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_FAILED) {
            throw new HotRestartException("Cluster-wide start failed!");
        }
        if (this.getRemainingValidationTimeMillis() == 0L) {
            if (this.clusterDataRecoveryPolicy == HotRestartClusterDataRecoveryPolicy.FULL_RECOVERY_ONLY) {
                throw new HotRestartException("Expected members didn't join, validation phase timed-out! Expected member-count: " + this.restoredMembersRef.get().size() + ", Actual member-count: " + members.size() + ". Start-time: " + String.valueOf(new Date(this.validationStartTime)) + ", Timeout: " + TimeUnit.MILLISECONDS.toSeconds(this.validationTimeout) + " sec.");
            }
            if (this.node.isMaster() && this.isPartialStartPolicy() && this.trySetCurrentMemberListToExpectedMembers()) {
                this.broadcast(new SendExpectedMembersOperation(this.expectedMembersRef.get()));
            }
        }
    }

    private boolean isExpectedMembersJoined(Map<UUID, Address> expectedMembers) {
        ClusterServiceImpl clusterService = this.node.getClusterService();
        Collection<MemberImpl> restoredMembers = this.restoredMembersRef.get();
        for (Member member : restoredMembers) {
            MemberImpl currentMember = clusterService.getMember(member.getUuid());
            if (currentMember == null) {
                this.logger.info("Waiting for cluster formation... Expected-Size: " + restoredMembers.size() + ", Actual-Size: " + clusterService.getSize() + ", Missing member: " + String.valueOf(member) + ". Start-time: " + String.valueOf(new Date(this.validationStartTime)) + ", Timeout: " + TimeUnit.MILLISECONDS.toSeconds(this.validationTimeout) + " sec.");
                return false;
            }
            expectedMembers.put(currentMember.getUuid(), currentMember.getAddress());
        }
        return true;
    }

    private Map<Address, Address> getMemberAddressChangesMapping() {
        Map<UUID, Address> expectedMembers = this.expectedMembersRef.get();
        MemberImpl localMember = this.node.getLocalMember();
        if (!localMember.getAddress().equals(expectedMembers.get(localMember.getUuid()))) {
            throw new HotRestartException("Expected members doesn't contain local member or local address has been changed after expected members are determined! Expected member address: " + String.valueOf(expectedMembers.get(localMember.getUuid())) + ", Local member: " + String.valueOf(localMember));
        }
        HashMap<Address, Address> addressMapping = new HashMap<Address, Address>();
        for (Member member : this.restoredMembersRef.get()) {
            Address expectedAddress = expectedMembers.get(member.getUuid());
            if (expectedAddress == null || expectedAddress.equals(member.getAddress())) continue;
            addressMapping.put(member.getAddress(), expectedAddress);
        }
        return addressMapping;
    }

    private void sendLocalMemberClusterStartInfoToMaster() {
        Address masterAddress = this.node.getMasterAddress();
        if (masterAddress == null) {
            this.logger.warning("Failed to send partition table to master since master address is null");
            return;
        }
        if (masterAddress.equals(this.node.getThisAddress())) {
            this.logger.warning("Failed to send partition table to master since this node is master.");
            return;
        }
        MemberClusterStartInfo memberClusterStartInfo = (MemberClusterStartInfo)this.memberClusterStartInfos.get(this.node.getThisUuid());
        if (memberClusterStartInfo == null) {
            this.logger.fine("No member cluster start info to send to master!");
            return;
        }
        PartitionTableView partitionTable = memberClusterStartInfo.getPartitionTable();
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Sending partition table to: %s, TABLE-> %s", masterAddress, partitionTable);
        } else if (this.logger.isFineEnabled()) {
            this.logger.fine("Sending partition table to: %s, Stamp: %s", masterAddress, partitionTable.stamp());
        }
        OperationServiceImpl operationService = this.node.getNodeEngine().getOperationService();
        operationService.send(new SendMemberClusterStartInfoOperation(memberClusterStartInfo), masterAddress);
    }

    private void waitForDataLoadTimeoutOrFinalClusterStartStatus() throws InterruptedException {
        EnumSet<HotRestartClusterStartStatus> expectedStatuses = EnumSet.of(HotRestartClusterStartStatus.CLUSTER_START_FAILED, HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED);
        while (!expectedStatuses.contains((Object)this.hotRestartStatus)) {
            Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            if (this.logger.isFineEnabled()) {
                long remaining = this.getRemainingDataLoadTimeMillis();
                this.logger.fine("Waiting for result... Remaining time: %s ms.", remaining);
            }
            this.failIfDataLoadDeadlineMissed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveExpectedMembersFromMaster(Address sender, Map<UUID, Address> expectedMembers) {
        block11: {
            if (this.node.isMaster()) {
                this.logger.warning("Received expected members from " + String.valueOf(sender) + " but this node is already master.");
                return;
            }
            if (!sender.equals(this.node.getMasterAddress())) {
                this.logger.warning("Received expected members from non-master member: " + String.valueOf(sender) + ", current master is " + String.valueOf(this.node.getMasterAddress()) + ", expected member list is " + String.valueOf(expectedMembers));
                return;
            }
            this.hotRestartStatusLock.lock();
            try {
                if (this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_IN_PROGRESS) {
                    Set<UUID> restoredMemberUuids = this.getRestoredMemberUuids();
                    for (UUID expectedMemberUuid : expectedMembers.keySet()) {
                        if (restoredMemberUuids.contains(expectedMemberUuid)) continue;
                        String message = "Invalid expected members are received from master: " + String.valueOf(sender) + ", " + String.valueOf(expectedMemberUuid) + " doesn't exist in restored members: " + String.valueOf(this.restoredMembersRef.get());
                        this.logger.severe(message);
                        return;
                    }
                    if (this.expectedMembersRef.compareAndSet(null, Collections.unmodifiableMap(expectedMembers))) {
                        this.logger.info("Expected members are set to " + String.valueOf(expectedMembers) + " received from master: " + String.valueOf(sender));
                        return;
                    }
                    Map<UUID, Address> currentExpectedMembers = this.expectedMembersRef.get();
                    if (!currentExpectedMembers.equals(expectedMembers)) {
                        this.logger.severe("Expected members are already set to " + String.valueOf(currentExpectedMembers) + " but a different one " + String.valueOf(expectedMembers) + " is received from master: " + String.valueOf(sender));
                    }
                    break block11;
                }
                this.logger.warning("Ignored expected members " + String.valueOf(expectedMembers) + " received from master: " + String.valueOf(sender) + " because cluster start status is set to " + String.valueOf((Object)this.hotRestartStatus) + " with excluded members: " + String.valueOf(this.excludedMemberUuids));
            }
            finally {
                this.hotRestartStatusLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replyExpectedMembersQuestion(Address sender, UUID senderUuid) {
        if (!this.node.isMaster()) {
            this.logger.warning("Won't reply expected members question of sender: " + String.valueOf(sender) + " since this node is not master.");
            return;
        }
        this.hotRestartStatusLock.lock();
        try {
            if (this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_FAILED || this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED && this.excludedMemberUuids.contains(senderUuid)) {
                this.logger.info(String.valueOf(sender) + " with UUID: " + String.valueOf(senderUuid) + " is excluded in start.");
                SendClusterStartResultOperation op = new SendClusterStartResultOperation(this.hotRestartStatus, this.excludedMemberUuids, null);
                this.sendIfNotThisMember(op, sender);
            } else if (this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_IN_PROGRESS) {
                Map<UUID, Address> expectedMembers = this.expectedMembersRef.get();
                if (expectedMembers != null) {
                    this.sendIfNotThisMember(new SendExpectedMembersOperation(expectedMembers), sender);
                }
            } else {
                ClusterServiceImpl clusterService = this.node.getClusterService();
                HashMap<UUID, Address> expectedMembers = new HashMap<UUID, Address>();
                for (Member member : clusterService.getActiveAndMissingMembers()) {
                    if (this.excludedMemberUuids.contains(member.getUuid())) continue;
                    expectedMembers.put(member.getUuid(), member.getAddress());
                }
                this.sendIfNotThisMember(new SendExpectedMembersOperation(expectedMembers), sender);
            }
        }
        finally {
            this.hotRestartStatusLock.unlock();
        }
    }

    private void failIfDataLoadDeadlineMissed() {
        block8: {
            if (this.getRemainingDataLoadTimeMillis() == 0L) {
                if (!this.node.isMaster()) {
                    if (this.clusterDataRecoveryPolicy != HotRestartClusterDataRecoveryPolicy.FULL_RECOVERY_ONLY) {
                        return;
                    }
                    throw new HotRestartException("Cluster-wide data load timeout...");
                }
                this.hotRestartStatusLock.lock();
                try {
                    if (this.hotRestartStatus != HotRestartClusterStartStatus.CLUSTER_START_IN_PROGRESS) break block8;
                    if (this.clusterDataRecoveryPolicy == HotRestartClusterDataRecoveryPolicy.FULL_RECOVERY_ONLY) {
                        this.logger.severe("Data load step timed out...");
                        this.hotRestartStatus = HotRestartClusterStartStatus.CLUSTER_START_FAILED;
                        this.broadcast(SendClusterStartResultOperation.newFailureResultOperation());
                        break block8;
                    }
                    if (this.isPartialStartPolicy()) {
                        this.tryPartialStart();
                        break block8;
                    }
                    throw new IllegalStateException("Invalid cluster start policy: " + String.valueOf((Object)this.clusterDataRecoveryPolicy));
                }
                finally {
                    this.hotRestartStatusLock.unlock();
                }
            }
        }
    }

    private void tryPartialStart() {
        boolean failed = false;
        Set<UUID> excludedMemberUuids = Collections.emptySet();
        Map<UUID, PartitionTableView> partitionTables = this.collectLoadSucceededMemberPartitionTables();
        if (partitionTables.isEmpty()) {
            failed = true;
        } else {
            excludedMemberUuids = this.collectExcludedMemberUuids(partitionTables);
        }
        if (failed) {
            this.logger.severe("Nobody has succeeded to load data...");
            this.hotRestartStatus = HotRestartClusterStartStatus.CLUSTER_START_FAILED;
            this.broadcast(SendClusterStartResultOperation.newFailureResultOperation());
        } else {
            this.excludedMemberUuids = Collections.unmodifiableSet(excludedMemberUuids);
            this.node.getClusterService().shrinkMissingMembers(this.excludedMemberUuids);
            this.hotRestartStatus = HotRestartClusterStartStatus.CLUSTER_START_SUCCEEDED;
            this.logger.warning("Partial data recovery is set. Excluded member UUIDs: " + String.valueOf(excludedMemberUuids));
            this.broadcast(new SendClusterStartResultOperation(this.hotRestartStatus, excludedMemberUuids, this.clusterState));
        }
    }

    private Map<UUID, PartitionTableView> collectLoadSucceededMemberPartitionTables() {
        HashMap<UUID, PartitionTableView> membersPartitionTables = new HashMap<UUID, PartitionTableView>();
        Map<UUID, Address> expectedMembers = this.expectedMembersRef.get();
        for (MemberImpl member : this.restoredMembersRef.get()) {
            MemberClusterStartInfo memberClusterStartInfo;
            if (!expectedMembers.containsKey(member.getUuid()) || (memberClusterStartInfo = (MemberClusterStartInfo)this.memberClusterStartInfos.get(member.getUuid())) == null || memberClusterStartInfo.getDataLoadStatus() != MemberClusterStartInfo.DataLoadStatus.LOAD_SUCCESSFUL) continue;
            membersPartitionTables.put(member.getUuid(), memberClusterStartInfo.getPartitionTable());
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Partition table -> member UUIDs: %s", membersPartitionTables);
        }
        return membersPartitionTables;
    }

    private Set<UUID> collectExcludedMemberUuids(Map<UUID, PartitionTableView> memberPartitionTables) {
        Long2ObjectHashMap<List> versionToUUIDs = new Long2ObjectHashMap<List>();
        for (Map.Entry<UUID, PartitionTableView> e : memberPartitionTables.entrySet()) {
            List uuids = versionToUUIDs.computeIfAbsent(ClusterMetadataManager.sumVersions(e.getValue()), k -> new ArrayList());
            uuids.add(e.getKey());
        }
        long selectedVersion = -1L;
        List selectedMembers = Collections.emptyList();
        for (Map.Entry e : versionToUUIDs.entrySet()) {
            long version = e.getKey();
            List members = (List)e.getValue();
            if (this.clusterDataRecoveryPolicy == HotRestartClusterDataRecoveryPolicy.PARTIAL_RECOVERY_MOST_RECENT) {
                if (version > selectedVersion) {
                    selectedVersion = version;
                    selectedMembers = members;
                }
            } else if (this.clusterDataRecoveryPolicy == HotRestartClusterDataRecoveryPolicy.PARTIAL_RECOVERY_MOST_COMPLETE && (members.size() > selectedMembers.size() || members.size() == selectedMembers.size() && version > selectedVersion)) {
                selectedVersion = version;
                selectedMembers = members;
            }
            this.logger.fine("Candidate members %s with total partition table version: %s", selectedMembers, selectedVersion);
        }
        PartitionTableView partitionTable = memberPartitionTables.get(selectedMembers.get(0));
        this.logger.info("Picking members " + String.valueOf(selectedMembers) + " with partition table stamp: " + partitionTable.stamp());
        HashSet<UUID> excludedMemberUuids = new HashSet<UUID>();
        for (Member member : this.restoredMembersRef.get()) {
            if (selectedMembers.contains(member.getUuid())) continue;
            excludedMemberUuids.add(member.getUuid());
        }
        return excludedMemberUuids;
    }

    private static long sumVersions(PartitionTableView partitionTable) {
        return IntStream.range(0, partitionTable.length()).mapToObj(partitionTable::getPartition).mapToLong(IPartition::version).sum();
    }

    public ClusterState getCurrentClusterState() {
        this.hotRestartStatusLock.lock();
        try {
            ClusterState clusterState = this.startCompleted ? this.node.getClusterService().getClusterState() : this.clusterState;
            return clusterState;
        }
        finally {
            this.hotRestartStatusLock.unlock();
        }
    }

    private void askForClusterStartResult() {
        this.broadcast(new AskForClusterStartResultOperation());
    }

    private void persistMembers() {
        if (this.noMembersListUpdateForClusterTopologyIntent()) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Not persisting updated members list because cluster topology intent is %s", (Object)this.node.getClusterTopologyIntent());
            }
            return;
        }
        ClusterServiceImpl clusterService = this.node.getClusterService();
        Collection<Member> allMembers = clusterService.getActiveAndMissingMembers();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Will persist %s (active & passive) members -> %s", allMembers.size(), allMembers);
        }
        this.metadataWriterLoop.writeMembers(allMembers);
    }

    private boolean noMembersListUpdateForClusterTopologyIntent() {
        ClusterTopologyIntent clusterTopologyIntent = this.node.getClusterTopologyIntent();
        return clusterTopologyIntent == ClusterTopologyIntent.CLUSTER_SHUTDOWN_WITH_MISSING_MEMBERS || clusterTopologyIntent == ClusterTopologyIntent.CLUSTER_STABLE_WITH_MISSING_MEMBERS;
    }

    private void persistPartitions() {
        InternalPartitionService partitionService = this.node.getPartitionService();
        PartitionTableView partitionTable = partitionService.createPartitionTableView();
        if (ClusterMetadataManager.sumVersions(partitionTable) == 0L) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Won't persist partition table, not initialized yet.");
            }
            return;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Will persist partition table with stamp: %s", partitionTable.stamp());
        }
        this.metadataWriterLoop.writePartitionTable(partitionTable);
    }

    private void broadcast(Operation operation) {
        Map<UUID, Address> expectedMembers = this.expectedMembersRef.get();
        if (expectedMembers != null) {
            for (Address address : expectedMembers.values()) {
                this.sendIfNotThisMember(operation, address);
            }
            return;
        }
        for (Member member : this.restoredMembersRef.get()) {
            this.sendIfNotThisMember(operation, member.getAddress());
        }
    }

    public void backup(File targetDir) {
        IOUtil.copy(this.homeDir, targetDir);
    }

    public UUID readMemberUuid() {
        LocalMemberReader reader = new LocalMemberReader(this.homeDir);
        try {
            reader.read();
        }
        catch (IOException e) {
            throw new HotRestartException("Cannot read local member UUID!", e);
        }
        MemberImpl localMember = reader.getLocalMember();
        return localMember != null ? localMember.getUuid() : null;
    }

    HotRestartClusterDataRecoveryPolicy getClusterDataRecoveryPolicy() {
        return this.clusterDataRecoveryPolicy;
    }

    @Nullable
    Collection<MemberImpl> getRestoredMembers() {
        return this.restoredMembersRef.get();
    }

    MemberClusterStartInfo.DataLoadStatus getMemberDataLoadStatus(Member member) {
        MemberClusterStartInfo memberClusterStartInfo = (MemberClusterStartInfo)this.memberClusterStartInfos.get(member.getUuid());
        return memberClusterStartInfo != null ? memberClusterStartInfo.getDataLoadStatus() : null;
    }

    long getRemainingValidationTimeMillis() {
        if (this.validationStartTime == 0L) {
            return this.validationTimeout;
        }
        long remaining = this.validationStartTime + this.validationTimeout - Clock.currentTimeMillis();
        return Math.max(0L, remaining);
    }

    long getRemainingDataLoadTimeMillis() {
        if (this.dataLoadStartTime == 0L) {
            return this.dataLoadTimeout;
        }
        long remaining = this.dataLoadStartTime + this.dataLoadTimeout - Clock.currentTimeMillis();
        return Math.max(0L, remaining);
    }

    public static boolean isValidHotRestartDir(File homeDir) {
        File clusterDir = new File(homeDir, DIR_NAME);
        return clusterDir.exists() && clusterDir.isDirectory() && new File(clusterDir, "cluster-version.txt").exists() && new File(clusterDir, "cluster-state.txt").exists() && new File(clusterDir, "members.bin").exists();
    }

    private void waitUntilAllMembersReachFinalState() {
        ClusterServiceImpl clusterService = this.node.getClusterService();
        long startTimeNanos = System.nanoTime();
        Collection<Member> members = clusterService.getMembers(MemberSelectors.NON_LOCAL_MEMBER_SELECTOR);
        Set addresses = members.stream().map(Member::getAddress).collect(Collectors.toSet());
        OperationServiceImpl operationService = this.node.getNodeEngine().getOperationService();
        BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(0L, 0L, MEMBERS_STATE_BACKOFF_MIN_PARK, MEMBERS_STATE_BACKOFF_MAX_PARK);
        block2: for (Member member : members) {
            Address address = member.getAddress();
            int idleCount = 0;
            while (System.nanoTime() - startTimeNanos < MEMBERS_STATE_WAIT_IN_NANOS) {
                InvocationFuture future = operationService.invokeOnTarget(null, new GetClusterStateOperation(this.node.getThisUuid()), address);
                try {
                    ClusterState memberState = (ClusterState)((Object)future.get());
                    if (memberState == this.clusterState) {
                        addresses.remove(address);
                        continue block2;
                    }
                    if (memberState != ClusterState.PASSIVE) {
                        addresses.remove(address);
                        this.logger.warning("Member " + String.valueOf(member) + " in inconsistent cluster state: " + String.valueOf((Object)memberState) + ", expected: " + String.valueOf((Object)this.clusterState));
                        continue block2;
                    }
                    idleStrategy.idle(idleCount);
                }
                catch (Exception e) {
                    if (e.getCause() instanceof TargetNotMemberException || e.getCause() instanceof MemberLeftException) {
                        addresses.remove(address);
                    }
                    this.logger.warning("Error while checking final member state: " + String.valueOf(member), e);
                    continue block2;
                }
                ++idleCount;
            }
        }
        if (addresses.isEmpty()) {
            this.logger.info("All cluster members have transitioned to the final cluster state");
            this.invokeListenersOnMembersInFinalState();
        } else {
            this.logger.warning("Unable to determine the state of some members within a timeout: " + String.valueOf(addresses));
        }
    }

    private void invokeListenersOnMembersInFinalState() {
        for (ClusterHotRestartEventListener listener : this.hotRestartEventListeners) {
            listener.onMembersInFinalState(this.clusterState);
        }
    }

    public void setClusterTopologyIntentOnMaster(ClusterTopologyIntent clusterTopologyIntentOnMaster) {
        this.clusterTopologyIntentOnMaster = clusterTopologyIntentOnMaster;
    }

    public void onMemberLeft(Member member, ClusterState clusterState) {
        if (this.node.partitionService.getPartitionStateManager().isAbsentInPartitionTable(member)) {
            return;
        }
        if (clusterState.isMigrationAllowed() || clusterState.isPartitionPromotionAllowed()) {
            if (this.crashedMemberUuids.add(member.getUuid()) && this.crashedMemberUuids.size() > 1) {
                this.unsafeMemberUuids.addAll(this.crashedMemberUuids);
            }
        } else {
            this.crashedMemberUuids.add(member.getUuid());
        }
    }

    public void onMemberJoined(Member member) {
        if (!this.node.isMaster()) {
            this.crashedMemberUuids.remove(member.getUuid());
        }
    }

    private class ClearMemberClusterStartInfoTask
    implements Runnable {
        private ClearMemberClusterStartInfoTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ClusterMetadataManager.this.hotRestartStatusLock.lock();
            try {
                if (ClusterMetadataManager.this.hotRestartStatus == HotRestartClusterStartStatus.CLUSTER_START_IN_PROGRESS) {
                    Collection<MemberImpl> restoredMembers = ClusterMetadataManager.this.restoredMembersRef.get();
                    if (restoredMembers == null) {
                        return;
                    }
                    ClusterServiceImpl clusterService = ClusterMetadataManager.this.node.getClusterService();
                    for (Member member : restoredMembers) {
                        if (clusterService.getMember(member.getAddress()) != null || ClusterMetadataManager.this.memberClusterStartInfos.remove(member.getUuid()) == null) continue;
                        ClusterMetadataManager.this.logger.warning("Member cluster start info of " + String.valueOf(member) + " is removed as it has left the cluster");
                    }
                }
            }
            finally {
                ClusterMetadataManager.this.hotRestartStatusLock.unlock();
            }
        }
    }
}

