/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.elastic.tree;

import com.hazelcast.internal.elastic.map.BehmSlotAccessorFactory;
import com.hazelcast.internal.elastic.map.BinaryElasticHashMap;
import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.elastic.tree.OffHeapComparator;
import com.hazelcast.internal.elastic.tree.OffHeapTreeEntry;
import com.hazelcast.internal.elastic.tree.OffHeapTreeStore;
import com.hazelcast.internal.elastic.tree.impl.RedBlackTreeStore;
import com.hazelcast.internal.elastic.util.DisposalUtil;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.memory.MemoryBlockAccessor;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.HeapData;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.query.impl.Comparables;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class BinaryElasticNestedTreeMap<T extends Map.Entry, V extends MemoryBlock> {
    private static final long NULL_ADDRESS = 0L;
    private static final ThreadLocal<Deque> THREAD_LOCAL_DISPOSE_QUEUE = ThreadLocal.withInitial(() -> new ArrayDeque(3));
    protected final MapEntryFactory<T> mapEntryFactory;
    private final MemoryAllocator malloc;
    private final OffHeapTreeStore records;
    private final EnterpriseSerializationService ess;
    private final MemoryBlockAccessor memoryBlockAccessor;
    private final BehmSlotAccessorFactory behmSlotAccessorFactory;

    protected BinaryElasticNestedTreeMap(EnterpriseSerializationService ess, MemoryAllocator malloc, OffHeapComparator keyComparator, MapEntryFactory<T> mapEntryFactory, BehmSlotAccessorFactory behmSlotAccessorFactory, MemoryBlockAccessor memoryBlockAccessor) {
        this.records = new RedBlackTreeStore(ess.getCurrentMemoryAllocator(), keyComparator);
        this.ess = ess;
        this.malloc = malloc;
        this.mapEntryFactory = mapEntryFactory != null ? mapEntryFactory : new DefaultMapEntryFactory();
        this.behmSlotAccessorFactory = behmSlotAccessorFactory;
        this.memoryBlockAccessor = memoryBlockAccessor;
    }

    protected BinaryElasticNestedTreeMap(EnterpriseSerializationService ess, MemoryAllocator malloc, OffHeapComparator keyComparator, BehmSlotAccessorFactory behmSlotAccessorFactory, MemoryBlockAccessor memoryBlockAccessor) {
        this(ess, malloc, keyComparator, null, behmSlotAccessorFactory, memoryBlockAccessor);
    }

    public V put(Data segmentKey, NativeMemoryData key, V value) {
        OffHeapTreeEntry offHeapTreeEntry;
        this.checkNotNullOrEmpty(segmentKey, "segmentKey can't be null or empty");
        this.checkNotNullOrEmpty(key, "key can't be null or empty");
        if (segmentKey instanceof HeapData) {
            HeapData hd = (HeapData)segmentKey;
            offHeapTreeEntry = this.records.getEntry(hd);
        } else {
            offHeapTreeEntry = this.records.getEntry((MemoryBlock)((Object)segmentKey));
        }
        OffHeapTreeEntry entry = offHeapTreeEntry;
        Deque disposeQueue = THREAD_LOCAL_DISPOSE_QUEUE.get();
        disposeQueue.clear();
        try {
            MemoryBlock mapMemBlock;
            BinaryElasticHashMap<V> map;
            if (entry == null) {
                map = new BinaryElasticHashMap<V>(this.ess, this.behmSlotAccessorFactory, this.memoryBlockAccessor, this.malloc);
                disposeQueue.offer(map);
                mapMemBlock = map.storeHeaderOffHeap(this.malloc, 0L);
                disposeQueue.offer(mapMemBlock);
                NativeMemoryData nativeSegmentKey = (NativeMemoryData)this.ess.convertToNativeData(segmentKey, this.malloc);
                disposeQueue.offer(nativeSegmentKey);
                this.records.put(nativeSegmentKey, mapMemBlock);
            } else {
                mapMemBlock = entry.values().next();
                map = BinaryElasticHashMap.loadFromOffHeapHeader(this.ess, this.malloc, mapMemBlock.address(), this.behmSlotAccessorFactory, this.memoryBlockAccessor);
            }
            Object oldValue = map.put(key, value);
            map.storeHeaderOffHeap(this.malloc, mapMemBlock.address());
            return oldValue;
        }
        catch (NativeOutOfMemoryError e) {
            while (!disposeQueue.isEmpty()) {
                this.dispose(disposeQueue.pollLast());
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(Data segmentKey, NativeMemoryData key) {
        MemoryBlock value;
        NativeMemoryData nativeSegmentKey;
        block5: {
            OffHeapTreeEntry entry;
            block4: {
                V v;
                this.checkNotNullOrEmpty(segmentKey, "segmentKey can't be null");
                this.checkNotNullOrEmpty(key, "key can't be null");
                nativeSegmentKey = null;
                try {
                    nativeSegmentKey = (NativeMemoryData)this.ess.toNativeData(segmentKey, this.malloc);
                    entry = this.records.getEntry(nativeSegmentKey);
                    if (entry != null) break block4;
                    v = null;
                    this.dispose((Object)nativeSegmentKey);
                }
                catch (Throwable throwable) {
                    this.dispose((Object)nativeSegmentKey);
                    throw throwable;
                }
                return v;
            }
            value = entry.values().next();
            if (value != null) break block5;
            V v = null;
            this.dispose((Object)nativeSegmentKey);
            return v;
        }
        BinaryElasticHashMap map = BinaryElasticHashMap.loadFromOffHeapHeader(this.ess, this.malloc, value.address(), this.behmSlotAccessorFactory, this.memoryBlockAccessor);
        Object object = map.get(key);
        this.dispose((Object)nativeSegmentKey);
        return (V)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> get(Data segmentKey) {
        MemoryBlock value;
        NativeMemoryData nativeSegmentKey;
        block7: {
            OffHeapTreeEntry entry;
            block6: {
                block5: {
                    this.checkNotNullOrEmpty(segmentKey, "segmentKey can't be null or empty");
                    nativeSegmentKey = null;
                    try {
                        nativeSegmentKey = (NativeMemoryData)this.ess.toNativeData(segmentKey, this.malloc);
                        if (nativeSegmentKey.address() != 0L) break block5;
                        Set set = Collections.emptySet();
                        this.dispose((Object)nativeSegmentKey);
                        return set;
                    }
                    catch (Throwable throwable) {
                        this.dispose((Object)nativeSegmentKey);
                        throw throwable;
                    }
                }
                entry = this.records.getEntry(nativeSegmentKey);
                if (entry != null) break block6;
                Set set = Collections.emptySet();
                this.dispose((Object)nativeSegmentKey);
                return set;
            }
            value = entry.values().next();
            if (value != null) break block7;
            Set set = Collections.emptySet();
            this.dispose((Object)nativeSegmentKey);
            return set;
        }
        BinaryElasticHashMap map = BinaryElasticHashMap.loadFromOffHeapHeader(this.ess, this.malloc, value.address(), this.behmSlotAccessorFactory, this.memoryBlockAccessor);
        HashSet result = new HashSet(map.size());
        this.addEntries(result, map.entrySet());
        HashSet hashSet = result;
        this.dispose((Object)nativeSegmentKey);
        return hashSet;
    }

    protected abstract void addEntries(Set<T> var1, Set<Map.Entry<Data, MemoryBlock>> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(Data segmentKey, NativeMemoryData key) {
        Object value;
        block5: {
            BinaryElasticHashMap map;
            MemoryBlock blob;
            block4: {
                this.checkNotNullOrEmpty(segmentKey, "segmentKey can't be null or empty");
                this.checkNotNullOrEmpty(key, "key can't be null or empty");
                OffHeapTreeEntry entry = this.records.getEntry((HeapData)segmentKey);
                if (entry == null) {
                    return null;
                }
                blob = entry.values().next();
                if (blob == null) {
                    return null;
                }
                map = BinaryElasticHashMap.loadFromOffHeapHeader(this.ess, this.malloc, blob.address(), this.behmSlotAccessorFactory, this.memoryBlockAccessor);
                value = map.remove(key);
                MemoryBlock keyBlob = entry.getKey();
                if (!map.isEmpty()) break block4;
                try {
                    this.records.remove(entry);
                }
                catch (Throwable throwable) {
                    this.dispose(keyBlob, blob, map);
                    throw throwable;
                }
                this.dispose(keyBlob, blob, map);
                break block5;
            }
            map.storeHeaderOffHeap(this.malloc, blob.address());
        }
        return (V)value;
    }

    /*
     * Exception decompiling
     */
    public Set<T> subMap(Data fromSegmentKey, boolean fromInclusive, Data toSegmentKey, boolean toInclusive) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 12[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Set<T> headMap(Data toSegmentKey, boolean inclusive) {
        return this.subMap(null, true, toSegmentKey, inclusive);
    }

    public Set<T> tailMap(Data fromSegmentKey, boolean inclusive) {
        if (this.isNullOrEmptyData(fromSegmentKey)) {
            return Collections.emptySet();
        }
        return this.subMap(fromSegmentKey, inclusive, null, true);
    }

    private boolean equal(Data lhs, Data rhs) {
        if (lhs.equals(rhs)) {
            return true;
        }
        Comparable lhsComparable = (Comparable)this.ess.toObject(lhs);
        Comparable rhsComparable = (Comparable)this.ess.toObject(rhs);
        if (lhsComparable == null || rhsComparable == null) {
            return lhsComparable == rhsComparable;
        }
        return Comparables.compare(lhsComparable, rhsComparable) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Iterator<OffHeapTreeEntry> treeEntryIterator = this.records.entries();
        while (treeEntryIterator.hasNext()) {
            OffHeapTreeEntry entry = treeEntryIterator.next();
            MemoryBlock keyBlob = entry.getKey();
            MemoryBlock valueBlob = entry.values().next();
            BinaryElasticHashMap map = BinaryElasticHashMap.loadFromOffHeapHeader(this.ess, this.malloc, valueBlob.address(), this.behmSlotAccessorFactory, this.memoryBlockAccessor);
            try {
                this.records.remove(entry);
            }
            catch (Throwable throwable) {
                this.dispose(map, valueBlob, keyBlob);
                throw throwable;
            }
            this.dispose(map, valueBlob, keyBlob);
        }
    }

    public void dispose() {
        try {
            this.clear();
        }
        finally {
            this.records.dispose(false);
        }
    }

    public long size() {
        long size = 0L;
        EntryIterator iterator = new EntryIterator();
        while (iterator.hasNext()) {
            Object map = iterator.next();
            size += (long)((BinaryElasticHashMap)map).size();
        }
        return size;
    }

    private Data toHeapData(MemoryBlock blob) {
        NativeMemoryData nativeMemoryData = new NativeMemoryData(blob.address(), blob.size());
        return this.ess.toData((Object)nativeMemoryData, DataType.HEAP);
    }

    private boolean isNullOrEmptyData(Data data) {
        return data == null || data.totalSize() == 0;
    }

    private void checkNotNullOrEmpty(Data data, String message) {
        if (this.isNullOrEmptyData(data)) {
            throw new IllegalArgumentException(message);
        }
    }

    private void dispose(Object object) {
        DisposalUtil.dispose(this.ess, this.malloc, object);
    }

    private void dispose(Object ... objects) {
        DisposalUtil.dispose(this.ess, this.malloc, objects);
    }

    private static class DefaultMapEntryFactory<T extends Map.Entry>
    implements MapEntryFactory<T> {
        private DefaultMapEntryFactory() {
        }

        @Override
        public T create(Data key, Data value) {
            return (T)new AbstractMap.SimpleEntry<Data, Data>(key, value);
        }
    }

    private class EntryIterator
    implements Iterator<BinaryElasticHashMap<MemoryBlock>> {
        private Iterator<OffHeapTreeEntry> entryIterator;
        private Iterator<MemoryBlock> valueIterator;
        private Data key;
        private BinaryElasticHashMap<MemoryBlock> value;

        EntryIterator(OffHeapTreeEntry entry) {
            this.entryIterator = BinaryElasticNestedTreeMap.this.records.entries(entry);
            this.advanceKeyIterator();
        }

        EntryIterator() {
            this.entryIterator = BinaryElasticNestedTreeMap.this.records.entries();
            this.advanceKeyIterator();
        }

        private void advanceKeyIterator() {
            if (this.entryIterator.hasNext()) {
                OffHeapTreeEntry entry = this.entryIterator.next();
                this.key = BinaryElasticNestedTreeMap.this.toHeapData(entry.getKey());
                this.valueIterator = entry.values();
            } else {
                this.key = null;
                this.value = null;
            }
        }

        private void advanceValueIterator() {
            if (this.valueIterator.hasNext()) {
                MemoryBlock valueBlob = this.valueIterator.next();
                this.value = BinaryElasticHashMap.loadFromOffHeapHeader(BinaryElasticNestedTreeMap.this.ess, BinaryElasticNestedTreeMap.this.malloc, valueBlob.address(), BinaryElasticNestedTreeMap.this.behmSlotAccessorFactory, BinaryElasticNestedTreeMap.this.memoryBlockAccessor);
            } else {
                this.value = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.valueIterator == null) {
                return false;
            }
            if (this.valueIterator.hasNext()) {
                return true;
            }
            this.advanceKeyIterator();
            return this.valueIterator.hasNext();
        }

        @Override
        public BinaryElasticHashMap<MemoryBlock> next() {
            if (this.valueIterator == null) {
                throw new NoSuchElementException();
            }
            if (this.valueIterator.hasNext()) {
                this.advanceValueIterator();
                return this.value;
            }
            this.advanceKeyIterator();
            if (this.valueIterator.hasNext()) {
                this.advanceValueIterator();
                return this.value;
            }
            throw new NoSuchElementException();
        }

        public Data getKey() {
            return this.key;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

