/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.diagnostics;

import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.impl.ClusterHeartbeatManager;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.DiagnosticsPlugin;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.concurrent.TimeUnit;

public class MemberHeartbeatPlugin
extends DiagnosticsPlugin {
    public static final HazelcastProperty PERIOD_SECONDS = new HazelcastProperty("hazelcast.diagnostics.member-heartbeat.period.seconds", 10, TimeUnit.SECONDS);
    public static final HazelcastProperty MAX_DEVIATION_PERCENTAGE = new HazelcastProperty("hazelcast.diagnostics.member-heartbeat.max-deviation-percentage", 100);
    private static final float HUNDRED = 100.0f;
    private final ClusterService clusterService;
    private final HazelcastProperties properties;
    private long periodMillis;
    private int maxDeviationPercentage;
    private boolean mainSectionStarted;

    public MemberHeartbeatPlugin(ILogger logger, ClusterService clusterService, HazelcastProperties props) {
        super(logger);
        this.clusterService = clusterService;
        this.properties = props;
        this.readProperties();
    }

    @Override
    void readProperties() {
        this.periodMillis = this.properties.getMillis(this.overrideProperty(PERIOD_SECONDS));
        this.maxDeviationPercentage = this.properties.getInteger(this.overrideProperty(MAX_DEVIATION_PERCENTAGE));
    }

    @Override
    public long getPeriodMillis() {
        return this.periodMillis;
    }

    @Override
    public void onStart() {
        super.onStart();
        this.logger.info("Plugin:active, period-millis:" + this.periodMillis);
    }

    @Override
    public void onShutdown() {
        super.onShutdown();
        this.logger.info("Plugin:inactive");
    }

    @Override
    public void run(DiagnosticsLogWriter writer) {
        if (!this.isActive()) {
            return;
        }
        if (!(this.clusterService instanceof ClusterServiceImpl)) {
            return;
        }
        this.render(writer, (ClusterServiceImpl)this.clusterService);
    }

    int getMaxDeviationPercentage() {
        return this.maxDeviationPercentage;
    }

    private void render(DiagnosticsLogWriter writer, ClusterServiceImpl clusterService) {
        ClusterHeartbeatManager clusterHeartbeatManager = clusterService.getClusterHeartbeatManager();
        long expectedIntervalMillis = clusterHeartbeatManager.getHeartbeatIntervalMillis();
        long nowMillis = System.currentTimeMillis();
        for (MemberImpl member : clusterService.getMemberImpls()) {
            long noHeartbeatMillis;
            float deviation;
            long lastHeartbeatMillis = clusterHeartbeatManager.getLastHeartbeatTime(member);
            if (lastHeartbeatMillis == 0L || !((deviation = 100.0f * (float)((noHeartbeatMillis = nowMillis - lastHeartbeatMillis) - expectedIntervalMillis) / (float)expectedIntervalMillis) >= (float)this.maxDeviationPercentage)) continue;
            this.startLazyMainSection(writer);
            writer.startSection("member" + String.valueOf(member.getAddress()));
            writer.writeKeyValueEntry("deviation(%)", deviation);
            writer.writeKeyValueEntry("noHeartbeat(ms)", noHeartbeatMillis);
            writer.writeKeyValueEntry("lastHeartbeat(ms)", lastHeartbeatMillis);
            writer.writeKeyValueEntryAsDateTime("lastHeartbeat(date-time)", lastHeartbeatMillis);
            writer.writeKeyValueEntry("now(ms)", nowMillis);
            writer.writeKeyValueEntryAsDateTime("now(date-time)", nowMillis);
            writer.endSection();
        }
        this.endLazyMainSection(writer);
    }

    private void startLazyMainSection(DiagnosticsLogWriter writer) {
        if (!this.mainSectionStarted) {
            this.mainSectionStarted = true;
            writer.startSection("MemberHeartbeats");
        }
    }

    private void endLazyMainSection(DiagnosticsLogWriter writer) {
        if (this.mainSectionStarted) {
            this.mainSectionStarted = false;
            writer.endSection();
        }
    }
}

