/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.InvalidConfigurationException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SchemaViolationConfigurationException
extends InvalidConfigurationException {
    private final String keywordLocation;
    private final String instanceLocation;
    private final List<SchemaViolationConfigurationException> errors;

    public SchemaViolationConfigurationException(String message, String keywordLocation, String instanceLocation, List<SchemaViolationConfigurationException> errors) {
        super(message);
        this.keywordLocation = keywordLocation;
        this.instanceLocation = instanceLocation;
        this.errors = List.copyOf(errors);
    }

    public String getKeywordLocation() {
        return this.keywordLocation;
    }

    public String getInstanceLocation() {
        return this.instanceLocation;
    }

    public List<SchemaViolationConfigurationException> getErrors() {
        return this.errors;
    }

    private String prettyPrint(int indentLevel) {
        String linePrefix = IntStream.range(0, indentLevel).mapToObj(i -> "  ").collect(Collectors.joining(""));
        String lineSeparator = System.lineSeparator();
        StringBuilder sb = new StringBuilder(linePrefix).append(this.getMessage()).append(lineSeparator).append(linePrefix).append("  instance location: ").append(this.instanceLocation).append(lineSeparator).append(linePrefix).append("  keyword location: ").append(this.keywordLocation).append(lineSeparator);
        this.errors.stream().map(err -> err.prettyPrint(indentLevel + 1)).forEach(sb::append);
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.prettyPrint(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaViolationConfigurationException that = (SchemaViolationConfigurationException)o;
        return this.getMessage().equals(that.getMessage()) && this.keywordLocation.equals(that.keywordLocation) && this.instanceLocation.equals(that.instanceLocation) && this.errors.equals(that.errors);
    }

    public int hashCode() {
        return Objects.hash(this.getMessage(), this.keywordLocation, this.instanceLocation, this.errors);
    }
}

