/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.internal.cluster.impl.ConfigMismatchException;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.properties.ClusterProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class ConfigCheck
implements IdentifiedDataSerializable {
    private String clusterName;
    private String joinerType;
    private boolean partitionGroupEnabled;
    private PartitionGroupConfig.MemberGroupType memberGroupType;
    private Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, Object> maps = new HashMap<String, Object>();
    private final Map<String, Object> queues = new HashMap<String, Object>();

    public ConfigCheck() {
    }

    public ConfigCheck(Config config, String joinerType) {
        this.joinerType = joinerType;
        this.properties.put(ClusterProperty.PARTITION_COUNT.getName(), config.getProperty(ClusterProperty.PARTITION_COUNT.getName()));
        this.clusterName = config.getClusterName();
        PartitionGroupConfig partitionGroupConfig = config.getPartitionGroupConfig();
        if (partitionGroupConfig != null) {
            this.partitionGroupEnabled = partitionGroupConfig.isEnabled();
            this.memberGroupType = this.partitionGroupEnabled ? partitionGroupConfig.getGroupType() : PartitionGroupConfig.MemberGroupType.PER_MEMBER;
        }
    }

    public boolean isCompatible(ConfigCheck found) {
        if (!ConfigCheck.equals(this.clusterName, found.clusterName)) {
            return false;
        }
        this.verifyJoiner(found);
        this.verifyPartitionGroup(found);
        this.verifyPartitionCount(found);
        return true;
    }

    public boolean hasSameClusterName(ConfigCheck found) {
        return ConfigCheck.equals(this.clusterName, found.clusterName);
    }

    public String getClusterName() {
        return this.clusterName;
    }

    private void verifyPartitionCount(ConfigCheck found) {
        String foundPartitionCount;
        String expectedPartitionCount = this.properties.get(ClusterProperty.PARTITION_COUNT.getName());
        if (!ConfigCheck.equals(expectedPartitionCount, foundPartitionCount = found.properties.get(ClusterProperty.PARTITION_COUNT.getName()))) {
            throw new ConfigMismatchException("Incompatible partition count! expected: " + expectedPartitionCount + ", found: " + foundPartitionCount);
        }
    }

    private void verifyPartitionGroup(ConfigCheck found) {
        if (!this.partitionGroupEnabled && found.partitionGroupEnabled || this.partitionGroupEnabled && !found.partitionGroupEnabled) {
            throw new ConfigMismatchException("Incompatible partition groups! expected: " + (this.partitionGroupEnabled ? "enabled" : "disabled") + " / " + String.valueOf((Object)this.memberGroupType) + ", found: " + (found.partitionGroupEnabled ? "enabled" : "disabled") + " / " + String.valueOf((Object)found.memberGroupType));
        }
        if (this.partitionGroupEnabled && this.memberGroupType != found.memberGroupType) {
            throw new ConfigMismatchException("Incompatible partition groups! expected: " + String.valueOf((Object)this.memberGroupType) + ", found: " + String.valueOf((Object)found.memberGroupType));
        }
    }

    private void verifyJoiner(ConfigCheck found) {
        if (!ConfigCheck.equals(this.joinerType, found.joinerType)) {
            throw new ConfigMismatchException("Incompatible joiners! expected: " + this.joinerType + ", found: " + found.joinerType);
        }
    }

    private static boolean equals(String thisValue, String thatValue) {
        if (thisValue == null) {
            return thatValue == null;
        }
        return thisValue.equals(thatValue);
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.clusterName);
        out.writeString(this.joinerType);
        out.writeBoolean(this.partitionGroupEnabled);
        if (this.partitionGroupEnabled) {
            out.writeString(this.memberGroupType.toString());
        }
        out.writeInt(this.properties.size());
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        SerializationUtil.writeMapStringKey(this.maps, out);
        SerializationUtil.writeMapStringKey(this.queues, out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.clusterName = in.readString();
        this.joinerType = in.readString();
        this.partitionGroupEnabled = in.readBoolean();
        if (this.partitionGroupEnabled) {
            String s = in.readString();
            try {
                this.memberGroupType = PartitionGroupConfig.MemberGroupType.valueOf(s);
            }
            catch (IllegalArgumentException ignored) {
                EmptyStatement.ignore(ignored);
            }
        }
        int propSize = in.readInt();
        this.properties = MapUtil.createHashMap(propSize);
        for (int k = 0; k < propSize; ++k) {
            String key = in.readString();
            String value = in.readString();
            this.properties.put(key, value);
        }
        int mapSize = in.readInt();
        for (int k = 0; k < mapSize; ++k) {
            String key = in.readString();
            Object value = in.readObject();
            this.maps.put(key, value);
        }
        int queueSize = in.readInt();
        for (int k = 0; k < queueSize; ++k) {
            String key = in.readString();
            Object value = in.readObject();
            this.queues.put(key, value);
        }
    }
}

