/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.bplustree;

import com.hazelcast.internal.bplustree.BPlusTree;
import com.hazelcast.internal.bplustree.BPlusTreeKeyAccessor;
import com.hazelcast.internal.bplustree.BPlusTreeKeyComparator;
import com.hazelcast.internal.bplustree.BPlusTreeLimitException;
import com.hazelcast.internal.bplustree.CompositeKeyComparison;
import com.hazelcast.internal.bplustree.DefaultNodeSplitStrategy;
import com.hazelcast.internal.bplustree.EntrySlotPayload;
import com.hazelcast.internal.bplustree.HDBPlusTree;
import com.hazelcast.internal.bplustree.HDBTreeInnerNodeAccessor;
import com.hazelcast.internal.bplustree.HDBTreeLeafNodeAccessor;
import com.hazelcast.internal.bplustree.HDBTreeNodeBaseAccessor;
import com.hazelcast.internal.bplustree.HDLockManager;
import com.hazelcast.internal.bplustree.LockManager;
import com.hazelcast.internal.bplustree.LockingContext;
import com.hazelcast.internal.bplustree.NodeSplitStrategy;
import com.hazelcast.internal.bplustree.TStoreAllocator;
import com.hazelcast.internal.bplustree.TStoreBTreeCompactor;
import com.hazelcast.internal.bplustree.TStoreBTreeInnerNodeAccessor;
import com.hazelcast.internal.bplustree.TStoreBTreeLeafNodeAccessor;
import com.hazelcast.internal.elastic.tree.MapEntryFactory;
import com.hazelcast.internal.memory.MemoryAllocator;
import com.hazelcast.internal.memory.MemoryBlock;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.EnterpriseSerializationService;
import com.hazelcast.internal.serialization.impl.NativeMemoryData;
import com.hazelcast.internal.util.QuickMath;
import com.hazelcast.memory.NativeOutOfMemoryError;
import com.hazelcast.query.impl.IndexKeyEntries;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Function;

public final class HDBPlusTree<T extends QueryableEntry>
implements BPlusTree<T> {
    static final int LOOKUP_INITIAL_BUFFER_SIZE = 8;
    static final Data PLUS_INFINITY_ENTRY_KEY = new NativeMemoryData();
    static final Data MINUS_INFINITY_ENTRY_KEY = new NativeMemoryData();
    static final int DEFAULT_BPLUS_TREE_SCAN_BATCH_MAX_SIZE = 1000;
    private static final long RETRY_OPERATION = -1L;
    private static final ThreadLocal<LockingContext> LOCKING_CONTEXT = ThreadLocal.withInitial(HDBPlusTree::newLockingContext);
    private static final int NULL_SLOT = -1;
    private static final int WITHIN_RANGE = 0;
    private static final int OUTSIDE_OF_RANGE = 1;
    private static final int RETRY = 2;
    private static final int MIN_NUM_ENTRIES_CAN_FIT_IN_PAGE = 3;
    private final MapEntryFactory<T> mapEntryFactory;
    private final int maxIndexEntrySize;
    private final HDBTreeInnerNodeAccessor innerNodeAccessor;
    private final HDBTreeLeafNodeAccessor leafNodeAccessor;
    private final EnterpriseSerializationService ess;
    private final LockManager lockManager;
    private final Object clearMutex = new Object();
    private final long rootAddr;
    private volatile boolean isDisposed;
    private final int btreeScanBatchSize;

    private HDBPlusTree(EnterpriseSerializationService ess, LockManager lockManager, MapEntryFactory<T> entryFactory, int nodeSize, int btreeScanBatchSize, HDBTreeInnerNodeAccessor innerNodeAccessor, HDBTreeLeafNodeAccessor leafNodeAccessor) {
        if (nodeSize <= 0 || !QuickMath.isPowerOfTwo(nodeSize)) {
            throw new IllegalArgumentException("Illegal node size " + nodeSize + ". Node size must be a power of two");
        }
        if (nodeSize < 128 || nodeSize > 65536) {
            throw new IllegalArgumentException("Illegal node size " + nodeSize + ". Node size cannot exceed 65536 and be less than 128");
        }
        if (btreeScanBatchSize < 0) {
            throw new IllegalArgumentException("Range scan batch size " + btreeScanBatchSize + " must be positive or zero");
        }
        this.mapEntryFactory = entryFactory;
        this.ess = ess;
        this.lockManager = lockManager;
        this.btreeScanBatchSize = btreeScanBatchSize;
        this.innerNodeAccessor = innerNodeAccessor;
        this.leafNodeAccessor = leafNodeAccessor;
        LockingContext lockingContext = HDBPlusTree.getLockingContext();
        this.rootAddr = innerNodeAccessor.newNodeLocked(lockingContext);
        this.maxIndexEntrySize = (nodeSize - 36) / 3;
        this.createEmptyTree(lockingContext);
        assert (this.getNodeAccessor().getNodeLevel(this.rootAddr, lockingContext) == 1);
    }

    public static <T extends Map.Entry> HDBPlusTree newHDBTree(EnterpriseSerializationService ess, MemoryAllocator keyAllocator, MemoryAllocator btreeAllocator, BPlusTreeKeyComparator keyComparator, BPlusTreeKeyAccessor keyAccessor, MapEntryFactory<T> entryFactory, int nodeSize, EntrySlotPayload entrySlotPayload) {
        int stripesCount = QuickMath.nextPowerOfTwo(Runtime.getRuntime().availableProcessors() * 4);
        HDLockManager lockManager = new HDLockManager(stripesCount);
        DefaultNodeSplitStrategy splitStrategy = new DefaultNodeSplitStrategy();
        HDBTreeInnerNodeAccessor innerNodeAccessor = new HDBTreeInnerNodeAccessor(lockManager, ess, keyComparator, keyAccessor, keyAllocator, btreeAllocator, nodeSize, splitStrategy, entrySlotPayload);
        HDBTreeLeafNodeAccessor leafNodeAccessor = new HDBTreeLeafNodeAccessor(lockManager, ess, keyComparator, keyAccessor, keyAllocator, btreeAllocator, nodeSize, splitStrategy, entrySlotPayload);
        return new HDBPlusTree<T>(ess, lockManager, entryFactory, nodeSize, 1000, innerNodeAccessor, leafNodeAccessor);
    }

    public static <T extends Map.Entry> HDBPlusTree newTStoreBTree(EnterpriseSerializationService ess, MemoryAllocator keyAllocator, TStoreAllocator btreeAllocator, BPlusTreeKeyComparator keyComparator, BPlusTreeKeyAccessor keyAccessor, MapEntryFactory<T> entryFactory, int nodeSize, EntrySlotPayload entrySlotPayload) {
        int stripesCount = QuickMath.nextPowerOfTwo(Runtime.getRuntime().availableProcessors() * 4);
        HDLockManager lockManager = new HDLockManager(stripesCount);
        DefaultNodeSplitStrategy splitStrategy = new DefaultNodeSplitStrategy();
        TStoreBTreeInnerNodeAccessor innerNodeAccessor = new TStoreBTreeInnerNodeAccessor((LockManager)lockManager, ess, keyComparator, keyAccessor, keyAllocator, btreeAllocator, nodeSize, (NodeSplitStrategy)splitStrategy, entrySlotPayload);
        TStoreBTreeLeafNodeAccessor leafNodeAccessor = new TStoreBTreeLeafNodeAccessor((LockManager)lockManager, ess, keyComparator, keyAccessor, keyAllocator, btreeAllocator, nodeSize, (NodeSplitStrategy)splitStrategy, entrySlotPayload);
        if (btreeAllocator.shouldUseGlobalIndex()) {
            btreeAllocator.registerCompactor(HDBPlusTree.createDependenciesInternal(innerNodeAccessor, lockManager, btreeAllocator::addressOf));
        }
        return new HDBPlusTree<T>(ess, lockManager, entryFactory, nodeSize, 1000, innerNodeAccessor, leafNodeAccessor);
    }

    public static <T extends Map.Entry> HDBPlusTree newHDBTree(EnterpriseSerializationService ess, MemoryAllocator keyAllocator, MemoryAllocator btreeAllocator, LockManager lockManager, BPlusTreeKeyComparator keyComparator, BPlusTreeKeyAccessor keyAccessor, MapEntryFactory<T> entryFactory, int nodeSize, int rangeScanBatchSize, EntrySlotPayload entrySlotPayload) {
        DefaultNodeSplitStrategy splitStrategy = new DefaultNodeSplitStrategy();
        HDBTreeInnerNodeAccessor innerNodeAccessor = new HDBTreeInnerNodeAccessor(lockManager, ess, keyComparator, keyAccessor, keyAllocator, btreeAllocator, nodeSize, splitStrategy, entrySlotPayload);
        HDBTreeLeafNodeAccessor leafNodeAccessor = new HDBTreeLeafNodeAccessor(lockManager, ess, keyComparator, keyAccessor, keyAllocator, btreeAllocator, nodeSize, splitStrategy, entrySlotPayload);
        return new HDBPlusTree<T>(ess, lockManager, entryFactory, nodeSize, rangeScanBatchSize, innerNodeAccessor, leafNodeAccessor);
    }

    public static <T extends Map.Entry> HDBPlusTree newTStoreBTree(EnterpriseSerializationService ess, MemoryAllocator keyAllocator, TStoreAllocator btreeAllocator, LockManager lockManager, BPlusTreeKeyComparator keyComparator, BPlusTreeKeyAccessor keyAccessor, MapEntryFactory<T> entryFactory, int nodeSize, int rangeScanBatchSize, EntrySlotPayload entrySlotPayload) {
        DefaultNodeSplitStrategy splitStrategy = new DefaultNodeSplitStrategy();
        TStoreBTreeInnerNodeAccessor innerNodeAccessor = new TStoreBTreeInnerNodeAccessor(lockManager, ess, keyComparator, keyAccessor, keyAllocator, btreeAllocator, nodeSize, (NodeSplitStrategy)splitStrategy, entrySlotPayload);
        TStoreBTreeLeafNodeAccessor leafNodeAccessor = new TStoreBTreeLeafNodeAccessor(lockManager, ess, keyComparator, keyAccessor, keyAllocator, btreeAllocator, nodeSize, (NodeSplitStrategy)splitStrategy, entrySlotPayload);
        return new HDBPlusTree<T>(ess, lockManager, entryFactory, nodeSize, rangeScanBatchSize, innerNodeAccessor, leafNodeAccessor);
    }

    private static TStoreBTreeCompactor.Dependencies createDependenciesInternal(final HDBTreeInnerNodeAccessor innerNodeAccessor, final LockManager lockManager, final Function<Long, Long> addressOf) {
        return new TStoreBTreeCompactor.Dependencies(){

            @Override
            public long getLockAddress(long stable) {
                return innerNodeAccessor.getLockStateAddr(stable);
            }

            @Override
            public boolean tryExclusiveLock(long lockAddress) {
                return lockManager.tryWriteLock(lockAddress);
            }

            @Override
            public void releaseLock(long lockAddress) {
                lockManager.releaseLock(lockAddress);
            }

            @Override
            public long addressOf(long address) {
                return (Long)addressOf.apply(address);
            }
        };
    }

    public TStoreBTreeCompactor.Dependencies createDependencies(Function<Long, Long> addressOf) {
        return HDBPlusTree.createDependenciesInternal(this.innerNodeAccessor, this.lockManager, addressOf);
    }

    private void createEmptyTree(LockingContext lockingContext) {
        try {
            this.incrementBTreeDepthRootLocked(lockingContext);
        }
        catch (Throwable e) {
            this.dispose0(lockingContext);
            this.releaseLocks(lockingContext);
            throw e;
        }
        finally {
            assert (lockingContext.hasNoLocksAndPins());
        }
    }

    long getRoot() {
        return this.rootAddr;
    }

    public int getNodeSize() {
        return this.innerNodeAccessor.nodeSize;
    }

    private void incrementBTreeDepthRootLocked(LockingContext lockingContext) {
        long newChildAddr;
        int rootLevel = this.getNodeAccessor().getNodeLevel(this.rootAddr, lockingContext);
        if (rootLevel == 255) {
            this.releaseLock(this.rootAddr, lockingContext);
            throw new BPlusTreeLimitException("Failed to increment BTree's level. Reached the maximum 255");
        }
        long l = newChildAddr = rootLevel == 0 ? this.leafNodeAccessor.newNodeLocked(lockingContext) : this.innerNodeAccessor.newNodeLocked(lockingContext);
        if (rootLevel > 0) {
            this.innerNodeAccessor.copyNodeContent(this.rootAddr, newChildAddr, lockingContext);
            assert (this.innerNodeAccessor.getKeysCount(this.rootAddr, lockingContext) == this.innerNodeAccessor.getKeysCount(newChildAddr, lockingContext));
            assert (this.innerNodeAccessor.getNodeLevel(this.rootAddr, lockingContext) == this.innerNodeAccessor.getNodeLevel(newChildAddr, lockingContext));
        }
        this.getNodeAccessor().setNodeLevel(this.rootAddr, rootLevel + 1, lockingContext);
        this.getNodeAccessor().setKeysCount(this.rootAddr, 0, lockingContext);
        this.innerNodeAccessor.insertToEmptyNode(this.rootAddr, newChildAddr, lockingContext);
        this.releaseLock(this.rootAddr, lockingContext);
        this.releaseLock(newChildAddr, lockingContext);
    }

    @Override
    public NativeMemoryData insert(Comparable indexKey, NativeMemoryData entryKey, MemoryBlock value) {
        return this.insert(indexKey, entryKey, value == null ? 0L : value.address());
    }

    @Override
    public NativeMemoryData insert(Comparable indexKey, NativeMemoryData entryKey, long valueAddress) {
        LockingContext lockingContext = HDBPlusTree.getLockingContext();
        NativeMemoryData indexKeyData = this.leafNodeAccessor.toNativeData(indexKey);
        try {
            Comparable indexKey0 = this.getKeyComparator().wrapIndexKey(indexKey);
            NativeMemoryData nativeMemoryData = this.insert(indexKey0, indexKeyData, entryKey, valueAddress, lockingContext);
            return nativeMemoryData;
        }
        catch (Throwable e) {
            this.releaseLocks(lockingContext);
            throw e;
        }
        finally {
            this.leafNodeAccessor.disposeIndexKeyNative(indexKeyData);
            assert (lockingContext.hasNoLocksAndPins());
        }
    }

    private NativeMemoryData insert(Comparable indexKeyComparable, NativeMemoryData indexKey, NativeMemoryData entryKey, long valueAddress, LockingContext lockingContext) {
        NativeMemoryData oldValue;
        int candidateEntryLen = this.innerNodeAccessor.spaceNeeded(indexKey, entryKey);
        if (candidateEntryLen > this.maxIndexEntrySize) {
            throw new IllegalArgumentException("index entry size is too big, it should not exceed " + this.maxIndexEntrySize + " bytes.");
        }
        while (true) {
            long leafAddr;
            this.readLock(this.rootAddr, lockingContext);
            long nodeAddr = this.rootAddr;
            long parentAddr = 0L;
            while (this.getNodeAccessor().isInnerNode(nodeAddr, lockingContext)) {
                parentAddr = nodeAddr;
                nodeAddr = this.innerNodeAccessor.getChildNode(nodeAddr, indexKeyComparable, entryKey, lockingContext);
                if (this.getNodeAccessor().getNodeLevel(parentAddr, lockingContext) == 1) {
                    this.writeLock(nodeAddr, lockingContext);
                    break;
                }
                this.getNodeAccessor().unpinIfNotLastUnpinned(parentAddr, lockingContext);
                this.readLock(nodeAddr, lockingContext);
                this.releaseLockNoUnpin(parentAddr, lockingContext);
            }
            if (!this.leafNodeAccessor.canAccommodate(leafAddr = nodeAddr, candidateEntryLen, lockingContext)) {
                if (!this.upgradeToWriteLock(parentAddr, lockingContext)) {
                    this.releaseLock(parentAddr, lockingContext);
                    this.releaseLock(leafAddr, lockingContext);
                    this.splitNode(indexKeyComparable, entryKey, candidateEntryLen, lockingContext);
                    continue;
                }
                if (this.splitLockedLeafWithParentLocked(parentAddr, leafAddr, candidateEntryLen, lockingContext)) continue;
                this.splitNode(indexKeyComparable, entryKey, candidateEntryLen, lockingContext);
                continue;
            }
            this.releaseLock(parentAddr, lockingContext);
            oldValue = this.leafNodeAccessor.insert(leafAddr, indexKeyComparable, indexKey, entryKey, valueAddress, lockingContext);
            this.releaseLock(leafAddr, lockingContext);
            if (oldValue != TStoreAllocator.RETRY) break;
            int partition = this.getNodeAccessor().getKeyPartition(entryKey);
            this.getNodeAccessor().yield(partition);
        }
        return oldValue;
    }

    private void splitNode(Comparable indexKey, NativeMemoryData entryKey, int candidateEntryLen, LockingContext lockingContext) {
        int splitLevel = 0;
        block0: while (true) {
            assert (splitLevel >= 0);
            this.readLock(this.rootAddr, lockingContext);
            long nodeAddr = this.rootAddr;
            int rootLevel = this.getNodeAccessor().getNodeLevel(this.rootAddr, lockingContext);
            if (rootLevel == splitLevel) {
                if (this.upgradeToWriteLock(this.rootAddr, lockingContext)) {
                    this.incrementBTreeDepthRootLocked(lockingContext);
                    continue;
                }
                this.releaseLock(this.rootAddr, lockingContext);
                this.writeLock(this.rootAddr, lockingContext);
                rootLevel = this.getNodeAccessor().getNodeLevel(this.rootAddr, lockingContext);
                if (rootLevel == splitLevel) {
                    this.incrementBTreeDepthRootLocked(lockingContext);
                    continue;
                }
            } else if (rootLevel == splitLevel + 1 && !this.upgradeToWriteLock(nodeAddr, lockingContext)) {
                this.releaseLock(nodeAddr, lockingContext);
                this.writeLock(nodeAddr, lockingContext);
            }
            while (true) {
                long parentAddr = nodeAddr;
                nodeAddr = this.innerNodeAccessor.getChildNode(nodeAddr, indexKey, entryKey, lockingContext);
                int parentLevel = this.getNodeAccessor().getNodeLevel(parentAddr, lockingContext);
                if (parentLevel == splitLevel + 1) {
                    this.writeLock(nodeAddr, lockingContext);
                    if (splitLevel == 0 && this.splitLockedLeafWithParentLocked(parentAddr, nodeAddr, candidateEntryLen, lockingContext)) {
                        return;
                    }
                    if (splitLevel > 0 && this.splitLockedInnerWithParentLocked(parentAddr, nodeAddr, lockingContext)) {
                        --splitLevel;
                        continue block0;
                    }
                    ++splitLevel;
                    continue block0;
                }
                if (parentLevel == splitLevel + 2) {
                    this.getNodeAccessor().unpinIfNotLastUnpinned(parentAddr, lockingContext);
                    this.writeLock(nodeAddr, lockingContext);
                } else {
                    this.getNodeAccessor().unpinIfNotLastUnpinned(parentAddr, lockingContext);
                    this.readLock(nodeAddr, lockingContext);
                }
                this.releaseLockNoUnpin(parentAddr, lockingContext);
            }
            break;
        }
    }

    private boolean splitLockedLeafWithParentLocked(long parentAddr, long childAddr, int spaceNeededInLeaf, LockingContext lockingContext) {
        assert (this.getNodeAccessor().getNodeLevel(childAddr, lockingContext) == 0);
        if (this.leafNodeAccessor.canAccommodate(childAddr, spaceNeededInLeaf, lockingContext)) {
            this.releaseLock(parentAddr, lockingContext);
            this.releaseLock(childAddr, lockingContext);
            return true;
        }
        int sepSlot = this.leafNodeAccessor.getSeparationSlot(childAddr, lockingContext);
        if (!this.innerNodeAccessor.canAccommodate(parentAddr, this.leafNodeAccessor.spaceNeeded(childAddr, sepSlot, lockingContext), lockingContext)) {
            this.releaseLock(parentAddr, lockingContext);
            this.releaseLock(childAddr, lockingContext);
            return false;
        }
        long forwAddr = this.leafNodeAccessor.getForwNode(childAddr, lockingContext);
        if (forwAddr != 0L) {
            this.writeLock(forwAddr, lockingContext);
        }
        long sepIndexKeyAddr = this.leafNodeAccessor.getIndexKeyAddr(childAddr, sepSlot, lockingContext);
        long sepEntryKeyAddr = this.leafNodeAccessor.getEntryKeyAddr(childAddr, sepSlot, lockingContext);
        long newLeafAddr = 0L;
        try {
            newLeafAddr = this.leafNodeAccessor.split(childAddr, lockingContext);
        }
        catch (NativeOutOfMemoryError oom) {
            this.leafNodeAccessor.disposeNode(newLeafAddr);
            throw oom;
        }
        this.leafNodeAccessor.setForwNode(newLeafAddr, forwAddr, lockingContext);
        this.leafNodeAccessor.setBackNode(newLeafAddr, childAddr, lockingContext);
        if (forwAddr != 0L) {
            this.leafNodeAccessor.setBackNode(forwAddr, newLeafAddr, lockingContext);
            this.getNodeAccessor().incSequenceCounter(forwAddr, lockingContext);
        }
        this.leafNodeAccessor.setForwNode(childAddr, newLeafAddr, lockingContext);
        this.innerNodeAccessor.insert(parentAddr, sepIndexKeyAddr, sepEntryKeyAddr, newLeafAddr, lockingContext);
        this.releaseLock(parentAddr, lockingContext);
        this.releaseLock(childAddr, lockingContext);
        this.releaseLock(newLeafAddr, lockingContext);
        if (forwAddr != 0L) {
            this.releaseLock(forwAddr, lockingContext);
        }
        return true;
    }

    private boolean splitLockedInnerWithParentLocked(long parentAddr, long childAddr, LockingContext lockingContext) {
        assert (this.getNodeAccessor().getNodeLevel(childAddr, lockingContext) > 0);
        if (!this.innerNodeAccessor.isSplittable(childAddr, lockingContext)) {
            this.releaseLock(parentAddr, lockingContext);
            this.releaseLock(childAddr, lockingContext);
            return true;
        }
        int sepSlot = this.innerNodeAccessor.getSeparationSlot(childAddr, lockingContext);
        if (!this.innerNodeAccessor.canAccommodate(parentAddr, this.innerNodeAccessor.spaceNeeded(childAddr, sepSlot, lockingContext), lockingContext)) {
            this.releaseLock(parentAddr, lockingContext);
            this.releaseLock(childAddr, lockingContext);
            return false;
        }
        long newInnerAddr = this.innerNodeAccessor.split(childAddr, lockingContext);
        sepSlot = this.getNodeAccessor().getKeysCount(childAddr, lockingContext);
        long sepIndexKeyAddr = this.innerNodeAccessor.getIndexKeyAddr(childAddr, sepSlot, lockingContext);
        long sepEntryKeyAddr = this.innerNodeAccessor.getEntryKeyAddr(childAddr, sepSlot, lockingContext);
        this.innerNodeAccessor.insert(parentAddr, sepIndexKeyAddr, sepEntryKeyAddr, newInnerAddr, lockingContext);
        this.releaseLock(parentAddr, lockingContext);
        this.releaseLock(childAddr, lockingContext);
        this.releaseLock(newInnerAddr, lockingContext);
        return true;
    }

    @Override
    public Data remove(Comparable indexKey, NativeMemoryData entryKey) {
        LockingContext lockingContext = HDBPlusTree.getLockingContext();
        try {
            Comparable indexKey0 = this.getKeyComparator().wrapIndexKey(indexKey);
            Data data = this.remove(indexKey0, entryKey, lockingContext);
            return data;
        }
        catch (Throwable e) {
            this.releaseLocks(lockingContext);
            throw e;
        }
        finally {
            assert (lockingContext.hasNoLocksAndPins());
        }
    }

    private Data remove(Comparable indexKey, NativeMemoryData entryKey, LockingContext lockingContext) {
        Data oldValue;
        long nodeAddr;
        while (true) {
            this.readLock(this.rootAddr, lockingContext);
            nodeAddr = this.rootAddr;
            while (this.getNodeAccessor().isInnerNode(nodeAddr, lockingContext)) {
                long parentAddr = nodeAddr;
                nodeAddr = this.innerNodeAccessor.getChildNode(nodeAddr, indexKey, entryKey, lockingContext);
                if (this.getNodeAccessor().getNodeLevel(parentAddr, lockingContext) == 1) {
                    this.getNodeAccessor().unpinIfNotLastUnpinned(parentAddr, lockingContext);
                    this.writeLock(nodeAddr, lockingContext);
                } else {
                    this.getNodeAccessor().unpinIfNotLastUnpinned(parentAddr, lockingContext);
                    this.readLock(nodeAddr, lockingContext);
                }
                this.releaseLockNoUnpin(parentAddr, lockingContext);
            }
            oldValue = this.leafNodeAccessor.remove(nodeAddr, indexKey, entryKey, lockingContext);
            if (oldValue != TStoreAllocator.RETRY) break;
            this.releaseLock(nodeAddr, lockingContext);
            int partition = this.getNodeAccessor().getKeyPartition(entryKey);
            this.getNodeAccessor().yield(partition);
        }
        boolean emptyLeaf = this.getNodeAccessor().getKeysCount(nodeAddr, lockingContext) == 0;
        this.releaseLock(nodeAddr, lockingContext);
        if (emptyLeaf) {
            this.removeNodeFromBTree(indexKey, entryKey, lockingContext);
        }
        return oldValue;
    }

    private void removeNodeFromBTree(Comparable indexKey, NativeMemoryData entryKey, LockingContext lockingContext) {
        while (true) {
            this.readLock(this.rootAddr, lockingContext);
            long nodeAddr = this.rootAddr;
            int rootLevel = this.getNodeAccessor().getNodeLevel(this.rootAddr, lockingContext);
            assert (rootLevel >= 1);
            List<Long> innerNodes = Collections.emptyList();
            if (rootLevel == 1) {
                long childAddr;
                if (this.upgradeToWriteLock(this.rootAddr, lockingContext)) {
                    childAddr = this.innerNodeAccessor.getChildNode(this.rootAddr, indexKey, entryKey, lockingContext);
                    if (!this.removeNodeFromAncestorWriteLocked(indexKey, entryKey, childAddr, this.rootAddr, innerNodes, lockingContext)) continue;
                    return;
                }
                this.releaseLock(this.rootAddr, lockingContext);
                this.writeLock(this.rootAddr, lockingContext);
                rootLevel = this.getNodeAccessor().getNodeLevel(this.rootAddr, lockingContext);
                if (rootLevel == 1) {
                    childAddr = this.innerNodeAccessor.getChildNode(this.rootAddr, indexKey, entryKey, lockingContext);
                    if (!this.removeNodeFromAncestorWriteLocked(indexKey, entryKey, childAddr, this.rootAddr, innerNodes, lockingContext)) continue;
                    return;
                }
                this.releaseLock(this.rootAddr, lockingContext);
                continue;
            }
            long ancestorAddr = nodeAddr;
            while (this.getNodeAccessor().getNodeLevel(nodeAddr, lockingContext) > 1) {
                nodeAddr = this.innerNodeAccessor.getChildNode(nodeAddr, indexKey, entryKey, lockingContext);
                this.readLock(nodeAddr, lockingContext);
                if (this.getNodeAccessor().getKeysCount(nodeAddr, lockingContext) == 0) {
                    this.getNodeAccessor().unpinIfNotLastUnpinned(nodeAddr, lockingContext);
                    if (innerNodes.isEmpty()) {
                        innerNodes = new ArrayList<Long>();
                    }
                    innerNodes.add(nodeAddr);
                    continue;
                }
                this.releaseLock(ancestorAddr, lockingContext);
                this.releaseLocksNoUnpin(innerNodes, lockingContext);
                innerNodes = Collections.emptyList();
                ancestorAddr = nodeAddr;
            }
            long childAddr = this.innerNodeAccessor.getChildNode(nodeAddr, indexKey, entryKey, lockingContext);
            if (!this.upgradeToWriteLock(ancestorAddr, lockingContext) || !this.upgradeToWriteLockNoFetchNoPin(innerNodes)) {
                this.releaseLock(ancestorAddr, lockingContext);
                this.releaseLocksNoUnpin(innerNodes, lockingContext);
                this.instantDurationWriteLock(ancestorAddr, lockingContext);
                continue;
            }
            if (this.removeNodeFromAncestorWriteLocked(indexKey, entryKey, childAddr, ancestorAddr, innerNodes, lockingContext)) break;
        }
    }

    private boolean removeNodeFromAncestorWriteLocked(Comparable indexKey, NativeMemoryData entryKey, long childAddr, long ancestorAddr, List<Long> innerNodes, LockingContext lockingContext) {
        this.writeLock(childAddr, lockingContext);
        assert (this.getNodeAccessor().getNodeLevel(childAddr, lockingContext) == 0);
        long leftChildAddr = 0L;
        long rightChildAddr = 0L;
        boolean disposeNodes = false;
        assert (this.getNodeAccessor().getKeysCount(ancestorAddr, lockingContext) != 0 || ancestorAddr == this.rootAddr);
        if (this.getNodeAccessor().getKeysCount(childAddr, lockingContext) == 0 && this.getNodeAccessor().getKeysCount(ancestorAddr, lockingContext) != 0) {
            leftChildAddr = this.leafNodeAccessor.getBackNode(childAddr, lockingContext);
            if (leftChildAddr != 0L && !this.tryWriteLock(leftChildAddr, lockingContext)) {
                this.releaseLock(ancestorAddr, lockingContext);
                this.releaseLocksNoUnpin(innerNodes, lockingContext);
                this.releaseLock(childAddr, lockingContext);
                this.instantDurationWriteLock(leftChildAddr, lockingContext);
                return false;
            }
            assert (leftChildAddr == 0L || this.getNodeAccessor().getNodeLevel(leftChildAddr, lockingContext) == 0);
            rightChildAddr = this.leafNodeAccessor.getForwNode(childAddr, lockingContext);
            if (rightChildAddr != 0L) {
                this.writeLock(rightChildAddr, lockingContext);
                assert (this.getNodeAccessor().getNodeLevel(rightChildAddr, lockingContext) == 0);
            }
            assert (leftChildAddr == 0L || this.leafNodeAccessor.getForwNode(leftChildAddr, lockingContext) == childAddr);
            assert (rightChildAddr == 0L || this.leafNodeAccessor.getBackNode(rightChildAddr, lockingContext) == childAddr);
            this.innerNodeAccessor.remove(ancestorAddr, indexKey, entryKey, lockingContext);
            if (leftChildAddr != 0L) {
                this.leafNodeAccessor.setForwNode(leftChildAddr, rightChildAddr, lockingContext);
                this.getNodeAccessor().incSequenceCounter(leftChildAddr, lockingContext);
            }
            if (rightChildAddr != 0L) {
                this.leafNodeAccessor.setBackNode(rightChildAddr, leftChildAddr, lockingContext);
                this.getNodeAccessor().incSequenceCounter(rightChildAddr, lockingContext);
            }
            disposeNodes = true;
        }
        boolean unlockBeforeNodeDisposal = this.getNodeAccessor().requiresUnlockBeforeNodeDisposal();
        this.releaseLock(ancestorAddr, lockingContext);
        if (unlockBeforeNodeDisposal) {
            this.releaseLocksNoUnpin(innerNodes, lockingContext);
        }
        if (disposeNodes) {
            innerNodes.forEach(this.innerNodeAccessor::disposeNode);
        }
        if (!unlockBeforeNodeDisposal) {
            this.releaseLocksNoUnpin(innerNodes, lockingContext);
        }
        this.getNodeAccessor().unpinIfNotLastUnpinned(childAddr, lockingContext);
        if (unlockBeforeNodeDisposal) {
            this.releaseLockNoUnpin(childAddr, lockingContext);
        }
        if (disposeNodes) {
            this.leafNodeAccessor.disposeNode(childAddr);
        }
        if (!unlockBeforeNodeDisposal) {
            this.releaseLockNoUnpin(childAddr, lockingContext);
        }
        if (leftChildAddr != 0L) {
            this.releaseLock(leftChildAddr, lockingContext);
        }
        if (rightChildAddr != 0L) {
            this.releaseLock(rightChildAddr, lockingContext);
        }
        return true;
    }

    @Override
    public Iterator<T> lookup(Comparable indexKey) {
        if (indexKey == null) {
            throw new IllegalArgumentException("Index key cannot be null");
        }
        LockingContext lockingContext = HDBPlusTree.getLockingContext();
        this.beforeOperation();
        try {
            Comparable indexKey0 = this.getKeyComparator().wrapIndexKey(indexKey);
            Data fromEntryKey = MINUS_INFINITY_ENTRY_KEY;
            EntryIterator entryIterator = this.lookup0(indexKey0, fromEntryKey, true, indexKey0, true, false, false, lockingContext);
            Iterator<T> iterator = this.batchIterator(entryIterator, 8);
            return iterator;
        }
        catch (Throwable e) {
            this.releaseLocks(lockingContext);
            throw e;
        }
        finally {
            this.afterOperation(lockingContext);
            assert (lockingContext.hasNoLocksAndPins());
        }
    }

    private Iterator<T> lookup(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending, Data fromKey) {
        assert (from != null || fromKey == null);
        LockingContext lockingContext = HDBPlusTree.getLockingContext();
        this.beforeOperation();
        try {
            EntryIterator entryIterator;
            if (from == null) {
                entryIterator = this.getEntries0(to, toInclusive, descending, lockingContext);
            } else {
                Comparable from0 = this.getKeyComparator().wrapIndexKey(from);
                Comparable to0 = this.getKeyComparator().wrapIndexKey(to);
                Data fromEntryKey = fromKey != null ? fromKey : (descending ? (fromInclusive ? PLUS_INFINITY_ENTRY_KEY : MINUS_INFINITY_ENTRY_KEY) : (fromInclusive ? MINUS_INFINITY_ENTRY_KEY : PLUS_INFINITY_ENTRY_KEY));
                entryIterator = this.lookup0(from0, fromEntryKey, fromInclusive, to0, toInclusive, descending, false, lockingContext);
            }
            Iterator<T> iterator = this.batchIterator(entryIterator, this.btreeScanBatchSize);
            return iterator;
        }
        catch (Throwable e) {
            this.releaseLocks(lockingContext);
            throw e;
        }
        finally {
            this.afterOperation(lockingContext);
            assert (lockingContext.hasNoLocksAndPins());
        }
    }

    @Override
    public Iterator<T> lookup(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending) {
        return this.lookup(from, fromInclusive, to, toInclusive, descending, null);
    }

    @Override
    public Iterator<IndexKeyEntries> lookupBatch(Comparable from, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending, Data fromKey) {
        Iterator<T> it = this.lookup(from, fromInclusive, to, toInclusive, descending, fromKey);
        return new IndexKeyEntriesIterator((IteratorWithMemory)it);
    }

    private Iterator<T> batchIterator(EntryIterator it, int batchInitialSize) {
        if (this.btreeScanBatchSize > 0) {
            EntryBatch<Object> entryBatch = new EntryBatch<Object>(batchInitialSize, this.btreeScanBatchSize);
            if (it.hasNext()) {
                Object next = it.next();
                entryBatch.add(new EntryBatchItem<Object>(next, it.getLastKeyRead()));
            }
            return new BatchingEntryIterator(it, entryBatch);
        }
        return it;
    }

    @Override
    public Iterator<Data> keys() {
        LockingContext lockingContext = HDBPlusTree.getLockingContext();
        this.beforeOperation();
        try {
            EntryIterator entryIterator = this.getEntries0(false, lockingContext);
            KeyIterator keyIterator = new KeyIterator(entryIterator);
            return keyIterator;
        }
        catch (Throwable e) {
            this.releaseLocks(lockingContext);
            throw e;
        }
        finally {
            this.afterOperation(lockingContext);
            assert (lockingContext.hasNoLocksAndPins());
        }
    }

    private EntryIterator lookup0(Comparable from, Data fromEntryKey, boolean fromInclusive, Comparable to, boolean toInclusive, boolean descending, boolean resync, LockingContext lockingContext) {
        EntryIterator it;
        long nodeAddr;
        assert (fromEntryKey != null || fromInclusive);
        while (true) {
            boolean lastSlot;
            int slot;
            boolean skipCurrentSlot;
            int keysCount;
            block18: {
                int mid;
                nodeAddr = this.rootAddr;
                this.readLock(this.rootAddr, lockingContext);
                while (this.getNodeAccessor().isInnerNode(nodeAddr, lockingContext)) {
                    long parentAddr = nodeAddr;
                    nodeAddr = this.innerNodeAccessor.getChildNode(nodeAddr, from, fromEntryKey, lockingContext);
                    this.getNodeAccessor().unpinIfNotLastUnpinned(parentAddr, lockingContext);
                    this.readLock(nodeAddr, lockingContext);
                    this.releaseLockNoUnpin(parentAddr, lockingContext);
                }
                it = new EntryIterator(to, toInclusive, descending);
                if ((nodeAddr = this.skipToNonEmptyNodeLocked(nodeAddr, descending, lockingContext)) == -1L) continue;
                if (nodeAddr == 0L) {
                    it.setNextEntryNull();
                    return it;
                }
                keysCount = this.getNodeAccessor().getKeysCount(nodeAddr, lockingContext);
                int lower = 0;
                int upper = keysCount - 1;
                skipCurrentSlot = false;
                while (true) {
                    if (upper < lower) {
                        if (descending) {
                            if (upper == -1) {
                                slot = lower;
                                skipCurrentSlot = true;
                            } else {
                                slot = upper;
                            }
                        } else if (lower == keysCount) {
                            slot = upper;
                            skipCurrentSlot = true;
                        } else {
                            slot = lower;
                        }
                        break block18;
                    }
                    mid = (upper + lower) / 2;
                    CompositeKeyComparison cmp = this.leafNodeAccessor.compareKeys(from, fromEntryKey, nodeAddr, mid, lockingContext);
                    if (CompositeKeyComparison.less(cmp)) {
                        upper = mid - 1;
                        continue;
                    }
                    if (!CompositeKeyComparison.greater(cmp)) break;
                    lower = mid + 1;
                }
                slot = mid;
                skipCurrentSlot = !fromInclusive;
            }
            assert (slot < keysCount);
            it.nextSlot = slot;
            it.sequenceNumber = this.getNodeAccessor().getSequenceNumber(nodeAddr, lockingContext);
            it.logicalAddress = this.getNodeAccessor().translateToLogical(nodeAddr, lockingContext);
            it.currentNodeAddr = nodeAddr;
            int slotStatus = it.tryLockAndCheckNextSlotIsWithinRange(lockingContext);
            if (slotStatus == 2) continue;
            if (slotStatus != 0 || !skipCurrentSlot) break;
            it.next();
            boolean bl = descending ? slot == 0 : (lastSlot = slot == keysCount - 1);
            if (!lastSlot) {
                it.nextSlot = descending ? slot - 1 : slot + 1;
            } else {
                nodeAddr = this.skipToNextNonEmptyNode(it.currentNodeAddr, descending, lockingContext);
                if (nodeAddr == -1L) continue;
                if (nodeAddr == 0L) {
                    it.setNextEntryNull();
                    return it;
                }
                it.sequenceNumber = this.getNodeAccessor().getSequenceNumber(nodeAddr, lockingContext);
                it.logicalAddress = this.getNodeAccessor().translateToLogical(nodeAddr, lockingContext);
                it.currentNodeAddr = nodeAddr;
                int n = it.nextSlot = descending ? this.getNodeAccessor().getKeysCount(nodeAddr, lockingContext) - 1 : 0;
            }
            if ((slotStatus = it.tryLockAndCheckNextSlotIsWithinRange(lockingContext)) != 2) break;
        }
        if (!resync || it.nextSlot == -1) {
            this.releaseLock(nodeAddr, lockingContext);
        }
        return it;
    }

    private EntryIterator getEntries0(Comparable to, boolean toInclusive, boolean descending, LockingContext lockingContext) {
        EntryIterator it;
        long nodeAddr;
        while (true) {
            nodeAddr = this.rootAddr;
            this.readLock(this.rootAddr, lockingContext);
            while (this.getNodeAccessor().isInnerNode(nodeAddr, lockingContext)) {
                long parentAddr = nodeAddr;
                nodeAddr = this.innerNodeAccessor.getValueAddr(nodeAddr, descending ? this.getNodeAccessor().getKeysCount(nodeAddr, lockingContext) : 0, lockingContext);
                this.getNodeAccessor().unpinIfNotLastUnpinned(parentAddr, lockingContext);
                this.readLock(nodeAddr, lockingContext);
                this.releaseLockNoUnpin(parentAddr, lockingContext);
            }
            it = new EntryIterator(to, toInclusive, descending);
            if ((nodeAddr = this.skipToNonEmptyNodeLocked(nodeAddr, descending, lockingContext)) == -1L) continue;
            if (nodeAddr == 0L) {
                it.setNextEntryNull();
                return it;
            }
            int keysCount = this.getNodeAccessor().getKeysCount(nodeAddr, lockingContext);
            it.nextSlot = descending ? keysCount - 1 : 0;
            it.sequenceNumber = this.getNodeAccessor().getSequenceNumber(nodeAddr, lockingContext);
            it.logicalAddress = this.getNodeAccessor().translateToLogical(nodeAddr, lockingContext);
            it.currentNodeAddr = nodeAddr;
            int slotStatus = it.tryLockAndCheckNextSlotIsWithinRange(lockingContext);
            if (slotStatus != 2) break;
        }
        this.releaseLock(nodeAddr, lockingContext);
        return it;
    }

    private EntryIterator getEntries0(boolean descending, LockingContext lockingContext) {
        return this.getEntries0(null, true, descending, lockingContext);
    }

    private long skipToNextNonEmptyNode(long nodeAddr, boolean descending, LockingContext lockingContext) {
        long nextAddr;
        long l = nextAddr = descending ? this.leafNodeAccessor.getBackNode(nodeAddr, lockingContext) : this.leafNodeAccessor.getForwNode(nodeAddr, lockingContext);
        if (nextAddr == 0L) {
            this.releaseLock(nodeAddr, lockingContext);
            return 0L;
        }
        if (descending) {
            if (!this.tryReadLockAndUnpin(nextAddr, nodeAddr, lockingContext)) {
                this.releaseLock(nodeAddr, lockingContext);
                this.instantDurationReadLock(nextAddr, lockingContext);
                return -1L;
            }
            this.releaseLockNoUnpin(nodeAddr, lockingContext);
            return this.skipToNonEmptyNodeLocked(nextAddr, descending, lockingContext);
        }
        this.getNodeAccessor().unpinIfNotLastUnpinned(nodeAddr, lockingContext);
        this.readLock(nextAddr, lockingContext);
        this.releaseLockNoUnpin(nodeAddr, lockingContext);
        return this.skipToNonEmptyNodeLocked(nextAddr, descending, lockingContext);
    }

    private long skipToNonEmptyNodeLocked(long nodeAddr, boolean descending, LockingContext lockingContext) {
        if (nodeAddr == 0L) {
            return 0L;
        }
        long currentNodeAddr = nodeAddr;
        while (this.getNodeAccessor().getKeysCount(currentNodeAddr, lockingContext) == 0) {
            if (descending) {
                long backAddr = this.leafNodeAccessor.getBackNode(currentNodeAddr, lockingContext);
                if (backAddr == 0L) {
                    this.releaseLock(currentNodeAddr, lockingContext);
                    return 0L;
                }
                if (this.tryReadLockAndUnpin(backAddr, currentNodeAddr, lockingContext)) {
                    this.releaseLockNoUnpin(currentNodeAddr, lockingContext);
                    currentNodeAddr = backAddr;
                    continue;
                }
                this.releaseLock(currentNodeAddr, lockingContext);
                this.instantDurationReadLock(backAddr, lockingContext);
                return -1L;
            }
            long forwAddr = this.leafNodeAccessor.getForwNode(currentNodeAddr, lockingContext);
            if (forwAddr == 0L) {
                this.releaseLock(currentNodeAddr, lockingContext);
                return 0L;
            }
            this.getNodeAccessor().unpinIfNotLastUnpinned(currentNodeAddr, lockingContext);
            this.readLock(forwAddr, lockingContext);
            this.releaseLockNoUnpin(currentNodeAddr, lockingContext);
            currentNodeAddr = forwAddr;
        }
        return currentNodeAddr;
    }

    @Override
    public void clear() {
        LockingContext lockingContext = HDBPlusTree.getLockingContext();
        try {
            this.clear0(lockingContext);
        }
        catch (Throwable e) {
            this.releaseLocks(lockingContext);
            throw e;
        }
        finally {
            assert (lockingContext.hasNoLocksAndPins());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear0(LockingContext lockingContext) {
        HDBTreeLeafNodeAccessor nodeBaseAccessor = this.leafNodeAccessor;
        Object object = this.clearMutex;
        synchronized (object) {
            ArrayList<Long> nodes = new ArrayList<Long>();
            this.collectNodesForRemove(this.rootAddr, nodes, lockingContext);
            this.getNodeAccessor().ensureWritable(this.rootAddr, lockingContext);
            this.getNodeAccessor().setNodeLevel(this.rootAddr, 1, lockingContext);
            this.getNodeAccessor().setKeysCount(this.rootAddr, 0, lockingContext);
            long newChildAddr = this.leafNodeAccessor.newNodeLocked(lockingContext);
            this.getNodeAccessor().ensureWritable(this.rootAddr, lockingContext);
            this.innerNodeAccessor.insertToEmptyNode(this.rootAddr, newChildAddr, lockingContext);
            this.releaseLock(newChildAddr, lockingContext);
            boolean unlockBeforeNodeDisposal = this.getNodeAccessor().requiresUnlockBeforeNodeDisposal();
            if (unlockBeforeNodeDisposal) {
                nodes.forEach(addr -> this.releaseLockNoUnpin((long)addr, lockingContext));
            }
            nodes.forEach(addr -> {
                if (addr != this.rootAddr) {
                    nodeBaseAccessor.disposeNode((long)addr);
                }
            });
            if (!unlockBeforeNodeDisposal) {
                nodes.forEach(addr -> this.releaseLockNoUnpin((long)addr, lockingContext));
            }
        }
    }

    @Override
    public void dispose() {
        LockingContext lockingContext = HDBPlusTree.getLockingContext();
        try {
            this.dispose0(lockingContext);
        }
        catch (Throwable e) {
            this.releaseLocks(lockingContext);
            throw e;
        }
        finally {
            assert (lockingContext.hasNoLocksAndPins());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose0(LockingContext lockingContext) {
        HDBTreeLeafNodeAccessor nodeBaseAccessor = this.leafNodeAccessor;
        Object object = this.clearMutex;
        synchronized (object) {
            if (this.isDisposed) {
                return;
            }
            ArrayList<Long> nodes = new ArrayList<Long>();
            this.collectNodesForRemove(this.rootAddr, nodes, lockingContext);
            boolean unlockBeforeNodeDisposal = this.getNodeAccessor().requiresUnlockBeforeNodeDisposal();
            if (unlockBeforeNodeDisposal) {
                this.isDisposed = true;
                nodes.forEach(addr -> this.releaseLockNoUnpin((long)addr, lockingContext));
            }
            nodes.forEach(nodeBaseAccessor::disposeNode);
            if (!unlockBeforeNodeDisposal) {
                this.isDisposed = true;
                nodes.forEach(addr -> this.releaseLockNoUnpin((long)addr, lockingContext));
            }
        }
    }

    private void collectNodesForRemove(long nodeAddr, List<Long> nodes, LockingContext lockingContext) {
        this.writeLockNoFetchNoPin(nodeAddr, lockingContext);
        nodes.add(nodeAddr);
        this.getNodeAccessor().ensureWritable(nodeAddr, lockingContext);
        int nodeLevel = this.getNodeAccessor().getNodeLevel(nodeAddr, lockingContext);
        assert (nodeLevel >= 1);
        int keysCount = this.getNodeAccessor().getKeysCount(nodeAddr, lockingContext);
        this.getNodeAccessor().incSequenceCounter(nodeAddr, lockingContext);
        for (int i = 0; i <= keysCount; ++i) {
            this.getNodeAccessor().ensureReadable(nodeAddr, lockingContext);
            long childAddr = this.innerNodeAccessor.getValueAddr(nodeAddr, i, lockingContext);
            if (nodeLevel > 1) {
                this.collectNodesForRemove(childAddr, nodes, lockingContext);
                continue;
            }
            this.writeLockNoFetchNoPin(childAddr, lockingContext);
            nodes.add(childAddr);
            this.getNodeAccessor().ensureWritable(childAddr, lockingContext);
            this.getNodeAccessor().incSequenceCounter(childAddr, lockingContext);
        }
    }

    private static LockingContext getLockingContext() {
        LockingContext context = LOCKING_CONTEXT.get();
        assert (context.hasNoLocksAndPins());
        context.replaceAddressToPin(0L);
        return context;
    }

    private static LockingContext newLockingContext() {
        return new LockingContext();
    }

    private void readLock(long nodeAddr, LockingContext lockingContext) {
        this.getNodeAccessor().pinAndReplaceLastUnpinned(nodeAddr, lockingContext);
        long lockAddr = this.getNodeAccessor().getLockStateAddr(nodeAddr);
        if (this.lockManager.tryReadLock(lockAddr)) {
            lockingContext.addLock(lockAddr);
            this.checkIfDisposed();
        } else {
            this.beforeLock();
            this.lockManager.readLock(lockAddr);
            this.afterLock(lockAddr, lockingContext);
        }
        this.getNodeAccessor().ensureReadable(nodeAddr, lockingContext);
    }

    private void readLockNoFetchNoPin(long nodeAddr, LockingContext lockingContext) {
        assert (lockingContext.hasNoUnpinnedAddress());
        long lockAddr = this.getNodeAccessor().getLockStateAddr(nodeAddr);
        if (this.lockManager.tryReadLock(lockAddr)) {
            lockingContext.addLock(lockAddr);
            this.checkIfDisposed();
        } else {
            this.beforeLock();
            this.lockManager.readLock(lockAddr);
            this.afterLock(lockAddr, lockingContext);
        }
    }

    private boolean tryReadLockAndUnpin(long nodeAddr, long unpinAddr, LockingContext lockingContext) {
        long lockAddr = this.getNodeAccessor().getLockStateAddr(nodeAddr);
        if (this.lockManager.tryReadLock(lockAddr)) {
            lockingContext.addLock(lockAddr);
            this.getNodeAccessor().unpinIfNotLastUnpinned(unpinAddr, lockingContext);
            this.getNodeAccessor().pinAndReplaceLastUnpinned(nodeAddr, lockingContext);
            this.getNodeAccessor().ensureReadable(nodeAddr, lockingContext);
            return true;
        }
        return false;
    }

    private void instantDurationReadLock(long nodeAddr, LockingContext lockingContext) {
        assert (lockingContext.hasNoUnpinnedAddress());
        long lockAddr = this.getNodeAccessor().getLockStateAddr(nodeAddr);
        if (!this.lockManager.tryInstantDurationReadLock(lockAddr)) {
            this.beforeLock();
            this.lockManager.instantDurationReadLock(lockAddr);
            this.afterLock();
        }
    }

    private void releaseLock(long nodeAddr, LockingContext lockingContext) {
        this.getNodeAccessor().unpinIfNotLastUnpinned(nodeAddr, lockingContext);
        long lockAddr = this.getNodeAccessor().getLockStateAddr(nodeAddr);
        this.lockManager.releaseLock(lockAddr);
        lockingContext.removeLock(lockAddr);
    }

    private void releaseLockNoUnpin(long nodeAddr, LockingContext lockingContext) {
        long lockAddr = this.getNodeAccessor().getLockStateAddr(nodeAddr);
        this.lockManager.releaseLock(lockAddr);
        lockingContext.removeLock(lockAddr);
    }

    private void writeLock(long nodeAddr, LockingContext lockingContext) {
        this.getNodeAccessor().pinAndReplaceLastUnpinned(-nodeAddr, lockingContext);
        long lockAddr = this.getNodeAccessor().getLockStateAddr(nodeAddr);
        if (this.lockManager.tryWriteLock(lockAddr)) {
            lockingContext.addLock(lockAddr);
            this.checkIfDisposed();
        } else {
            this.beforeLock();
            this.lockManager.writeLock(lockAddr);
            this.afterLock(lockAddr, lockingContext);
        }
        this.getNodeAccessor().ensureWritable(nodeAddr, lockingContext);
    }

    private void writeLockNoFetchNoPin(long nodeAddr, LockingContext lockingContext) {
        assert (lockingContext.hasNoUnpinnedAddress());
        long lockAddr = this.getNodeAccessor().getLockStateAddr(nodeAddr);
        if (this.lockManager.tryWriteLock(lockAddr)) {
            lockingContext.addLock(lockAddr);
            this.checkIfDisposed();
        } else {
            this.beforeLock();
            this.lockManager.writeLock(lockAddr);
            this.afterLock(lockAddr, lockingContext);
        }
    }

    private boolean upgradeToWriteLock(long nodeAddr, LockingContext lockingContext) {
        long lockAddr = this.getNodeAccessor().getLockStateAddr(nodeAddr);
        boolean upgraded = this.lockManager.tryUpgradeToWriteLock(lockAddr);
        if (upgraded) {
            this.getNodeAccessor().upgradeToWritable(nodeAddr, lockingContext);
        }
        return upgraded;
    }

    private boolean upgradeToWriteLockNoFetchNoPin(long nodeAddr) {
        long lockAddr = this.getNodeAccessor().getLockStateAddr(nodeAddr);
        return this.lockManager.tryUpgradeToWriteLock(lockAddr);
    }

    private void instantDurationWriteLock(long nodeAddr, LockingContext lockingContext) {
        assert (lockingContext.hasNoUnpinnedAddress());
        long lockAddr = this.getNodeAccessor().getLockStateAddr(nodeAddr);
        if (!this.lockManager.tryInstantDurationWriteLock(lockAddr)) {
            this.beforeLock();
            this.lockManager.instantDurationWriteLock(lockAddr);
            this.afterLock();
        }
    }

    private boolean tryWriteLock(long nodeAddr, LockingContext lockingContext) {
        long lockAddr = this.getNodeAccessor().getLockStateAddr(nodeAddr);
        if (this.lockManager.tryWriteLock(lockAddr)) {
            lockingContext.addLock(lockAddr);
            this.getNodeAccessor().pinAndReplaceLastUnpinned(-nodeAddr, lockingContext);
            this.getNodeAccessor().ensureWritable(nodeAddr, lockingContext);
            return true;
        }
        return false;
    }

    private void releaseLocksNoUnpin(List<Long> nodeAddrs, LockingContext lockingContext) {
        nodeAddrs.forEach(nodeAddr -> this.releaseLockNoUnpin((long)nodeAddr, lockingContext));
    }

    private void releaseLocks(LockingContext lockingContext) {
        lockingContext.releasePins(this.getNodeAccessor()::unpin);
        lockingContext.releaseLocks(this.lockManager);
    }

    private boolean upgradeToWriteLockNoFetchNoPin(List<Long> nodeAddrs) {
        for (long nodeAddr : nodeAddrs) {
            if (this.upgradeToWriteLockNoFetchNoPin(nodeAddr)) continue;
            return false;
        }
        return true;
    }

    private void checkIfDisposed() {
        if (this.isDisposed) {
            this.throwDisposed(null);
        }
    }

    private void throwDisposed(Throwable cause) {
        DistributedObjectDestroyedException e = new DistributedObjectDestroyedException("Disposed B+tree cannot be accessed.");
        e.initCause(cause);
        throw e;
    }

    public HDBTreeNodeBaseAccessor getNodeAccessor() {
        return this.innerNodeAccessor;
    }

    BPlusTreeKeyComparator getKeyComparator() {
        return this.leafNodeAccessor.keyComparator;
    }

    void setNodeSplitStrategy(NodeSplitStrategy nodeSplitStrategy) {
        this.leafNodeAccessor.setNodeSplitStrategy(nodeSplitStrategy);
        this.innerNodeAccessor.setNodeSplitStrategy(nodeSplitStrategy);
    }

    boolean isDisposed() {
        return this.isDisposed;
    }

    private void beforeOperation() {
        this.getNodeAccessor().beforeOperation();
    }

    private void afterOperation(LockingContext lockingContext) {
        try {
            this.getNodeAccessor().afterOperation(lockingContext);
        }
        catch (IllegalStateException e) {
            this.throwDisposed(e);
        }
    }

    private void beforeLock() {
        try {
            this.getNodeAccessor().beforeLock();
        }
        catch (IllegalStateException e) {
            this.throwDisposed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterLock(long lockAddr, LockingContext lockingContext) {
        lockingContext.addLock(lockAddr);
        try {
            this.checkIfDisposed();
        }
        finally {
            this.afterLock();
        }
    }

    private void afterLock() {
        try {
            this.getNodeAccessor().afterLock();
        }
        catch (IllegalStateException e) {
            this.throwDisposed(e);
        }
    }

    private class EntryIterator
    implements IteratorWithMemory<T> {
        final Comparable to;
        final boolean toInclusive;
        final boolean descending;
        int lastSlot = -1;
        int nextSlot = -1;
        T nextEntry;
        T lastEntry;
        Data nextIndexKey;
        Data lastIndexKey;
        long currentNodeAddr;
        long sequenceNumber;
        long logicalAddress;

        EntryIterator(Comparable to, boolean toInclusive, boolean descending) {
            this.to = to;
            this.toInclusive = toInclusive;
            this.descending = descending;
        }

        @Override
        public boolean hasNext() {
            if (this.nextSlot != -1) {
                return true;
            }
            this.nextEntry();
            return this.nextSlot != -1;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastSlot = this.nextSlot;
            this.lastEntry = this.nextEntry;
            this.lastIndexKey = this.nextIndexKey;
            this.nextSlot = -1;
            Object lastEntry = this.nextEntry;
            this.nextEntry = null;
            this.nextIndexKey = null;
            return lastEntry;
        }

        void nextEntry() {
            LockingContext lockingContext = HDBPlusTree.getLockingContext();
            try {
                this.nextBatch0(null, lockingContext);
            }
            catch (Throwable e) {
                HDBPlusTree.this.releaseLocks(lockingContext);
                throw e;
            }
            finally {
                assert (lockingContext.hasNoLocksAndPins());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void nextBatch0(EntryBatch entryBatch, LockingContext lockingContext) {
            assert (this.nextSlot == -1);
            assert (entryBatch == null || entryBatch.hasCapacity());
            if (this.lastSlot == -1) {
                return;
            }
            HDBPlusTree.this.beforeOperation();
            try {
                boolean advance = true;
                block8: while (true) {
                    int slotStatus;
                    if (!this.validateAndLock(this.currentNodeAddr, lockingContext)) {
                        Data lastEntryKeyData = ((QueryableEntry)this.lastEntry).getKeyData();
                        Comparable lastIndexKey = (Comparable)HDBPlusTree.this.ess.toObject(this.lastIndexKey);
                        Comparable wrappedLastIndexKey = HDBPlusTree.this.getKeyComparator().wrapIndexKey(lastIndexKey);
                        EntryIterator resyncedIt = HDBPlusTree.this.lookup0(wrappedLastIndexKey, lastEntryKeyData, false, this.to, this.toInclusive, this.descending, true, lockingContext);
                        if (resyncedIt.nextSlot == -1) {
                            this.setNextEntryNull();
                            return;
                        }
                        this.sequenceNumber = resyncedIt.sequenceNumber;
                        this.logicalAddress = resyncedIt.logicalAddress;
                        this.currentNodeAddr = resyncedIt.currentNodeAddr;
                        this.nextSlot = resyncedIt.nextSlot;
                        this.nextEntry = resyncedIt.nextEntry;
                        this.nextIndexKey = resyncedIt.nextIndexKey;
                        if (entryBatch == null) {
                            HDBPlusTree.this.releaseLock(this.currentNodeAddr, lockingContext);
                            return;
                        }
                        this.next();
                        entryBatch.add(new EntryBatchItem(this.lastEntry, this.lastIndexKey));
                        advance = true;
                    }
                    do {
                        assert (!advance || this.lastSlot >= 0 && (HDBPlusTree.this.getNodeAccessor().getKeysCount(this.currentNodeAddr, lockingContext) == 0 || this.lastSlot < HDBPlusTree.this.getNodeAccessor().getKeysCount(this.currentNodeAddr, lockingContext))) : "lastSlot=" + this.lastSlot + ", nextSlot=" + this.nextSlot + ", getKeysCount(currentNodeAddr)=" + HDBPlusTree.this.getNodeAccessor().getKeysCount(this.currentNodeAddr, lockingContext);
                        if (advance && this.descending) {
                            if (this.lastSlot == 0) {
                                do {
                                    long backAddr;
                                    if ((backAddr = HDBPlusTree.this.leafNodeAccessor.getBackNode(this.currentNodeAddr, lockingContext)) == 0L) {
                                        this.setNextEntryNull();
                                        HDBPlusTree.this.releaseLock(this.currentNodeAddr, lockingContext);
                                        return;
                                    }
                                    if (!HDBPlusTree.this.tryReadLockAndUnpin(backAddr, this.currentNodeAddr, lockingContext)) {
                                        HDBPlusTree.this.releaseLock(this.currentNodeAddr, lockingContext);
                                        if (entryBatch != null && entryBatch.size() > 0) {
                                            return;
                                        }
                                        HDBPlusTree.this.instantDurationReadLock(backAddr, lockingContext);
                                        continue block8;
                                    }
                                    HDBPlusTree.this.releaseLockNoUnpin(this.currentNodeAddr, lockingContext);
                                    this.currentNodeAddr = backAddr;
                                    this.sequenceNumber = HDBPlusTree.this.getNodeAccessor().getSequenceNumber(this.currentNodeAddr, lockingContext);
                                    this.logicalAddress = HDBPlusTree.this.getNodeAccessor().translateToLogical(this.currentNodeAddr, lockingContext);
                                    this.nextSlot = HDBPlusTree.this.getNodeAccessor().getKeysCount(this.currentNodeAddr, lockingContext) - 1;
                                } while (HDBPlusTree.this.getNodeAccessor().getKeysCount(this.currentNodeAddr, lockingContext) == 0);
                            } else {
                                this.nextSlot = this.lastSlot - 1;
                            }
                        } else if (advance) {
                            if (this.lastSlot == HDBPlusTree.this.getNodeAccessor().getKeysCount(this.currentNodeAddr, lockingContext) - 1) {
                                do {
                                    long forwAddr;
                                    if ((forwAddr = HDBPlusTree.this.leafNodeAccessor.getForwNode(this.currentNodeAddr, lockingContext)) == 0L) {
                                        this.setNextEntryNull();
                                        HDBPlusTree.this.releaseLock(this.currentNodeAddr, lockingContext);
                                        return;
                                    }
                                    HDBPlusTree.this.getNodeAccessor().unpinIfNotLastUnpinned(this.currentNodeAddr, lockingContext);
                                    HDBPlusTree.this.readLock(forwAddr, lockingContext);
                                    HDBPlusTree.this.releaseLockNoUnpin(this.currentNodeAddr, lockingContext);
                                    this.currentNodeAddr = forwAddr;
                                    this.sequenceNumber = HDBPlusTree.this.getNodeAccessor().getSequenceNumber(this.currentNodeAddr, lockingContext);
                                    this.logicalAddress = HDBPlusTree.this.getNodeAccessor().translateToLogical(this.currentNodeAddr, lockingContext);
                                    this.nextSlot = 0;
                                } while (HDBPlusTree.this.getNodeAccessor().getKeysCount(this.currentNodeAddr, lockingContext) == 0);
                            } else {
                                this.nextSlot = this.lastSlot + 1;
                            }
                        }
                        slotStatus = this.tryLockAndCheckNextSlotIsWithinRange(lockingContext);
                        if (slotStatus == 2) {
                            advance = false;
                            continue block8;
                        }
                        advance = true;
                        if (entryBatch == null || slotStatus != 0) continue;
                        this.next();
                        entryBatch.add(new EntryBatchItem(this.lastEntry, this.lastIndexKey));
                    } while (entryBatch != null && entryBatch.hasCapacity() && slotStatus == 0);
                    break;
                }
                HDBPlusTree.this.releaseLock(this.currentNodeAddr, lockingContext);
                return;
            }
            finally {
                HDBPlusTree.this.afterOperation(lockingContext);
            }
        }

        int tryLockAndCheckNextSlotIsWithinRange(LockingContext lockingContext) {
            if (this.to == null) {
                return this.tryLockAndSetNextEntry(lockingContext) ? 0 : 2;
            }
            if (this.nextSlot != -1) {
                CompositeKeyComparison cmp = HDBPlusTree.this.leafNodeAccessor.compareKeys(this.to, null, this.currentNodeAddr, this.nextSlot, true, lockingContext);
                if (this.descending && (this.toInclusive && CompositeKeyComparison.lessOrEqual(cmp) || !this.toInclusive && CompositeKeyComparison.less(cmp)) || !this.descending && (this.toInclusive && CompositeKeyComparison.greaterOrEqual(cmp) || !this.toInclusive && CompositeKeyComparison.greater(cmp))) {
                    return this.tryLockAndSetNextEntry(lockingContext) ? 0 : 2;
                }
            }
            this.setNextEntryNull();
            return 1;
        }

        private boolean validateAndLock(long nodeAddr, LockingContext lockingContext) {
            HDBPlusTree.this.readLockNoFetchNoPin(nodeAddr, lockingContext);
            if (!HDBPlusTree.this.getNodeAccessor().isAllocated(nodeAddr) || this.logicalAddress != HDBPlusTree.this.getNodeAccessor().translateToLogical(nodeAddr, lockingContext)) {
                HDBPlusTree.this.releaseLockNoUnpin(nodeAddr, lockingContext);
                return false;
            }
            HDBPlusTree.this.getNodeAccessor().pinAndReplaceLastUnpinned(nodeAddr, lockingContext);
            HDBPlusTree.this.getNodeAccessor().ensureReadable(nodeAddr, lockingContext);
            if (this.sequenceNumber != HDBPlusTree.this.getNodeAccessor().getSequenceNumber(nodeAddr, lockingContext)) {
                HDBPlusTree.this.releaseLock(nodeAddr, lockingContext);
                return false;
            }
            return true;
        }

        private void setNextEntryNull() {
            this.lastSlot = -1;
            this.nextSlot = -1;
            this.nextEntry = null;
            this.nextIndexKey = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tryLockAndSetNextEntry(LockingContext lockingContext) {
            long cookie;
            NativeMemoryData lastEntryKey = HDBPlusTree.this.leafNodeAccessor.getEntryKey(this.currentNodeAddr, this.nextSlot, lockingContext);
            long keyHash = HDBPlusTree.this.getNodeAccessor().getKeyHash64(lastEntryKey);
            int partition = HDBPlusTree.this.getNodeAccessor().getKeyPartition(lastEntryKey);
            if (!lockingContext.hasPartition(partition)) {
                HDBPlusTree.this.leafNodeAccessor.beforePartitionOperation(partition, lockingContext);
            }
            if ((cookie = HDBPlusTree.this.getNodeAccessor().tryLockRecord(partition, keyHash)) == 0L) {
                HDBPlusTree.this.releaseLock(this.currentNodeAddr, lockingContext);
                return false;
            }
            if (cookie == -1L) {
                HDBPlusTree.this.releaseLock(this.currentNodeAddr, lockingContext);
                HDBPlusTree.this.getNodeAccessor().yield(partition);
                return false;
            }
            if (cookie < 0L) {
                HDBPlusTree.this.releaseLock(this.currentNodeAddr, lockingContext);
                HDBPlusTree.this.getNodeAccessor().waitUntilRecordUnlocked(partition, keyHash, cookie);
                return false;
            }
            try {
                Data lastIndexKey = HDBPlusTree.this.leafNodeAccessor.getIndexKeyHeapData(this.currentNodeAddr, this.nextSlot, lockingContext);
                Data lastValue = HDBPlusTree.this.leafNodeAccessor.getValue(this.currentNodeAddr, this.nextSlot, partition, lastEntryKey);
                assert (lastValue != TStoreAllocator.RETRY);
                this.nextEntry = (QueryableEntry)HDBPlusTree.this.mapEntryFactory.create(lastEntryKey, lastValue);
                this.nextIndexKey = lastIndexKey;
                boolean bl = true;
                return bl;
            }
            finally {
                HDBPlusTree.this.getNodeAccessor().unlockRecord(partition, keyHash, cookie);
            }
        }

        @Override
        public Data getLastKeyRead() {
            return this.lastIndexKey;
        }
    }

    private class IndexKeyEntriesIterator
    implements Iterator<IndexKeyEntries> {
        IteratorWithMemory<T> iterator;
        T cachedData;
        Data cachedKey;
        Data previouslyReturnedKey;
        com.hazelcast.internal.bplustree.HDBPlusTree$IndexKeyEntriesIterator.EntryIteratorSplit splitIterator;
        boolean splitIteratorDone;

        IndexKeyEntriesIterator(IteratorWithMemory<T> iterator) {
            this.iterator = iterator;
            this.splitIterator = new EntryIteratorSplit();
        }

        @Override
        public boolean hasNext() {
            if (this.cachedData != null) {
                return true;
            }
            return this.iterator.hasNext();
        }

        @Override
        public IndexKeyEntries next() {
            if (this.cachedData == null) {
                if (!this.iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.cachedData = (QueryableEntry)this.iterator.next();
                this.cachedKey = this.iterator.getLastKeyRead();
            }
            assert (!this.cachedKey.equals(this.previouslyReturnedKey)) : "Cannot call next() method without consuming all previous IndexKeyEntries' entries";
            this.previouslyReturnedKey = this.cachedKey;
            this.splitIteratorDone = false;
            return new IndexKeyEntries((Comparable)HDBPlusTree.this.ess.toObject(this.cachedKey), (Iterator<QueryableEntry>)this.splitIterator);
        }

        private class EntryIteratorSplit
        implements Iterator<QueryableEntry> {
            private EntryIteratorSplit() {
            }

            @Override
            public boolean hasNext() {
                if (IndexKeyEntriesIterator.this.splitIteratorDone) {
                    return false;
                }
                if (IndexKeyEntriesIterator.this.cachedData != null) {
                    return true;
                }
                if (IndexKeyEntriesIterator.this.iterator.hasNext()) {
                    QueryableEntry data = (QueryableEntry)IndexKeyEntriesIterator.this.iterator.next();
                    Data key = IndexKeyEntriesIterator.this.iterator.getLastKeyRead();
                    Data oldCachedKey = IndexKeyEntriesIterator.this.cachedKey;
                    IndexKeyEntriesIterator.this.cachedData = data;
                    IndexKeyEntriesIterator.this.cachedKey = key;
                    boolean result = IndexKeyEntriesIterator.this.cachedKey.equals(oldCachedKey);
                    if (!result) {
                        IndexKeyEntriesIterator.this.splitIteratorDone = true;
                    }
                    return result;
                }
                return false;
            }

            @Override
            public QueryableEntry next() {
                if (IndexKeyEntriesIterator.this.cachedData != null) {
                    Object temp = IndexKeyEntriesIterator.this.cachedData;
                    IndexKeyEntriesIterator.this.cachedData = null;
                    return temp;
                }
                QueryableEntry result = (QueryableEntry)IndexKeyEntriesIterator.this.iterator.next();
                return result;
            }
        }
    }

    static interface IteratorWithMemory<T>
    extends Iterator<T> {
        public Data getLastKeyRead();
    }

    private static class EntryBatch<T> {
        private final List<EntryBatchItem<T>> values;
        private final int capacity;

        EntryBatch(int initialSize, int capacity) {
            this.capacity = capacity;
            this.values = new ArrayList<EntryBatchItem<T>>(initialSize);
        }

        boolean hasCapacity() {
            return this.values.size() < this.capacity;
        }

        void add(EntryBatchItem<T> e) {
            this.values.add(e);
        }

        Iterator<EntryBatchItem<T>> iterator() {
            return this.values.iterator();
        }

        void clear() {
            this.values.clear();
        }

        int size() {
            return this.values.size();
        }
    }

    private static class EntryBatchItem<T> {
        private final T item;
        private final Data key;

        EntryBatchItem(T item, Data key) {
            this.item = item;
            this.key = key;
        }

        T getItem() {
            return this.item;
        }

        Data getKey() {
            return this.key;
        }
    }

    class BatchingEntryIterator
    implements IteratorWithMemory<T> {
        private final EntryBatch<T> batch;
        private final EntryIterator entryIterator;
        private Iterator<EntryBatchItem<T>> batchIterator;
        private Data lastKeyRead;

        BatchingEntryIterator(EntryIterator iterator, EntryBatch<T> batch) {
            this.batch = batch;
            this.entryIterator = iterator;
            this.batchIterator = batch.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.batchIterator.hasNext()) {
                return true;
            }
            this.batch.clear();
            this.nextBatch();
            this.batchIterator = this.batch.iterator();
            return this.batchIterator.hasNext();
        }

        private void nextBatch() {
            LockingContext lockingContext = HDBPlusTree.getLockingContext();
            try {
                this.entryIterator.nextBatch0(this.batch, lockingContext);
            }
            catch (Throwable e) {
                HDBPlusTree.this.releaseLocks(lockingContext);
                throw e;
            }
            finally {
                assert (lockingContext.hasNoLocksAndPins());
            }
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            EntryBatchItem batchItem = this.batchIterator.next();
            this.lastKeyRead = batchItem.getKey();
            return (QueryableEntry)batchItem.getItem();
        }

        @Override
        public Data getLastKeyRead() {
            return this.lastKeyRead;
        }
    }

    private class KeyIterator
    implements Iterator<Data> {
        private final EntryIterator entryIterator;
        private Data lastKey;

        KeyIterator(EntryIterator entryIterator) {
            this.entryIterator = entryIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.lastKey == null) {
                return this.entryIterator.hasNext();
            }
            while (this.entryIterator.hasNext()) {
                Data indexKeyData = this.entryIterator.nextIndexKey;
                if (!indexKeyData.equals(this.lastKey)) {
                    return true;
                }
                this.entryIterator.next();
            }
            return false;
        }

        @Override
        public Data next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.entryIterator.next();
            this.lastKey = this.entryIterator.lastIndexKey;
            return this.lastKey;
        }
    }
}

