/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.rest;

import com.hazelcast.internal.ascii.AbstractTextCommand;
import com.hazelcast.internal.ascii.TextCommandConstants;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpStatusCode;
import com.hazelcast.internal.ascii.rest.RestCallCollector;
import com.hazelcast.internal.ascii.rest.RestCallExecution;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.annotation.Nullable;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "MS_MUTABLE_ARRAY", "MS_PKGPROTECT"})
public abstract class HttpCommand
extends AbstractTextCommand {
    public static final byte[] CONTENT_TYPE_PLAIN_TEXT = StringUtil.stringToBytes("text/plain");
    public static final byte[] CONTENT_TYPE_JSON = StringUtil.stringToBytes("application/json");
    public static final byte[] CONTENT_TYPE_BINARY = StringUtil.stringToBytes("application/binary");
    static final String HEADER_CONTENT_TYPE = "content-type: ";
    static final String HEADER_CONTENT_LENGTH = "content-length: ";
    static final String HEADER_CHUNKED = "transfer-encoding: chunked";
    static final String HEADER_EXPECT_100 = "expect: 100";
    private static final String HEADER_CUSTOM_PREFIX = "Hazelcast-";
    private static final byte[] CONTENT_TYPE = StringUtil.stringToBytes("Content-Type: ");
    private static final byte[] CONTENT_LENGTH = StringUtil.stringToBytes("Content-Length: ");
    protected final String uri;
    protected ByteBuffer response;
    protected boolean nextLine;
    private final RestCallExecution executionDetails = new RestCallExecution();

    public HttpCommand(TextCommandConstants.TextCommandType type, String uri) {
        super(type);
        this.uri = uri;
        this.nextLine = true;
        this.executionDetails.setRequestPath(uri);
    }

    @Override
    public boolean shouldReply() {
        return true;
    }

    public String getURI() {
        return this.uri;
    }

    public void send204() {
        this.setResponse(HttpStatusCode.SC_204, null, null);
    }

    public void send400() {
        this.setResponse(HttpStatusCode.SC_400, null, null);
    }

    public void send403() {
        this.setResponse(HttpStatusCode.SC_403, null, null);
    }

    public void send404() {
        this.setResponse(HttpStatusCode.SC_404, null, null);
    }

    public void send500() {
        this.setResponse(HttpStatusCode.SC_500, null, null);
    }

    public void send503() {
        this.setResponse(HttpStatusCode.SC_503, null, null);
    }

    public void send200() {
        this.setResponse(HttpStatusCode.SC_200, null, null);
    }

    public void setResponse(HttpStatusCode statusCode, @Nullable Map<String, Object> headers) {
        byte[] statusLine = statusCode.statusLine;
        int size = statusLine.length;
        byte[] len = StringUtil.stringToBytes(String.valueOf(0));
        size += CONTENT_LENGTH.length;
        size += len.length;
        size += TextCommandConstants.RETURN.length;
        if (headers != null) {
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                size += StringUtil.stringToBytes(HEADER_CUSTOM_PREFIX + entry.getKey() + ": ").length;
                size += StringUtil.stringToBytes(entry.getValue().toString()).length;
                size += TextCommandConstants.RETURN.length;
            }
        }
        this.response = ByteBuffer.allocate(size += TextCommandConstants.RETURN.length);
        this.response.put(statusLine);
        this.response.put(CONTENT_LENGTH);
        this.response.put(len);
        this.response.put(TextCommandConstants.RETURN);
        if (headers != null) {
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                this.response.put(StringUtil.stringToBytes(HEADER_CUSTOM_PREFIX + entry.getKey() + ": "));
                this.response.put(StringUtil.stringToBytes(entry.getValue().toString()));
                this.response.put(TextCommandConstants.RETURN);
            }
        }
        this.response.put(TextCommandConstants.RETURN);
        this.response.flip();
        this.setStatusCode(statusCode.code);
    }

    public void setResponseWithHeaders(HttpStatusCode statusCode, @Nullable Map<String, Object> headers, @Nullable byte[] value) {
        byte[] statusLine = statusCode.statusLine;
        int valueSize = value == null ? 0 : value.length;
        byte[] len = StringUtil.stringToBytes(String.valueOf(valueSize));
        int size = statusLine.length;
        size += CONTENT_LENGTH.length;
        size += len.length;
        size += TextCommandConstants.RETURN.length;
        if (headers != null) {
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                size += StringUtil.stringToBytes(entry.getKey() + ": ").length;
                size += StringUtil.stringToBytes(entry.getValue().toString()).length;
                size += TextCommandConstants.RETURN.length;
            }
        }
        size += TextCommandConstants.RETURN.length;
        this.response = ByteBuffer.allocate(size += valueSize);
        this.response.put(statusLine);
        this.response.put(CONTENT_LENGTH);
        this.response.put(len);
        this.response.put(TextCommandConstants.RETURN);
        if (headers != null) {
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                this.response.put(StringUtil.stringToBytes(entry.getKey() + ": "));
                this.response.put(StringUtil.stringToBytes(entry.getValue().toString()));
                this.response.put(TextCommandConstants.RETURN);
            }
        }
        this.response.put(TextCommandConstants.RETURN);
        if (value != null) {
            this.response.put(value);
        }
        this.response.flip();
        this.setStatusCode(statusCode.code);
    }

    public void setResponse(HttpStatusCode statusCode, @Nullable byte[] contentType, @Nullable byte[] value) {
        byte[] statusLine = statusCode.statusLine;
        int valueSize = value == null ? 0 : value.length;
        byte[] len = StringUtil.stringToBytes(String.valueOf(valueSize));
        int size = statusLine.length;
        if (contentType != null) {
            size += CONTENT_TYPE.length;
            size += contentType.length;
            size += TextCommandConstants.RETURN.length;
        }
        size += CONTENT_LENGTH.length;
        size += len.length;
        size += TextCommandConstants.RETURN.length;
        size += TextCommandConstants.RETURN.length;
        this.response = ByteBuffer.allocate(size += valueSize);
        this.response.put(statusLine);
        if (contentType != null) {
            this.response.put(CONTENT_TYPE);
            this.response.put(contentType);
            this.response.put(TextCommandConstants.RETURN);
        }
        this.response.put(CONTENT_LENGTH);
        this.response.put(len);
        this.response.put(TextCommandConstants.RETURN);
        this.response.put(TextCommandConstants.RETURN);
        if (value != null) {
            this.response.put(value);
        }
        this.response.flip();
        this.setStatusCode(statusCode.code);
    }

    @Override
    public boolean writeTo(ByteBuffer dst) {
        IOUtil.copyFromHeapBuffer(this.response, dst);
        return !this.response.hasRemaining();
    }

    @Override
    public boolean readFrom(ByteBuffer src) {
        while (src.hasRemaining()) {
            char c = (char)src.get();
            if (c == '\n') {
                if (this.nextLine) {
                    return true;
                }
                this.nextLine = true;
                continue;
            }
            if (c == '\r') continue;
            this.nextLine = false;
        }
        return false;
    }

    @Override
    public String toString() {
        return "HttpCommand [" + String.valueOf((Object)this.type) + "]{uri='" + this.uri + "'}" + super.toString();
    }

    public RestCallExecution getExecutionDetails() {
        return this.executionDetails;
    }

    void setStatusCode(int statusCode) {
        int existingStatusCode = this.executionDetails.getStatusCode();
        if (existingStatusCode > 0) {
            throw new IllegalStateException("can not set statusCode to " + statusCode + ", it is already " + existingStatusCode);
        }
        this.executionDetails.setStatusCode(statusCode);
    }

    @Override
    public void beforeSendResponse(TextCommandService textCommandService) {
        RestCallCollector collector = textCommandService.getRestCallCollector();
        collector.collectExecution(this);
    }
}

