/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.dataconnection.impl;

import com.hazelcast.core.HazelcastException;
import java.util.concurrent.atomic.AtomicInteger;

public class ReferenceCounter {
    private final AtomicInteger referenceCount = new AtomicInteger(1);
    private final Runnable destroyAction;

    public ReferenceCounter(Runnable destroyAction) {
        this.destroyAction = destroyAction;
    }

    public void retain() {
        this.referenceCount.updateAndGet(cnt -> {
            if (cnt <= 0) {
                throw new IllegalStateException("Resurrected a dead object");
            }
            return cnt + 1;
        });
    }

    public boolean release() {
        long newCount = this.referenceCount.decrementAndGet();
        if (newCount < 0L) {
            throw new IllegalStateException("release without retain");
        }
        if (newCount == 0L) {
            try {
                this.destroyAction.run();
            }
            catch (Exception e) {
                throw new HazelcastException("Could not destroy reference counted object: " + String.valueOf(e), e);
            }
            return true;
        }
        return false;
    }
}

