/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl.dto;

import com.hazelcast.cp.internal.raft.impl.RaftDataSerializerHook;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.EOFException;
import java.io.IOException;

public class AppendFailureResponse
implements IdentifiedDataSerializable {
    public static final int SKIPPED_FOLLOWER_NEXT_INDEX = -1;
    private RaftEndpoint follower;
    private int term;
    private long expectedNextIndex;
    private long flowControlSequenceNumber;
    private long followerNextIndex;

    public AppendFailureResponse() {
    }

    public AppendFailureResponse(RaftEndpoint follower, int term, long expectedNextIndex, long flowControlSequenceNumber, long followerNextIndex) {
        this.follower = follower;
        this.term = term;
        this.expectedNextIndex = expectedNextIndex;
        this.flowControlSequenceNumber = flowControlSequenceNumber;
        this.followerNextIndex = followerNextIndex;
    }

    public RaftEndpoint follower() {
        return this.follower;
    }

    public int term() {
        return this.term;
    }

    public long expectedNextIndex() {
        return this.expectedNextIndex;
    }

    public long flowControlSequenceNumber() {
        return this.flowControlSequenceNumber;
    }

    public long followerNextIndex() {
        return this.followerNextIndex;
    }

    @Override
    public int getFactoryId() {
        return RaftDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 7;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.term);
        out.writeObject(this.follower);
        out.writeLong(this.expectedNextIndex);
        out.writeLong(this.flowControlSequenceNumber);
        out.writeLong(this.followerNextIndex);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.term = in.readInt();
        this.follower = (RaftEndpoint)in.readObject();
        this.expectedNextIndex = in.readLong();
        try {
            this.flowControlSequenceNumber = in.readLong();
        }
        catch (EOFException e) {
            this.flowControlSequenceNumber = -1L;
        }
        try {
            this.followerNextIndex = in.readLong();
        }
        catch (EOFException e) {
            this.followerNextIndex = -1L;
        }
    }

    public String toString() {
        return "AppendFailureResponse{follower=" + String.valueOf(this.follower) + ", term=" + this.term + ", expectedNextIndex=" + this.expectedNextIndex + ", flowControlSequenceNumber=" + this.flowControlSequenceNumber + ", followerNextIndex=" + this.followerNextIndex + "}";
    }
}

