/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.raft.impl;

import com.hazelcast.config.cp.RaftAlgorithmConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.exception.LeaderDemotedException;
import com.hazelcast.cp.exception.StaleAppendRequestException;
import com.hazelcast.cp.internal.datastructures.snapshot.ChunkUtil;
import com.hazelcast.cp.internal.raft.MembershipChangeMode;
import com.hazelcast.cp.internal.raft.QueryPolicy;
import com.hazelcast.cp.internal.raft.command.DestroyRaftGroupCmd;
import com.hazelcast.cp.internal.raft.command.RaftGroupCmd;
import com.hazelcast.cp.internal.raft.impl.ChunkedSnapshotInstaller;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.RaftIntegration;
import com.hazelcast.cp.internal.raft.impl.RaftNode;
import com.hazelcast.cp.internal.raft.impl.RaftNodeStatus;
import com.hazelcast.cp.internal.raft.impl.RaftRole;
import com.hazelcast.cp.internal.raft.impl.command.UpdateRaftGroupMembersCmd;
import com.hazelcast.cp.internal.raft.impl.dto.AppendFailureResponse;
import com.hazelcast.cp.internal.raft.impl.dto.AppendRequest;
import com.hazelcast.cp.internal.raft.impl.dto.AppendSuccessResponse;
import com.hazelcast.cp.internal.raft.impl.dto.InstallSnapshotRequest;
import com.hazelcast.cp.internal.raft.impl.dto.InstallSnapshotResponse;
import com.hazelcast.cp.internal.raft.impl.dto.PreVoteRequest;
import com.hazelcast.cp.internal.raft.impl.dto.PreVoteResponse;
import com.hazelcast.cp.internal.raft.impl.dto.TriggerLeaderElection;
import com.hazelcast.cp.internal.raft.impl.dto.V55InstallSnapshot;
import com.hazelcast.cp.internal.raft.impl.dto.VoteRequest;
import com.hazelcast.cp.internal.raft.impl.dto.VoteResponse;
import com.hazelcast.cp.internal.raft.impl.handler.AppendFailureResponseHandlerTask;
import com.hazelcast.cp.internal.raft.impl.handler.AppendRequestHandlerTask;
import com.hazelcast.cp.internal.raft.impl.handler.AppendSuccessResponseHandlerTask;
import com.hazelcast.cp.internal.raft.impl.handler.InstallSnapshotRequestHandlerTask;
import com.hazelcast.cp.internal.raft.impl.handler.InstallSnapshotResponseHandlerTask;
import com.hazelcast.cp.internal.raft.impl.handler.PreVoteRequestHandlerTask;
import com.hazelcast.cp.internal.raft.impl.handler.PreVoteResponseHandlerTask;
import com.hazelcast.cp.internal.raft.impl.handler.TriggerLeaderElectionHandlerTask;
import com.hazelcast.cp.internal.raft.impl.handler.V55InstallSnapshotHandlerTask;
import com.hazelcast.cp.internal.raft.impl.handler.VoteRequestHandlerTask;
import com.hazelcast.cp.internal.raft.impl.handler.VoteResponseHandlerTask;
import com.hazelcast.cp.internal.raft.impl.log.LogEntry;
import com.hazelcast.cp.internal.raft.impl.log.RaftLog;
import com.hazelcast.cp.internal.raft.impl.log.SnapshotChunk;
import com.hazelcast.cp.internal.raft.impl.log.SnapshotEntry;
import com.hazelcast.cp.internal.raft.impl.persistence.NopRaftStateStore;
import com.hazelcast.cp.internal.raft.impl.persistence.RaftStateStore;
import com.hazelcast.cp.internal.raft.impl.persistence.RestoredRaftState;
import com.hazelcast.cp.internal.raft.impl.state.FollowerState;
import com.hazelcast.cp.internal.raft.impl.state.LeaderState;
import com.hazelcast.cp.internal.raft.impl.state.QueryState;
import com.hazelcast.cp.internal.raft.impl.state.RaftGroupMembers;
import com.hazelcast.cp.internal.raft.impl.state.RaftState;
import com.hazelcast.cp.internal.raft.impl.task.InitLeadershipTransferTask;
import com.hazelcast.cp.internal.raft.impl.task.MembershipChangeTask;
import com.hazelcast.cp.internal.raft.impl.task.PreVoteTask;
import com.hazelcast.cp.internal.raft.impl.task.QueryTask;
import com.hazelcast.cp.internal.raft.impl.task.RaftNodeStatusAwareTask;
import com.hazelcast.cp.internal.raft.impl.task.ReplicateTask;
import com.hazelcast.cp.internal.raft.impl.util.PostponedResponse;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.RandomPicker;
import com.hazelcast.internal.util.collection.Long2ObjectHashMap;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public final class RaftNodeImpl
implements RaftNode {
    private static final int LEADER_ELECTION_TIMEOUT_RANGE = 1000;
    private static final long RAFT_NODE_INIT_DELAY_MILLIS = 500L;
    private static final float RATIO_TO_KEEP_LOGS_AFTER_SNAPSHOT = 0.1f;
    private static final long METADATA_CHUNK_INDEX = -1L;
    private static final int METADATA_CHUNK_NUMBER = 0;
    private final CPGroupId groupId;
    private final ILogger logger;
    private final RaftState state;
    private final RaftIntegration raftIntegration;
    private final ChunkedSnapshotInstaller chunkedSnapshotInstaller;
    private final Long2ObjectHashMap<InternalCompletableFuture> futures = new Long2ObjectHashMap();
    private final long heartbeatPeriodInMillis;
    private final int leaderElectionTimeout;
    private final int maxUncommittedEntryCount;
    private final int appendRequestMaxEntryCount;
    private final int commitIndexAdvanceCountToSnapshot;
    private final int maxMissedLeaderHeartbeatCount;
    private final long appendRequestBackoffTimeoutInMillis;
    private final int maxNumberOfLogsToKeepAfterSnapshot;
    private final Runnable appendRequestBackoffResetTask;
    private final Runnable flushTask;
    private final RaftStateStore stateStore;
    private long lastAppendEntriesTimestamp;
    private long appendFailureResponsesSent;
    private boolean appendRequestBackoffResetTaskScheduled;
    private boolean flushTaskSubmitted;
    private volatile RaftNodeStatus status = RaftNodeStatus.INITIAL;

    private RaftNodeImpl(CPGroupId groupId, RaftEndpoint localMember, Collection<RaftEndpoint> members, RaftStateStore stateStore, RaftAlgorithmConfig raftAlgorithmConfig, RaftIntegration raftIntegration) {
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(localMember);
        Preconditions.checkNotNull(members);
        Preconditions.checkNotNull(stateStore);
        Preconditions.checkNotNull(raftAlgorithmConfig);
        Preconditions.checkNotNull(raftIntegration);
        this.groupId = groupId;
        this.raftIntegration = raftIntegration;
        this.maxUncommittedEntryCount = raftAlgorithmConfig.getUncommittedEntryCountToRejectNewAppends();
        this.appendRequestMaxEntryCount = raftAlgorithmConfig.getAppendRequestMaxEntryCount();
        this.commitIndexAdvanceCountToSnapshot = raftAlgorithmConfig.getCommitIndexAdvanceCountToSnapshot();
        this.leaderElectionTimeout = (int)raftAlgorithmConfig.getLeaderElectionTimeoutInMillis();
        this.heartbeatPeriodInMillis = raftAlgorithmConfig.getLeaderHeartbeatPeriodInMillis();
        this.maxMissedLeaderHeartbeatCount = raftAlgorithmConfig.getMaxMissedLeaderHeartbeatCount();
        this.maxNumberOfLogsToKeepAfterSnapshot = (int)((float)this.commitIndexAdvanceCountToSnapshot * 0.1f);
        this.appendRequestBackoffTimeoutInMillis = raftAlgorithmConfig.getAppendRequestBackoffTimeoutInMillis();
        int logCapacity = this.commitIndexAdvanceCountToSnapshot + this.maxUncommittedEntryCount + this.maxNumberOfLogsToKeepAfterSnapshot;
        this.state = RaftState.newRaftState(groupId, localMember, members, logCapacity, stateStore);
        this.logger = this.getLogger(RaftNode.class);
        this.appendRequestBackoffResetTask = new AppendRequestBackoffResetTask();
        this.stateStore = stateStore;
        if (stateStore instanceof NopRaftStateStore) {
            this.flushTask = null;
            this.flushTaskSubmitted = true;
        } else {
            this.flushTask = new FlushTask();
        }
        this.chunkedSnapshotInstaller = new ChunkedSnapshotInstaller(this);
    }

    private RaftNodeImpl(CPGroupId groupId, RestoredRaftState restoredState, RaftStateStore stateStore, RaftAlgorithmConfig config, RaftIntegration raftIntegration) {
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(stateStore);
        Preconditions.checkNotNull(raftIntegration);
        Preconditions.checkNotNull(groupId);
        this.groupId = groupId;
        this.raftIntegration = raftIntegration;
        this.maxUncommittedEntryCount = config.getUncommittedEntryCountToRejectNewAppends();
        this.appendRequestMaxEntryCount = config.getAppendRequestMaxEntryCount();
        this.commitIndexAdvanceCountToSnapshot = config.getCommitIndexAdvanceCountToSnapshot();
        this.leaderElectionTimeout = (int)config.getLeaderElectionTimeoutInMillis();
        this.heartbeatPeriodInMillis = config.getLeaderHeartbeatPeriodInMillis();
        this.maxMissedLeaderHeartbeatCount = config.getMaxMissedLeaderHeartbeatCount();
        this.maxNumberOfLogsToKeepAfterSnapshot = (int)((float)this.commitIndexAdvanceCountToSnapshot * 0.1f);
        this.appendRequestBackoffTimeoutInMillis = config.getAppendRequestBackoffTimeoutInMillis();
        int logCapacity = this.commitIndexAdvanceCountToSnapshot + this.maxUncommittedEntryCount + this.maxNumberOfLogsToKeepAfterSnapshot;
        this.state = RaftState.restoreRaftState(groupId, restoredState, logCapacity, stateStore);
        this.logger = this.getLogger(RaftNode.class);
        this.appendRequestBackoffResetTask = new AppendRequestBackoffResetTask();
        this.stateStore = stateStore;
        if (stateStore instanceof NopRaftStateStore) {
            this.flushTask = null;
            this.flushTaskSubmitted = true;
        } else {
            this.flushTask = new FlushTask();
        }
        this.chunkedSnapshotInstaller = new ChunkedSnapshotInstaller(this);
    }

    public static RaftNodeImpl newRaftNode(CPGroupId groupId, RaftEndpoint localMember, Collection<RaftEndpoint> members, RaftAlgorithmConfig config, RaftIntegration integration) {
        return new RaftNodeImpl(groupId, Preconditions.checkNotNull(localMember), Preconditions.checkNotNull(members), NopRaftStateStore.INSTANCE, config, integration);
    }

    public static RaftNodeImpl newRaftNode(CPGroupId groupId, RaftEndpoint localMember, Collection<RaftEndpoint> members, RaftAlgorithmConfig config, RaftIntegration integration, RaftStateStore raftStateStore) {
        return new RaftNodeImpl(groupId, Preconditions.checkNotNull(localMember), Preconditions.checkNotNull(members), raftStateStore, config, integration);
    }

    public static RaftNodeImpl restoreRaftNode(CPGroupId groupId, RestoredRaftState restoredState, RaftAlgorithmConfig config, RaftIntegration integration) {
        return new RaftNodeImpl(groupId, restoredState, NopRaftStateStore.INSTANCE, config, integration);
    }

    public static RaftNodeImpl restoreRaftNode(CPGroupId groupId, RestoredRaftState restoredState, RaftAlgorithmConfig config, RaftIntegration integration, RaftStateStore raftStateStore) {
        return new RaftNodeImpl(groupId, restoredState, raftStateStore, config, integration);
    }

    public ChunkedSnapshotInstaller getChunkedSnapshotInstaller() {
        return this.chunkedSnapshotInstaller;
    }

    public RaftIntegration getRaftIntegration() {
        return this.raftIntegration;
    }

    public ILogger getLogger(Class clazz) {
        String name = this.state.name();
        return this.raftIntegration.getLogger(clazz.getName() + "(" + name + ")");
    }

    @Override
    public CPGroupId getGroupId() {
        return this.groupId;
    }

    @Override
    public RaftEndpoint getLocalMember() {
        return this.state.localEndpoint();
    }

    @Override
    public RaftEndpoint getLeader() {
        return this.state.leader();
    }

    @Override
    public RaftNodeStatus getStatus() {
        return this.status;
    }

    @Override
    public Collection<RaftEndpoint> getInitialMembers() {
        return this.state.initialMembers();
    }

    @Override
    public Collection<RaftEndpoint> getCommittedMembers() {
        return this.state.committedGroupMembers().members();
    }

    @Override
    public Collection<RaftEndpoint> getAppliedMembers() {
        return this.state.lastGroupMembers().members();
    }

    @Override
    public InternalCompletableFuture forceSetTerminatedStatus() {
        InternalCompletableFuture resultFuture = this.raftIntegration.newCompletableFuture();
        if (this.isTerminatedOrSteppedDown()) {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Already stepped down or terminated, not setting `TERMINATED` status.");
            }
            resultFuture.complete(null);
            return resultFuture;
        }
        this.execute(() -> {
            Throwable failure = null;
            try {
                if (this.isTerminatedOrSteppedDown()) {
                    return;
                }
                if (this.status == RaftNodeStatus.INITIAL) {
                    this.setStatus(RaftNodeStatus.TERMINATED);
                    return;
                }
                this.invalidateFuturesFrom(this.state.commitIndex() + 1L);
                LeaderState leaderState = this.state.leaderState();
                if (leaderState != null) {
                    for (BiTuple<Object, InternalCompletableFuture> t : leaderState.queryState().operations()) {
                        ((InternalCompletableFuture)t.element2).completeExceptionally(new LeaderDemotedException(this.state.localEndpoint(), null));
                    }
                }
                this.state.completeLeadershipTransfer(new LeaderDemotedException(this.state.localEndpoint(), null));
                this.setStatus(RaftNodeStatus.TERMINATED);
            }
            catch (Throwable t) {
                failure = t;
                this.logger.severe("Failure during force-termination", t);
                if (this.status != RaftNodeStatus.TERMINATED && this.status != RaftNodeStatus.STEPPED_DOWN) {
                    this.setStatus(RaftNodeStatus.TERMINATED);
                }
            }
            finally {
                if (failure == null) {
                    resultFuture.complete(null);
                } else {
                    resultFuture.completeExceptionally(failure);
                }
            }
        });
        return resultFuture;
    }

    public void start() {
        if (this.status == RaftNodeStatus.TERMINATED) {
            this.logger.warning("Not starting since already terminated...");
            return;
        }
        if (this.status != RaftNodeStatus.INITIAL) {
            throw new IllegalStateException("Cannot start RaftNode when " + String.valueOf((Object)this.status));
        }
        if (!this.raftIntegration.isReady()) {
            this.raftIntegration.schedule(this::start, 500L, TimeUnit.MILLISECONDS);
            return;
        }
        this.logger.fine("Starting Raft node: " + String.valueOf(this.state.localEndpoint()) + " for " + String.valueOf(this.groupId) + " with " + this.state.memberCount() + " members: " + String.valueOf(this.state.members()));
        this.execute(() -> {
            if (this.status == RaftNodeStatus.TERMINATED) {
                this.logger.warning("Not starting since already terminated...");
                return;
            }
            if (this.status != RaftNodeStatus.INITIAL) {
                throw new IllegalStateException("Cannot start RaftNode when " + String.valueOf((Object)this.status));
            }
            this.initRestoredState();
            try {
                this.state.init();
            }
            catch (IOException e) {
                this.logger.severe("Raft node start failed!", e);
                this.setStatus(RaftNodeStatus.TERMINATED);
                return;
            }
            new PreVoteTask(this, 0).run();
            this.scheduleLeaderFailureDetection();
            if (this.status == RaftNodeStatus.INITIAL) {
                this.setStatus(RaftNodeStatus.ACTIVE);
            }
        });
    }

    private void closeStateStore() {
        try {
            this.state.stateStore().close();
        }
        catch (IOException e) {
            this.logger.severe(e);
        }
    }

    @Override
    public void handlePreVoteRequest(PreVoteRequest request) {
        this.execute(new PreVoteRequestHandlerTask(this, request));
    }

    @Override
    public void handlePreVoteResponse(PreVoteResponse response) {
        this.execute(new PreVoteResponseHandlerTask(this, response));
    }

    @Override
    public void handleVoteRequest(VoteRequest request) {
        this.execute(new VoteRequestHandlerTask(this, request));
    }

    @Override
    public void handleVoteResponse(VoteResponse response) {
        this.execute(new VoteResponseHandlerTask(this, response));
    }

    @Override
    public void handleAppendRequest(AppendRequest request) {
        this.execute(new AppendRequestHandlerTask(this, request));
    }

    @Override
    public void handleAppendResponse(AppendSuccessResponse response) {
        this.execute(new AppendSuccessResponseHandlerTask(this, response));
    }

    @Override
    public void handleAppendResponse(AppendFailureResponse response) {
        this.execute(new AppendFailureResponseHandlerTask(this, response));
    }

    @Override
    public void v55handleInstallSnapshot(V55InstallSnapshot request) {
        this.execute(new V55InstallSnapshotHandlerTask(this, request));
    }

    @Override
    public void handleInstallSnapshotRequest(InstallSnapshotRequest request) {
        this.execute(new InstallSnapshotRequestHandlerTask(this, request));
    }

    @Override
    public void handleInstallSnapshotResponse(InstallSnapshotResponse response) {
        this.execute(new InstallSnapshotResponseHandlerTask(this, response));
    }

    @Override
    public void handleTriggerLeaderElection(TriggerLeaderElection request) {
        this.execute(new TriggerLeaderElectionHandlerTask(this, request));
    }

    @Override
    public InternalCompletableFuture replicate(Object operation) {
        InternalCompletableFuture resultFuture = this.raftIntegration.newCompletableFuture();
        this.execute(new ReplicateTask(this, operation, resultFuture));
        return resultFuture;
    }

    @Override
    public InternalCompletableFuture replicateMembershipChange(RaftEndpoint member, MembershipChangeMode mode) {
        InternalCompletableFuture resultFuture = this.raftIntegration.newCompletableFuture();
        this.execute(new MembershipChangeTask(this, resultFuture, member, mode));
        return resultFuture;
    }

    @Override
    public InternalCompletableFuture replicateMembershipChange(RaftEndpoint member, MembershipChangeMode mode, long groupMembersCommitIndex) {
        InternalCompletableFuture resultFuture = this.raftIntegration.newCompletableFuture();
        this.raftIntegration.execute(new MembershipChangeTask(this, resultFuture, member, mode, groupMembersCommitIndex));
        return resultFuture;
    }

    @Override
    public InternalCompletableFuture query(Object operation, QueryPolicy queryPolicy) {
        InternalCompletableFuture resultFuture = this.raftIntegration.newCompletableFuture();
        this.raftIntegration.execute(new QueryTask(this, operation, queryPolicy, resultFuture));
        return resultFuture;
    }

    @Override
    public InternalCompletableFuture transferLeadership(RaftEndpoint endpoint) {
        InternalCompletableFuture resultFuture = this.raftIntegration.newCompletableFuture();
        this.raftIntegration.execute(new InitLeadershipTransferTask(this, endpoint, resultFuture));
        return resultFuture;
    }

    @Override
    public boolean isTerminatedOrSteppedDown() {
        return this.status == RaftNodeStatus.TERMINATED || this.status == RaftNodeStatus.STEPPED_DOWN;
    }

    public void setStatus(RaftNodeStatus newStatus) {
        if (this.status == RaftNodeStatus.TERMINATED || this.status == RaftNodeStatus.STEPPED_DOWN) {
            throw new IllegalStateException("Cannot set status: " + String.valueOf((Object)newStatus) + " since already " + String.valueOf((Object)this.status));
        }
        RaftNodeStatus prevStatus = this.status;
        if (prevStatus != newStatus) {
            Level level = Level.WARNING;
            if (newStatus == RaftNodeStatus.ACTIVE) {
                level = Level.INFO;
            } else if ((newStatus == RaftNodeStatus.TERMINATED || newStatus == RaftNodeStatus.STEPPED_DOWN) && prevStatus != RaftNodeStatus.INITIAL) {
                this.closeStateStore();
            }
            this.status = newStatus;
            this.logger.log(level, "Status is set to: " + String.valueOf((Object)newStatus));
            this.raftIntegration.onNodeStatusChange(newStatus);
        }
    }

    private void groupDestroyed() {
        if (this.status != RaftNodeStatus.TERMINATED) {
            this.closeStateStore();
            this.status = RaftNodeStatus.TERMINATED;
            this.logger.warning("Status is set to: " + String.valueOf((Object)RaftNodeStatus.TERMINATED) + " on group destroyed");
        }
        this.raftIntegration.onGroupDestroyed(this.groupId);
    }

    public long getLeaderElectionTimeoutInMillis() {
        return RandomPicker.getInt(this.leaderElectionTimeout, this.leaderElectionTimeout + 1000);
    }

    public boolean canReplicateNewEntry(Object operation) {
        long commitIndex;
        if (this.isTerminatedOrSteppedDown()) {
            return false;
        }
        RaftLog log = this.state.log();
        long lastLogIndex = log.lastLogOrSnapshotIndex();
        if (lastLogIndex - (commitIndex = this.state.commitIndex()) >= (long)this.maxUncommittedEntryCount) {
            return false;
        }
        if (this.status == RaftNodeStatus.TERMINATING) {
            return false;
        }
        if (this.status == RaftNodeStatus.UPDATING_GROUP_MEMBER_LIST) {
            return this.state.lastGroupMembers().isKnownMember(this.getLocalMember()) && !(operation instanceof RaftGroupCmd);
        }
        if (operation instanceof UpdateRaftGroupMembersCmd) {
            LogEntry lastCommittedEntry;
            LogEntry logEntry = lastCommittedEntry = commitIndex == log.snapshotIndex() ? log.snapshot() : log.getLogEntry(commitIndex);
            assert (lastCommittedEntry != null);
            return lastCommittedEntry.term() == this.state.term();
        }
        return this.state.leadershipTransferState() == null;
    }

    public boolean canQueryLinearizable() {
        RaftLog log;
        LogEntry lastCommittedEntry;
        if (this.isTerminatedOrSteppedDown()) {
            return false;
        }
        long commitIndex = this.state.commitIndex();
        LogEntry logEntry = lastCommittedEntry = commitIndex == (log = this.state.log()).snapshotIndex() ? log.snapshot() : log.getLogEntry(commitIndex);
        assert (lastCommittedEntry != null);
        if (lastCommittedEntry.term() != this.state.term()) {
            return false;
        }
        QueryState queryState = this.state.leaderState().queryState();
        return queryState.queryCount() < this.maxUncommittedEntryCount;
    }

    public boolean isLinearizableReadOptimizationEnabled() {
        return this.raftIntegration.isLinearizableReadOptimizationEnabled();
    }

    private void scheduleLeaderFailureDetection() {
        this.schedule(new LeaderFailureDetectionTask(), this.getLeaderElectionTimeoutInMillis());
    }

    private void scheduleHeartbeat() {
        this.schedule(new HeartbeatTask(), this.heartbeatPeriodInMillis);
    }

    public void send(PreVoteRequest request, RaftEndpoint target) {
        this.raftIntegration.send(request, target);
    }

    public void send(PreVoteResponse response, RaftEndpoint target) {
        this.raftIntegration.send(response, target);
    }

    public void send(VoteRequest request, RaftEndpoint target) {
        this.raftIntegration.send(request, target);
    }

    public void send(VoteResponse response, RaftEndpoint target) {
        this.raftIntegration.send(response, target);
    }

    public void send(AppendSuccessResponse response, RaftEndpoint target) {
        this.raftIntegration.send(response, target);
    }

    public void send(AppendFailureResponse response, RaftEndpoint target) {
        this.raftIntegration.send(response, target);
        ++this.appendFailureResponsesSent;
    }

    public void send(TriggerLeaderElection request, RaftEndpoint target) {
        this.raftIntegration.send(request, target);
    }

    public void broadcastAppendRequest() {
        for (RaftEndpoint follower : this.state.remoteMembers()) {
            this.sendAppendRequest(follower);
        }
        this.updateLastAppendEntriesTimestamp();
    }

    public void sendAppendRequest(RaftEndpoint follower) {
        if (!this.raftIntegration.isReachable(follower)) {
            return;
        }
        RaftLog raftLog = this.state.log();
        LeaderState leaderState = this.state.leaderState();
        FollowerState followerState = leaderState.getFollowerState(follower);
        if (followerState.isAppendRequestBackoffSet()) {
            return;
        }
        long nextIndex = followerState.nextIndex();
        if (this.shouldSendSnapshot(raftLog, nextIndex)) {
            this.sendSnapshotRequest(follower, raftLog, leaderState, followerState);
            return;
        }
        this.sendAppendEntries(follower, raftLog, leaderState, followerState, nextIndex);
    }

    private boolean shouldSendSnapshot(RaftLog raftLog, long nextIndex) {
        return nextIndex <= raftLog.snapshotIndex() && (!raftLog.containsLogEntry(nextIndex) || nextIndex > 1L && !raftLog.containsLogEntry(nextIndex - 1L));
    }

    private void sendSnapshotRequest(RaftEndpoint follower, RaftLog raftLog, LeaderState leaderState, FollowerState followerState) {
        if (this.raftIntegration.isChunkingSupportedVersion()) {
            this.initiateFollowerSnapshotSync(follower);
        } else {
            this.sendV55Snapshot(follower, raftLog.snapshot(), leaderState, followerState);
        }
    }

    private void initiateFollowerSnapshotSync(RaftEndpoint follower) {
        this.logger.fine("Forcing a full snapshot sync for follower %s", follower);
        this.sendNextSnapshotChunk(follower, -1L, 0);
    }

    public void sendNextSnapshotChunk(RaftEndpoint follower, long requestedSnapshotIndex, int requestedChunkNumber) {
        SnapshotChunk chunkToSend;
        LeaderState leaderState = this.state.leaderState();
        SnapshotEntry snapshotEntry = ChunkUtil.toChunkedV60SnapshotFromV55(this.raftIntegration, this.state.log().snapshot(), this.logger);
        if (ChunkUtil.extractChunksFrom(snapshotEntry).isEmpty()) {
            throw new IllegalStateException("No chunks extracted from snapshot");
        }
        long currentSnapshotIndex = snapshotEntry.index();
        if (requestedSnapshotIndex > currentSnapshotIndex) {
            this.logger.warning(String.format("Ignoring request from %s for a future snapshot. Follower wants index %d, but we only have index %d.", follower, requestedSnapshotIndex, currentSnapshotIndex));
            return;
        }
        if (requestedSnapshotIndex < currentSnapshotIndex) {
            this.logger.info(String.format("Follower %s is behind (wants index %d, we have %d). Sending current snapshot metadata to force a reset.", follower, requestedSnapshotIndex, currentSnapshotIndex));
            chunkToSend = RaftNodeImpl.createMetadataChunk(snapshotEntry);
        } else {
            List<SnapshotChunk> snapshotChunks = ChunkUtil.extractChunksFrom(snapshotEntry);
            chunkToSend = snapshotChunks.get(requestedChunkNumber);
            this.logger.fine("Sending snapshot chunk %d (0-based) of %d to follower %s for index %d.", requestedChunkNumber, chunkToSend.chunkCount(), follower, currentSnapshotIndex);
        }
        if (chunkToSend == null) {
            this.logger.severe(String.format("Failed to get snapshot chunk %d (0-based) for follower %s at index %d. Aborting.", requestedChunkNumber, follower, currentSnapshotIndex));
            return;
        }
        FollowerState followerState = leaderState.getFollowerState(follower);
        InstallSnapshotRequest request = new InstallSnapshotRequest(this.state.localEndpoint(), this.state.term(), chunkToSend, leaderState.queryRound(), followerState.setMaxAppendRequestBackoff());
        this.raftIntegration.send(request, follower);
        this.scheduleAppendAckResetTask();
    }

    private static SnapshotChunk createMetadataChunk(SnapshotEntry snapshotEntry) {
        List<SnapshotChunk> chunks = ChunkUtil.extractChunksFrom(snapshotEntry);
        return (SnapshotChunk)new SnapshotChunk().setChunkCount(chunks.size()).setChunkNumber(0).setGroupMembers(snapshotEntry.groupMembers()).setGroupMembersLogIndex(snapshotEntry.groupMembersLogIndex()).setSnapshotTerm(snapshotEntry.term()).setIndex(snapshotEntry.index()).setOperation(null);
    }

    private void sendV55Snapshot(RaftEndpoint follower, SnapshotEntry snapshotEntry, LeaderState leaderState, FollowerState followerState) {
        V55InstallSnapshot request = new V55InstallSnapshot(this.state.localEndpoint(), this.state.term(), snapshotEntry, leaderState.queryRound(), followerState.setAppendRequestBackoff());
        this.logger.fine("Sending %s to %s since next index: %d <= snapshot index: %d", request, follower, followerState.nextIndex(), this.state.log().snapshotIndex());
        this.raftIntegration.send(request, follower);
        this.scheduleAppendAckResetTask();
    }

    private void sendAppendEntries(RaftEndpoint follower, RaftLog raftLog, LeaderState leaderState, FollowerState followerState, long nextIndex) {
        LogEntry[] entries = this.prepareLogEntries(raftLog, followerState, nextIndex);
        boolean shouldBackoff = this.shouldSetBackoff(raftLog, followerState, nextIndex);
        if (shouldBackoff) {
            followerState.setAppendRequestBackoff();
        }
        long prevEntryIndex = nextIndex > 1L ? nextIndex - 1L : 0L;
        int prevEntryTerm = this.getPreviousEntryTerm(raftLog, prevEntryIndex);
        AppendRequest request = new AppendRequest(this.getLocalMember(), this.state.term(), prevEntryTerm, prevEntryIndex, this.state.commitIndex(), entries, leaderState.queryRound(), followerState.flowControlSequenceNumber());
        this.logger.fine("Sending %s to %s with next index: %d", request, follower, nextIndex);
        this.raftIntegration.send(request, follower);
        if (this.shouldTriggerFlush(entries, leaderState)) {
            this.submitFlushTask();
        }
        if (shouldBackoff) {
            this.scheduleAppendAckResetTask();
        }
    }

    private LogEntry[] prepareLogEntries(RaftLog raftLog, FollowerState followerState, long nextIndex) {
        if (nextIndex > 1L && followerState.matchIndex() == 0L) {
            return new LogEntry[0];
        }
        if (nextIndex > raftLog.lastLogOrSnapshotIndex()) {
            return new LogEntry[0];
        }
        if (raftLog.lastLogOrSnapshotIndex() == 0L && nextIndex == 1L) {
            return new LogEntry[0];
        }
        long end = Math.min(nextIndex + (long)this.appendRequestMaxEntryCount, raftLog.lastLogOrSnapshotIndex());
        return raftLog.getEntriesBetween(nextIndex, end);
    }

    private boolean shouldSetBackoff(RaftLog raftLog, FollowerState followerState, long nextIndex) {
        return nextIndex == 1L && raftLog.lastLogOrSnapshotIndex() > 0L || nextIndex > 1L && followerState.matchIndex() == 0L || nextIndex > 1L && nextIndex <= raftLog.lastLogOrSnapshotIndex();
    }

    private int getPreviousEntryTerm(RaftLog raftLog, long prevEntryIndex) {
        LogEntry prevEntry;
        if (prevEntryIndex == 0L) {
            return 0;
        }
        LogEntry logEntry = prevEntry = raftLog.snapshotIndex() == prevEntryIndex ? raftLog.snapshot() : raftLog.getLogEntry(prevEntryIndex);
        if (prevEntry == null) {
            throw new IllegalStateException(String.format("Previous entry not found: index=%d, snapshot=%d", prevEntryIndex, raftLog.snapshotIndex()));
        }
        return prevEntry.term();
    }

    private boolean shouldTriggerFlush(LogEntry[] entries, LeaderState leaderState) {
        return entries.length > 0 && entries[entries.length - 1].index() > leaderState.flushedLogIndex();
    }

    public void applyLogEntries() {
        long lastApplied;
        long commitIndex = this.state.commitIndex();
        if (commitIndex == (lastApplied = this.state.lastApplied())) {
            return;
        }
        assert (commitIndex > lastApplied) : "commit index: " + commitIndex + " cannot be smaller than last applied: " + lastApplied;
        RaftLog raftLog = this.state.log();
        for (long idx = this.state.lastApplied() + 1L; idx <= commitIndex; ++idx) {
            LogEntry entry = raftLog.getLogEntry(idx);
            if (entry == null) {
                String msg = "Failed to get log entry at index: " + idx;
                this.logger.severe(msg);
                throw new AssertionError((Object)msg);
            }
            this.applyLogEntry(entry);
            this.state.lastApplied(idx);
        }
        assert (this.status != RaftNodeStatus.TERMINATED || commitIndex == raftLog.lastLogOrSnapshotIndex()) : "commit index: " + commitIndex + " must be equal to " + raftLog.lastLogOrSnapshotIndex() + " on termination.";
        if (this.state.role() == RaftRole.LEADER || this.state.role() == RaftRole.FOLLOWER) {
            this.takeSnapshotIfCommitIndexAdvanced();
        }
    }

    private void applyLogEntry(LogEntry entry) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Processing %s", entry);
        }
        Object response = null;
        Object operation = entry.operation();
        if (operation instanceof RaftGroupCmd) {
            if (operation instanceof DestroyRaftGroupCmd) {
                this.groupDestroyed();
            } else if (operation instanceof UpdateRaftGroupMembersCmd) {
                UpdateRaftGroupMembersCmd op = (UpdateRaftGroupMembersCmd)operation;
                if (this.state.lastGroupMembers().index() < entry.index()) {
                    this.setStatus(RaftNodeStatus.UPDATING_GROUP_MEMBER_LIST);
                    this.updateGroupMembers(entry.index(), op.getMembers());
                }
                assert (this.status == RaftNodeStatus.UPDATING_GROUP_MEMBER_LIST) : "STATUS: " + String.valueOf((Object)this.status);
                assert (this.state.lastGroupMembers().index() == entry.index());
                this.state.commitGroupMembers();
                UpdateRaftGroupMembersCmd cmd = op;
                if (cmd.getMember().equals(this.state.localEndpoint()) && cmd.getMode() == MembershipChangeMode.REMOVE) {
                    this.setStatus(RaftNodeStatus.STEPPED_DOWN);
                    this.invalidateFuturesUntil(entry.index() - 1L, new LeaderDemotedException(this.state.localEndpoint(), null));
                } else {
                    this.setStatus(RaftNodeStatus.ACTIVE);
                }
                response = entry.index();
            } else {
                response = new IllegalArgumentException("Invalid command: " + String.valueOf(operation));
            }
        } else {
            response = this.raftIntegration.runOperation(operation, entry.index());
        }
        if (response == PostponedResponse.INSTANCE) {
            return;
        }
        this.completeFuture(entry.index(), response);
    }

    public void updateLastAppendEntriesTimestamp() {
        this.lastAppendEntriesTimestamp = Clock.currentTimeMillis();
    }

    public RaftState state() {
        return this.state;
    }

    public void runQuery(Object operation, InternalCompletableFuture resultFuture) {
        Object result = this.raftIntegration.runOperation(operation, this.state.commitIndex());
        resultFuture.complete(result);
    }

    public void execute(Runnable task) {
        this.raftIntegration.execute(task);
    }

    public void schedule(Runnable task, long delayInMillis) {
        if (this.isTerminatedOrSteppedDown()) {
            return;
        }
        this.raftIntegration.schedule(task, delayInMillis, TimeUnit.MILLISECONDS);
    }

    public void registerFuture(long entryIndex, InternalCompletableFuture future) {
        InternalCompletableFuture f = this.futures.put(entryIndex, future);
        assert (f == null) : "Future object is already registered for entry index: " + entryIndex;
    }

    public void completeFuture(long entryIndex, Object response) {
        InternalCompletableFuture f = this.futures.remove(entryIndex);
        if (f != null) {
            if (response instanceof Throwable) {
                Throwable throwable = (Throwable)response;
                f.completeExceptionally(throwable);
            } else {
                f.complete(response);
            }
        }
    }

    public void invalidateFuturesFrom(long entryIndex) {
        int count = 0;
        Iterator<Map.Entry<Long, InternalCompletableFuture>> iterator = this.futures.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, InternalCompletableFuture> entry = iterator.next();
            long index = entry.getKey();
            if (index < entryIndex) continue;
            entry.getValue().completeExceptionally(new LeaderDemotedException(this.state.localEndpoint(), this.state.leader()));
            iterator.remove();
            ++count;
        }
        if (count > 0) {
            this.logger.warning("Invalidated " + count + " futures from log index: " + entryIndex);
        }
    }

    private void invalidateFuturesUntil(long entryIndex, Throwable response) {
        int count = 0;
        Iterator<Map.Entry<Long, InternalCompletableFuture>> iterator = this.futures.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, InternalCompletableFuture> entry = iterator.next();
            long index = entry.getKey();
            if (index > entryIndex) continue;
            entry.getValue().completeExceptionally(response);
            iterator.remove();
            ++count;
        }
        if (count > 0) {
            this.logger.warning("Invalidated " + count + " futures until log index: " + entryIndex);
        }
    }

    private void takeSnapshotIfCommitIndexAdvanced() {
        long[] matchIndices;
        boolean allMatchIndicesKnown;
        List<SnapshotChunk> snapshot;
        long commitIndex = this.state.commitIndex();
        if (commitIndex - this.state.log().snapshotIndex() < (long)this.commitIndexAdvanceCountToSnapshot) {
            return;
        }
        if (this.isTerminatedOrSteppedDown()) {
            return;
        }
        this.logger.fine("Taking chunked snapshot at commit index: %d", commitIndex);
        try {
            snapshot = this.raftIntegration.takeServiceSnapshots(commitIndex);
        }
        catch (Throwable t) {
            this.logger.severe("Could not take snapshot at commit index: " + commitIndex, t);
            return;
        }
        RaftLog log = this.state.log();
        int snapshotTerm = log.getLogEntry(commitIndex).term();
        RaftGroupMembers members = this.state.committedGroupMembers();
        if (this.raftIntegration.isChunkingSupportedVersion()) {
            this.logger.fine("SnapshotChunk creation start: snapshotTerm=%d, commitIndex=%d, members=%s, memberIndex=%d", snapshotTerm, commitIndex, members.members(), members.index());
            List<SnapshotChunk> chunksFromSnapshot = ChunkUtil.createChunksFromSnapshot(this.raftIntegration, snapshotTerm, commitIndex, members.members(), members.index(), snapshot, this.logger);
            this.logger.fine("SnapshotChunk creation result: created %d chunks", chunksFromSnapshot.size());
            try {
                this.persistAndFlushSnapshotChunks(chunksFromSnapshot, commitIndex);
            }
            catch (IOException e) {
                throw new HazelcastException(e);
            }
            snapshot = chunksFromSnapshot;
        }
        long highestLogIndexToTruncate = commitIndex - (long)this.maxNumberOfLogsToKeepAfterSnapshot;
        LeaderState leaderState = this.state.leaderState();
        if (leaderState != null && (allMatchIndicesKnown = Arrays.stream(matchIndices = leaderState.matchIndices(), 0, matchIndices.length - 1).noneMatch(i -> i == 0L))) {
            highestLogIndexToTruncate = Arrays.stream(matchIndices).filter(i -> i < commitIndex).filter(i -> i > commitIndex - (long)this.maxNumberOfLogsToKeepAfterSnapshot).map(i -> i - 1L).sorted().findFirst().orElse(commitIndex);
        }
        SnapshotEntry snapshotEntry = new SnapshotEntry(snapshotTerm, commitIndex, snapshot, members.index(), members.members());
        int truncatedEntryCount = log.setSnapshot(snapshotEntry, highestLogIndexToTruncate, true);
        this.logger.fine("%s is taken, %d entries are truncated.", snapshotEntry, truncatedEntryCount);
    }

    private void persistAndFlushSnapshotChunks(List<SnapshotChunk> chunksFromSnapshot, long snapshotIndex) throws IOException {
        for (SnapshotChunk chunk : chunksFromSnapshot) {
            try {
                this.stateStore.persistSnapshotChunk(chunk);
            }
            catch (IOException e) {
                throw new HazelcastException(String.format("Persist failed at snapshot index: %d, chunkNumber: %d(0-based)", chunk.index(), chunk.chunkNumber()), e);
            }
        }
        try {
            this.stateStore.flushLogs();
        }
        catch (IOException e) {
            throw new HazelcastException(String.format("Flush failed at snapshot index: %d", snapshotIndex), e);
        }
    }

    public boolean installSnapshot(SnapshotEntry snapshot) {
        long commitIndex = this.state.commitIndex();
        if (commitIndex > snapshot.index()) {
            this.logger.info("Ignored stale " + String.valueOf(snapshot) + ", commit index at: " + commitIndex);
            return false;
        }
        if (commitIndex == snapshot.index()) {
            this.logger.info("Ignored " + String.valueOf(snapshot) + " since commit index is same.");
            return true;
        }
        this.state.commitIndex(snapshot.index());
        RaftLog raftLog = this.state.log();
        int truncated = raftLog.setSnapshot(snapshot);
        raftLog.flush();
        if (truncated > 0) {
            this.logger.info(truncated + " entries are truncated to install " + String.valueOf(snapshot));
        }
        this.raftIntegration.restoreSnapshot(snapshot, snapshot.index());
        this.setStatus(RaftNodeStatus.ACTIVE);
        this.state.restoreGroupMembers(snapshot.groupMembersLogIndex(), snapshot.groupMembers());
        this.printMemberState();
        this.state.lastApplied(snapshot.index());
        this.invalidateFuturesUntil(snapshot.index(), new StaleAppendRequestException(this.state.leader()));
        this.logger.info(String.valueOf(snapshot) + " is installed.");
        return true;
    }

    private void initRestoredState() {
        SnapshotEntry snapshotEntry = this.state.log().snapshot();
        if (this.raftIntegration.isChunkingSupportedVersion()) {
            snapshotEntry = ChunkUtil.toChunkedV60SnapshotFromV55(this.raftIntegration, snapshotEntry, this.logger);
        }
        if (SnapshotEntry.isNonInitial(snapshotEntry)) {
            this.printMemberState();
            this.raftIntegration.restoreSnapshot(snapshotEntry, snapshotEntry.index());
            if (this.logger.isFineEnabled()) {
                this.logger.info(String.valueOf(snapshotEntry) + " is restored.");
            } else {
                this.logger.info("Snapshot is restored at commitIndex=" + snapshotEntry.index());
            }
        }
        this.applyRestoredRaftGroupCommands(snapshotEntry);
    }

    private void applyRestoredRaftGroupCommands(SnapshotEntry snapshot) {
        long i;
        RaftLog log = this.state.log();
        LogEntry committedEntry = null;
        LogEntry lastAppliedEntry = null;
        long l = i = snapshot != null ? snapshot.index() + 1L : 1L;
        while (i <= log.lastLogOrSnapshotIndex()) {
            LogEntry entry = log.getLogEntry(i);
            assert (entry != null) : "index: " + i;
            if (entry.operation() instanceof RaftGroupCmd) {
                committedEntry = lastAppliedEntry;
                lastAppliedEntry = entry;
            }
            ++i;
        }
        if (committedEntry != null) {
            this.state.commitIndex(committedEntry.index());
            this.applyLogEntries();
        }
        if (lastAppliedEntry != null) {
            if (lastAppliedEntry.operation() instanceof UpdateRaftGroupMembersCmd) {
                this.setStatus(RaftNodeStatus.UPDATING_GROUP_MEMBER_LIST);
                Collection<RaftEndpoint> members = ((UpdateRaftGroupMembersCmd)lastAppliedEntry.operation()).getMembers();
                this.updateGroupMembers(lastAppliedEntry.index(), members);
            } else if (lastAppliedEntry.operation() instanceof DestroyRaftGroupCmd) {
                this.setStatus(RaftNodeStatus.TERMINATING);
            } else {
                throw new IllegalStateException("Invalid group command for restore: " + String.valueOf(lastAppliedEntry));
            }
        }
    }

    public void printMemberState() {
        CPGroupId groupId = this.state.groupId();
        StringBuilder sb = new StringBuilder("\n\nCP Group Members {").append("groupId: ").append(groupId.getName()).append("(").append(groupId.getId()).append(")").append(", size:").append(this.state.memberCount()).append(", term:").append(this.state.term()).append(", logIndex:").append(this.state.membersLogIndex()).append("} [");
        for (RaftEndpoint member : this.state.members()) {
            CPMember cpMember = this.raftIntegration.getCPMember(member);
            sb.append("\n\t").append(cpMember != null ? cpMember : member);
            if (this.state.localEndpoint().equals(member)) {
                sb.append(" - ").append((Object)this.state.role()).append(" this");
                continue;
            }
            if (!member.equals(this.state.leader())) continue;
            sb.append(" - ").append((Object)RaftRole.LEADER);
        }
        sb.append("\n]\n");
        this.logger.info(sb.toString());
    }

    public void updateGroupMembers(long logIndex, Collection<RaftEndpoint> members) {
        this.state.updateGroupMembers(logIndex, members);
        this.printMemberState();
    }

    public void resetGroupMembers() {
        this.state.resetGroupMembers();
        this.printMemberState();
    }

    private void scheduleAppendAckResetTask() {
        if (this.appendRequestBackoffResetTaskScheduled) {
            return;
        }
        this.appendRequestBackoffResetTaskScheduled = true;
        this.schedule(this.appendRequestBackoffResetTask, this.appendRequestBackoffTimeoutInMillis);
    }

    private void submitFlushTask() {
        if (this.flushTaskSubmitted) {
            return;
        }
        this.flushTaskSubmitted = true;
        this.raftIntegration.submit(this.flushTask);
    }

    public void toFollower(int term) {
        LeaderState leaderState = this.state.leaderState();
        if (leaderState != null) {
            for (BiTuple<Object, InternalCompletableFuture> t : leaderState.queryState().operations()) {
                ((InternalCompletableFuture)t.element2).completeExceptionally(new LeaderDemotedException(this.state.localEndpoint(), null));
            }
        }
        this.state.toFollower(term);
        this.printMemberState();
    }

    public void leader(RaftEndpoint endpoint) {
        this.state.leader(endpoint);
        this.printMemberState();
    }

    public void toLeader() {
        this.state.toLeader();
        this.appendEntryAfterLeaderElection();
        this.printMemberState();
        this.broadcastAppendRequest();
        this.scheduleHeartbeat();
        this.raftIntegration.onNewLeaderElected();
    }

    private long findQuorumMatchIndex() {
        LeaderState leaderState = this.state.leaderState();
        long[] indices = leaderState.matchIndices();
        if (this.state.isKnownMember(this.state.localEndpoint())) {
            long leaderIndex;
            indices[indices.length - 1] = leaderIndex = this.flushTask == null ? this.state.log().lastLogOrSnapshotIndex() : leaderState.flushedLogIndex();
        } else {
            indices = Arrays.copyOf(indices, indices.length - 1);
        }
        Arrays.sort(indices);
        long quorumMatchIndex = indices[(indices.length - 1) / 2];
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Quorum match index: %s, indices: %s", quorumMatchIndex, Arrays.toString(indices));
        }
        return quorumMatchIndex;
    }

    public boolean tryAdvanceCommitIndex() {
        long commitIndex = this.state.commitIndex();
        RaftLog raftLog = this.state.log();
        for (long quorumMatchIndex = this.findQuorumMatchIndex(); quorumMatchIndex > commitIndex; --quorumMatchIndex) {
            LogEntry entry = raftLog.getLogEntry(quorumMatchIndex);
            if (entry.term() == this.state.term()) {
                this.commitEntries(quorumMatchIndex);
                return true;
            }
            if (!this.logger.isFineEnabled()) continue;
            this.logger.fine("Cannot commit %s since an entry from the current term: %s is needed.", entry, this.state.term());
        }
        return false;
    }

    private void commitEntries(long commitIndex) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Setting commit index: %s", commitIndex);
        }
        this.state.commitIndex(commitIndex);
        if (this.status == RaftNodeStatus.ACTIVE) {
            this.applyLogEntries();
            this.tryRunQueries();
        } else {
            this.tryRunQueries();
            this.applyLogEntries();
        }
        this.broadcastAppendRequest();
    }

    public boolean tryRunQueries() {
        QueryState queryState = this.state.leaderState().queryState();
        if (queryState.queryCount() == 0) {
            return false;
        }
        long commitIndex = this.state.commitIndex();
        if (!queryState.isMajorityAcked(commitIndex, this.state.majority())) {
            return true;
        }
        Collection<BiTuple<Object, InternalCompletableFuture>> operations = queryState.operations();
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Running " + operations.size() + " queries at commit index: " + commitIndex + ", query round: " + queryState.queryRound());
        }
        for (BiTuple<Object, InternalCompletableFuture> t : operations) {
            this.runQuery(t.element1, (InternalCompletableFuture)t.element2);
        }
        queryState.reset();
        return false;
    }

    private void appendEntryAfterLeaderElection() {
        Object entry = this.raftIntegration.getAppendedEntryOnLeaderElection();
        if (entry != null) {
            RaftLog log = this.state.log();
            log.appendEntries(new LogEntry(this.state.term(), log.lastLogOrSnapshotIndex() + 1L, entry));
        }
    }

    public boolean isHeartbeatTimedOut(long timestamp) {
        long missedHeartbeatThreshold = (long)this.maxMissedLeaderHeartbeatCount * this.heartbeatPeriodInMillis;
        return timestamp + missedHeartbeatThreshold < Clock.currentTimeMillis();
    }

    public boolean isHeartbeatTimedOut() {
        return this.isHeartbeatTimedOut(this.lastAppendEntriesTimestamp);
    }

    public boolean isLeaderAvailable() {
        RaftEndpoint leader = this.state.leader();
        return leader != null && this.raftIntegration.isReachable(leader) && !this.isHeartbeatTimedOut();
    }

    public long getAppendFailureResponsesSent() {
        return this.appendFailureResponsesSent;
    }

    public String toString() {
        return "RaftNode{groupId=" + String.valueOf(this.groupId) + ", status=" + String.valueOf((Object)this.status) + ", localEndpoint=" + String.valueOf(this.state.localEndpoint()) + "}";
    }

    private class AppendRequestBackoffResetTask
    extends RaftNodeStatusAwareTask {
        AppendRequestBackoffResetTask() {
            super(RaftNodeImpl.this);
        }

        @Override
        protected void innerRun() {
            RaftNodeImpl.this.appendRequestBackoffResetTaskScheduled = false;
            LeaderState leaderState = RaftNodeImpl.this.state.leaderState();
            if (leaderState == null) {
                return;
            }
            Map<RaftEndpoint, FollowerState> followerStates = leaderState.getFollowerStates();
            for (Map.Entry<RaftEndpoint, FollowerState> entry : followerStates.entrySet()) {
                FollowerState followerState = entry.getValue();
                if (!followerState.isAppendRequestBackoffSet()) continue;
                if (followerState.completeAppendRequestBackoffRound()) {
                    RaftNodeImpl.this.sendAppendRequest(entry.getKey());
                    continue;
                }
                RaftNodeImpl.this.scheduleAppendAckResetTask();
            }
        }
    }

    private class FlushTask
    extends RaftNodeStatusAwareTask {
        FlushTask() {
            super(RaftNodeImpl.this);
        }

        @Override
        protected void innerRun() {
            RaftNodeImpl.this.flushTaskSubmitted = false;
            RaftLog log = RaftNodeImpl.this.state.log();
            log.flush();
            LeaderState leaderState = RaftNodeImpl.this.state.leaderState();
            if (leaderState != null) {
                leaderState.flushedLogIndex(log.lastLogOrSnapshotIndex());
                RaftNodeImpl.this.tryAdvanceCommitIndex();
            }
        }
    }

    private class LeaderFailureDetectionTask
    extends RaftNodeStatusAwareTask {
        LeaderFailureDetectionTask() {
            super(RaftNodeImpl.this);
        }

        @Override
        protected void innerRun() {
            try {
                if (RaftNodeImpl.this.state.role() == RaftRole.LEADER) {
                    return;
                }
                RaftEndpoint leader = RaftNodeImpl.this.state.leader();
                if (leader == null) {
                    if (RaftNodeImpl.this.state.role() == RaftRole.FOLLOWER) {
                        this.logger.warning("We are FOLLOWER and there is no current leader. Will start new election round...");
                        this.runPreVoteTask();
                    }
                } else if (!RaftNodeImpl.this.raftIntegration.isReachable(leader)) {
                    this.logger.warning("Current leader " + String.valueOf(leader) + " is not reachable. Will start new election round...");
                    this.resetLeaderAndStartElection();
                } else if (RaftNodeImpl.this.isHeartbeatTimedOut()) {
                    this.logger.warning("Current leader " + String.valueOf(leader) + "'s heartbeats are timed-out. Will start new election round...");
                    this.resetLeaderAndStartElection();
                } else if (!RaftNodeImpl.this.state.committedGroupMembers().isKnownMember(leader)) {
                    this.logger.warning("Current leader " + String.valueOf(leader) + " is not member anymore. Will start new election round...");
                    this.resetLeaderAndStartElection();
                }
            }
            finally {
                RaftNodeImpl.this.scheduleLeaderFailureDetection();
            }
        }

        final void resetLeaderAndStartElection() {
            RaftNodeImpl.this.leader(null);
            this.runPreVoteTask();
        }

        private void runPreVoteTask() {
            if (RaftNodeImpl.this.state.preCandidateState() == null) {
                new PreVoteTask(RaftNodeImpl.this, RaftNodeImpl.this.state.term()).run();
            }
        }
    }

    private class HeartbeatTask
    extends RaftNodeStatusAwareTask {
        HeartbeatTask() {
            super(RaftNodeImpl.this);
        }

        @Override
        protected void innerRun() {
            if (RaftNodeImpl.this.state.role() == RaftRole.LEADER) {
                if (RaftNodeImpl.this.isHeartbeatTimedOut(RaftNodeImpl.this.state.leaderState().majorityAppendRequestAckTimestamp(RaftNodeImpl.this.state.majority()))) {
                    this.logger.warning("Demoting to " + String.valueOf((Object)RaftRole.FOLLOWER) + " since not received acks from majority recently...");
                    RaftNodeImpl.this.toFollower(RaftNodeImpl.this.state.term());
                    RaftNodeImpl.this.invalidateFuturesUntil(RaftNodeImpl.this.state.log().lastLogOrSnapshotIndex(), new StaleAppendRequestException(null));
                    return;
                }
                if (RaftNodeImpl.this.lastAppendEntriesTimestamp < Clock.currentTimeMillis() - RaftNodeImpl.this.heartbeatPeriodInMillis) {
                    RaftNodeImpl.this.broadcastAppendRequest();
                }
                RaftNodeImpl.this.scheduleHeartbeat();
            }
        }
    }
}

