/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.persistence;

import com.hazelcast.cp.internal.persistence.BufferedRaf;
import com.hazelcast.cp.internal.persistence.FileIOSupport;
import com.hazelcast.cp.internal.persistence.LogEntryRingBuffer;
import com.hazelcast.cp.internal.raft.impl.RaftEndpoint;
import com.hazelcast.cp.internal.raft.impl.log.LogEntry;
import com.hazelcast.cp.internal.raft.impl.log.SnapshotEntry;
import com.hazelcast.cp.internal.raft.impl.persistence.LogFileStructure;
import com.hazelcast.cp.internal.raft.impl.persistence.RaftStateStore;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class V55OnDiskRaftStateStore
implements RaftStateStore {
    private final File baseDir;
    private final InternalSerializationService serializationService;
    private final LogEntryRingBuffer logEntryRingBuffer;
    private final int maxUncommittedEntries;
    private final LogFileStructure logFileStructure;
    private BufferedRaf logRaf;
    private BufferedRaf.BufRafObjectDataOut logDataOut;
    private File currentFile;
    private File danglingFile;
    private long nextEntryIndex;
    private boolean flushCalledOnCurrentFile;

    public V55OnDiskRaftStateStore(@Nonnull File baseDir, @Nonnull InternalSerializationService serializationService, int maxUncommittedEntries, @Nullable LogFileStructure logFileStructure) {
        this.baseDir = baseDir;
        this.serializationService = serializationService;
        this.maxUncommittedEntries = maxUncommittedEntries;
        this.logFileStructure = logFileStructure;
        this.logEntryRingBuffer = this.initializeRingBuffer(logFileStructure, maxUncommittedEntries);
        this.currentFile = logFileStructure != null ? new File(baseDir, logFileStructure.filename()) : null;
        this.nextEntryIndex = this.calculateNextEntryIndex(logFileStructure);
    }

    private LogEntryRingBuffer initializeRingBuffer(@Nullable LogFileStructure logFileStructure, int maxUncommittedEntries) {
        return logFileStructure != null ? new LogEntryRingBuffer(maxUncommittedEntries, logFileStructure) : new LogEntryRingBuffer(maxUncommittedEntries);
    }

    private long calculateNextEntryIndex(@Nullable LogFileStructure logFileStructure) {
        if (logFileStructure == null) {
            return 1L;
        }
        long[] tailEntryOffsets = logFileStructure.tailEntryOffsets();
        return logFileStructure.indexOfFirstTailEntry() + (long)tailEntryOffsets.length;
    }

    public int getMaxUncommittedEntries() {
        return this.maxUncommittedEntries;
    }

    public LogFileStructure getLogFileStructure() {
        return this.logFileStructure;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public InternalSerializationService getSerializationService() {
        return this.serializationService;
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public long getNextEntryIndex() {
        return this.nextEntryIndex;
    }

    public BufferedRaf getLogRaf() {
        return this.logRaf;
    }

    public BufferedRaf.BufRafObjectDataOut getLogDataOut() {
        return this.logDataOut;
    }

    @Override
    public void open() throws IOException {
        if (!(this.baseDir.exists() || this.baseDir.mkdir() || this.baseDir.exists())) {
            throw new IOException("Cannot create directory: " + this.baseDir.getAbsolutePath());
        }
        if (this.currentFile == null) {
            this.currentFile = this.createFileWithIndex(this.nextEntryIndex);
        }
        this.logRaf = V55OnDiskRaftStateStore.openForAppend(this.currentFile);
        this.logDataOut = this.createObjectDataOutput(this.logRaf);
    }

    @Override
    public void persistEntry(@Nonnull LogEntry entry) throws IOException {
        this.validateEntryIndex(entry.index());
        this.logEntryRingBuffer.addEntryOffset(this.logRaf.filePointer());
        byte[] bytes = this.serializationService.toBytes(entry, 0, false);
        this.writeEntry(this.logRaf, this.logDataOut, bytes);
        ++this.nextEntryIndex;
    }

    @Override
    public void persistSnapshotChunk(Object snapshotChunk) {
        throw new UnsupportedOperationException(String.format("Snapshot chunking not supported in version %s", Versions.V5_5));
    }

    @Override
    public void deleteSnapshotChunks(long snapshotIndex) {
        throw new UnsupportedOperationException(String.format("Snapshot chunking not supported in version %s", Versions.V5_5));
    }

    @Override
    public void persistSnapshot(@Nonnull SnapshotEntry snapshot) throws IOException {
        byte[] bytes = this.serializationService.toBytes(snapshot, 0, false);
        File newFile = this.createFileWithIndex(snapshot.index());
        BufferedRaf newRaf = V55OnDiskRaftStateStore.openForAppend(newFile);
        BufferedRaf.BufRafObjectDataOut newDataOut = this.createObjectDataOutput(newRaf);
        this.writeEntry(newRaf, newDataOut, bytes);
        long newStartOffset = newRaf.filePointer();
        if (this.logEntryRingBuffer.topIndex() > snapshot.index()) {
            long copyFromOffset = this.logEntryRingBuffer.getEntryOffset(snapshot.index() + 1L);
            this.logRaf.seek(copyFromOffset);
            this.logRaf.copyTo(newRaf);
        }
        this.logRaf.close();
        this.logRaf = newRaf;
        this.logDataOut = newDataOut;
        this.logEntryRingBuffer.adjustToNewFile(newStartOffset, snapshot.index());
        this.nextEntryIndex = Math.max(this.nextEntryIndex, snapshot.index() + 1L);
        this.updateCurrentFile(newFile);
    }

    private void validateEntryIndex(long entryIndex) {
        if (entryIndex != this.nextEntryIndex) {
            throw new IllegalArgumentException(String.format("Expected entry index %,d, but got %,d", this.nextEntryIndex, entryIndex));
        }
    }

    private void writeEntry(BufferedRaf raf, BufferedRaf.BufRafObjectDataOut dataOut, byte[] bytes) throws IOException {
        raf.writeInt(bytes.length);
        dataOut.write(bytes);
        dataOut.writeCrc32();
    }

    private void updateCurrentFile(File newFile) {
        if (this.flushCalledOnCurrentFile) {
            this.danglingFile = this.currentFile;
            this.flushCalledOnCurrentFile = false;
        } else {
            IOUtil.delete(this.currentFile);
        }
        this.currentFile = newFile;
    }

    @Override
    public void deleteEntriesFrom(long startIndexInclusive) throws IOException {
        long rollbackOffset = this.logEntryRingBuffer.deleteEntriesFrom(startIndexInclusive);
        this.logRaf.seek(rollbackOffset);
        this.logRaf.setLength(rollbackOffset);
        this.nextEntryIndex = startIndexInclusive;
    }

    @Override
    public void persistInitialMembers(@Nonnull RaftEndpoint localMember, @Nonnull Collection<RaftEndpoint> initialMembers) throws IOException {
        this.writeToFile("members", out -> {
            out.writeObject(localMember);
            SerializationUtil.writeCollection(initialMembers, out);
        });
    }

    @Override
    public void persistTerm(int term, @Nullable RaftEndpoint votedFor) throws IOException {
        this.writeToFile("term", out -> {
            out.writeInt(term);
            out.writeObject(votedFor);
        });
    }

    @Override
    public void flushLogs() throws IOException {
        this.logDataOut.flush();
        this.logRaf.force();
        this.flushCalledOnCurrentFile = true;
        if (this.danglingFile != null) {
            IOUtil.delete(this.danglingFile);
            this.danglingFile = null;
        }
    }

    @Override
    public boolean isChunkingSupportedVersion() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.flushLogs();
        this.logRaf.close();
    }

    private BufferedRaf.BufRafObjectDataOut createObjectDataOutput(BufferedRaf raf) {
        return raf.asObjectDataOutputStream(this.serializationService);
    }

    private File createFileWithIndex(long entryIndex) {
        File newFile = new File(this.baseDir, V55OnDiskRaftStateStore.getRaftLogFileName(entryIndex));
        if (this.currentFile != null && this.currentFile.getName().equals(newFile.getName())) {
            throw new IllegalArgumentException("Invalid index for new file: " + entryIndex);
        }
        return newFile;
    }

    private void writeToFile(String filename, FileIOSupport.Writable writable) throws IOException {
        FileIOSupport.writeWithChecksum(this.baseDir, filename, this.serializationService, writable);
    }

    private static BufferedRaf openForAppend(File file) throws IOException {
        BufferedRaf raf = new BufferedRaf(new RandomAccessFile(file, "rw"));
        raf.seek(raf.length());
        return raf;
    }

    static String getRaftLogFileName(long entryIndex) {
        return String.format("raftlog-%016x", entryIndex);
    }
}

