/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.persistence;

import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.CPMemberInfo;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.persistence.CPMetadataStore;
import com.hazelcast.cp.internal.persistence.FileIOSupport;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

public class CPMetadataStoreImpl
implements CPMetadataStore {
    static final String CP_MEMBER_FILE_NAME = "cp-member";
    static final String ACTIVE_CP_MEMBERS_FILE_NAME_PREFIX = "active-members-";
    private static final String METADATA_GROUP_ID_FILE_NAME_PREFIX = "metadata-group-id-";
    private final File dir;
    private final InternalSerializationService serializationService;

    CPMetadataStoreImpl(File dir, InternalSerializationService serializationService) {
        this.dir = dir;
        this.serializationService = serializationService;
    }

    @Override
    public boolean isMarkedAPMember() {
        File file = new File(this.dir, CP_MEMBER_FILE_NAME);
        return file.exists() && file.length() == 0L;
    }

    @Override
    public boolean tryMarkAPMember() throws IOException {
        File file = new File(this.dir, CP_MEMBER_FILE_NAME);
        if (file.exists()) {
            return file.length() == 0L;
        }
        return file.createNewFile();
    }

    @Override
    public boolean containsLocalMemberFile() {
        File file = new File(this.dir, CP_MEMBER_FILE_NAME);
        return file.exists() && file.length() > 0L;
    }

    @Override
    public void persistLocalCPMember(CPMember member) throws IOException {
        FileIOSupport.writeWithChecksum(this.dir, CP_MEMBER_FILE_NAME, this.serializationService, out -> out.writeObject(member));
    }

    @Override
    public CPMemberInfo readLocalCPMember() throws IOException {
        File file = new File(this.dir, CP_MEMBER_FILE_NAME);
        if (!file.exists() || file.length() == 0L) {
            return null;
        }
        try {
            return FileIOSupport.readWithChecksum(this.dir, CP_MEMBER_FILE_NAME, this.serializationService, ObjectDataInput::readObject);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Cannot read local CP member", e);
        }
    }

    @Override
    public void persistActiveCPMembers(Collection<? extends CPMember> members, long commitIndex) throws IOException {
        String fileName = CPMetadataStoreImpl.getActiveCpMembersFileName(commitIndex);
        FileIOSupport.writeWithChecksum(this.dir, fileName, this.serializationService, out -> {
            out.writeLong(commitIndex);
            SerializationUtil.writeCollection(members, out);
        });
        this.deleteStaleFiles(ACTIVE_CP_MEMBERS_FILE_NAME_PREFIX);
    }

    @Override
    public long readActiveCPMembers(Collection<CPMember> members) throws IOException {
        String latestFileName = this.getLatestFileName(ACTIVE_CP_MEMBERS_FILE_NAME_PREFIX);
        if (latestFileName == null) {
            return 0L;
        }
        try {
            Long result = FileIOSupport.readWithChecksum(this.dir, latestFileName, this.serializationService, in -> {
                long commitIndex = in.readLong();
                int count = in.readInt();
                for (int i = 0; i < count; ++i) {
                    CPMember member = (CPMember)in.readObject();
                    members.add(member);
                }
                return commitIndex;
            });
            return result != null ? result : 0L;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Cannot read active CP members", e);
        }
    }

    @Override
    public void persistMetadataGroupId(RaftGroupId groupId) throws IOException {
        String fileName = CPMetadataStoreImpl.getMetadataGroupIdFileName(groupId.getSeed());
        FileIOSupport.writeWithChecksum(this.dir, fileName, this.serializationService, out -> out.writeObject(groupId));
        this.deleteStaleFiles(METADATA_GROUP_ID_FILE_NAME_PREFIX);
    }

    @Override
    public RaftGroupId readMetadataGroupId() throws IOException {
        String latestFileName = this.getLatestFileName(METADATA_GROUP_ID_FILE_NAME_PREFIX);
        if (latestFileName == null) {
            return null;
        }
        try {
            return FileIOSupport.readWithChecksum(this.dir, latestFileName, this.serializationService, ObjectDataInput::readObject);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Cannot read metadata group id", e);
        }
    }

    private String getLatestFileName(String prefix) {
        Object[] fileNames = this.getFileNamesWithPrefix(prefix);
        if (fileNames == null || fileNames.length == 0) {
            return null;
        }
        Arrays.sort(fileNames);
        return fileNames[fileNames.length - 1];
    }

    private void deleteStaleFiles(String prefix) {
        Object[] allFileNames = this.getFileNamesWithPrefix(prefix);
        assert (allFileNames != null && allFileNames.length > 0);
        Arrays.sort(allFileNames);
        Object latestFileName = allFileNames[allFileNames.length - 1];
        for (Object name : allFileNames) {
            if (((String)name).equals(latestFileName)) continue;
            IOUtil.deleteQuietly(new File(this.dir, (String)name));
        }
    }

    static String getMetadataGroupIdFileName(RaftGroupId groupId) {
        return CPMetadataStoreImpl.getFileNameWithPrefixAndSuffix(METADATA_GROUP_ID_FILE_NAME_PREFIX, groupId.getSeed());
    }

    private static String getMetadataGroupIdFileName(long seed) {
        return CPMetadataStoreImpl.getFileNameWithPrefixAndSuffix(METADATA_GROUP_ID_FILE_NAME_PREFIX, seed);
    }

    private static String getActiveCpMembersFileName(long commitIndex) {
        return CPMetadataStoreImpl.getFileNameWithPrefixAndSuffix(ACTIVE_CP_MEMBERS_FILE_NAME_PREFIX, commitIndex);
    }

    private static String getFileNameWithPrefixAndSuffix(String prefix, long suffix) {
        return String.format(prefix + "%016x", suffix);
    }

    private String[] getFileNamesWithPrefix(String prefix) {
        return this.dir.list((dir, name) -> name.startsWith(prefix) && !name.endsWith(".tmp"));
    }

    static boolean isCPMemberFile(File dir, String fileName) {
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        File file = new File(dir, fileName);
        return file.exists() && file.isFile() && fileName.equals(CP_MEMBER_FILE_NAME);
    }

    static boolean isMetadataGroupIdFile(File dir, String fileName) {
        File file = new File(dir, fileName);
        return file.exists() && file.isFile() && fileName.startsWith(METADATA_GROUP_ID_FILE_NAME_PREFIX);
    }

    public static boolean isCPDirectory(File dir) {
        return CPMetadataStoreImpl.isCPMemberFile(dir, CP_MEMBER_FILE_NAME);
    }
}

