/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.snapshot;

import com.hazelcast.cp.internal.raft.impl.RaftDataSerializerConstants;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;

public abstract class AbstractDataChunk
implements IdentifiedDataSerializable {
    private String name;
    private boolean destroyed;
    private long chunkSizeInBytes;

    protected AbstractDataChunk() {
    }

    protected AbstractDataChunk(String name, boolean destroyed) {
        this.name = Objects.requireNonNull(name, "Name cannot be null");
        this.destroyed = destroyed;
        this.chunkSizeInBytes = AbstractDataChunk.calculateSizeOfChunkMetadata(name);
    }

    private static long calculateSizeOfChunkMetadata(String name) {
        return name.length() + 1 + 8;
    }

    protected void addToChunkSize(long size) {
        this.chunkSizeInBytes += size;
    }

    public final String getName() {
        return this.name;
    }

    public final long getChunkSizeInBytes() {
        return this.chunkSizeInBytes;
    }

    public final boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public int getFactoryId() {
        return RaftDataSerializerConstants.F_ID;
    }

    @Override
    public final void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeBoolean(this.destroyed);
        out.writeLong(this.chunkSizeInBytes);
        this.writeDataInternal(out);
    }

    abstract void writeDataInternal(ObjectDataOutput var1) throws IOException;

    @Override
    public final void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.destroyed = in.readBoolean();
        this.chunkSizeInBytes = in.readLong();
        this.readDataInternal(in);
    }

    abstract void readDataInternal(ObjectDataInput var1) throws IOException;

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDataChunk that = (AbstractDataChunk)o;
        return this.destroyed == that.destroyed && this.chunkSizeInBytes == that.chunkSizeInBytes && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.name);
        result = 31 * result + Boolean.hashCode(this.destroyed);
        result = 31 * result + Long.hashCode(this.chunkSizeInBytes);
        return result;
    }

    public String toString() {
        return "AbstractDataChunk{name='" + this.name + "', destroyed=" + this.destroyed + ", chunkSizeInBytes=" + this.chunkSizeInBytes + "}";
    }
}

