/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.atomicref;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.IAtomicReference;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.datastructures.atomicref.AtomicRef;
import com.hazelcast.cp.internal.datastructures.atomicref.AtomicRefSnapshot;
import com.hazelcast.cp.internal.datastructures.atomicref.proxy.AtomicRefProxy;
import com.hazelcast.cp.internal.datastructures.snapshot.ChunkUtil;
import com.hazelcast.cp.internal.datastructures.snapshot.DataChunkGroup;
import com.hazelcast.cp.internal.datastructures.snapshot.ValueDataChunk;
import com.hazelcast.cp.internal.datastructures.spi.atomic.RaftAtomicValueService;
import com.hazelcast.cp.internal.raft.ChunkedSnapshotAwareService;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;

public class AtomicRefService
extends RaftAtomicValueService<Data, AtomicRef, AtomicRefSnapshot>
implements DynamicMetricsProvider,
ChunkedSnapshotAwareService<ValueDataChunk, AtomicRefSnapshot> {
    public static final String SERVICE_NAME = "hz:raft:atomicRefService";
    private long maxChunkSizeInBytes;

    public AtomicRefService(NodeEngine nodeEngine) {
        super(nodeEngine);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        super.init(nodeEngine, properties);
        if (nodeEngine.getProperties().getBoolean(ClusterProperty.METRICS_DATASTRUCTURES)) {
            nodeEngine.getMetricsRegistry().registerDynamicMetricsProvider(this);
        }
        this.maxChunkSizeInBytes = ChunkUtil.getMaxChunkSizeInBytes(nodeEngine.getProperties());
    }

    @Override
    protected AtomicRefSnapshot newSnapshot(Map<String, Data> values, Set<String> destroyed) {
        return new AtomicRefSnapshot(values, destroyed);
    }

    @Override
    protected AtomicRef newAtomicValue(CPGroupId groupId, String name, Data val) {
        return new AtomicRef(groupId, name, val);
    }

    @Override
    protected IAtomicReference newRaftAtomicProxy(NodeEngineImpl nodeEngine, RaftGroupId groupId, String proxyName, String objectNameForProxy) {
        return new AtomicRefProxy(nodeEngine, groupId, proxyName, objectNameForProxy);
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        MetricDescriptor root = descriptor.withPrefix("cp.atomicref");
        HashMap<CPGroupId, Long> liveCounts = new HashMap<CPGroupId, Long>();
        for (AtomicRef value : this.atomicValues.values()) {
            CPGroupId groupId = value.groupId();
            String groupName = groupId.getName();
            MetricDescriptor desc = root.copy().withDiscriminator("id", value.name() + "@" + groupName).withTag("name", value.name()).withTag("group", groupName).withMetric("dummy");
            context.collect(desc, 0L);
            liveCounts.merge(groupId, 1L, Long::sum);
        }
        this.addSummaryMetrics(root.withPrefix("cp.atomicref.summary"), context, liveCounts);
    }

    @Override
    public Iterator<DataChunkGroup<ValueDataChunk>> takeChunkedSnapshot(@Nonnull CPGroupId groupId, long commitIndex) {
        AtomicRefSnapshot atomicRefSnapshot = (AtomicRefSnapshot)this.takeSnapshot(groupId, commitIndex);
        return ChunkUtil.groupServiceChunksBySize(atomicRefSnapshot.toChunks(), this.maxChunkSizeInBytes).iterator();
    }

    @Override
    public void restoreChunkedSnapshot(@Nonnull CPGroupId groupId, long commitIndex, @Nonnull DataChunkGroup<ValueDataChunk> dataChunk) {
        Preconditions.checkNotNull(groupId);
        Preconditions.checkNotNull(dataChunk);
        List<ValueDataChunk> data = dataChunk.getServiceData();
        for (ValueDataChunk valueData : data) {
            if (valueData.isDestroyed()) {
                if (!this.destroyedValues.add(BiTuple.of(groupId, valueData.getName()))) continue;
                this.destroyedValueCounts.merge(groupId, 1L, Long::sum);
                continue;
            }
            Data value = valueData.getValue();
            String name = valueData.getName();
            this.atomicValues.put(BiTuple.of(groupId, name), this.newAtomicValue(groupId, name, value));
        }
    }

    @Override
    public void resetForChunkedSnapshotRestore(@Nonnull CPGroupId groupId) {
        this.reset();
    }
}

