/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures;

import com.hazelcast.cp.internal.datastructures.atomiclong.AtomicLongService;
import com.hazelcast.cp.internal.datastructures.atomicref.AtomicRefService;
import com.hazelcast.cp.internal.datastructures.countdownlatch.CountDownLatchService;
import com.hazelcast.cp.internal.datastructures.cpmap.CPMapService;
import com.hazelcast.cp.internal.datastructures.lock.LockService;
import com.hazelcast.cp.internal.datastructures.semaphore.SemaphoreService;
import com.hazelcast.cp.internal.session.ProxySessionManagerService;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.servicemanager.ServiceDescriptor;
import com.hazelcast.spi.impl.servicemanager.ServiceDescriptorProvider;

public class RaftDataServiceDescriptorProvider
implements ServiceDescriptorProvider {
    @Override
    public ServiceDescriptor[] createServiceDescriptors() {
        return new ServiceDescriptor[]{new AtomicLongServiceDescriptor(), new LockServiceDescriptor(), new RaftSessionManagerServiceDescriptor(), new AtomicRefServiceDescriptor(), new SemaphoreServiceDescriptor(), new CountDownLatchServiceDescriptor(), new CPMapServiceDescriptor()};
    }

    private static class AtomicLongServiceDescriptor
    implements ServiceDescriptor {
        private AtomicLongServiceDescriptor() {
        }

        @Override
        public String getServiceName() {
            return "hz:raft:atomicLongService";
        }

        @Override
        public Object getService(NodeEngine nodeEngine) {
            return new AtomicLongService(nodeEngine);
        }
    }

    private static class LockServiceDescriptor
    implements ServiceDescriptor {
        private LockServiceDescriptor() {
        }

        @Override
        public String getServiceName() {
            return "hz:raft:lockService";
        }

        @Override
        public Object getService(NodeEngine nodeEngine) {
            return new LockService(nodeEngine);
        }
    }

    private static class RaftSessionManagerServiceDescriptor
    implements ServiceDescriptor {
        private RaftSessionManagerServiceDescriptor() {
        }

        @Override
        public String getServiceName() {
            return "hz:raft:proxySessionManagerService";
        }

        @Override
        public Object getService(NodeEngine nodeEngine) {
            return new ProxySessionManagerService(nodeEngine);
        }
    }

    private static class AtomicRefServiceDescriptor
    implements ServiceDescriptor {
        private AtomicRefServiceDescriptor() {
        }

        @Override
        public String getServiceName() {
            return "hz:raft:atomicRefService";
        }

        @Override
        public Object getService(NodeEngine nodeEngine) {
            return new AtomicRefService(nodeEngine);
        }
    }

    private static class SemaphoreServiceDescriptor
    implements ServiceDescriptor {
        private SemaphoreServiceDescriptor() {
        }

        @Override
        public String getServiceName() {
            return "hz:raft:semaphoreService";
        }

        @Override
        public Object getService(NodeEngine nodeEngine) {
            return new SemaphoreService(nodeEngine);
        }
    }

    private static class CountDownLatchServiceDescriptor
    implements ServiceDescriptor {
        private CountDownLatchServiceDescriptor() {
        }

        @Override
        public String getServiceName() {
            return "hz:raft:countDownLatchService";
        }

        @Override
        public Object getService(NodeEngine nodeEngine) {
            return new CountDownLatchService(nodeEngine);
        }
    }

    private static final class CPMapServiceDescriptor
    implements ServiceDescriptor {
        private CPMapServiceDescriptor() {
        }

        @Override
        public String getServiceName() {
            return "hz:raft:mapService";
        }

        @Override
        public Object getService(NodeEngine nodeEngine) {
            return new CPMapService(nodeEngine);
        }
    }
}

