/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.NamedConfig;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanConsumerConfig;
import com.hazelcast.config.WanCustomPublisherConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class WanReplicationConfig
implements IdentifiedDataSerializable,
NamedConfig {
    private String name;
    private WanConsumerConfig consumerConfig;
    private List<WanCustomPublisherConfig> customPublisherConfigs = new ArrayList<WanCustomPublisherConfig>(0);
    private List<WanBatchPublisherConfig> batchPublisherConfigs = new ArrayList<WanBatchPublisherConfig>(1);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public WanReplicationConfig setName(@Nonnull String name) {
        this.name = Preconditions.checkNotNull(name, "Name must not be null");
        return this;
    }

    public WanConsumerConfig getConsumerConfig() {
        return this.consumerConfig;
    }

    public WanReplicationConfig setConsumerConfig(WanConsumerConfig consumerConfig) {
        this.consumerConfig = consumerConfig;
        return this;
    }

    @Nonnull
    public List<WanCustomPublisherConfig> getCustomPublisherConfigs() {
        return this.customPublisherConfigs;
    }

    public WanReplicationConfig setCustomPublisherConfigs(@Nonnull List<WanCustomPublisherConfig> customPublisherConfigs) {
        this.customPublisherConfigs = Preconditions.checkNotNull(customPublisherConfigs, "Publisher configurations must not be null");
        return this;
    }

    @Nonnull
    public List<WanBatchPublisherConfig> getBatchPublisherConfigs() {
        return this.batchPublisherConfigs;
    }

    public WanReplicationConfig setBatchPublisherConfigs(@Nonnull List<WanBatchPublisherConfig> batchPublisherConfigs) {
        this.batchPublisherConfigs = Preconditions.checkNotNull(batchPublisherConfigs, "Publisher configurations must not be null");
        return this;
    }

    public WanReplicationConfig addBatchReplicationPublisherConfig(WanBatchPublisherConfig config) {
        this.batchPublisherConfigs.add(config);
        return this;
    }

    public WanReplicationConfig addCustomPublisherConfig(WanCustomPublisherConfig config) {
        this.customPublisherConfigs.add(config);
        return this;
    }

    public String toString() {
        return "WanReplicationConfig{name='" + this.name + "', wanConsumerConfig=" + String.valueOf(this.consumerConfig) + ", customPublisherConfigs=" + String.valueOf(this.customPublisherConfigs) + ", batchPublisherConfigs=" + String.valueOf(this.batchPublisherConfigs) + "}";
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 0;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeObject(this.consumerConfig);
        SerializationUtil.writeList(this.batchPublisherConfigs, out);
        SerializationUtil.writeList(this.customPublisherConfigs, out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.consumerConfig = (WanConsumerConfig)in.readObject();
        this.batchPublisherConfigs = SerializationUtil.readList(in);
        this.customPublisherConfigs = SerializationUtil.readList(in);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WanReplicationConfig that = (WanReplicationConfig)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.consumerConfig != null ? !this.consumerConfig.equals(that.consumerConfig) : that.consumerConfig != null) {
            return false;
        }
        if (!this.customPublisherConfigs.equals(that.customPublisherConfigs)) {
            return false;
        }
        return this.batchPublisherConfigs.equals(that.batchPublisherConfigs);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.consumerConfig != null ? this.consumerConfig.hashCode() : 0);
        result = 31 * result + this.customPublisherConfigs.hashCode();
        result = 31 * result + this.batchPublisherConfigs.hashCode();
        return result;
    }
}

