/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.EntryListIntegerIntegerCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class MapFetchWithQueryCodec {
    public static final int REQUEST_MESSAGE_TYPE = 81920;
    public static final int RESPONSE_MESSAGE_TYPE = 81921;
    private static final int REQUEST_BATCH_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 20;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private MapFetchWithQueryCodec() {
    }

    public static ClientMessage encodeRequest(String name, Collection<Map.Entry<Integer, Integer>> iterationPointers, int batch, Data projection, Data predicate) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setContainsSerializedDataInRequest(true);
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Map.FetchWithQuery");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 81920);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, batch);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        EntryListIntegerIntegerCodec.encode(clientMessage, iterationPointers);
        DataCodec.encode(clientMessage, projection);
        DataCodec.encode(clientMessage, predicate);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.batch = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.name = StringCodec.decode(iterator);
        request.iterationPointers = EntryListIntegerIntegerCodec.decode(iterator);
        request.projection = DataCodec.decode(iterator);
        request.predicate = DataCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(Collection<Data> results, Collection<Map.Entry<Integer, Integer>> iterationPointers) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 81921);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encodeContainsNullable(clientMessage, results, DataCodec::encodeNullable);
        EntryListIntegerIntegerCodec.encode(clientMessage, iterationPointers);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        response.results = ListMultiFrameCodec.decodeContainsNullable(iterator, DataCodec::decodeNullable);
        response.iterationPointers = EntryListIntegerIntegerCodec.decode(iterator);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public List<Map.Entry<Integer, Integer>> iterationPointers;
        public int batch;
        public Data projection;
        public Data predicate;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public List<Data> results;
        public List<Map.Entry<Integer, Integer>> iterationPointers;
    }
}

